<?php echo $header; ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<?php echo $column_left; ?>
<div id="content">
    <div class="page-header">
        <div class="container-fluid">
            <div class="pull-right">
                <button id="button-export"data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><?php echo $button_save; ?></button>
            </div>
            <h1><?php echo $heading_title; ?></h1>
            <ul class="breadcrumb">
                <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>
    <div class="container-fluid">
        <?php if ($error_warning) { ?>
        <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $heading_title; ?></h3>
            </div>
            <div class="panel-body">

            <div class="col-sm-12">
            <div class="form-group">
                <label class="control-label" for="input-product-model">Kategori</label>
                <select class="category" name="category" style="width:100%;" multiple="multiple">
                <?php  
                  if($categories){
                      foreach($categories as $key => $value){
                        if(in_array($key,$filter_category)){
                          echo '<option selected value="'.$key.'">'.$value.'</option>';
                        }else{
                          echo '<option value="'.$key.'">'.$value.'</option>';
                        }
                      }
                  }   
                  ?>
                </select>   
            </div>
          </div>

        </div>
    </div>
</div>

<?php echo $footer; ?>

<script>
$(document).ready(function() {
    $('.category').select2();
});

$('#button-export').on('click', function() {
    url = 'index.php?route=tool/hopishop&token=<?php echo $token; ?>';
    var selected_categories = $('.category').select2('val');

    if (selected_categories != null) {
        url += '&selected_categories=' + selected_categories.join();
    } else {
        if (confirm('Tüm ürünleri aktarmak istediğinize emin misiniz?') == true) {
            window.open('https://'+window.location.hostname+'/'+url, '_blank');
        } else {
            return;
        }
    }
    window.open('https://'+window.location.hostname+'/'+url, '_blank');
});
</script>