 <?php echo $header; ?><?php echo $column_left; ?> 
  <div id="content">
    <div class="page-header">
      <div class="container-fluid">
        <div class="pull-left">
        <h1 class="text-left"><?php echo $heading_title; ?></h1>
        <ul class="breadcrumb">
        <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
        <?php } ?>
        </ul>
      </div>
    </div>
    <?php 
    function private_str($str, $start, $end){
      $after = mb_substr($str, 0, $start, 'utf8');
      $repeat = str_repeat('*', $end);
      $before = mb_substr($str, ($start + $end), strlen($str), 'utf8');
      return $after.$repeat.$before;
   }
   ?>
    <div class="container-fluid">

      <div class="panel panel-default">
        <div class="panel-heading">
          <h3 class="panel-title"><i class="fa fa-money"></i> <?php echo $heading_title; ?></h3>
          <div style="display:flex; justify-content:space-between; ">
          <h2 class="text-left"> <?php echo "Toplam Satış: " . $total_gossip ?></h2> 
           <h2 class="text-right" ><?php echo "Toplam Komisyon: " .(intval($total_price)) ."₺ + KDV"?></h2>
            
          </div>
        </div>
        <div class="panel-body">
          <div class="table-responsive">

            <table class="table">
              <thead>
                <tr>
                  <th scope="col"><?php echo $column_customer; ?></th>
                  <th scope="col"><?php echo $column_product_name; ?></th>
                  <th scope="col"><?php echo "Ürün Modeli" ?></th>
                  <th scope="col"><?php echo "Kazanç" ?></th>
                </tr>
              </thead>
          <tbody>
             <?php if ($orders) { ?>
             <?php foreach ($orders as $order) { ?>

              <tr>
                <td class="text-left"><?php echo private_str($order['customer'],1,12); ?>;</td>
                <td class="text-left"><?php echo $order['product_name'] ?></td>
                <td class="text-left"><?php echo $order['model'] ?></td>
                <td class="text-left"><?php echo (intval($order['price']) * 10) / 100 . "₺"; ?></td>
              </tr>

             <?php } ?>
             <?php } else { ?>
             <tr>
               <td class="text-center" colspan="4"><?php echo $text_no_results; ?></td>
             </tr>
             <?php } ?>
           </tbody>
            </table>

          </div>
          <div class="row">
            <div class="col-sm-6 text-left"><?php echo $pagination; ?></div>
            <div class="col-sm-6 text-right"><?php echo $results; ?></div>
          </div>

        </div>
      </div>
    </div></div>
<?php echo $footer; ?>