



<script src="https://www.deercase.com/ps-panel/view/javascript/JSPrintManager-master/scripts/zip.js"></script>
<script src="https://www.deercase.com/ps-panel/view/javascript/JSPrintManager-master/scripts/zip-ext.js"></script>
<script src="https://www.deercase.com/ps-panel/view/javascript/JSPrintManager-master/scripts/deflate.js"></script>
<script src="https://www.deercase.com/ps-panel/view/javascript/JSPrintManager-master/scripts/JSPrintManager.js"></script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/bluebird/3.3.5/bluebird.min.js"></script>
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>



<div style="text-align:center">
    <h1>Print Zebra EPL commands from Javascript</h1>
    <hr />
    <label class="checkbox">
        <input type="checkbox" id="useDefaultPrinter" /> <strong>Print to Default printer</strong>
    </label>
    <p>or...</p>
    <div id="installedPrinters">
        <label for="installedPrinterName">Select an installed Printer:</label>
        <select name="installedPrinterName" id="installedPrinterName"></select>
    </div>
    <br /><br />
    <button type="button" onclick="print();">Print Now...</button>
</div>

<script>

    //WebSocket settings
    JSPM.JSPrintManager.auto_reconnect = true;
    JSPM.JSPrintManager.start();
    JSPM.JSPrintManager.WS.onStatusChanged = function () {
        if (jspmWSStatus()) {
            //get client installed printers
            JSPM.JSPrintManager.getPrinters().then(function (myPrinters) {
                var options = '';
                for (var i = 0; i < myPrinters.length; i++) {
                    options += '<option>' + myPrinters[i] + '</option>';
                }
                $('#installedPrinterName').html(options);
            });
        }
    };

    //Check JSPM WebSocket status
    function jspmWSStatus() {
        if (JSPM.JSPrintManager.websocket_status == JSPM.WSStatus.Open)
            return true;
        else if (JSPM.JSPrintManager.websocket_status == JSPM.WSStatus.Closed) {
            //alert('JSPrintManager (JSPM) is not installed or not running! Download JSPM Client App from https://neodynamic.com/downloads/jspm');
            return false;
        }
        else if (JSPM.JSPrintManager.websocket_status == JSPM.WSStatus.Blocked) {
            //alert('JSPM has blocked this website!');
            return false;
        }
    }

    //Do printing...
    function print(o) {
        if (jspmWSStatus()) {
            //Create a ClientPrintJob
            var cpj = new JSPM.ClientPrintJob();
            //Set Printer type (Refer to the help, there many of them!)
            if ($('#useDefaultPrinter').prop('checked')) {
                cpj.clientPrinter = new JSPM.DefaultPrinter();
            } else {
                cpj.clientPrinter = new JSPM.InstalledPrinter($('#installedPrinterName').val());
            }
            //Set content to print...
            //Create Zebra EPL commands for sample label
            var lineFeed = "\x0A";

            var cmds = '';
            cmds += lineFeed;
            cmds += "N";
            cmds += lineFeed;
            cmds += "Q609,24";
            cmds += lineFeed;
            cmds += "q784";
            cmds += lineFeed;
            cmds += "A170,5,0,1,5,5,N,\"WORLDWIDE\"";
            cmds += lineFeed;
            cmds += "LO5,230,765,10";
            cmds += lineFeed;
            cmds += "A10,265,0,1,3,3,R,\"MODEL:\"";
            cmds += lineFeed;
            cmds += "A280,265,0,1,3,3,N,\"Bar Code Printer\"";
            cmds += lineFeed;
            cmds += "A10,340,0,1,3,3,R,\" CODE: \"";
            cmds += lineFeed;
            cmds += "B280,340,0,3C,2,6,120,B,\"BCP-1234\"";
            cmds += lineFeed;
            cmds += "LO5,520,765,10";
            cmds += lineFeed;
            cmds += "A100,550,0,1,2,2,N,\"ISO 9000 Made In USA\"";
            cmds += lineFeed;
            cmds += "P1";
            cmds += lineFeed;

            cpj.printerCommands = cmds;
            //Send print job to printer!
            cpj.sendToClient();
        }
    }

</script>