<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
    <div class="page-header">
        <div class="container-fluid">
            <div class="pull-right">
                <button type="button" id="button-download" class="btn btn-info pull-right"><i class="fa fa-download"></i> Excel ile Dışarı Aktar</button>
            </div>

            <h1><?php echo $heading_title; ?></h1>
            <ul class="breadcrumb">
                <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>
    <div class="container-fluid">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-bar-chart"></i> <?php echo $text_list; ?></h3>
            </div>
            <div class="panel-body">
                <div class="well">
                    <div class="row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label" for="input-date-start"><?php echo $entry_date_start; ?></label>
                                <div class="input-group date">
                                    <input type="text" name="filter_date_start" value="<?php echo $filter_date_start; ?>" placeholder="<?php echo $entry_date_start; ?>" data-date-format="YYYY-MM-DD" id="input-date-start" class="form-control" />
                                    <span class="input-group-btn">
                  <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                  </span></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label" for="input-date-end"><?php echo $entry_date_end; ?></label>
                                <div class="input-group date">
                                    <input type="text" name="filter_date_end" value="<?php echo $filter_date_end; ?>" placeholder="<?php echo $entry_date_end; ?>" data-date-format="YYYY-MM-DD" id="input-date-end" class="form-control" />
                                    <span class="input-group-btn">
                  <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                  </span></div>
                            </div>
                        </div>
                        <div class="col-sm-6">

                            <div class="form-group">
                                <label class="control-label" for="input-status"><?php echo $entry_status; ?></label>
                                <select name="filter_reprint_reason_id" id="input-status" class="form-control">
                                    <option value="0"><?php echo $text_all_status; ?></option>
                                    <?php foreach ($reprint_reasons as $reason) { ?>
                                    <?php if ($reason['reprint_reason_id'] == $filter_reprint_reason_id) { ?>
                                    <option value="<?php echo $reason['reprint_reason_id']; ?>" selected="selected"><?php echo $reason['name']; ?></option>
                                    <?php } else { ?>
                                    <option value="<?php echo $reason['reprint_reason_id']; ?>"><?php echo $reason['name']; ?></option>
                                    <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            <button type="button" id="button-filter" class="btn btn-primary pull-right"><i class="fa fa-filter"></i> <?php echo $button_filter; ?></button>
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                        <tr>
                            <td class="text-left">Sipariş No</td>
                            <td class="text-left">Ürün Adı</td>
                            <td class="text-left">Tekrar Basım Nedeni</td>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if ($reprints) { ?>
                        <?php foreach ($reprints as $reprint) { ?>
                        <tr>
                            <td class="text-left"><?php echo $reprint['order_id']; ?></td>
                            <td class="text-left"><?php echo $reprint['name']; ?></td>
                            <td class="text-left"><?php echo $reprint['reprint_reason_name']; ?></td>
                        </tr>
                        <?php } ?>
                        <?php } else { ?>
                        <tr>
                            <td class="text-center" colspan="6"><?php echo $text_no_results; ?></td>
                        </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
                <div class="row">
                    <div class="col-sm-6 text-left"><?php echo $pagination; ?></div>
                    <div class="col-sm-6 text-right"><?php echo $results; ?></div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript"><!--
        $('#button-filter').on('click', function() {
            url = 'index.php?route=report/sale_reprint&token=<?php echo $token; ?>';

            var filter_date_start = $('input[name=\'filter_date_start\']').val();

            if (filter_date_start) {
                url += '&filter_date_start=' + encodeURIComponent(filter_date_start);
            }

            var filter_date_end = $('input[name=\'filter_date_end\']').val();

            if (filter_date_end) {
                url += '&filter_date_end=' + encodeURIComponent(filter_date_end);
            }

            var filter_group = $('select[name=\'filter_group\']').val();

            if (filter_group) {
                url += '&filter_group=' + encodeURIComponent(filter_group);
            }

            var filter_reprint_reason_id = $('select[name=\'filter_reprint_reason_id\']').val();

            if (filter_reprint_reason_id != 0) {
                url += '&filter_reprint_reason_id=' + encodeURIComponent(filter_reprint_reason_id);
            }

            location = url;
        });

        // Excel Download Begin

        $('#button-download').on('click', function() {
            url = 'index.php?route=report/sale_reprint/excelDownload&token=<?php echo $token; ?>';

            var filter_date_start = $('input[name=\'filter_date_start\']').val();

            if (filter_date_start) {
                url += '&filter_date_start=' + encodeURIComponent(filter_date_start);
            }

            var filter_date_end = $('input[name=\'filter_date_end\']').val();

            if (filter_date_end) {
                url += '&filter_date_end=' + encodeURIComponent(filter_date_end);
            }

            var filter_group = $('select[name=\'filter_group\']').val();

            if (filter_group) {
                url += '&filter_group=' + encodeURIComponent(filter_group);
            }

            var filter_reprint_reason_id = $('select[name=\'filter_reprint_reason_id\']').val();

            if (filter_reprint_reason_id != 0) {
                url += '&filter_reprint_reason_id=' + encodeURIComponent(filter_reprint_reason_id);
            }

            location = url;
        });

        // Excel Download End



        //--></script>
    <script type="text/javascript"><!--
        $('.date').datetimepicker({
            pickTime: false
        });
        //--></script></div>
<?php echo $footer; ?>