<?php echo $header; ?>
<?php echo $column_left; ?>
<div id="content">
    <div class="page-header">
        <div class="container-fluid">
            <div class="pull-right">
                <button type="submit" form="form-block" class="btn btn-primary">
                    Kaydet
                </button>
                <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="Blok Listesine Dön" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
            <h1><?php echo $heading_title; ?></h1>
            <ul class="breadcrumb">
                <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>
    <div class="container-fluid">
        <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-block" class="form-horizontal">
        <?php if ($error_warning) { ?>
        <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $heading_title; ?></h3>
            </div>
            <div class="panel-body">
                            <div class="form-group required">
                                <label class="col-sm-2 control-label" for="input-name">Blok Adı</label>
                                <div class="col-sm-10">
                                    <input type="text" name="<?=$file_name;?>_name" value="<?php echo $description_block_name; ?>" placeholder="" id="input-name" class="form-control" />
                                </div>
                            </div>

                                <div class="form-group required">
                                    <label class="col-sm-2 control-label" for="input-content">Blok İçeriği<br><br>
                                    <p class="text-muted">
Değişkenler<br>
[product_name]: Ürün Adı</p></label>
                                    <div class="col-sm-10">
                                    <textarea name="<?=$file_name;?>_content" placeholder="<?php echo $entry_content; ?>" id="input-content" class="form-control">
                                        <?php echo $description_block_content; ?>
                                    </textarea>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-sm-2 control-label" for="input-category"><?php echo $entry_category; ?></label>
                                    <div class="col-sm-10">
                                        <input type="text" name="category" value="" placeholder="<?php echo $entry_category; ?>" id="input-category" class="form-control" />
                                        <div id="block_category" class="well well-sm" style="height: 150px; overflow: auto;">
                                            <?php foreach ($description_block_category as $block_category) { ?>
                                            <div id="block_category<?php echo $block_category['category_id']; ?>"><i class="fa fa-minus-circle"></i> <?php echo $block_category['name']; ?>
                                                <input type="hidden" name="description_block_category[]" value="<?php echo $block_category['category_id']; ?>" />
                                            </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                <label class="col-sm-2 control-label" for="input-category"><?php echo $entry_attribute; ?></label>
                                <div class="col-sm-10">
                                        <input type="text" name="attribute" value="" placeholder="<?php echo $entry_attribute; ?>" id="input-attribute" class="form-control" />
                                        <div id="block_attribute" class="well well-sm" style="height: 150px; overflow: auto;">
                                            <?php foreach ($description_block_attribute as $block_attribute) { ?>
                                            <div id="block_attribute<?php echo $block_attribute['attribute_id']; ?>"><i class="fa fa-minus-circle"></i> <?php echo $block_attribute['name']; ?>
                                                <input type="hidden" name="description_block_attribute[]" value="<?php echo $block_attribute['attribute_id']; ?>" />
                                            </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="col-sm-2 control-label" for="input-status">Durum</label>
                                    <div class="col-sm-10">
                                        <select name="<?=$file_name;?>_status" id="input-status" class="form-control">
                                            <?php if ($description_block_status) { ?>
                                            <option value="1" selected="selected">Açık</option>
                                            <option value="0">Kapalı</option>
                                            <?php } else { ?>
                                            <option value="1">Açık</option>
                                            <option value="0" selected="selected">Kapalı</option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
        </div>
    </form>                        
    </div>
</div>


<?php echo $footer; ?>

<style>
.filemanager > .cke_button_icon {background-image: url('//scripts.piyersoft.com/javascript/ckeditor/plugins/filemanager/icon.png'); background-size: auto;}
.filemanager:hover {background-color: #D5E1F2;}
.note-editor {display:none;}
</style>
<script src="//scripts.piyersoft.com/javascript/ckeditor/ckeditor.js"></script>
<script src="//scripts.piyersoft.com/javascript/ckeditor/adapters/jquery.js"></script>
<script>

CKEDITOR.replace('input-content', {
	language: '<?php echo $language_code; ?>',
	on: {
		instanceReady: function(evt) {
			$('#cke_input-content').after('<input type="hidden" id="filemanager" value="" />');
			$('#cke_input-content .cke_button__image').before('<a href="javascript:;" class="filemanager cke_button" title="Resim Ekle"><span class="cke_button_icon">&nbsp;</span></a>');
			$(document).on('click', '#cke_input-content .filemanager', function() {
				$('#modal-image').remove();
				$.ajax({
					url: 'index.php?route=common/filemanager&token=<?php echo $token; ?>&target=filemanager',
					dataType: 'html',
					success: function(html) {
						$('body').append('<div id="modal-image" class="modal filemanager">' + html + '</div>');
						$('#modal-image').modal('show');
					}
				});
			});
			$('body').on('click', '.filemanager .thumbnail', function (){
				$('#modal-image').removeClass('filemanager');
				evt.editor.focus();
				evt.editor.insertHtml('<img src="<?php echo HTTPS_CATALOG . 'image/'; ?>' + $('#filemanager').val() + '" alt="" />');
			});
		}
	}
});

// Category
$('input[name=\'category\']').autocomplete({
    'source': function(request, response) {
         $.ajax({
            url: 'index.php?route=catalog/category/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
            dataType: 'json',
            success: function(json) {
                response($.map(json, function(item) {
                    return {
                        label: item['name'],
                        value: item['category_id']
                    }
                }));
            }
        });
    },
    'select': function(item) {
        $('input[name=\'category\']').val('');

        $('#block_category' + item['value']).remove();

        $('#block_category').append('<div id="block_category' + item['value'] + '"><i class="fa fa-minus-circle"></i> ' + item['label'] + '<input type="hidden" name="description_block_category[]" value="' + item['value'] + '" /></div>');
    }
});

// Attribute
$('input[name=\'attribute\']').autocomplete({
    'source': function(request, response) {
         $.ajax({
            url: 'index.php?route=catalog/attribute/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
            dataType: 'json',
            success: function(json) {
                response($.map(json, function(item) {
                    return {
                        label: item['name'],
                        value: item['attribute_id']
                    }
                }));
            }
        });
    },
    'select': function(item) {
        $('input[name=\'attribute\']').val('');

        $('#block_attribute' + item['value']).remove();

        $('#block_attribute').append('<div id="block_attribute' + item['value'] + '"><i class="fa fa-minus-circle"></i> ' + item['label'] + '<input type="hidden" name="description_block_attribute[]" value="' + item['value'] + '" /></div>');
    }
});

$('#block_category').delegate('.fa-minus-circle', 'click', function() {
	$(this).parent().remove();
});
$('#block_attribute').delegate('.fa-minus-circle', 'click', function() {
	$(this).parent().remove();
});

</script>
