<?php echo $header; ?><?php echo $column_left; ?>
    <div id="content">
        <div class="page-header">
            <div class="container-fluid">
                <div class="pull-right">
                    <a href="<?php echo $add; ?>" data-toggle="tooltip" title="Etiket Ekle" class="btn btn-primary"><i
                                class="fa fa-plus"></i> Ekle</a>
                    <button type="button" data-toggle="tooltip" id="selectDelete" title="Etiket Sil"
                            class="btn btn-danger"
                            onclick="confirm('Emin misiniz?') ? $('#form-sticker').submit() : false;"><i
                                class="fa fa-trash-o"></i> Sil
                    </button>
                </div>
                <h1><?php echo $heading_title; ?></h1>
                <ul class="breadcrumb">
                    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                        <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <?php if ($error_warning) { ?>
            <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
                <button type="button" class="close" data-dismiss="alert">&times;</button>
            </div>
        <?php } ?>
        <?php if ($success) { ?>
            <div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
                <button type="button" class="close" data-dismiss="alert">&times;</button>
            </div>
        <?php } ?>
        <?php if (isset($_GET['success'])) { ?>
            <div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $_GET['success']; ?>
                <button type="button" class="close" data-dismiss="alert">&times;</button>
            </div>
        <?php } ?>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo $text_list; ?></h3>
            </div>

            <!-- Tablo -->
            <div class="panel-body">
                <form action="<?php echo $delete; ?>" method="post" enctype="multipart/form-data" id="form-sticker">
                    <div class="input-group">
                        <span class="input-group-addon"><i class="fa fa-search"></i></span>
                        <input type="text" name="filter_name" value="" id="input-name" placeholder="Kategori Ara"
                               class="form-control"/>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <td style="width: 1px;" class="text-center"><input type="checkbox"
                                                                                   onclick="$('input[name*=\'selected\']').prop('checked', this.checked);"/>
                                </td>
                                <td class="text-left">Resim</td>
                                <td class="text-left">ID</td>
                                <td class="text-left">Model Adı</td>
                                <td class="text-right">Etiket Adı</td>
                                <td class="text-right">Etiket Rengi</td>
                                <td class="text-right">Yazı Boyutu</td>
                                <td class="text-right">Etiket Yönü</td>
                                <td class="text-right">Bitiş Tarihi</td>
                                <td class="text-right">İşlemler</td>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($stickers as $sticker) { ?>
                                <tr>
                                    <td class="text-center"><input type="checkbox" name="selected[]"
                                                                   value="<?php echo $sticker['id']; ?>"/>
                                    </td>
                                    <td class="text-center"><?php if ($sticker['image']) {
                                            $image = explode('.', $sticker['image']);
                                            $newImage = "https://www.deercase.com/image/cache/" . $image[0] . '-100x100.' . $image[1];
                                            ?>
                                            <img src="<?php echo $newImage; ?>"
                                                 alt="<?php echo $sticker['name']; ?>" class="img-thumbnail" style="width: 50px"/>
                                        <?php } else { ?>
                                            <span class="img-thumbnail list"><i class="fa fa-camera fa-2x"></i></span>
                                        <?php } ?></td>
                                    <td class="text-right"><?php echo $sticker['id'] ?></td>
                                    <td class="text-center"><b><?php echo $sticker['model_name'] ?></b></td>
                                    <td class="text-center"><?php echo $sticker['name'] ?></td>
                                    <td class="text-right"><input type="color" value="<?php echo $sticker['color'] ?>"
                                                                  disabled></td>
                                    <td class="text-right"><?php echo $sticker['text_size'] ?>px</td>
                                    <td class="text-right">
                                        <?php if ($sticker['direction'] === "left") {
                                            echo "SOL";
                                        } elseif ($sticker['direction'] === "right") {
                                            echo "SAĞ";
                                        } ?>
                                    </td>
                                    <td class="text-right"><?php echo date("m.d.Y", strtotime($sticker['finished_at'])); ?></td>
                                    <td class="text-right"><a
                                                href="<?php echo $edit . "&sticker_id=" . $sticker['id'] ?>"
                                                data-toggle="tooltip" title="Düzenle"
                                                class="btn btn-primary"><i class="fa fa-pencil"></i></a>
                                    </td>
                                </tr>
                            <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        $('input[name=\'filter_name\']').autocomplete({
            'source': function (request, response) {
                $.ajax({
                    url: 'index.php?route=catalog/sticker/autocompleteEasySearch&token=<?php echo $token; ?>&filter_name=' + encodeURIComponent('%' + request),
                    dataType: 'json',
                    success: function (json) {
                        response($.map(json, function (item) {
                            return {
                                labelSelected: item['edit'],
                                label: labelBold(request, item['name']),
                                value: item['id']
                            }
                        }));
                        labelResult(json);
                    }
                });
            },
            'select': function (item) {
                window.location.href = item['labelSelected'].replace(/&amp;/g, '&');
            }
        });

        function labelBold(request, str) {
            var theregex = new RegExp('(' + request.replace(/([.*+?^=!:${}()|\[\]\/\\])/g, "\\$1").split(' ').join('|') + ')', 'gi');
            return str.replace(theregex, '<strong style="color:#C00;">$1</strong>');
        }

        function labelResult(json) {
            html = '';
            for (i = 0; i < json.length; i++) {
                category = json[i];

                html += '<tr>';
                html += '<td class="text-center"><input type="checkbox" name="selected[]" value="' + category['id'] + '" /></td>';
                html += '<td class="text-right">IMAGE</td>';
                html += '<td class="text-right">' + category['id'] + '</td>';
                html += '<td class="text-center"><b>' + category['model_name'] + '</b></td>';
                html += '<td class="text-center">' + category['name'] + '</td>';
                html += '<td class="text-right"><input type="color" value="' + category['color'] + '" disabled></td>';
                html += '<td class="text-right">' + category['text_size'] + 'px</td>';
                html += '<td class="text-right">' + category['direction'] + '</td>';
                html += '<td class="text-right">' + category['finished_at'] + '</td>';
                html += '<td class="text-right"><a href="' + category['edit'] + '" data-toggle="tooltip" title="Güncelle" class="btn btn-primary"><i class="fa fa-pencil"></i></a></td>';
                html += '</tr>';
            }

            $('#form-sticker table > tbody').html(html);
        }
    </script>


<?php echo $footer; ?>