<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
  <div class="page-header">
    <div class="container-fluid">
      <div class="pull-right">
        <button type="submit" form="form-article" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
        <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a></div>
      <h1><?php echo $heading_title; ?></h1>
      <ul class="breadcrumb">
        <?php foreach ($breadcrumbs as $breadcrumb) { ?>
        <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
        <?php } ?>
      </ul>
    </div>
  </div>
  <div class="container-fluid">
    <?php if ($error_warning) { ?>
    <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
      <button type="button" class="close" data-dismiss="alert">&times;</button>
    </div>
    <?php } ?>
    <div class="panel panel-default">
      <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_form; ?></h3>
      </div>
      <div class="panel-body">
        <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-article" class="form-horizontal">
          <ul class="nav nav-tabs">
            <li class="active"><a href="#tab-general" data-toggle="tab"><?php echo $tab_general; ?></a></li>
			<li><a href="#tab-data" data-toggle="tab"><?php echo $tab_data; ?></a></li>
          </ul>
          <div class="tab-content">
            <div class="tab-pane active" id="tab-general">
              <ul class="nav nav-tabs" id="language">
                <?php foreach ($languages as $language) { ?>
                <li><a href="#language<?php echo $language['language_id']; ?>" data-toggle="tab"><img src="//scripts.piyersoft.com/images/language/<?php echo $language['code']; ?>.png" title="<?php echo $language['name']; ?>" /> <?php echo $language['name']; ?></a></li>
                <?php } ?>
              </ul>
              <div class="tab-content">
                <?php foreach ($languages as $language) { ?>
                <div class="tab-pane" id="language<?php echo $language['language_id']; ?>">
                  <div class="form-group required">
                    <label class="col-sm-2 control-label" for="input-name<?php echo $language['language_id']; ?>"><?php echo $entry_name; ?></label>
                    <div class="col-sm-10">
                      <input type="text" name="article_description[<?php echo $language['language_id']; ?>][name]" value="<?php echo isset($article_description[$language['language_id']]) ? $article_description[$language['language_id']]['name'] : ''; ?>" placeholder="<?php echo $entry_name; ?>" id="input-name<?php echo $language['language_id']; ?>" class="form-control" />
                      <?php if (isset($error_name[$language['language_id']])) { ?>
                      <div class="text-danger"><?php echo $error_name[$language['language_id']]; ?></div>
                      <?php } ?>
                    </div>
                  </div>
                  
                  <div class="form-group required">
                        <label class="col-sm-2 control-label" for="input-intro-text<?php echo $language['language_id']; ?>"><?php echo $entry_intro_text; ?></label>
                        <div class="col-sm-10">
                            <textarea name="article_description[<?php echo $language['language_id']; ?>][intro_text]" placeholder="<?php echo $entry_intro_text; ?>" id="input-intro-text<?php echo $language['language_id']; ?>" class="form-control summernote"><?php echo isset($article_description[$language['language_id']]) ? $article_description[$language['language_id']]['intro_text'] : ''; ?></textarea>
                        </div>
                  </div>
                  <div class="form-group required">
                    <label class="col-sm-2 control-label" for="input-description<?php echo $language['language_id']; ?>"><?php echo $entry_description; ?></label>
                    <div class="col-sm-10">
                      <textarea name="article_description[<?php echo $language['language_id']; ?>][description]" placeholder="<?php echo $entry_description; ?>" id="input-description<?php echo $language['language_id']; ?>" class="form-control summernote"><?php echo isset($article_description[$language['language_id']]) ? $article_description[$language['language_id']]['description'] : ''; ?></textarea>
                    </div>
                  </div>
                  <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-author<?php echo $language['language_id']; ?>"><?php echo $entry_author; ?></label>
                        <div class="col-sm-10">
                            <input type="text" name="article_description[<?php echo $language['language_id']; ?>][author]" value="<?php echo isset($article_description[$language['language_id']]) ? $article_description[$language['language_id']]['author'] : ''; ?>" placeholder="<?php echo $entry_author; ?>" id="input-author<?php echo $language['language_id']; ?>" class="form-control" />
                        </div>
                  </div>
                  <div class="form-group required">
                    <label class="col-sm-2 control-label" for="input-meta-title<?php echo $language['language_id']; ?>"><?php echo $entry_meta_title; ?></label>
                    <div class="col-sm-10">
                      <input type="text" name="article_description[<?php echo $language['language_id']; ?>][meta_title]" value="<?php echo isset($article_description[$language['language_id']]) ? $article_description[$language['language_id']]['meta_title'] : ''; ?>" placeholder="<?php echo $entry_meta_title; ?>" id="input-meta-title<?php echo $language['language_id']; ?>" class="form-control" />
                      <?php if (isset($error_meta_title[$language['language_id']])) { ?>
                      <div class="text-danger"><?php echo $error_meta_title[$language['language_id']]; ?></div>
                      <?php } ?>
                    </div>
                  </div>
                  <div class="form-group">
                    <label class="col-sm-2 control-label" for="input-meta-description<?php echo $language['language_id']; ?>"><?php echo $entry_meta_description; ?></label>
                    <div class="col-sm-10">
                      <textarea name="article_description[<?php echo $language['language_id']; ?>][meta_description]" rows="5" placeholder="<?php echo $entry_meta_description; ?>" id="input-meta-description<?php echo $language['language_id']; ?>" class="form-control"><?php echo isset($article_description[$language['language_id']]) ? $article_description[$language['language_id']]['meta_description'] : ''; ?></textarea>
                    </div>
                  </div>
                  <div class="form-group">
                    <label class="col-sm-2 control-label" for="input-meta-keyword<?php echo $language['language_id']; ?>"><?php echo $entry_meta_keyword; ?></label>
                    <div class="col-sm-10">
                      <textarea name="article_description[<?php echo $language['language_id']; ?>][meta_keyword]" rows="5" placeholder="<?php echo $entry_meta_keyword; ?>" id="input-meta-keyword<?php echo $language['language_id']; ?>" class="form-control"><?php echo isset($article_description[$language['language_id']]) ? $article_description[$language['language_id']]['meta_keyword'] : ''; ?></textarea>
                    </div>
                  </div>
				  
				  

                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-tag<?php echo $language['language_id']; ?>"><span data-toggle="tooltip" title="<?php echo $help_tag; ?>"><?php echo $entry_tag; ?></span></label>
                        <div class="col-sm-10">
                            <input type="text" name="article_description[<?php echo $language['language_id']; ?>][tag]" value="<?php echo isset($article_description[$language['language_id']]) ? $article_description[$language['language_id']]['tag'] : ''; ?>" placeholder="<?php echo $entry_tag; ?>" id="input-tag<?php echo $language['language_id']; ?>" class="form-control" />
                        </div>
                    </div>

                  

                </div>
                <?php } ?>
              </div>
            </div>
			<div class="tab-pane fade" id="tab-data">
				<div class="form-group required">
                        <label class="col-sm-2 control-label" for="input-category"><span data-toggle="tooltip" title="<?php echo $help_category; ?>"><?php echo $entry_category; ?></span></label>
                        <div class="col-sm-10">
                            <input type="text" name="blog-category" value="" placeholder="<?php echo $entry_category; ?>" id="input-category" class="form-control" />
                            <div id="article-blog-category" class="well well-sm" style="height: 150px; overflow: auto;">
                                <?php foreach ($article_blog_categories as $article_blog_category) { ?>
                                <div id="article-category<?php echo $article_blog_category['blog_category_id']; ?>"><i class="fa fa-minus-circle"></i> <?php echo $article_blog_category['name']; ?>
                                    <input type="hidden" name="article_blog_category[]" value="<?php echo $article_blog_category['blog_category_id']; ?>" />
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                  </div>
          <div class="form-group">
              <label class="col-sm-2 control-label">Resim</label>
              <div class="col-sm-10"><a href="" id="thumb-image" data-toggle="image" class="img-thumbnail"><img src="<?php echo $thumb; ?>" alt="" title="" data-placeholder="<?php echo $placeholder; ?>" /></a>
                <input type="hidden" name="image" value="<?php echo $image; ?>" id="input-image" />
              </div>
          </div>
				<div class="form-group">
					<label class="col-sm-2 control-label" for="input-keyword"><span data-toggle="tooltip" title="<?php echo $help_keyword; ?>"><?php echo $entry_keyword; ?></span></label>
					<div class="col-sm-10">
					  <input type="text" name="keyword" value="<?php echo $keyword; ?>" placeholder="<?php echo $entry_keyword; ?>" id="input-keyword" class="form-control" />
					  <?php if ($error_keyword) { ?>
					  <div class="text-danger"><?php echo $error_keyword; ?></div>
					  <?php } ?>               
					</div>
				</div> 
				
				<div class="form-group">
                    <label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
                    <div class="col-sm-10">
                        <select name="status" id="input-status" class="form-control">
                            <?php if ($status) { ?>
                            <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                            <option value="0"><?php echo $text_disabled; ?></option>
                            <?php } else { ?>
                            <option value="1"><?php echo $text_enabled; ?></option>
                            <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                  </div>

                  <div class="form-group">
                    <label class="col-sm-2 control-label" for="input-sort-order"><?php echo $entry_sort_order; ?></label>
                    <div class="col-sm-10">
                        <input type="text" name="sort_order" value="<?php echo $sort_order; ?>" placeholder="<?php echo $entry_sort_order; ?>" id="input-sort-order" class="form-control" />
                    </div>
                  </div>
				  
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
  <script src="//scripts.piyersoft.com/javascript/ckeditor/ckeditor.js"></script>
  <script src="//scripts.piyersoft.com/javascript/ckeditor/adapters/jquery.js"></script>
  <script type="text/javascript">
<?php foreach ($languages as $language) { ?>
CKEDITOR.replace('input-description<?php echo $language['language_id']; ?>', {
	language: '<?php echo $language_code; ?>',
	on: {
		instanceReady: function(evt) {
			$('#cke_input-description<?php echo $language['language_id']; ?>').after('<input type="hidden" id="filemanager<?php echo $language['language_id']; ?>" value="" />');
			$('#cke_input-description<?php echo $language['language_id']; ?> .cke_button__image').before('<a href="javascript:;" class="filemanager cke_button" title="<?php echo $text_filemanager; ?>"><span class="cke_button_icon">&nbsp;</span></a>');
			$(document).on('click', '#cke_input-description<?php echo $language['language_id']; ?> .filemanager', function() {
				$('#modal-image').remove();
				$.ajax({
					url: 'index.php?route=common/filemanager&token=<?php echo $token; ?>&target=filemanager<?php echo $language['language_id']; ?>',
					dataType: 'html',
					success: function(html) {
						$('body').append('<div id="modal-image" class="modal filemanager<?php echo $language['language_id']; ?>">' + html + '</div>');
						$('#modal-image').modal('show');
					}
				});
			});
			$('body').on('click', '.filemanager<?php echo $language['language_id']; ?> .thumbnail', function (){
				$('#modal-image').removeClass('filemanager<?php echo $language['language_id']; ?>');
				evt.editor.focus();
				evt.editor.insertHtml('<img src="<?php echo HTTPS_CATALOG . 'image/'; ?>' + $('#filemanager<?php echo $language['language_id']; ?>').val() + '" alt="" />');
			});
		}
	}
});
<?php } ?>


</script>
<style>
.filemanager > .cke_button_icon {background-image: url('//scripts.piyersoft.com/javascript/ckeditor/plugins/filemanager/icon.png'); background-size: auto;}
.filemanager:hover {background-color: #D5E1F2;}
.note-editor {display:none;}
</style>


  <script type="text/javascript"><!--
// Category
$('input[name=\'blog-category\']').autocomplete({
	'source': function(request, response) {
		$.ajax({
			url: 'index.php?route=blog/blog_category/autocomplete&token=<?php echo $token; ?>&filter_name=' +  encodeURIComponent(request),
			dataType: 'json',			
			success: function(json) {
				response($.map(json, function(item) {
					return {
						label: item['name'],
						value: item['blog_category_id']
					}
				}));
			}
		});
	},
	'select': function(item) {
		$('input[name=\'blog-category\']').val('');
		
		$('#article-blog-category' + item['value']).remove();
		
		$('#article-blog-category').append('<div id="article-blog-category' + item['value'] + '"><i class="fa fa-minus-circle"></i> ' + item['label'] + '<input type="hidden" name="article_blog_category[]" value="' + item['value'] + '" /></div>');
	}
});

$('#article-blog-category').delegate('.fa-minus-circle', 'click', function() {
	$(this).parent().remove();
});
//--></script>
    <script type="text/javascript"><!--
        $('#language a:first').tab('show');
        $('#option a:first').tab('show');
        //--></script> </div>

<?php echo $footer; ?> 