# JSPrintManager

## Print Commands & Files, Manage Printers & Scan Docs from Javascript

**[JSPrintManager](https://neodynamic.com/products/printing/js-print-manager)** is a **Javascript + Client App** solution for **Client-side Printing & Scanning** scenarios **designed to be used in any Website** developed on top of **any Web Platform like ASP.NET, PHP, Django, Ruby On Rails (RoR), Express.js and more!**

By writing pure Javascript code, **JSPrintManager** allows you to _easily send raw data, text and native commands_ as well as _known file formats (like PDF, TXT, DOC, XLS, JPG, PNG)_ to any printer installed or available at the client machine *without showing or displaying any print dialog box!*
Scan Documents & Images is also supported!

**[More details about JSPrintManager...](https://neodynamic.com/products/printing/js-print-manager)**

## Features

### Raw Data Printing
Send any raw data & commands supported by the client printer like [EPSON ESC/POS](https://www.neodynamic.com/articles/How-to-print-raw-ESC-POS-commands-from-Javascript), HP PCL, PostScript, [Zebra ZPL](https://www.neodynamic.com/articles/How-to-print-raw-Zebra-ZPL-commands-from-Javascript) and [Eltron EPL](https://www.neodynamic.com/articles/How-to-print-raw-Zebra-EPL-commands-from-Javascript), and more! Shipping labels generated by postal services like [UPS, FedEx, USPS, DHL as well as PRN files](https://www.neodynamic.com/articles/How-to-print-raw-commands-from-Web-APIs-WebServices-Remote-and-Local-files-with-Javascript) are also supported!

### Advanced PDF Printing
[Print PDF files without requiring Adobe Reader or any other external software!](https://www.neodynamic.com/articles/Advanced-Silent-PDF-Printing-Tray-Paper-Size-Rotation-Pages-Range-Settings-from-Javascript) Advanced PDF Printing settings include Tray Name, Paper Size, Print Rotation, Pages Range, Duplex, Password-protection and more!

### Print Images & Docs
In addition to print raw commands, you can also use JSPrintManager solution to send and print known file formats like PDF, TXT, DOC/x, XLS/x, JPG, PNG, and more! PDF, TXT, PNG, JPG and BMP are natively supported; others will require external software like Word, Excel, LibreOffice, etc.

### Advanced DOC Printing
[Print DOC files silently](https://neodynamic.com/articles/Silent-Print-Word-DOC-duplex-pages-range-reverse-from-Javascript) with Advanced Printing settings including Password-protected files, manual Duplex, Pages Range, and more! _Windows only, requires MS Word 97+_

### Advanced XLS Printing
[Print XLS files silently](https://neodynamic.com/articles/Silent-Print-Excel-Spreadsheet-XLS-pages-range-from-Javascript) with Advanced Printing settings including Password-protected files, Pages Range, and more! _Windows only, requires MS Excel 97+_

### Print Files With Password
Print Password Protected PDF, DOC & XLS files! The password protected file is set at server side and the password to unlock it is encrypted and embedded into the file as part of its metadata.

### Web Scan Docs & Images
[Scan docs & images through any TWAIN/WIA/SANE-compatible devices](https://neodynamic.com/articles/How-to-scan-documents-images-from-Javascript) specifying settings like DPI Resolution, Pixel Mode (Grayscale, Color), and Output Image Format (JPG, PNG)!

### Tray/Bin & Paper Size
If the printer is installed in the client system through a Printer Driver, then you can specify to which Tray Name to send the print job and specify a Paper Size if desired. The file formats supported by this feature are PDF, JPEG, PNG, BMP & TXT

### BIDI Serial Comm
[Bidirectional Serial Port Communication support!](https://neodynamic.com/articles/How-to-send-write-receive-read-bidi-serial-port-data-from-Javascript) Send/Write & Receive/Read data strings to any RS-232, COM & TTY port available on the client system.

### Get Printers Info & Status
Besides getting the list of installed printers available in the client machine, you can also get further details like DPI Resolution, PortName, "Is Connected", "Is Shared", "Is Local", "Is Network", "Is Virtual or Real/Physical printer?", as well as the list of supported Papers and list of trays/bins!

### Printers Watcher
Detect when a new printer is added, when a printer is removed/deleted, and when any changes or modifications are done on any printers available at the client machine. _Windows only_

### Get Print Jobs Status
Trace print jobs status when targeting any installed client printers. Got notified whether the print job completed, number of printed pages, and many more related information.

### Print Server Mode
[JSPrintManager can be installed and configured as a dedicated print service](https://www.neodynamic.com/articles/How-to-print-raw-commands-pdf-files-from-iOS-Android-ChromeOS-sandboxed-devices-from-Javascript) on a given Desktop, Server or Device running Windows, Linux, macOS/OSX or Raspberry Pi OSes

### Print from Mobile & Sandboxed Devices
With [JSPrintManager in Print Server Mode](https://www.neodynamic.com/articles/How-to-print-raw-commands-pdf-files-from-iOS-Android-ChromeOS-sandboxed-devices-from-Javascript), clients such as mobile/sandboxed devices (running iOS, Android, ChromeOS...) and Terminal Services/Citrix environments will be able to print from your website! Useful for Mobile Billing, Mobile POS, Mobile Ordering, etc.

### Print to Any Printer
Print to any brand and type of client printers! Thermal Label Barcode printers, POS receipt printers, Impact printers, Ticket printers, RFID printers, Dot-Matrix, 3D Printers and more!

### Get Printers Info
Besides getting the list of installed printers available in the client machine, you can also get further details like DPI Resolution, PortName, "Is Connected", "Is Shared", "Is Local", "Is Network", "[Is Virtual or Real/Physical printer?](https://www.neodynamic.com/articles/How-to-detect-virtual-real-physical-printer-from-Javascript)", as well as the list of supported Papers and list of trays/bins!

### Tray & Paper Size
If the printer is installed in the client system through a Printer Driver, then you can specify to which Tray Name to send the print job and specify a Paper Size if desired. The file formats supported by this feature are PDF, JPEG, PNG, BMP & TXT

### Printer Communication
Client Printers Connectivity support: installed printers through Printer Driver (for USB connection), Shared Printers, Parallel Port (LPT) or Serial Port RS-232 (COM) as well as IP/Ethernet Network printers. On Linux & Mac OS, any kind of printer installed through CUPS is supported.

### Any Web Platform
Based on pure Javascript code, JSPrintManager.js can be used in any Web Platform like ASP.NET, PHP, Django, Ruby On Rails (RoR), Express.js as well as in any Web Framework like Angular or React

### Cross Platform Client
Any Client platform can print from your Website. JSPrintManager App supports Windows, macOS / OS X, Linux & Raspberry Pi (Linux ARM) devices. It's a very small client App without external dependencies!  ~~No ActiveX,  No Flash,  No Silverlight,  No Java,  No .NET Framework~~


## JSPrintManager Components

- **The Website component (JSPrintManager.js)** is a Javascript object which is used in a website to generate _"Client Print Jobs"_.

- **The Client-side component** is a lightweight native app (without any dependencies) that processes all the _"Client Print Jobs"_ generated by the Javascript object. **JSPrintManager App** can be installed on **Windows, Linux, Mac & Raspberry Pi!** **[Download JSPrintManager App...](https://neodynamic.com/downloads/jspm)**

## How to use JSPrintManager - Sample Code

### React Sample (Online Demo)
This GitHub repo contains the source code of [JSPrintManager Online Demo Website](https://jsprintmanager.azurewebsites.net) which was written by using [**ReactJS**](https://reactjs.org/)

### Angular Sample
If you're an **Angular** dev, then try this sample repo https://github.com/neodynamic/JSPrintManager-Angular

### Vue Sample
If you're a **Vue** dev, then try this sample repo https://github.com/neodynamic/JSPrintManager-Vue

### Any other JS framework
If your using **another Javascript framework** please refer to the different [articles about JSPrintManager and different printing topics which were written in plain Javascript code](https://www.neodynamic.com/products/printing/js-print-manager/articles)


## HOWTOs & Articles

#### Printing Known File Formats
- [Advanced Silent PDF Printing with Tray, Paper Size, Rotation &amp; Pages Range Settings from Javascript](https://www.neodynamic.com/articles/Advanced-Silent-PDF-Printing-Tray-Paper-Size-Rotation-Pages-Range-Settings-from-Javascript)


#### Printing RAW Printer Commands
- [How to print raw commands from Web APIs, WebServices, Remote and Local files with Javascript](https://www.neodynamic.com/articles/How-to-print-raw-commands-from-Web-APIs-WebServices-Remote-and-Local-files-with-Javascript)

- [How to print raw Zebra ZPL commands from Javascript](https://www.neodynamic.com/articles/How-to-print-raw-Zebra-ZPL-commands-from-Javascript)

- [Print Unicode UTF8 Text to Zebra ZPL printer from Javascript](https://www.neodynamic.com/articles/Print-Unicode-UTF8-Text-to-Zebra-ZPL-printer-from-Javascript)

- [How to print raw Zebra EPL commands from Javascript](https://www.neodynamic.com/articles/How-to-print-raw-Zebra-EPL-commands-from-Javascript)

- [How to generate (JSESCPOSBuilder) and print raw ESC/POS commands from Javascript](https://www.neodynamic.com/articles/How-to-generate-and-print-raw-ESC-POS-commands-from-Javascript)

- [How to print raw ESC/POS commands from Javascript](https://www.neodynamic.com/articles/How-to-print-raw-ESC-POS-commands-from-Javascript)

- [How to print raw Intermec IPL commands from Javascript](https://www.neodynamic.com/articles/How-to-print-raw-Intermec-IPL-commands-from-Javascript)

- [How to print raw BOCA FGL commands from Javascript](https://www.neodynamic.com/articles/How-to-print-raw-BOCA-FGL-commands-from-Javascript)

- [How to print raw Datamax DPL commands from Javascript](https://www.neodynamic.com/articles/How-to-print-raw-Datamax-DPL-commands-from-Javascript)

- [How to print raw Godex EZPL commands from Javascript](https://www.neodynamic.com/articles/How-to-print-raw-Godex-EZPL-commands-from-Javascript)

#### HTML &amp; CSS Content
- [Print HTML from Javascript directly to the client printer without print dialog or silent mode](https://www.neodynamic.com/articles/Print-HTML-from-Javascript-to-client-printer-without-print-dialog-silently)

#### MS Word Documents (*.doc; *.docx)
- [Silent Word DOC Printing with Duplex, Reverse & Pages Range Settings from Javascript](https://www.neodynamic.com/articles/Silent-Print-Word-DOC-duplex-pages-range-reverse-from-Javascript)

#### MS Excel Spreadsheet (*.xls; *.xlsx)
- [Silent Excel Spreadsheet XLS Printing with Pages Range Settings from Javascript](https://www.neodynamic.com/articles/Silent-Print-Excel-Spreadsheet-XLS-pages-range-from-Javascript)

#### Image Files (*.jpg; *.png)
- [Silent JPG &amp; PNG Images Printing with custom Location, Size &amp; Page Orientation Settings from Javascript](https://www.neodynamic.com/articles/Silent-Print-Images-JPG-PNG-Location-Size-Page-Orientation-from-Javascript)

#### Mobile &amp; Sandboxed Printing
- [How to print raw commands and pdf files from iOS, Android, ChromeOS and sandboxed devices from Javascript](https://www.neodynamic.com/articles/How-to-print-raw-commands-pdf-files-from-iOS-Android-ChromeOS-sandboxed-devices-from-Javascript)

#### Printers
- [How to detect when a Printer is added or created, updated, deleted or removed from Javascript](https://www.neodynamic.com/articles/How-to-detect-when-Printer-is-added-created-updated-deleted-removed-from-Javascript)

- [How to detect virtual &amp; real-physical printers from Javascript](https://www.neodynamic.com/articles/How-to-detect-virtual-real-physical-printer-from-Javascript)

- [How to trace Print Job Status from Javascript](https://www.neodynamic.com/articles/How-to-trace-Print-Job-Status-from-Javascript)

#### Serial Port Comm
- [How to send/write and receive/read (BIDI) Serial Port Data from Javascript](https://www.neodynamic.com/articles/How-to-send-write-receive-read-bidi-serial-port-data-from-Javascript)

#### Web Scanning
- [How to Scan Documents &amp; Images from Javascript](https://www.neodynamic.com/articles/How-to-scan-documents-images-from-Javascript)

## Licensing

**JSPrintManager is a Commercial** product. Licensing model and prices are available [here](https://neodynamic.com/products/printing/js-print-manager/buy)

## Support

Tech questions are handled by [Neodynamic Dev Team](https://neodynamic/support)
