<?php
class ControllerToolMUpload extends Controller { 
	private $error = array();
 
	public function index() {
        // list of valid extensions, ex. array("jpeg", "xml", "bmp")
        $allowedExtensions = array();
        // max file size in bytes
        $sizeLimit = 10 * 1024 * 1024;
        
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        
              $multi_dir='';
    		  if ($this->config->get('multiimageuploader_folder')) {
    		      $multi_dir="catalog/";
    		      $multi_dir.=$this->config->get('multiimageuploader_folder');
        		  if (!is_dir ( DIR_IMAGE.$multi_dir )) {
        		      mkdir( DIR_IMAGE.$multi_dir, 0777);
        		  }    		      
    		  }
		      if ($this->config->get('multiimageuploader_segment')) {
		          if ($this->config->get('multiimageuploader_segment') == "date") {
		              $multi_dir.=date("Y")."/";
            		  if (!is_dir ( DIR_IMAGE.$multi_dir )) {
            		      mkdir( DIR_IMAGE.$multi_dir, 0777);
            		  } 		              

            		  if (!is_dir ( DIR_IMAGE.$multi_dir )) {
            		      mkdir( DIR_IMAGE.$multi_dir, 0777);
            		  }  		              
		              $multi_dir.=date("m")."/";
            		  if (!is_dir ( DIR_IMAGE.$multi_dir )) {
            		      mkdir( DIR_IMAGE.$multi_dir, 0777);
            		  }  		              
		          }
		          
		      }          
        
        
        $result = $uploader->handleUpload(DIR_IMAGE, $multi_dir);
        
        // to pass data through iframe you will need to encode all html tags
        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }

}


class qqUploadedFileXhr {
    /**
     * Save the file to the specified path
     * @return boolean TRUE on success
     */
    function save($path) {    
        $input = fopen("php://input", "r");
        $temp = tmpfile();
        $realSize = stream_copy_to_stream($input, $temp);
        fclose($input);
        
        if ($realSize != $this->getSize()){            
            return false;
        }
        
        $target = fopen($path, "w");        
        fseek($temp, 0, SEEK_SET);
        stream_copy_to_stream($temp, $target);
        fclose($target);
        
        return true;
    }
    function getName() {
        return $_GET['qqfile'];
    }
    function getSize() {
        if (isset($_SERVER["CONTENT_LENGTH"])){
            return (int)$_SERVER["CONTENT_LENGTH"];            
        } else {
            throw new Exception('Getting content length is not supported.');
        }      
    }   
}

/**
 * Handle file uploads via regular form post (uses the $_FILES array)
 */
class qqUploadedFileForm {  
    /**
     * Save the file to the specified path
     * @return boolean TRUE on success
     */
    function save($path) {
        if(!move_uploaded_file($_FILES['qqfile']['tmp_name'], $path)){
            return false;
        }
        return true;
    }
    function getName() {
        return $_FILES['qqfile']['name'];
    }
    function getSize() {
        return $_FILES['qqfile']['size'];
    }
}

class qqFileUploader {
    private $allowedExtensions = array();
    private $sizeLimit = 10485760;
    private $file;

    function __construct(array $allowedExtensions = array(), $sizeLimit = 10485760){        
        $allowedExtensions = array_map("strtolower", $allowedExtensions);
            
        $this->allowedExtensions = $allowedExtensions;        
        $this->sizeLimit = $sizeLimit;
        
        $this->checkServerSettings();       

        if (isset($_GET['qqfile'])) {
            $this->file = new qqUploadedFileXhr();
        } elseif (isset($_FILES['qqfile'])) {
            $this->file = new qqUploadedFileForm();
        } else {
            $this->file = false; 
        }
    }
    
    private function checkServerSettings(){        
        $postSize = $this->toBytes(ini_get('post_max_size'));
        $uploadSize = $this->toBytes(ini_get('upload_max_filesize'));        
        
        if ($postSize < $this->sizeLimit || $uploadSize < $this->sizeLimit){
            $size = max(1, $this->sizeLimit / 1024 / 1024) . 'M';             
            //die("{'error':'increase post_max_size and upload_max_filesize to $size'}");    
        }        
    }
    
    private function toBytes($str){
        $val = trim($str);
        $last = strtolower($str[strlen($str)-1]);
        switch($last) {
            case 'g': $val *= 1024;
            case 'm': $val *= 1024;
            case 'k': $val *= 1024;        
        }
        return $val;
    }
    
    /**
     * Returns array('success'=>true) or array('error'=>'error message')
     */
    function handleUpload($IMAGEDIR, $uploadDirectory, $replaceOldFile = FALSE){
        if (!is_writable($IMAGEDIR.$uploadDirectory)){
            return array('error' => "Sunucu Hatası. Yükleme klasörü yazılabilir değil!. ".$IMAGEDIR.$uploadDirectory);
        }
        
        if (!$this->file){
            return array('error' => 'Dosyalar yüklenemedi.');
        }
        
        $size = $this->file->getSize();
        
        if ($size == 0) {
            return array('error' => 'Dosya boş!');
        }
        
        if ($size > $this->sizeLimit) {
            return array('error' => 'Dosya boyutu çok büyük!');
        }
        
        $pathinfo = pathinfo($this->file->getName());
        $filename = $pathinfo['filename'];
        //$filename = md5(uniqid());
        $ext = $pathinfo['extension'];

        if($this->allowedExtensions && !in_array(strtolower($ext), $this->allowedExtensions)){
            $these = implode(', ', $this->allowedExtensions);
            return array('error' => 'Dosya geçersiz bir uzantıya sahip, sahip olabileceği uzantılar '. $these . '.');
        }
        
        if(!$replaceOldFile){
            /// don't overwrite previous files that were uploaded
            while (file_exists($IMAGEDIR.$uploadDirectory . $filename . '.' . $ext)) {
                $filename .= rand(10, 99);
            }
        }
        
        if ($this->file->save($IMAGEDIR.$uploadDirectory . $filename . '.' . $ext)){
            $file = $uploadDirectory.$filename.'.'.$ext;
            return array('success'=>true, 'fileName'=>$file);
        } else {
            return array('error'=> 'Yüklenen dosya kaydedilemedi.' .
                'Yükleme iptal edildi veya sunucu hatasıyla karşılaştı');
        }
        
    }    
}

