<?php
class ControllerToolHopishop extends Controller {
    public function index()
    {
        $data['heading_title'] = 'HopiShop Excel Aktarım Aracı';
        $this->document->setTitle($data['heading_title']);

        //$this->load->model('setting/setting');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => 'HopiShop Excel Aktarım Aracı',
            'href' => $this->url->link('tool/hopishop', 'token=' . $this->session->data['token'] , true)
        );

        $this->load->model('catalog/category');
		$categories = $this->model_catalog_category->getSubCategories();
        $data['categories'] = array();
		foreach($categories as $key => $value) {
			$data['categories']+= $this->model_catalog_category->getSubCategories($key);
		}
		unset($categories);
		

        $data['selected_categories'] = null;

        $data['error_warning'] = "";

        $data['token'] = $this->session->data['token'];

		$data['button_save'] = 'Excel\'e Aktar';

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE . 'tool/hopishop.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . 'tool/hopishop', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'tool/hopishop', $data));
        }
    }
/*
    public function export() {
        $server = ($_SERVER['HTTPS']) ? 'https://' . $_SERVER['SERVER_NAME'] : 'http://' . $_SERVER['SERVER_NAME'];

        $ch = curl_init( $server . '/index.php?route=tool/hopishop&selected_categories=' . $this->request->get['selected_categories']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

        curl_exec($ch);
        curl_close($ch);

    }
*/
}