<?php
class ControllerStartupStartup extends Controller {
	public function index() {

        // Settings
        $this->config->set('config_store_id', 0);

        $query = $this->db->query("SELECT * FROM ps_setting WHERE store_id = '0' OR store_id = '" . (int)$this->config->get('config_store_id') . "' ORDER BY store_id ASC");
        foreach ($query->rows as $result) {
            if (!$result['serialized']) {
                $this->config->set($result['key'], $result['value']);
            } else {
                $this->config->set($result['key'], json_decode($result['value'], true));
            }
        }


        /*
        $settings_cache = $this->cache->cache_get('settings', 'settings/');
        if(!$settings_cache){
            $query = $this->db->query("SELECT * FROM ps_setting WHERE store_id = '0' OR store_id = '" . (int)$this->config->get('config_store_id') . "' ORDER BY store_id ASC");
            foreach ($query->rows as $result) {
                if (!$result['serialized']) {
                    $this->config->set($result['key'], $result['value']);
                } else {
                    $this->config->set($result['key'], json_decode($result['value'], true));
                }
            }
            $this->cache->cache_set('settings', $query->rows, 'settings/');
        }else{
            foreach ($settings_cache as $result) {
                if (!$result['serialized']) {
                    $this->config->set($result['key'], $result['value']);
                } else {
                    $this->config->set($result['key'], json_decode($result['value'], true));
                }
            }
        } */

        $this->config->set('config_language_id', 1);
		
		// Language
		$language = new Language($this->config->get('config_admin_language'));
		$language->load($this->config->get('config_admin_language'));
		$this->registry->set('language', $language);
		
		// Customer
		$this->registry->set('customer', new Cart\Customer($this->registry));
		
		// Affiliate
		$this->registry->set('affiliate', new Cart\Affiliate($this->registry));

		// Currency
		$this->registry->set('currency', new Cart\Currency($this->registry));
	
		// Tax
		$this->registry->set('tax', new Cart\Tax($this->registry));
		
		if ($this->config->get('config_tax_default') == 'shipping') {
			$this->tax->setShippingAddress($this->config->get('config_country_id'), $this->config->get('config_zone_id'));
		}

		if ($this->config->get('config_tax_default') == 'payment') {
			$this->tax->setPaymentAddress($this->config->get('config_country_id'), $this->config->get('config_zone_id'));
		}

		$this->tax->setStoreAddress($this->config->get('config_country_id'), $this->config->get('config_zone_id'));

		// Weight
		$this->registry->set('weight', new Cart\Weight($this->registry));
		
		// Length
		$this->registry->set('length', new Cart\Length($this->registry));
		
		// Cart
		$this->registry->set('cart', new Cart\Cart($this->registry));

        $this->registry->set('entegrasyon', new Entegrasyon ($this->registry));
		
		// Encryption
		$this->registry->set('encryption', new Encryption($this->config->get('config_encryption')));

        $this->registry->set('product', new product($this->registry));
		

	}

	private function sqlUpdate()
	{
		$check = $this->db->query("SHOW COLUMNS FROM `ps_option` LIKE 'sub_option' ");
		
		if(!$check->rows){
			$this->db->query("ALTER TABLE `ps_option` ADD `sub_option` INT NOT NULL AFTER `type`;");
		}

		$check = $this->db->query("SHOW COLUMNS FROM `ps_product_option_value` LIKE 'customer_group_id' ");
		if(!$check->rows){
			$this->db->query("ALTER TABLE `ps_product_option_value` ADD `customer_group_id` INT NOT NULL AFTER `weight_prefix`;");
		}

		$check = $this->db->query("SHOW COLUMNS FROM `ps_product_option_value` LIKE 'sub_option_id' ");
		if(!$check->rows){
			$this->db->query("ALTER TABLE `ps_product_option_value` ADD `sub_option_id` INT NOT NULL AFTER `option_id`;");
		}

		$check = $this->db->query("SHOW COLUMNS FROM `ps_product_option_value` LIKE 'sub_option_value_id' ");
		if(!$check->rows){
			$this->db->query("ALTER TABLE `ps_product_option_value` ADD `sub_option_value_id` INT NOT NULL AFTER `sub_option_id`;");
		}

		$check = $this->db->query("SHOW COLUMNS FROM `ps_product_option_value` LIKE 'option_thumb_image' ");
		if(!$check->rows){
			$this->db->query("ALTER TABLE `ps_product_option_value` ADD `option_thumb_image` TEXT NOT NULL AFTER `customer_group_id`;");
		}

		$check = $this->db->query("SHOW COLUMNS FROM `ps_product_option_value` LIKE 'option_value_barcode' ");
		if(!$check->rows){
			$this->db->query("ALTER TABLE `ps_product_option_value` ADD `option_value_barcode` VARCHAR(255) NOT NULL AFTER `option_thumb_image`;");
		}

		//
		$check = $this->db->query("SHOW COLUMNS FROM `ps_information_description` LIKE 'description_html' ");
		if(!$check->rows){
			$this->db->query("ALTER TABLE `ps_information_description` ADD `description_html` TEXT NOT NULL AFTER `description`;");
		}

	}
	
}