<?php

class ControllerSettingInstalment extends Controller{
	
	private $error = array();

	public function index(){

		$this->load->language('setting/instalment');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/category');
		$this->load->model('setting/instalment');

		$this->getList();


	}

	public function add() {
        $this->load->language('setting/instalment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/instalment');

        if ($this->request->server['REQUEST_METHOD'] == 'POST') { 
            $this->model_setting_instalment->addInstalment($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/instalment', 'token=' . $this->session->data['token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
       $this->load->language('setting/instalment');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/category');
        $this->load->model('setting/instalment');

        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $this->model_setting_instalment->editInstalment($this->request->get['id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/instalment', 'token=' . $this->session->data['token'] . $url, true));
        }

        $this->getForm();
    }

	protected function getList(){

		$data['token'] = $this->session->data['token'];

		if (isset($this->request->get['sort'])) {
		    $sort = $this->request->get['sort'];
		} else {
		    $sort = 'name';
		}

		if (isset($this->request->get['order'])) {
		    $order = $this->request->get['order'];
		} else {
		    $order = 'ASC';
		}

		if (isset($this->request->get['page'])) {
		    $page = $this->request->get['page'];
		} else {
		    $page = 1;
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
		    $url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
		    $url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
		    $url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
		    'text' => $this->language->get('text_home'),
		    'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
		    'text' => $this->language->get('heading_title'),
		    'href' => $this->url->link('setting/instalment', 'token=' . $this->session->data['token'] . $url, true)
		);

		$data['add'] = $this->url->link('setting/instalment/add', 'token=' . $this->session->data['token'] . $url, true);
		$data['delete'] = $this->url->link('setting/instalment/delete', 'token=' . $this->session->data['token'] . $url, true);
		

		$data['instalments'] = array();

		
		$category_total = $this->model_setting_instalment->getTotalInstalments();

		$results = $this->model_setting_instalment->getInstalments();

		foreach ($results as $result) {
		    $data['instalments'][] = array(
		        'instalment_id' 	=> $result['id'],
		        'category_id' 		=> $result['category_id'],
		        'name' 				=> $result['name'],
		        'instalment_values' => $result['instalment_values'],
		        'edit'        => $this->url->link('setting/instalment/edit', 'token=' . $this->session->data['token'] . '&id=' . $result['id'] . $url, true),
		        'delete'      => $this->url->link('setting/instalment/delete', 'token=' . $this->session->data['token'] . '&id=' . $result['id'] . $url, true)
		    );
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');

		$data['column_name'] = $this->language->get('column_name');
		$data['column_sort_order'] = $this->language->get('column_sort_order');
		$data['column_action'] = $this->language->get('column_action');
		$data['column_instalment'] = $this->language->get('column_instalment');

		$data['button_add'] = $this->language->get('button_add');
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');
		$data['button_rebuild'] = $this->language->get('button_rebuild');

		if (isset($this->error['warning'])) {
		    $data['error_warning'] = $this->error['warning'];
		} else {
		    $data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
		    $data['success'] = $this->session->data['success'];

		    unset($this->session->data['success']);
		} else {
		    $data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
		    $data['selected'] = (array)$this->request->post['selected'];
		} else {
		    $data['selected'] = array();
		}

		$url = '';

		if ($order == 'ASC') {
		    $url .= '&order=DESC';
		} else {
		    $url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
		    $url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_name'] = $this->url->link('catalog/category', 'token=' . $this->session->data['token'] . '&sort=name' . $url, true);
		$data['sort_sort_order'] = $this->url->link('catalog/category', 'token=' . $this->session->data['token'] . '&sort=sort_order' . $url, true);

		$url = '';

		if (isset($this->request->get['sort'])) {
		    $url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
		    $url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $category_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('catalog/category', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($category_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($category_total - $this->config->get('config_limit_admin'))) ? $category_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $category_total, ceil($category_total / $this->config->get('config_limit_admin')));

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');


		if(file_exists(DIR_LOCAL_TEMPLATE .'setting/instalment_list.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'setting/instalment_list', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'setting/instalment_list', $data));
		}

		

	}

	public function delete() {
	    $this->load->language('setting/instalment');

	    $this->document->setTitle($this->language->get('heading_title'));

	    $this->load->model('setting/instalment');

	    if (isset($this->request->post['selected'])) {
	        foreach ($this->request->post['selected'] as $instalment_id) {
	            $this->model_setting_instalment->deleteInstalment($instalment_id);
	        }

	        $this->session->data['success'] = $this->language->get('text_success');

	        $url = '';

	        if (isset($this->request->get['sort'])) {
	            $url .= '&sort=' . $this->request->get['sort'];
	        }

	        if (isset($this->request->get['order'])) {
	            $url .= '&order=' . $this->request->get['order'];
	        }

	        if (isset($this->request->get['page'])) {
	            $url .= '&page=' . $this->request->get['page'];
	        }

	        $this->response->redirect($this->url->link('setting/instalment', 'token=' . $this->session->data['token'] . $url, true));
	    }

	    $this->getList();
	}

    protected function getForm() {

    	$data['heading_title'] = $this->language->get('heading_title');

        $data['text_form'] = !isset($this->request->get['id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['text_none'] = $this->language->get('text_none');
        $data['text_default'] = $this->language->get('text_default');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        
        $data['entry_category'] = $this->language->get('entry_category');
        $data['entry_instalment'] = $this->language->get('entry_instalment');
        $data['entry_status'] = $this->language->get('entry_status');
      

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = array();
        }

        if (isset($this->error['meta_title'])) {
            $data['error_meta_title'] = $this->error['meta_title'];
        } else {
            $data['error_meta_title'] = array();
        }

        if (isset($this->error['keyword'])) {
            $data['error_keyword'] = $this->error['keyword'];
        } else {
            $data['error_keyword'] = '';
        }

        if (isset($this->error['parent'])) {
            $data['error_parent'] = $this->error['parent'];
        } else {
            $data['error_parent'] = '';
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/instalment', 'token=' . $this->session->data['token'] . $url, true)
        );

        if (!isset($this->request->get['id'])) {
            $data['action'] = $this->url->link('setting/instalment/add', 'token=' . $this->session->data['token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('setting/instalment/edit', 'token=' . $this->session->data['token'] . '&id=' . $this->request->get['id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('setting/instalment', 'token=' . $this->session->data['token'] . $url, true);

        if (isset($this->request->get['id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $instalment_info = $this->model_setting_instalment->getInstalment($this->request->get['id']);
        }

        $data['token'] = $this->session->data['token'];

        $this->load->model('catalog/category');
      
      	$data['categories'] = $this->model_catalog_category->getCategories();

        

        if (isset($this->request->post['category_id'])) {
            $data['category_id'] = $this->request->post['category_id'];
        } elseif (!empty($instalment_info)) {
            $data['category_id'] = $instalment_info['category_id'];
        } else {
            $data['category_id'] = '';
        }

        if (isset($this->request->post['instalment'])) {
            $data['instalment'] = $this->request->post['instalment'];
        } elseif (!empty($instalment_info)) {
            $data['instalment'] = $instalment_info['instalment_values'];
        } else {
            $data['instalment'] = '';
        }

        
        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($instalment_info)) {
            $data['status'] = $instalment_info['status'];
        } else {
            $data['status'] = true;
        }

        

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE .'setting/instalment_form.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'setting/instalment_form', $data));
        }else{ 
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'setting/instalment_form', $data));
        }




    }










}

