<?php
class ControllerSaleSeymaOrders extends Controller {  

    private $error = array();

    public function index() {
        
        $this->load->language('sale/seyma_orders');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');
        
        $this->getList();

        
    }
    protected function getList() {

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_order_payment'])) {
            $filter_order_payment = $this->request->get['filter_order_payment'];
        } else {
            $filter_order_payment = null;
        }

        if (isset($this->request->get['filter_order_zone'])) {
            $filter_order_zone = $this->request->get['filter_order_zone'];
        } else {
            $filter_order_zone = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }

        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true)
        );

        $data['invoice'] = $this->url->link('sale/order/invoice', 'token=' . $this->session->data['token'], true);
        $data['shipping'] = $this->url->link('sale/order/shipping', 'token=' . $this->session->data['token'], true);
        $data['add'] = $this->url->link('sale/order/add', 'token=' . $this->session->data['token'], true);
        $data['delete'] = $this->url->link('sale/order/delete', 'token=' . $this->session->data['token'], true);

        $data['orders'] = array();

        $filter_data = array(
            'filter_order_id' => $filter_order_id,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_customer' => $filter_customer,
            'filter_order_status' => $filter_order_status,
            'filter_order_zone' => $filter_order_zone,
            'filter_order_payment' => $filter_order_payment,
            'filter_total' => $filter_total,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $order_total = $this->model_sale_order->getTotalOrders($filter_data);

        $results = $this->model_sale_order->getOrders($filter_data);

        $totalPriceOfOrderProducts = 0;
        foreach ($results as $result) {//var_dump($result); die();
            $order_customer_id = 0;
            $order_customer_id = $this->model_sale_order->getOrderCustomerId($result['order_id']);
            $order_products = $this->model_sale_order->getOrderProducts($result['order_id']);

            $order_products = array_filter (
                $order_products,
                function ($order_product) {
                    return ( stristr ($order_product ['model'], "ss"));
                }
            );
            
            foreach($order_products as $order_product){

                $total_customer_orders = 0;
                if ($order_customer_id > 0) {
                    $total_customer_orders = $this->model_sale_order->getTotalOrdersByCustomer($order_customer_id);
                }

                $data['orders'][] = array(
                    'order_id' => $order_product['order_id'],
                    'customer' => $result['customer'],
                    'product_name' => $order_product['name'],
                    'customer_id' => $order_customer_id,
                    'total_customer_orders' => $total_customer_orders,
                    'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                    'price' => $this->currency->format($order_product['price'], $result['currency_code'], $result['currency_value']),
                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),

                );

                $totalPriceOfOrderProducts += floatval(str_replace(",",".",end($data['orders'])['price']));

            } 
        }

        $sql = "SELECT SUM(total) * 1.18 AS Result, COUNT(*) AS Amount FROM ps_order_product
        WHERE model LIKE '%ss%' AND 
        order_id NOT IN ( SELECT order_id FROM ps_order WHERE (total = 0.0000 OR total = 6.0000) AND 
        order_id IN ( SELECT order_id FROM ps_order_product WHERE model LIKE '%ss%' ) )";
        $query = $this->db->query($sql);


        /*$sql = "SELECT SUM(o.total) * 1.18 AS Result, COUNT(*) AS Amount FROM ps_order o
        LEFT JOIN ps_order_product od ON(o.order_id = od.order_id)
        WHERE od.model LIKE '%ss%' AND (o.total != 0.0000 OR o.total != 6.0000) AND (o.date_added BETWEEN '2020-02-01' AND '2020-02-29') ";

        $query = $this->db->query($sql);*/





        $data['percent_thirty'] = $query->row['Result'] / 100 * 30;
        $data['total_seyma'] = $query->row['Result'];

        $data['total_orders'] = $query->row['Amount'];

        //var_dump($data['total_seyma']); die();


        $data['total_price'] = ($totalPriceOfOrderProducts . "₺");

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_missing'] = $this->language->get('text_missing');
        $data['text_loading'] = $this->language->get('text_loading');

        $data['column_order_id'] = $this->language->get('column_order_id');
        $data['column_customer'] = $this->language->get('column_customer');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_total'] = $this->language->get('column_total');
        $data['column_product_name'] = $this->language->get('column_product_name');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_date_modified'] = $this->language->get('column_date_modified');
        $data['column_action'] = $this->language->get('column_action');

        $data['entry_order_id'] = $this->language->get('entry_order_id');
        $data['entry_customer'] = $this->language->get('entry_customer');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_total'] = $this->language->get('entry_total');
        $data['entry_date_added'] = $this->language->get('entry_date_added');
        $data['entry_date_modified'] = $this->language->get('entry_date_modified');

        $data['button_invoice_print'] = $this->language->get('button_invoice_print');
        $data['button_shipping_print'] = $this->language->get('button_shipping_print');

        $data['button_filter'] = $this->language->get('button_filter');
        $data['button_view'] = $this->language->get('button_view');
        $data['button_ip_add'] = $this->language->get('button_ip_add');

        $this->load->model('localisation/zone');
        $data['zones'] = $this->model_localisation_zone->getZonesByCountryId($this->config->get('config_country_id'));

        $data['shipping_methods'] = $this->model_sale_order->getShippingMethods();

        $data['paymnet_methods'] = $this->model_sale_order->getPaymentMethods();


        $data['token'] = $this->session->data['token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }

        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_order'] = $this->url->link('sale/seyma_orders', 'token=' . $this->session->data['token'] . '&sort=o.order_id' . $url, true);
        $data['sort_product_name'] = $this->url->link('sale/seyma_orders', 'token=' . $this->session->data['token'] . '&sort=o.product_name' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/seyma_orders', 'token=' . $this->session->data['token'] . '&sort=customer' . $url, true);
        $data['sort_status'] = $this->url->link('sale/seyma_orders', 'token=' . $this->session->data['token'] . '&sort=order_status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/seyma_orders', 'token=' . $this->session->data['token'] . '&sort=o.total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/seyma_orders', 'token=' . $this->session->data['token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/seyma_orders', 'token=' . $this->session->data['token'] . '&sort=o.date_modified' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }

        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/seyma_orders', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        //$data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['filter_order_id'] = $filter_order_id;
        $data['filter_email'] = $filter_email;
        $data['filter_telephone'] = $filter_telephone;
        $data['filter_customer'] = $filter_customer;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_order_zone'] = $filter_order_zone;
        $data['filter_order_payment'] = $filter_order_payment;
        $data['filter_total'] = $filter_total;
        $data['filter_date_added'] = $filter_date_added;
        $data['filter_date_modified'] = $filter_date_modified;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_list.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/seyma_order_list', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/seyma_order_list', $data));
        }
    }

}