<?php

require_once DIR_SYSTEM . "picqer" . DIRECTORY_SEPARATOR . "php-barcode-generator" . DIRECTORY_SEPARATOR . "generate-verified-files.php";

require_once DIR_SYSTEM . 'dompdf/autoload.inc.php';

class ControllerSalePreparedOrders extends Controller
{
    use MngArasYurticiTrait;

    private $error = array();

    public function index()
    {
        error_reporting(0);

        $this->load->language('sale/prepared_orders');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/order');

        $this->getList();
    }

    public function getList()
    {

        $data['editUrl'] = $this->url->link('catalog/product/edit', 'token=' . $this->session->data['token'] . '&product_id=', true); //17.09.20 idle stock update (ali.a)
        $data['preparedProductsUrl'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'], true); //20.09.20 idle stock update (ali.a)

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }


        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }


        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }


        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }


        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }


        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['row_color_code'])) {
            $row_color_code = $this->request->get['row_color_code'];
        } else {
            $row_color_code = '';
        }


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }


        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }


        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }


        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }
        //20.09.20 decrease product idle stock (ali.a)
        $data['filtersUrl'] = $url;
        if (isset($this->request->get['decreaseIdleStock'])) {
            $this->load->model('sale/order');
            $productId = $this->request->get['decreaseIdleStock'];
            $this->model_sale_order->decreaseIdleStock($productId);
            $preparedProductsUrl = $this->url->link('sale/prepared_orders');
            header('Location: ' . $preparedProductsUrl . '&token=' . $this->session->data['token']);
            exit;
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );


        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . $url, true)
        );


        ///Buraya islemlerin linki gelcek


        $data['kargo_firma'] = 'YURTICI';

        if ($this->config->get('yurticikargo_status')) {
            $data['yurticikargo_status'] = $this->config->get('yurticikargo_status');
        } else {
            $data['yurticikargo_status'] = false;
        }



        if ($this->config->get('araskargo_status')) {
            $data['araskargo_status'] = $this->config->get('araskargo_status');
        } else {
            $data['araskargo_status'] = false;
        }


        $filter_by = '';
        if (isset($this->request->get['filter_by'])) {
            $filter_by = $this->request->get['filter_by'];
        }

        // filtre butonlarına row_color_code ekleme -Can 30.12.2021
        $buttons_filter_url = "";
        $buttons_filter_url .= ($row_color_code !== "") ? '&row_color_code=' . $row_color_code : "";
        // filtre butonlarına row_color_code ekleme son
        $data['filter_by_personalized'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&filter_by=personalized' . $buttons_filter_url, true);
        $data['filter_by_reprinted'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&filter_by=reprinted' . $buttons_filter_url, true);
        $data['all_products'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . $buttons_filter_url, true);

        //$data['filter_by_personalized'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&filter_by=personalized', true);
        //$data['filter_by_reprinted'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&filter_by=reprinted', true);
        //$data['all_products'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'], true);
        $data['bulkdownload'] = $this->url->link('sale/prepared_orders/bulkDownload', 'token=' . $this->session->data['token'], true);

        $data['orders'] = array();


        /*------------------------- for specific user case we bulk load orders without lazyload    --------------------------------*/
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->user->getId());

        //if (in_array($user_info['user_id'], array(22, 17, 46,3))) {
        $config_limit_admin = 20000;

        $start = ($page - 1) * $config_limit_admin;

        $sql = "SELECT
                        po.order_id, 
                        CONCAT(o.firstname, ' ', o.lastname) AS customer, 
                        o.row_color_code,
                        (SELECT 
                            os.name 
                        FROM ps_order_status os 
                        WHERE 
                            os.order_status_id = o.order_status_id AND 
                            os.language_id ='" . (int)$this->config->get('config_language_id') . "') 
                        AS order_status, 
                        o.shipping_code, 
		                o.total, 
		                o.currency_code, 
		                o.currency_value, 
		                o.date_added, 
		                o.date_modified, 
                        o.shipping_zone,
		                o.status, 
		                o.comment,
		                o.customer_id,
		                o.order_status_id,
                        o.payment_code
                        FROM ps_prepared_orders po 
                        LEFT JOIN ps_order o ON (po.order_id = o.order_id) WHERE po.status = 0 AND o.status = 0 AND po.row_color_code = '#" . $this->db->escape($row_color_code) . "'
                        ORDER BY 
                        o.date_added ASC 
                        LIMIT " . (int)$start . "," . (int)$config_limit_admin;

        // var_dump($sql); die();


        $data['complated_count'] = 0;

        $results = $this->db->query($sql)->rows;

        $order_total_products = $this->db->query("SELECT COUNT(op.product_id) AS total FROM ps_prepared_orders po LEFT JOIN ps_order_product op ON (po.order_id = op.order_id) WHERE po.status = 0  ")->row['total'];

        $order_total = $this->db->query("SELECT COUNT(order_id) AS total FROM ps_prepared_orders WHERE status = 0 AND row_color_code = '#" . $this->db->escape($row_color_code) . "' ")->row['total'];

        $data['order_total'] = $order_total;
        $data['order_total_products'] = $order_total_products;

        $data['products'] = array();

        $this->load->model('extension/module/yurticikargo');
        $this->load->model('extension/module/suratkargo');
        $this->load->model('extension/module/byexpresskargo');
        $this->load->model('extension/module/araskargo');
        $this->load->model('extension/module/mngkargo');
        $this->load->model('extension/module/scottycargo');

        $order_total_product = 0;

        $test_count = 0;

        foreach ($results as $result) {
            //$order_products = $this->db->query("SELECT op.*,p.image,p.product_type,p.model2,p.idle_stock,op.show_idle_stock  FROM ps_order_product op LEFT JOIN ps_product p ON p.product_id=op.product_id WHERE op.order_id = '". (int)$result['order_id'] ."'  ")->rows;

            $order_products = "SELECT op.*,p.image,p.product_type,p.model2,p.idle_stock FROM ps_order_product op LEFT JOIN ps_product p ON p.product_id=op.product_id WHERE op.order_id = '" . (int)$result['order_id'] . "'  ";

            if (isset($this->request->get['filter_by'])) {
                if ($this->request->get['filter_by'] == "reprinted") {
                    $order_products .= " AND op.reprint_download_count = 0";
                }
            }

            $order_products = $this->db->query($order_products)->rows;
            //$data['complated_count'] += $this->db->query("SELECT COUNT(order_id) AS total FROM ps_order_product WHERE order_id = '". (int)$result['order_id'] ."' AND status = 1 ")->row['total'];


            if ($order_products) {

                $this->load->model('tool/image');

                foreach ($order_products as $order_product) {
                    $test_count++;


                    $p_model2 = $order_product['model2'];
                    if ($order_product['model2'] != '' && $order_product['product_type'] == 7)
                        $p_model2 = str_replace('cst001-', '', str_replace('_', '-', str_replace('kişiye_özel_telefon_kılıfları-', '', $p_model2)));

                    $case_image = $image['image'];

                    $data['product_idle_stock'][$order_product['product_id']] = $order_product['idle_stock']; //17.09.20 idle stock (ali.a)

                    $image = isset($image['image']) ? $this->model_tool_image->resize($image['image'], 100, 100) : '';
                    // Order Options
                    $option_data = array();
                    $options = $this->model_sale_order->getOrderOptions($order_product['order_id'], $order_product['order_product_id']);
                    foreach ($options as $option) {
                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $option['value'],
                            'type' => $option['type']
                        );
                    }

                    // Order Options
                    $case_pattern_image = $this->model_tool_image->resize($order_product['case_order_image'], 100, 100);

                    $customcase_image = '';

                    if ($order_product['customcase_image'] != '') {

                        $str = explode('***', $order_product['customcase_image']);

                        $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];

                        if ($case_image != '' && file_exists(DIR_IMAGE . $case_image))
                            $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $case_image;

                        else
                            $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/personal/' . $str[0] . '.png';
                    }

                    $total_customer_orders = 0;
                    /*if ($order_customer_id > 0) {
                            $total_customer_orders = $this->model_sale_order->getTotalOrdersByCustomer($order_customer_id);
                        }*/


                    $customer_pattern_data = json_decode($order_product['customer_pattern_data'], true);
                    if (isset($customer_pattern_data['pattern_text'])) {
                        $case_text = $customer_pattern_data['pattern_text'];
                    } else {
                        $case_text = '';
                    }


                    $order_comment = $result['comment'];


                    if ($result['status'] != 1 and !$order_product['return_status']) {

                        if ($filter_by == 'personalized' && $case_text != '') {

                            if ($order_product['quantity'] > 1) {
                                for ($temp = 1; $temp <= $order_product['quantity']; $temp++) {
                                    $order_total_product++;
                                    $data['products'][] = array(
                                        'order_product_id' => $order_product['order_product_id'],
                                        'product_id' => $order_product['product_id'],
                                        'order_id' => $result['order_id'],
                                        'model' => $order_product['model'],
                                        'model2' => $p_model2,
                                        'product_type' => $customer_pattern_data['product_type'],
                                        'name' => $order_product['name'],
                                        'idle_stock' => $order_product['idle_stock'],
                                        'image' => $image,
                                        'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                        'customer_pattern_data' => $order_product['customer_pattern_data'],
                                        'case_text' => $case_text,
                                        'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                        'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                        'customcase_image' => $customcase_image,
                                        'case_image' => $case_image,
                                        'customer' => $result['customer'],
                                        'product_model' => $order_product['model'],
                                        'comment' => $order_comment,
                                        'option' => array(),
                                        'quantity' => 1,
                                        'total_customer_orders' => $total_customer_orders,
                                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                        'shipping_zone' => $result['shipping_zone'],
                                        'payment_code' => $result['payment_code'],
                                        'status' => $order_product['status'],
                                        'reprint' => $order_product['reprint'],
                                        'reprint_download_count' => $order_product['reprint_download_count'],
                                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                        'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                        'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                        'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                        'options' => $options,
                                        'shipping_code' => $result['shipping_code'],
                                        'reprint_reason_id' => $order_product['reprint_reason_id'],
                                        'return_status' => $order_product['return_status'],
                                        'room_no' => $order_product['room_no'],
                                        //'show_idle_stock' => $order_product['show_idle_stock'],
                                        'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                    );
                                }
                            } else {
                                $order_total_product++;
                                $data['products'][] = array(
                                    'order_product_id' => $order_product['order_product_id'],
                                    'product_id' => $order_product['product_id'],
                                    'order_id' => $result['order_id'],
                                    'model' => $order_product['model'],
                                    'model2' => $p_model2,
                                    'product_type' => $customer_pattern_data['product_type'],
                                    'name' => $order_product['name'],
                                    'idle_stock' => $order_product['idle_stock'],
                                    'image' => $image,
                                    'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                    'customer_pattern_data' => $order_product['customer_pattern_data'],
                                    'case_text' => $case_text,
                                    'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                    'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                    'customcase_image' => $customcase_image,
                                    'case_image' => $case_image,
                                    'customer' => $result['customer'],
                                    'product_model' => $order_product['model'],
                                    'comment' => $order_comment,
                                    'option' => array(),
                                    'quantity' => $order_product['quantity'],
                                    'total_customer_orders' => $total_customer_orders,
                                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                    'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                    'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                    'shipping_zone' => $result['shipping_zone'],
                                    'payment_code' => $result['payment_code'],
                                    'status' => $order_product['status'],
                                    'reprint' => $order_product['reprint'],
                                    'reprint_download_count' => $order_product['reprint_download_count'],
                                    'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                    'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                    'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                    'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                    'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                    'options' => $options,
                                    'shipping_code' => $result['shipping_code'],
                                    'reprint_reason_id' => $order_product['reprint_reason_id'],
                                    'return_status' => $order_product['return_status'],
                                    'room_no' => $order_product['room_no'],
                                    //'show_idle_stock' => $order_product['show_idle_stock'],
                                    'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                );
                            }
                        } elseif ($filter_by == 'reprinted' && $order_product['reprint']) {


                            if ($order_product['quantity'] > 1) {
                                for ($temp = 1; $temp <= $order_product['quantity']; $temp++) {
                                    $order_total_product++;
                                    $data['products'][] = array(
                                        'order_product_id' => $order_product['order_product_id'],
                                        'product_id' => $order_product['product_id'],
                                        'order_id' => $result['order_id'],
                                        'model' => $order_product['model'],
                                        'model2' => $p_model2,
                                        'product_type' => $customer_pattern_data['product_type'],
                                        'name' => $order_product['name'],
                                        'idle_stock' => $order_product['idle_stock'],
                                        'image' => $image,
                                        'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                        'customer_pattern_data' => $order_product['customer_pattern_data'],
                                        'case_text' => $case_text,
                                        'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                        'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                        'customcase_image' => $customcase_image,
                                        'case_image' => $case_image,
                                        'customer' => $result['customer'],
                                        'product_model' => $order_product['model'],
                                        'comment' => $order_comment,
                                        'option' => array(),
                                        'quantity' => 1,
                                        'total_customer_orders' => $total_customer_orders,
                                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                        'shipping_zone' => $result['shipping_zone'],
                                        'payment_code' => $result['payment_code'],
                                        'status' => $order_product['status'],
                                        'reprint' => $order_product['reprint'],
                                        'reprint_download_count' => $order_product['reprint_download_count'],
                                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                        'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                        'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                        'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                        'options' => $options,
                                        'shipping_code' => $result['shipping_code'],
                                        'reprint_reason_id' => $order_product['reprint_reason_id'],
                                        'return_status' => $order_product['return_status'],
                                        'room_no' => $order_product['room_no'],
                                        //'show_idle_stock' => $order_product['show_idle_stock'],
                                        'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                    );
                                }
                            } else {
                                $order_total_product++;
                                $data['products'][] = array(
                                    'order_product_id' => $order_product['order_product_id'],
                                    'product_id' => $order_product['product_id'],
                                    'order_id' => $result['order_id'],
                                    'model' => $order_product['model'],
                                    'model2' => $p_model2,
                                    'product_type' => $customer_pattern_data['product_type'],
                                    'name' => $order_product['name'],
                                    'idle_stock' => $order_product['idle_stock'],
                                    'image' => $image,
                                    'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                    'customer_pattern_data' => $order_product['customer_pattern_data'],
                                    'case_text' => $case_text,
                                    'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                    'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                    'customcase_image' => $customcase_image,
                                    'case_image' => $case_image,
                                    'customer' => $result['customer'],
                                    'product_model' => $order_product['model'],
                                    'comment' => $order_comment,
                                    'option' => array(),
                                    'quantity' => $order_product['quantity'],
                                    'total_customer_orders' => $total_customer_orders,
                                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                    'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                    'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                    'shipping_zone' => $result['shipping_zone'],
                                    'payment_code' => $result['payment_code'],
                                    'status' => $order_product['status'],
                                    'reprint' => $order_product['reprint'],
                                    'reprint_download_count' => $order_product['reprint_download_count'],
                                    'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                    'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                    'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                    'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                    'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                    'options' => $options,
                                    'shipping_code' => $result['shipping_code'],
                                    'reprint_reason_id' => $order_product['reprint_reason_id'],
                                    'return_status' => $order_product['return_status'],
                                    'room_no' => $order_product['room_no'],
                                    //'show_idle_stock' => $order_product['show_idle_stock'],
                                    'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                );
                            }
                        } elseif ($filter_by == '') {


                            if ($order_product['quantity'] > 1) {
                                for ($temp = 1; $temp <= $order_product['quantity']; $temp++) {
                                    $order_total_product++;
                                    $data['products'][] = array(
                                        'order_product_id' => $order_product['order_product_id'],
                                        'product_id' => $order_product['product_id'],
                                        'order_id' => $result['order_id'],
                                        'model' => $order_product['model'],
                                        'model2' => $p_model2,
                                        'product_type' => $customer_pattern_data['product_type'],
                                        'name' => $order_product['name'],
                                        'idle_stock' => $order_product['idle_stock'],
                                        'image' => $image,
                                        'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                        'customer_pattern_data' => $order_product['customer_pattern_data'],
                                        'case_text' => $case_text,
                                        'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                        'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                        'customcase_image' => $customcase_image,
                                        'case_image' => $case_image,
                                        'customer' => $result['customer'],
                                        'product_model' => $order_product['model'],
                                        'comment' => $order_comment,
                                        'option' => array(),
                                        'quantity' => 1,
                                        'total_customer_orders' => $total_customer_orders,
                                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                        'shipping_zone' => $result['shipping_zone'],
                                        'payment_code' => $result['payment_code'],
                                        'status' => $order_product['status'],
                                        'reprint' => $order_product['reprint'],
                                        'reprint_download_count' => $order_product['reprint_download_count'],
                                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                        'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                        'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                        'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                        'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                        'options' => $options,
                                        'shipping_code' => $result['shipping_code'],
                                        'reprint_reason_id' => $order_product['reprint_reason_id'],
                                        'return_status' => $order_product['return_status'],
                                        'room_no' => $order_product['room_no'],
                                        //'show_idle_stock' => $order_product['show_idle_stock'],
                                        'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                    );
                                }
                            } else {
                                $order_total_product++;
                                $data['products'][] = array(
                                    'order_product_id' => $order_product['order_product_id'],
                                    'product_id' => $order_product['product_id'],
                                    'order_id' => $result['order_id'],
                                    'model' => $order_product['model'],
                                    'model2' => $p_model2,
                                    'product_type' => $customer_pattern_data['product_type'],
                                    'name' => $order_product['name'],
                                    'idle_stock' => $order_product['idle_stock'],
                                    'image' => $image,
                                    'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                    'customer_pattern_data' => $order_product['customer_pattern_data'],
                                    'case_text' => $case_text,
                                    'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                    'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                    'customcase_image' => $customcase_image,
                                    'case_image' => $case_image,
                                    'customer' => $result['customer'],
                                    'product_model' => $order_product['model'],
                                    'comment' => $order_comment,
                                    'option' => array(),
                                    'quantity' => $order_product['quantity'],
                                    'total_customer_orders' => $total_customer_orders,
                                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                    'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                    'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                    'shipping_zone' => $result['shipping_zone'],
                                    'payment_code' => $result['payment_code'],
                                    'status' => $order_product['status'],
                                    'reprint' => $order_product['reprint'],
                                    'reprint_download_count' => $order_product['reprint_download_count'],
                                    'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                    'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                    'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                    'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                    'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                    'options' => $options,
                                    'shipping_code' => $result['shipping_code'],
                                    'reprint_reason_id' => $order_product['reprint_reason_id'],
                                    'return_status' => $order_product['return_status'],
                                    'room_no' => $order_product['room_no'],
                                    //'show_idle_stock' => $order_product['show_idle_stock'],
                                    'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                );
                            }
                        }
                    }
                }
            }
        }


        //}


        // $data['products'] dizisine ek eklemeler
        foreach($data['products'] as $p_key => $dataItem){
            $data['products'][$p_key]['mngcargo_info'] = $this->model_extension_module_mngkargo->getShippingData($dataItem['order_id']);
            $data['products'][$p_key]['mngcargo_barcode'] = $this->url->link('sale/prepared_orders/mngcargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$dataItem['order_id'], true);
        }

        /*------------------------- End  for specific user case  bulk load orders without lazyload    --------------------------------*/


        $data['heading_title'] = $this->language->get('heading_title');

        $data['order_total_product'] = $order_total_product;


        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_missing'] = $this->language->get('text_missing');
        $data['text_loading'] = $this->language->get('text_loading');


        $data['column_order_id'] = $this->language->get('column_order_id');
        $data['column_customer'] = $this->language->get('column_customer');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_product_name'] = $this->language->get('column_product_name');
        $data['column_product_model'] = $this->language->get('column_product_model');
        $data['column_quantity'] = $this->language->get('column_quantity');

        $data['column_comment'] = $this->language->get('column_comment');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_date_modified'] = $this->language->get('column_date_modified');
        $data['column_action'] = $this->language->get('column_action');
        $data['column_image'] = $this->language->get('column_image');


        $data['entry_order_id'] = $this->language->get('entry_order_id');
        $data['entry_customer'] = $this->language->get('entry_customer');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_date_added'] = $this->language->get('entry_date_added');
        $data['entry_date_modified'] = $this->language->get('entry_date_modified');


        $data['button_invoice_print'] = $this->language->get('button_invoice_print');
        $data['button_shipping_print'] = $this->language->get('button_shipping_print');
        $data['button_filter'] = $this->language->get('button_filter');
        $data['button_view'] = $this->language->get('button_view');
        $data['button_ip_add'] = $this->language->get('button_ip_add');
        $data['button_delete'] = $this->language->get('button_delete');
        $data['delete'] = $this->url->link('sale/prepared_orders/delete', 'token=' . $this->session->data['token'], true);


        $data['token'] = $this->session->data['token'];


        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }


        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }


        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }


        if (isset($this->request->get['page'])) {

            $url .= '&page=' . $this->request->get['page'];
        }


        $data['sort_order'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=o.order_id' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=customer' . $url, true);
        $data['sort_status'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=order_status' . $url, true);
        $data['sort_p_model'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=o.p_model' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=o.date_modified' . $url, true);

        $url = '';


        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        /*-------------------------   for specific user case  we  load bulk orders without lazyload    --------------------------------*/

        // if (in_array($user_info['user_id'], array(22, 17, 46, 3))) {
        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = (isset($_GET['limit'])) ? $_GET['limit'] : $config_limit_admin;
        $pagination->url = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);
        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $config_limit_admin) + 1 : 0, ((($page - 1) * $config_limit_admin) > ($order_total - $config_limit_admin)) ? $order_total : ((($page - 1) * $config_limit_admin) + $config_limit_admin), $order_total, ceil($order_total / $config_limit_admin));

        $data['filter_order_id'] = $filter_order_id;
        $data['filter_customer'] = $filter_customer;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_date_added'] = $filter_date_added;
        $data['filter_date_modified'] = $filter_date_modified;
        $data['sort'] = $sort;
        $data['order'] = $order;
        //}
        /*------------------------- End  for specific user case   load bulk orders without lazyload    --------------------------------*/


        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        // The URL we send API requests to

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        $data['order_status_id'] = $this->config->get('yurticikargo_order_status_id');
        $data['scottycargo_order_status_id'] = $this->config->get('scottycargo_order_status_id');


        // API login

        $this->load->model('user/api');

        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

        if ($api_info) {
            $data['api_id'] = $api_info['api_id'];
            $data['api_key'] = $api_info['key'];
            $data['api_ip'] = $this->request->server['REMOTE_ADDR'];
        } else {
            $data['api_id'] = '';
            $data['api_key'] = '';
            $data['api_ip'] = '';
        }


        $data['header'] = $this->load->controller('common/header');

        $data['column_left'] = $this->load->controller('common/column_left');

        $data['footer'] = $this->load->controller('common/footer');

            // Hazırlanan siparişlerdeki farkı gösteren array 
        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/prepared_orders.tpl')) {
            //                                       Tam olarak bu array'e user_id girin -Tunay
            if (in_array($user_info['user_id'], array(22, 17, 46, 3, 57, 54, 62, 5, 70))) {

                $this->load->model('localisation/reprint_reason');
                $data['reprint_reasons'] = $this->model_localisation_reprint_reason->getReprintReasons();

                $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/prepared_orders_bulk_load_orders', $data));
            } else {
                $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/prepared_orders', $data));
            }
        } else {

            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/prepared_orders', $data));
        }
    }

    // Infinite Scroll Tunay
    function getScrollOrder()
    {
        $this->load->language('sale/prepared_orders');
        $this->load->model('sale/order');
        $this->load->model('localisation/reprint_reason');
        $data['orders'] = array();

        $data['editUrl'] = $this->url->link('catalog/product/edit', 'token=' . $this->session->data['token'] . '&product_id=', true); //16.09.20 idle stock update (ali.a)
        $data['preparedProductsUrl'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'], true); //20.09.20 idle stock update (ali.a)

        $data['reprint_reasons'] = $this->model_localisation_reprint_reason->getReprintReasons();

        $json = array();
        $config_limit_admin = 100;


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }
        $filter_by = '';
        if (isset($this->request->get['filter_by'])) {
            $filter_by = $this->request->get['filter_by'];
        }
        if (isset($this->request->get['row_color_code'])) {
            $row_color_code = $this->request->get['row_color_code'];
        } else {
            $row_color_code = '';
        }


        $json['pageno'] = $page;

        $start = ($page - 1) * $config_limit_admin;

        $data['text_no_results'] = $this->language->get('text_no_results');

        $sql = "SELECT
        po.order_id, 
        CONCAT(o.firstname, ' ', o.lastname) AS customer, 
        o.row_color_code,
        (SELECT 
            os.name 
        FROM ps_order_status os 
        WHERE 
        os.order_status_id = o.order_status_id AND 
        os.language_id ='" . (int)$this->config->get('config_language_id') . "') 
        AS order_status, 
        o.shipping_code, 
        o.total, 
        o.currency_code, 
        o.currency_value, 
        o.date_added, 
        o.date_modified, 
        o.shipping_zone,
        o.status, 
        o.comment,
        o.customer_id,
        o.order_status_id,
        o.payment_code
        FROM ps_prepared_orders po 
        LEFT JOIN ps_order o ON (po.order_id = o.order_id) WHERE po.status = 0 AND o.status = 0 AND po.row_color_code = '#" . $this->db->escape($row_color_code) . "'
        ORDER BY 
        o.date_added ASC 
        LIMIT " . (int)$start . "," . (int)$config_limit_admin;

        $results = $this->db->query($sql)->rows;

        $order_total = 0;

        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->user->getId());

        //if (in_array($user_info['user_id'], array(22, 17, 46,3))) {
        $config_limit_admin = 20000;

        $start = ($page - 1) * $config_limit_admin;

        $sql = "SELECT
                        po.order_id, 
                        CONCAT(o.firstname, ' ', o.lastname) AS customer, 
                        o.row_color_code,
                        (SELECT 
                            os.name 
                        FROM ps_order_status os 
                        WHERE 
                            os.order_status_id = o.order_status_id AND 
                            os.language_id ='" . (int)$this->config->get('config_language_id') . "') 
                        AS order_status, 
                        o.shipping_code, 
		                o.total, 
		                o.currency_code, 
		                o.currency_value, 
		                o.date_added, 
		                o.date_modified, 
                        o.shipping_zone,
		                o.status, 
		                o.comment,
		                o.customer_id,
		                o.order_status_id,
                        o.payment_code
                        FROM ps_prepared_orders po 
                        LEFT JOIN ps_order o ON (po.order_id = o.order_id) WHERE po.status = 0 AND o.status = 0 AND po.row_color_code = '#" . $this->db->escape($row_color_code) . "'
                        ORDER BY 
                        o.date_added ASC 
                        LIMIT " . (int)$start . "," . (int)$config_limit_admin;

        // var_dump($sql); die();


        $data['complated_count'] = 0;

        $results = $this->db->query($sql)->rows;

        $order_total_products = $this->db->query("SELECT COUNT(op.product_id) AS total FROM ps_prepared_orders po LEFT JOIN ps_order_product op ON (po.order_id = op.order_id) WHERE po.status = 0  ")->row['total'];

        $order_total = $this->db->query("SELECT COUNT(order_id) AS total FROM ps_prepared_orders WHERE status = 0 AND row_color_code = '#" . $this->db->escape($row_color_code) . "' ")->row['total'];

        $data['order_total'] = $order_total;
        $data['order_total_products'] = $order_total_products;

        $data['products'] = array();

        $this->load->model('extension/module/yurticikargo');
        $this->load->model('extension/module/suratkargo');
        $this->load->model('extension/module/byexpresskargo');
        $this->load->model('extension/module/araskargo');
        $this->load->model('extension/module/mngkargo');
        $this->load->model('extension/module/scottycargo');

        $order_total_product = 0;

        $test_count = 0;

        foreach ($results as $result) {
            //$order_products = $this->db->query("SELECT op.*,p.image,p.product_type,p.model2,p.idle_stock,op.show_idle_stock  FROM ps_order_product op LEFT JOIN ps_product p ON p.product_id=op.product_id WHERE op.order_id = '". (int)$result['order_id'] ."'  ")->rows;

            $order_products = "SELECT op.*,p.image,p.product_type,p.model2,p.idle_stock FROM ps_order_product op LEFT JOIN ps_product p ON p.product_id=op.product_id WHERE op.order_id = '" . (int)$result['order_id'] . "'  ";

            if (isset($this->request->get['filter_by'])) {
                if ($this->request->get['filter_by'] == "reprinted") {
                    $order_products .= " AND op.reprint_download_count = 0";
                }
            }

            $order_products = $this->db->query($order_products)->rows;
            //$data['complated_count'] += $this->db->query("SELECT COUNT(order_id) AS total FROM ps_order_product WHERE order_id = '". (int)$result['order_id'] ."' AND status = 1 ")->row['total'];


            if ($order_products) {

                $this->load->model('tool/image');

                foreach ($order_products as $order_product) {
                    $test_count++;


                    $p_model2 = $order_product['model2'];
                    if ($order_product['model2'] != '' && $order_product['product_type'] == 7)
                        $p_model2 = str_replace('cst001-', '', str_replace('_', '-', str_replace('kişiye_özel_telefon_kılıfları-', '', $p_model2)));

                        $image = isset($image['image']) ? $this->model_tool_image->resize($image['image'], 100, 100) : '';
                        $case_image = $image;

                        $data['product_idle_stock'][$order_product['product_id']] = $order_product['idle_stock']; //17.09.20 idle stock (ali.a)
    

                    
                    // Order Options
                    $option_data = array();
                    $options = $this->model_sale_order->getOrderOptions($order_product['order_id'], $order_product['order_product_id']);
                    foreach ($options as $option) {
                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $option['value'],
                            'type' => $option['type']
                        );
                    }

                    // Order Options
                    $case_pattern_image = $this->model_tool_image->resize($order_product['case_order_image'], 100, 100);

                    $customcase_image = '';

                    if ($order_product['customcase_image'] != '') {

                        $str = explode('***', $order_product['customcase_image']);

                        $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];

                        if ($case_image != '' && file_exists(DIR_IMAGE . $case_image))
                            $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $case_image;

                        else
                            $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/personal/' . $str[0] . '.png';
                    }

                    $total_customer_orders = 0;
                    /*if ($order_customer_id > 0) {
                            $total_customer_orders = $this->model_sale_order->getTotalOrdersByCustomer($order_customer_id);
                        }*/


                    $customer_pattern_data = json_decode($order_product['customer_pattern_data'], true);
                    if (isset($customer_pattern_data['pattern_text'])) {
                        $case_text = $customer_pattern_data['pattern_text'];
                    } else {
                        $case_text = '';
                    }


                    $order_comment = $result['comment'];


                    if ($result['status'] != 1 and !$order_product['return_status']) {

                        if ($filter_by == 'personalized' && $case_text != '') {

                            if ($order_product['quantity'] > 1) {
                                for ($temp = 1; $temp <= $order_product['quantity']; $temp++) {
                                    $order_total_product++;
                                    $data['products'][] = array(
                                        'order_product_id' => $order_product['order_product_id'],
                                        'product_id' => $order_product['product_id'],
                                        'order_id' => $result['order_id'],
                                        'model' => $order_product['model'],
                                        'model2' => $p_model2,
                                        'product_type' => $customer_pattern_data['product_type'],
                                        'name' => $order_product['name'],
                                        'idle_stock' => $order_product['idle_stock'],
                                        'image' => $image,
                                        'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                        'customer_pattern_data' => $order_product['customer_pattern_data'],
                                        'case_text' => $case_text,
                                        'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                        'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                        'customcase_image' => $customcase_image,
                                        'case_image' => $case_image,
                                        'customer' => $result['customer'],
                                        'product_model' => $order_product['model'],
                                        'comment' => $order_comment,
                                        'option' => array(),
                                        'quantity' => 1,
                                        'total_customer_orders' => $total_customer_orders,
                                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                        'shipping_zone' => $result['shipping_zone'],
                                        'payment_code' => $result['payment_code'],
                                        'status' => $order_product['status'],
                                        'reprint' => $order_product['reprint'],
                                        'reprint_download_count' => $order_product['reprint_download_count'],
                                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                        'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                        'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                        'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                        'options' => $options,
                                        'shipping_code' => $result['shipping_code'],
                                        'reprint_reason_id' => $order_product['reprint_reason_id'],
                                        'return_status' => $order_product['return_status'],
                                        'room_no' => $order_product['room_no'],
                                        //'show_idle_stock' => $order_product['show_idle_stock'],
                                        'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                    );
                                }
                            } else {
                                $order_total_product++;
                                $data['products'][] = array(
                                    'order_product_id' => $order_product['order_product_id'],
                                    'product_id' => $order_product['product_id'],
                                    'order_id' => $result['order_id'],
                                    'model' => $order_product['model'],
                                    'model2' => $p_model2,
                                    'product_type' => $customer_pattern_data['product_type'],
                                    'name' => $order_product['name'],
                                    'idle_stock' => $order_product['idle_stock'],
                                    'image' => $image,
                                    'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                    'customer_pattern_data' => $order_product['customer_pattern_data'],
                                    'case_text' => $case_text,
                                    'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                    'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                    'customcase_image' => $customcase_image,
                                    'case_image' => $case_image,
                                    'customer' => $result['customer'],
                                    'product_model' => $order_product['model'],
                                    'comment' => $order_comment,
                                    'option' => array(),
                                    'quantity' => $order_product['quantity'],
                                    'total_customer_orders' => $total_customer_orders,
                                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                    'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                    'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                    'shipping_zone' => $result['shipping_zone'],
                                    'payment_code' => $result['payment_code'],
                                    'status' => $order_product['status'],
                                    'reprint' => $order_product['reprint'],
                                    'reprint_download_count' => $order_product['reprint_download_count'],
                                    'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                    'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                    'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                    'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                    'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                    'options' => $options,
                                    'shipping_code' => $result['shipping_code'],
                                    'reprint_reason_id' => $order_product['reprint_reason_id'],
                                    'return_status' => $order_product['return_status'],
                                    'room_no' => $order_product['room_no'],
                                    //'show_idle_stock' => $order_product['show_idle_stock'],
                                    'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                );
                            }
                        } elseif ($filter_by == 'reprinted' && $order_product['reprint']) {


                            if ($order_product['quantity'] > 1) {
                                for ($temp = 1; $temp <= $order_product['quantity']; $temp++) {
                                    $order_total_product++;
                                    $data['products'][] = array(
                                        'order_product_id' => $order_product['order_product_id'],
                                        'product_id' => $order_product['product_id'],
                                        'order_id' => $result['order_id'],
                                        'model' => $order_product['model'],
                                        'model2' => $p_model2,
                                        'product_type' => $customer_pattern_data['product_type'],
                                        'name' => $order_product['name'],
                                        'idle_stock' => $order_product['idle_stock'],
                                        'image' => $image,
                                        'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                        'customer_pattern_data' => $order_product['customer_pattern_data'],
                                        'case_text' => $case_text,
                                        'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                        'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                        'customcase_image' => $customcase_image,
                                        'case_image' => $case_image,
                                        'customer' => $result['customer'],
                                        'product_model' => $order_product['model'],
                                        'comment' => $order_comment,
                                        'option' => array(),
                                        'quantity' => 1,
                                        'total_customer_orders' => $total_customer_orders,
                                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                        'shipping_zone' => $result['shipping_zone'],
                                        'payment_code' => $result['payment_code'],
                                        'status' => $order_product['status'],
                                        'reprint' => $order_product['reprint'],
                                        'reprint_download_count' => $order_product['reprint_download_count'],
                                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                        'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                        'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                        'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                        'options' => $options,
                                        'shipping_code' => $result['shipping_code'],
                                        'reprint_reason_id' => $order_product['reprint_reason_id'],
                                        'return_status' => $order_product['return_status'],
                                        'room_no' => $order_product['room_no'],
                                        //'show_idle_stock' => $order_product['show_idle_stock'],
                                        'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                    );
                                }
                            } else {
                                $order_total_product++;
                                $data['products'][] = array(
                                    'order_product_id' => $order_product['order_product_id'],
                                    'product_id' => $order_product['product_id'],
                                    'order_id' => $result['order_id'],
                                    'model' => $order_product['model'],
                                    'model2' => $p_model2,
                                    'product_type' => $customer_pattern_data['product_type'],
                                    'name' => $order_product['name'],
                                    'idle_stock' => $order_product['idle_stock'],
                                    'image' => $image,
                                    'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                    'customer_pattern_data' => $order_product['customer_pattern_data'],
                                    'case_text' => $case_text,
                                    'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                    'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                    'customcase_image' => $customcase_image,
                                    'case_image' => $case_image,
                                    'customer' => $result['customer'],
                                    'product_model' => $order_product['model'],
                                    'comment' => $order_comment,
                                    'option' => array(),
                                    'quantity' => $order_product['quantity'],
                                    'total_customer_orders' => $total_customer_orders,
                                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                    'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                    'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                    'shipping_zone' => $result['shipping_zone'],
                                    'payment_code' => $result['payment_code'],
                                    'status' => $order_product['status'],
                                    'reprint' => $order_product['reprint'],
                                    'reprint_download_count' => $order_product['reprint_download_count'],
                                    'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                    'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                    'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                    'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                    'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                    'options' => $options,
                                    'shipping_code' => $result['shipping_code'],
                                    'reprint_reason_id' => $order_product['reprint_reason_id'],
                                    'return_status' => $order_product['return_status'],
                                    'room_no' => $order_product['room_no'],
                                    //'show_idle_stock' => $order_product['show_idle_stock'],
                                    'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                );
                            }
                        } elseif ($filter_by == '') {


                            if ($order_product['quantity'] > 1) {
                                for ($temp = 1; $temp <= $order_product['quantity']; $temp++) {
                                    $order_total_product++;
                                    $data['products'][] = array(
                                        'order_product_id' => $order_product['order_product_id'],
                                        'product_id' => $order_product['product_id'],
                                        'order_id' => $result['order_id'],
                                        'model' => $order_product['model'],
                                        'model2' => $p_model2,
                                        'product_type' => $customer_pattern_data['product_type'],
                                        'name' => $order_product['name'],
                                        'idle_stock' => $order_product['idle_stock'],
                                        'image' => $image,
                                        'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                        'customer_pattern_data' => $order_product['customer_pattern_data'],
                                        'case_text' => $case_text,
                                        'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                        'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                        'customcase_image' => $customcase_image,
                                        'case_image' => $case_image,
                                        'customer' => $result['customer'],
                                        'product_model' => $order_product['model'],
                                        'comment' => $order_comment,
                                        'option' => array(),
                                        'quantity' => 1,
                                        'total_customer_orders' => $total_customer_orders,
                                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                        'shipping_zone' => $result['shipping_zone'],
                                        'payment_code' => $result['payment_code'],
                                        'status' => $order_product['status'],
                                        'reprint' => $order_product['reprint'],
                                        'reprint_download_count' => $order_product['reprint_download_count'],
                                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                        'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                        'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                        'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                        'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                        'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                        //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                        'options' => $options,
                                        'shipping_code' => $result['shipping_code'],
                                        'reprint_reason_id' => $order_product['reprint_reason_id'],
                                        'return_status' => $order_product['return_status'],
                                        'room_no' => $order_product['room_no'],
                                        //'show_idle_stock' => $order_product['show_idle_stock'],
                                        'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                    );
                                }
                            } else {
                                $order_total_product++;
                                $data['products'][] = array(
                                    'order_product_id' => $order_product['order_product_id'],
                                    'product_id' => $order_product['product_id'],
                                    'order_id' => $result['order_id'],
                                    'model' => $order_product['model'],
                                    'model2' => $p_model2,
                                    'product_type' => $customer_pattern_data['product_type'],
                                    'name' => $order_product['name'],
                                    'idle_stock' => $order_product['idle_stock'],
                                    'image' => $image,
                                    'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                                    'customer_pattern_data' => $order_product['customer_pattern_data'],
                                    'case_text' => $case_text,
                                    'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                                    'admin_gradient_pattern_image' => ($order_product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_gradient_pattern_image'] : ''),
                                    'customcase_image' => $customcase_image,
                                    'case_image' => $case_image,
                                    'customer' => $result['customer'],
                                    'product_model' => $order_product['model'],
                                    'comment' => $order_comment,
                                    'option' => array(),
                                    'quantity' => $order_product['quantity'],
                                    'total_customer_orders' => $total_customer_orders,
                                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                    'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                                    'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                                    'shipping_zone' => $result['shipping_zone'],
                                    'payment_code' => $result['payment_code'],
                                    'status' => $order_product['status'],
                                    'reprint' => $order_product['reprint'],
                                    'reprint_download_count' => $order_product['reprint_download_count'],
                                    'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                                    'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'suratkargo_barcode' => $this->model_extension_module_suratkargo->getShippingData($result['order_id']),
                                    'surat_kargo_barcode' => $this->url->link('sale/prepared_orders/surat_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'surat_kargo_barcode_default' => $this->url->link('sale/prepared_orders/suratkargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'araskargo_barcode' => $this->model_extension_module_araskargo->getShippingData($result['order_id']),
                                    'aras_kargo_barcode' => $this->url->link('sale/prepared_orders/aras_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_barcode_default' => $this->url->link('sale/prepared_orders/araskargo_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    'aras_kargo_last_barcode' => $this->url->link('sale/prepared_orders/araskargo_last_barcode', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),

                                    'scottycargo_info' => $this->model_extension_module_scottycargo->getShippingData($result['order_id']),
                                    'scottycargo_barcode' => $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),


                                    'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                                    //'mukerrer' => $Mukerrer [$result ['order_id']] != 1,
                                    'options' => $options,
                                    'shipping_code' => $result['shipping_code'],
                                    'reprint_reason_id' => $order_product['reprint_reason_id'],
                                    'return_status' => $order_product['return_status'],
                                    'room_no' => $order_product['room_no'],
                                    //'show_idle_stock' => $order_product['show_idle_stock'],
                                    'disable_scotty' => ($result['payment_code'] == 'cod') ? 1 : 0,
                                );
                                
                            }
                        }
                    }
                }
            }
        }
        $json['orders'] = ($data['products'] ? true : false);
        $json['orders_data'] = array($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/ajax_prepared_scroll_orders', $data, true));
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
    function getajaxOrders()
    {

        $this->load->language('sale/prepared_orders');
        $this->load->model('sale/order');
        $this->load->model('localisation/reprint_reason');
        $data['orders'] = array();

        $data['editUrl'] = $this->url->link('catalog/product/edit', 'token=' . $this->session->data['token'] . '&product_id=', true); //16.09.20 idle stock update (ali.a)
        $data['preparedProductsUrl'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'], true); //20.09.20 idle stock update (ali.a)

        $data['reprint_reasons'] = $this->model_localisation_reprint_reason->getReprintReasons();

        $json = array();
        $config_limit_admin = 100;


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }
        $filter_by = '';
        if (isset($this->request->get['filter_by'])) {
            $filter_by = $this->request->get['filter_by'];
        }

        $json['pageno'] = $page;

        $start = ($page - 1) * $config_limit_admin;

        $data['text_no_results'] = $this->language->get('text_no_results');

        $sql = "SELECT o.order_id, CONCAT(o.firstname, ' ', o.lastname) AS customer, o.row_color_code, op.reprint_reason_id,op.room_no,
        (SELECT os.name FROM ps_order_status os WHERE os.order_status_id = o.order_status_id AND os.language_id = '" . (int)$this->config->get('config_language_id') . "') AS order_status,
		o.shipping_code, o.total, o.currency_code, o.currency_value, o.date_added, o.date_modified, o.status, o.comment,o.customer_id,op.order_product_id,op.product_id,op.name,op.model,op.quantity,op.case_order_image,op.customer_pattern_data,op.admin_pattern_image,op.admin_gradient_pattern_image,op.customcase_image,op.status,op.reprint,op.return_status,p.image,p.model2,p.idle_stock FROM ps_order o inner join ps_order_product op on op.order_id=o.order_id inner join ps_product p on op.product_id=p.product_id WHERE o.status = 0 AND o.row_color_code = '#ABFF72' AND op.return_status=0 ORDER BY o.date_added ASC  LIMIT " . (int)$start . "," . (int)$config_limit_admin;


        $results = $this->db->query($sql)->rows;

        $order_total = 0;


        $data['products'] = array();

        $this->load->model('extension/module/yurticikargo');
        $this->load->model('tool/image');
        $OrderIDs = array();

        foreach ($results as $Result)
            $OrderIDs[] = $Result['order_id'];
        $Mukerrer = array_count_values($OrderIDs);
        foreach ($results as $result) {

            $order_customer_id = $result['customer_id'];


            $p_model2 = $result['model2'];

            if ($result['model2'] != '')
                $p_model2 = str_replace('cst001-', '', str_replace('_', '-', str_replace('kişiye_özel_telefon_kılıfları-', '', $p_model2)));

            //  $order_customer_id = $this->model_sale_order->getOrderCustomerId($result['order_id']);
            //  $order_products = $this->model_sale_order->getOrderProducts($result['order_id']);
            // if ($order_products) {

            /* Mükerrer Hesaplama - @toturkmen - Başlangıç */


            /* Mükerrer Hesaplama - @toturkmen - Bitiş */


            //   foreach ($order_products as $order_product) {
            //  $image = $this->db->query("SELECT image FROM ps_product WHERE product_id='" . $result['product_id'] . "' ")->row;
            $case_image = $result['image'];
            $image = isset($image['image']) ? $this->model_tool_image->resize($image['image'], 100, 100) : '';
            // Order Options

            $option_data = array();
            $options = $this->model_sale_order->getOrderOptions($result['order_id'], $result['order_product_id']);
            foreach ($options as $option) {
                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => $option['value'],
                    'type' => $option['type']
                );
            }

            // Order Options
            $case_pattern_image = $this->model_tool_image->resize($result['case_order_image'], 100, 100);

            $customcase_image = '';

            if ($result['customcase_image'] != '') {

                $str = explode('***', $result['customcase_image']);

                $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];

                if ($case_image != '' && file_exists(DIR_IMAGE . $case_image))
                    $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $case_image;
                else
                    $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/personal/' . $str[0] . '.png';
            }

            $total_customer_orders = 0;
            if ($order_customer_id > 0) {
                //  $total_customer_orders = $this->model_sale_order->getTotalOrdersByCustomer($order_customer_id);
            }


            $customer_pattern_data = json_decode($result['customer_pattern_data'], true);
            if (isset($customer_pattern_data['pattern_text'])) {
                $case_text = $customer_pattern_data['pattern_text'];
            } else {
                $case_text = '';
            }


            $order_comment = $result['comment'];

            if ($filter_by == 'personalized' && $case_text != '') {
                $order_total++;

                if ($result['quantity'] > 1) {
                    for ($temp = 1; $temp <= $result['quantity']; $temp++) {
                        $data['products'][] = array(
                            'order_product_id' => $result['order_product_id'],
                            'product_id' => $result['product_id'],
                            'order_id' => $result['order_id'],
                            'model' => $result['model'],
                            'model2' => $p_model2,
                            'product_type' => $customer_pattern_data['product_type'],
                            'name' => $result['name'],
                            'image' => $image,
                            'case_order_image' => ($result['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['case_order_image'] : ''),
                            'customer_pattern_data' => $result['customer_pattern_data'],
                            'case_text' => $case_text,
                            'admin_pattern_image' => ($result['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_pattern_image'] : ''),
                            'admin_gradient_pattern_image' => ($result['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_gradient_pattern_image'] : ''),
                            'customcase_image' => $customcase_image,
                            'case_image' => $case_image,
                            'customer' => $result['customer'],
                            'product_model' => $result['model'],
                            'comment' => $order_comment,
                            'option' => array(),
                            'quantity' => 1,
                            // 'total_customer_orders' => $total_customer_orders,
                            'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                            'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                            'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                            'status' => $result['status'],
                            'reprint' => $result['reprint'],
                            'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                            'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                            'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                            'mukerrer' => $Mukerrer[$result['order_id']] != 1,
                            'options' => $options,
                            'shipping_code' => $result['shipping_code'],
                            'reprint_reason_id' => $result['reprint_reason_id'],
                            'room_no' => $result['room_no'],
                            'return_status' => $result['return_status'],
                            'idle_stock' => $result['idle_stock'],
                        );
                    }
                } else {

                    $data['products'][] = array(
                        'order_product_id' => $result['order_product_id'],
                        'product_id' => $result['product_id'],
                        'order_id' => $result['order_id'],
                        'model' => $result['model'],
                        'model2' => $p_model2,
                        'product_type' => $customer_pattern_data['product_type'],
                        'name' => $result['name'],
                        'image' => $image,
                        'case_order_image' => ($result['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['case_order_image'] : ''),
                        'customer_pattern_data' => $result['customer_pattern_data'],
                        'case_text' => $case_text,
                        'admin_pattern_image' => ($result['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_pattern_image'] : ''),
                        'admin_gradient_pattern_image' => ($result['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_gradient_pattern_image'] : ''),
                        'customcase_image' => $customcase_image,
                        'case_image' => $case_image,
                        'customer' => $result['customer'],
                        'product_model' => $result['model'],
                        'comment' => $order_comment,
                        'option' => array(),
                        'quantity' => $result['quantity'],
                        // 'total_customer_orders' => $total_customer_orders,
                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                        'status' => $result['status'],
                        'reprint' => $result['reprint'],
                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                        'mukerrer' => $Mukerrer[$result['order_id']] != 1,
                        'options' => $options,
                        'shipping_code' => $result['shipping_code'],
                        'reprint_reason_id' => $result['reprint_reason_id'],
                        'room_no' => $result['room_no'],
                        'return_status' => $result['return_status'],
                        'idle_stock' => $result['idle_stock'],
                    );
                }
            } elseif ($filter_by == 'reprinted' && $result['reprint']) {
                $order_total++;
                if ($result['quantity'] > 1) {
                    for ($temp = 1; $temp <= $result['quantity']; $temp++) {
                        $data['products'][] = array(
                            'order_product_id' => $result['order_product_id'],
                            'product_id' => $result['product_id'],
                            'order_id' => $result['order_id'],
                            'model' => $result['model'],
                            'model2' => $p_model2,
                            'product_type' => $customer_pattern_data['product_type'],
                            'name' => $result['name'],
                            'image' => $image,
                            'case_order_image' => ($result['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['case_order_image'] : ''),
                            'customer_pattern_data' => $result['customer_pattern_data'],
                            'case_text' => $case_text,
                            'admin_pattern_image' => ($result['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_pattern_image'] : ''),
                            'admin_gradient_pattern_image' => ($result['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_gradient_pattern_image'] : ''),
                            'customcase_image' => $customcase_image,
                            'case_image' => $case_image,
                            'customer' => $result['customer'],
                            'product_model' => $result['model'],
                            'comment' => $order_comment,
                            'option' => array(),
                            'quantity' => 1,
                            // 'total_customer_orders' => $total_customer_orders,
                            'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                            'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                            'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                            'status' => $result['status'],
                            'reprint' => $result['reprint'],
                            'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                            'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                            'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                            'mukerrer' => $Mukerrer[$result['order_id']] != 1,
                            'options' => $options,
                            'shipping_code' => $result['shipping_code'],
                            'reprint_reason_id' => $result['reprint_reason_id'],
                            'room_no' => $result['room_no'],
                            'return_status' => $result['return_status'],
                            'idle_stock' => $result['idle_stock'],
                        );
                    }
                } else {
                    $data['products'][] = array(
                        'order_product_id' => $result['order_product_id'],
                        'product_id' => $result['product_id'],
                        'order_id' => $result['order_id'],
                        'model' => $result['model'],
                        'model2' => $p_model2,
                        'product_type' => $customer_pattern_data['product_type'],
                        'name' => $result['name'],
                        'image' => $image,
                        'case_order_image' => ($result['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['case_order_image'] : ''),
                        'customer_pattern_data' => $result['customer_pattern_data'],
                        'case_text' => $case_text,
                        'admin_pattern_image' => ($result['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_pattern_image'] : ''),
                        'admin_gradient_pattern_image' => ($result['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_gradient_pattern_image'] : ''),
                        'customcase_image' => $customcase_image,
                        'case_image' => $case_image,
                        'customer' => $result['customer'],
                        'product_model' => $result['model'],
                        'comment' => $order_comment,
                        'option' => array(),
                        'quantity' => $result['quantity'],
                        // 'total_customer_orders' => $total_customer_orders,
                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                        'status' => $result['status'],
                        'reprint' => $result['reprint'],
                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                        'mukerrer' => $Mukerrer[$result['order_id']] != 1,
                        'options' => $options,
                        'shipping_code' => $result['shipping_code'],
                        'reprint_reason_id' => $result['reprint_reason_id'],
                        'room_no' => $result['room_no'],
                        'return_status' => $result['return_status'],
                        'idle_stock' => $result['idle_stock'],
                    );
                }
            } elseif ($filter_by == '') {
                $order_total++;

                if ($result['quantity'] > 1) {
                    for ($temp = 1; $temp <= $result['quantity']; $temp++) {
                        $data['products'][] = array(
                            'order_product_id' => $result['order_product_id'],
                            'product_id' => $result['product_id'],
                            'order_id' => $result['order_id'],
                            'model' => $result['model'],
                            'model2' => $p_model2,
                            'product_type' => $customer_pattern_data['product_type'],
                            'name' => $result['name'],
                            'image' => $image,
                            'case_order_image' => ($result['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['case_order_image'] : ''),
                            'customer_pattern_data' => $result['customer_pattern_data'],
                            'case_text' => $case_text,
                            'admin_pattern_image' => ($result['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_pattern_image'] : ''),
                            'admin_gradient_pattern_image' => ($result['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_gradient_pattern_image'] : ''),
                            'customcase_image' => $customcase_image,
                            'case_image' => $case_image,
                            'customer' => $result['customer'],
                            'product_model' => $result['model'],
                            'comment' => $order_comment,
                            'option' => array(),
                            'quantity' => 1,
                            // 'total_customer_orders' => $total_customer_orders,
                            'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                            'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                            'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                            'status' => $result['status'],
                            'reprint' => $result['reprint'],
                            'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                            'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                            'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                            'mukerrer' => $Mukerrer[$result['order_id']] != 1,
                            'options' => $options,
                            'shipping_code' => $result['shipping_code'],
                            'reprint_reason_id' => $result['reprint_reason_id'],
                            'room_no' => $result['room_no'],
                            'return_status' => $result['return_status'],
                            'idle_stock' => $result['idle_stock'],
                        );
                    }
                } else {
                    $data['products'][] = array(
                        'order_product_id' => $result['order_product_id'],
                        'product_id' => $result['product_id'],
                        'order_id' => $result['order_id'],
                        'model' => $result['model'],
                        'model2' => $p_model2,
                        'product_type' => $customer_pattern_data['product_type'],
                        'name' => $result['name'],
                        'image' => $image,
                        'case_order_image' => ($result['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['case_order_image'] : ''),
                        'customer_pattern_data' => $result['customer_pattern_data'],
                        'case_text' => $case_text,
                        'admin_pattern_image' => ($result['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_pattern_image'] : ''),
                        'admin_gradient_pattern_image' => ($result['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $result['admin_gradient_pattern_image'] : ''),
                        'customcase_image' => $customcase_image,
                        'case_image' => $case_image,
                        'customer' => $result['customer'],
                        'product_model' => $result['model'],
                        'comment' => $order_comment,
                        'option' => array(),
                        'quantity' => $result['quantity'],
                        // 'total_customer_orders' => $total_customer_orders,
                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                        'status' => $result['status'],
                        'reprint' => $result['reprint'],
                        'kargo_talepno' => $this->model_extension_module_yurticikargo->getShippingData($result['order_id']),
                        'kargo_barcode' => $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                        'order_href' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$result['order_id'], true),
                        'mukerrer' => $Mukerrer[$result['order_id']] != 1,
                        'options' => $options,
                        'shipping_code' => $result['shipping_code'],
                        'reprint_reason_id' => $result['reprint_reason_id'],
                        'room_no' => $result['room_no'],
                        'return_status' => $result['return_status'],
                        'idle_stock' => $result['idle_stock'],
                    );
                }
            }

            // }
            //}
        }
        $json['orders'] = ($data['products'] ? true : false);
        $json['orders_data'] = $this->load->view(DIR_LOCAL_TEMPLATE . 'sale/ajax_prepared_orders', $data, true);
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function delete()
    {

        $this->load->language('sale/prepared_orders');


        $this->document->setTitle($this->language->get('heading_title'));


        $this->load->model('sale/order');


        if (isset($this->request->post['selected_order_ids']) && $this->validate()) {

            foreach ($this->request->post['selected_order_ids'] as $order_id) {

                $sql = 'SELECT order_status_id from ps_order where order_id=' . $order_id;

                $status = $this->db->query($sql)->row;

                if ($status['order_status_id'] == '7') {

                    $this->model_sale_order->deleteOrder($order_id);

                    $this->session->data['success'] = $this->language->get('text_success');
                }
            }


            $url = '';


            if (isset($this->request->get['filter_order_id'])) {

                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }


            if (isset($this->request->get['filter_customer'])) {

                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }


            if (isset($this->request->get['filter_order_status'])) {

                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }


            if (isset($this->request->get['filter_total'])) {

                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }


            if (isset($this->request->get['filter_date_added'])) {

                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }


            if (isset($this->request->get['filter_date_modified'])) {

                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }


            $this->response->redirect($this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . $url, true));
        }


        $this->getList();
    }

    protected function validate()
    {

        if (!$this->user->hasPermission('modify', 'sale/prepared_orders')) {

            $this->error['warning'] = $this->language->get('error_permission');
        }


        return !$this->error;
    }

    public function invoice()
    {


        $order_id = $this->request->get['order_id'];


        $this->db->query("UPDATE ps_order_yurticikargo SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . $order_id . "' ");


        $yurtici_kargo_info = array();

        if ($this->config->get('yurticikargo_status')) {

            $this->load->model('extension/module/yurticikargo');

            $yurtici_kargo_info = $this->model_extension_module_yurticikargo->getShippingData($order_id);
        }

        require_once(DIR_SYSTEM . 'picqer/php-barcode-generator/generate-verified-files.php');

        $generatorJPG = new Picqer\Barcode\BarcodeGeneratorJPG();
        $barkod_cargokey = $generatorJPG->getBarcode($yurtici_kargo_info['kargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_cargokey = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_cargokey) . '" style=" width: 320px;">';
        $barkod_talepno = $generatorJPG->getBarcode($yurtici_kargo_info['kargo_talepno'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_talepno = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_talepno) . '" style="width: 320px;">';


        $this->load->model('sale/order');

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info['order_status_id'] == 7) {
            return 'Bu sipariş iptal edilmiştir.';
        }

        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

        $product_names = array();


        //Return Status -- veritabanındaki kayıt
        // 0 Geçerli sipariş
        // 1 İade
        // 2 İptal
        // 3 Değişim

        $products = $this->model_sale_order->getOrderProducts($order_id);


        $return_info = '';

        foreach ($products as $product) {

            $option_name = '';
            $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);
            foreach ($options as $option) {
                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => $option['value'],
                    'type' => $option['type']
                );
                $option_name .= '<br>' . $option['name'] . ': ' . $option['value'];
            }



            $name = explode(' ', $product['name']);

            if ($product['return_status'] == 1) {
                $return_info .= $product['name'] . ' <b>İADE</b> <br>';
            } else if ($product['return_status'] == 2) {
                $return_info .= $product['name'] . ' <b>İPTAL</b> <br>';
            } else if ($product['return_status'] == 3) {
                $return_info .= $product['name'] . ' <b>DEĞİŞİM</b> <br>';
            } else {
                $product_names[] = $product['model'] . ' - ' . str_replace('Tutacaklı', '<b style="color: red; font-size: 18px;">Tutacaklı</b>', $product['name']) . ' ' . $option_name;
            }
        }


        $product_names = implode('<br>', $product_names);

        $shipping_title = '';

        if ($order_info['payment_code'] == 'cod') {
            $shipping_title = 'Kapıda Nakit Ödemeli Normal Gönderi';
        } else {
            $shipping_title = 'Gönderici Ödemeli Normal Gönderi';
        }


        $html = '<html>
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

          <style>
            html { margin: 0; padding: 9px; }
            body { font-family: DejaVu Sans, sans-serif; margin: 0; padding: 9px;}

            .outer{
              width: 100%;
              padding: 0;
            }

            .title{
              width: 100%;
              font-size: 14px;
              margin-bottom: 4px;
            }

            .inner{
              width: 100%;
              float: left;
            }

            .alt{
              width: 100%;
            }

            .altBilgi{
              width: 100%;
              float:left;
            }

            .altBarkod{
              width: 100%;
              float: right;
              padding-top: 10px;
            }

            .barcode{
              right: 275px;
              top: 175px;
            }

            .alt-title{
              font-weight: bold;
              font-size: 11px;
            }

            .alt div{
              font-size: 10px;
            }

            .tarih{
              margin: 0;
              font-size: 8px;
              margin-top: 3px;
            }
          </style>

        </head>
        <body>

          <div class="outer">

            <div class="inner">
             ';

        if ($return_info) {

            $html .= '<div class="alt border-bottom" >
                <div class="alt-title">İptal/İade/Değişim Sipariş Notu  Sipariş No: ' . $order_id . '</div>
                <div style="height: 80%">' . $return_info . '</div>

              </div>';
        }

        if ($order_info['comment']) {

            $html .= '<div style="height: 100%; font-size:10px;">
                ' . $order_info['comment'] . '

              </div>';
        }

        $shipping_city = '';
        if ($order_info['customer_id'] and empty($order_info['shipping_city'])) {
            $get_adress = $this->db->query("SELECT city FROM ps_address WHERE customer_id = '" . $order_info['customer_id'] . "' ")->row;
            if (isset($get_adress['city']) and $get_adress['city']) {
                $shipping_city = $get_adress['city'];
            }
        } else if ($order_info['shipping_city']) {
            $shipping_city = $order_info['shipping_city'];
        }

        if ($product_names) {

            $html .= '

            <div class="alt border-bottom">
                <div class="alt-title"><b>' . $order_info['shipping_firstname'] . ' ' . $order_info['shipping_lastname'] . ' ' . $order_info['telephone'] . ' - Sipariş No: ' . $order_info['order_id'] . ' - ' . @date('d:m:y h:i') . ' </b><</div>
              </div>
              <div class="alt border-bottom">
                <div>' . $product_names . '</div>
              </div>
              <div class="alt">
                  <div><b>Toplam: ' . $total . ' - Sip No: ' . $yurtici_kargo_info['kargo_barcode'] . ' - Talep No: ' . $yurtici_kargo_info['kargo_talepno'] . '</b></div>
                <div class="altBarkod">
                <div><b>YURTİÇİ</b> Cargokey <br>' . $barkod_cargokey . '
                </div> <br>
                <div>Talep No <br>
                ' . $barkod_talepno . '
                </div>
              </div>
            </div>';
        }

        $html .= '
          </div>
        </body>
      </html>
        ';

        if ($_SERVER['REMOTE_ADDR'] == "39.35.236.133") {
            echo $html;
        }
        require_once(DIR_SYSTEM . 'dompdf/autoload.inc.php');



        $dompdf = new Dompdf\Dompdf(array('enable_remote' => true, 'debugLayout' => true));
        $dompdf->loadHtml($html);

        $customPaper = array(0, 0, 377, 302);
        //$customPaper = array(0, 0, 378, 330);
        $dompdf->set_paper($customPaper);

        $dompdf->render();
        // Output the generated PDF to Browser

        $dompdf->stream("dompdf_out.pdf", array("Attachment" => 0));
    }

    public function invoice_second()
    {


        $order_id = $this->request->get['order_id'];

        $this->load->model('sale/order');

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info['order_status_id'] == 7) {
            return 'Bu sipariş iptal edilmiştir.';
        }

        $this->db->query("UPDATE ps_order_mngkargo_second SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . $order_id . "' ");


        $yurtici_kargo_info = array();

        if ($this->config->get('yurticikargo_status')) {

            $this->load->model('extension/module/yurticikargo');

            $yurtici_kargo_info = $ask = $this->db->query("SELECT * FROM ps_order_mngkargo_second WHERE order_id = '" . $order_id . "' ")->row;
        }

        require_once(DIR_SYSTEM . 'picqer/php-barcode-generator/generate-verified-files.php');

        $generatorJPG = new Picqer\Barcode\BarcodeGeneratorJPG();
        $barkod_cargokey = $generatorJPG->getBarcode($yurtici_kargo_info['kargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_cargokey = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_cargokey) . '" style="width: 200px;">';
        $barkod_talepno = $generatorJPG->getBarcode($yurtici_kargo_info['kargo_talepno'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_talepno = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_talepno) . '" style="width: 200px;">';


        $this->load->model('sale/order');

        $order_info = $this->model_sale_order->getOrder($order_id);
        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

        $product_names = array();


        //Return Status -- veritabanındaki kayıt
        // 0 Geçerli sipariş
        // 1 İade
        // 2 İptal
        // 3 Değişim

        $products = $this->model_sale_order->getOrderProducts($order_id);


        $return_info = '';

        foreach ($products as $product) {

            $name = explode(' ', $product['name']);

            if ($product['return_status'] == 1) {
                $return_info .= $product['name'] . ' <b>İADE</b> <br>';
            } else if ($product['return_status'] == 2) {
                $return_info .= $product['name'] . ' <b>İPTAL</b> <br>';
            } else if ($product['return_status'] == 3) {
                $return_info .= $product['name'] . ' <b>DEĞİŞİM</b> <br>';
            } else {
                $product_names[] = $product['model'] . ' - ' . str_replace('Tutacaklı', '<b style="color: red; font-size: 18px;">Tutacaklı</b>', $product['name']);
            }
        }


        $product_names = implode('<br>', $product_names);

        $shipping_title = '';

        if ($order_info['payment_code'] == 'cod') {
            $shipping_title = 'Kapıda Nakit Ödemeli Normal Gönderi';
        } else {
            $shipping_title = 'Gönderici Ödemeli Normal Gönderi';
        }


        $html = '<html>
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

          <style>
            html { margin: 0; padding: 9px; }
            body { font-family: DejaVu Sans, sans-serif; margin: 0; padding: 9px;}

            .outer{
              width: 100%;
              padding: 0;
            }

            .title{
              width: 100%;
              font-size: 14px;
              margin-bottom: 4px;
            }

            .inner{
              width: 100%;
              float: left;
            }

            .alt{
              width: 100%;
            }

            .altBilgi{
              width: 100%;
              float:left;
            }

            .altBarkod{
              width: 100%;
              float: right;
              padding-top: 10px;
            }

            .barcode{
              right: 275px;
              top: 175px;
            }

            .alt-title{
              font-weight: bold;
              font-size: 11px;
            }

            .alt div{
              font-size: 10px;
            }

            .tarih{
              margin: 0;
              font-size: 8px;
              margin-top: 3px;
            }
          </style>

        </head>
        <body>

          <div class="outer">

            <div class="inner">
             ';

        if ($return_info) {

            $html .= '<div class="alt border-bottom" >
                <div class="alt-title">İptal/İade/Değişim Sipariş Notu  Sipariş No: ' . $order_id . '</div>
                <div style="height: 80%">' . $return_info . '</div>

              </div>';
        }

        if ($order_info['comment']) {

            $html .= '<div style="height: 100%; font-size:10px;">
                ' . $order_info['comment'] . '

              </div>';
        }

        if ($product_names) {

            $html .= '
                <div class="alt border-bottom">
                <div class="alt-title"><b>' . $order_info['shipping_firstname'] . ' ' . $order_info['shipping_lastname'] . ' ' . $order_info['telephone'] . ' - Sipariş No: ' . $order_info['order_id'] . ' - ' . @date('d:m:y h:i') . ' </b><</div>
              </div>
              <div class="alt border-bottom">
                <div style="font-size:11px">' . $product_names . '</div>
              </div>
              <div class="alt">
                  <div><b>Toplam: ' . $total . ' - Sip No: ' . $yurtici_kargo_info['kargo_barcode'] . ' - Talep No: ' . $yurtici_kargo_info['kargo_talepno'] . '</b></div>
                <div class="altBarkod">
                <div><b style="font-size:11px">MNG KARGO</b> Cargokey <br>' . $barkod_cargokey . '
                </div> <br>
                <div>Talep No <br>
                ' . $barkod_talepno . '
                </div>
              </div>
            </div>';
        }

        $html .= '
          </div>
        </body>
      </html>
        ';


        require_once(DIR_SYSTEM . 'dompdf/autoload.inc.php');

        $dompdf = new Dompdf\Dompdf(array('enable_remote' => true));
        $dompdf->loadHtml($html);

        $customPaper = array(0, 0, 377, 302);
        //$customPaper = array(0, 0, 378, 330);
        $dompdf->set_paper($customPaper);

        $dompdf->render();
        // Output the generated PDF to Browser

        $dompdf->stream("dompdf_out.pdf", array("Attachment" => false));
    }

    public function aras_invoice()
    {
        $order_id = $this->request->get['order_id'];

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info['order_status_id'] == 7) {
            return 'Bu sipariş iptal edilmiştir.';
        }

        $this->db->query("UPDATE ps_order_araskargo SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . $order_id . "' ");

        $kargo_info = array();

        $this->load->model('extension/module/araskargo');
        $kargo_info = $ask = $this->db->query("SELECT * FROM ps_order_araskargo WHERE order_id = '" . $order_id . "' ")->row;

        $file_name = DIR_UPLOAD . 'cargo_stickers/' . $order_id . '.pdf';

        if (!file_exists($file_name)) {

            $zpl = $kargo_info['barcode_text'];

            //$file_name = DIR_UPLOAD . 'cargo_stickers/' . $order_id . '.pdf';
            $curl = curl_init();
            // adjust print density (8dpmm), label width (4 inches), label height (6 inches), and label index (0) as necessary
            curl_setopt($curl, CURLOPT_URL, "http://api.labelary.com/v1/printers/8dpmm/labels/4x6/0/");
            curl_setopt($curl, CURLOPT_POST, TRUE);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $zpl);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array("Accept: application/pdf")); // omit this line to get PNG images back
            $result = curl_exec($curl);

            // var_dump($result); die();

            if (curl_getinfo($curl, CURLINFO_HTTP_CODE) == 200) {
                $file = fopen($file_name, "w"); // change file name for PNG images
                fwrite($file, $result);
                fclose($file);
            } else {
                print_r("Error: $result");
            }

            curl_close($curl);

            $filepath = $file_name;
            header("Content-type: application/pdf");
            readfile($filepath);
        } else {
            header("Content-type: application/pdf");
            readfile($file_name);
        }
    }

    public function araskargo_last_barcode()
    {



        $order_id = $this->request->get['order_id'];

        $this->db->query("UPDATE ps_order_araskargo SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . (int)$order_id . "' ");

        a:
        $getZplInfo = $this->db->query("SELECT * FROM ps_order_araskargo WHERE order_id = '" . $order_id . "' ")->row;

        if (!$getZplInfo['ZebraZpl']) {
            $this->ARAS_GETBARCODE($order_id);
            goto a;
        }

        $zpl = $getZplInfo['ZebraZpl'];

        $fileName = DIR_DOWNLOAD . 'arasLastBarcode/' . $order_id . "_aras_last_barcode.pdf";

        if (!file_exists($fileName)) {
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, "http://api.labelary.com/v1/printers/8dpmm/labels/4x6/0/");
            curl_setopt($curl, CURLOPT_POST, TRUE);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $zpl);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array("Accept: application/pdf")); // omit this line to get PNG images back
            $result = curl_exec($curl);


            if (curl_getinfo($curl, CURLINFO_HTTP_CODE) == 200) {
                $file = fopen($fileName, "w"); // change file name for PNG images
                fwrite($file, $result);
                fclose($file);
            } else {
                print_r("Error: $result");
            }

            curl_close($curl);
        } else {
            header("Content-type: application/pdf");
            header("Content-Disposition: inline; filename=" . $fileName);

            @readfile($fileName);
        }
    }

    public function araskargo_invoice_old()
    {


        $order_id = $this->request->get['order_id'];

        $this->db->query("UPDATE ps_order_araskargo SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . $order_id . "' ");


        $kargo_info = array();

        if ($this->config->get('araskargo_status')) {

            $this->load->model('extension/module/araskargo');

            $kargo_info = $ask = $this->db->query("SELECT * FROM ps_order_araskargo WHERE order_id = '" . $order_id . "' ")->row;
        }

        require_once(DIR_SYSTEM . 'picqer/php-barcode-generator/generate-verified-files.php');

        $generatorJPG = new Picqer\Barcode\BarcodeGeneratorJPG();
        $barkod_cargokey = $generatorJPG->getBarcode($kargo_info['kargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_cargokey = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_cargokey) . '" style="width: 320px;">';
        $barkod_talepno = $generatorJPG->getBarcode($kargo_info['kargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_talepno = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_talepno) . '" style="width: 320px;">';


        $this->load->model('sale/order');

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info['order_status_id'] == 7) {
            return 'Bu sipariş iptal edilmiştir.';
        }

        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

        $product_names = array();


        //Return Status -- veritabanındaki kayıt
        // 0 Geçerli sipariş
        // 1 İade
        // 2 İptal
        // 3 Değişim

        $products = $this->model_sale_order->getOrderProducts($order_id);


        $return_info = '';

        foreach ($products as $product) {

            $option_name = '';
            $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);
            foreach ($options as $option) {
                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => $option['value'],
                    'type' => $option['type']
                );
                $option_name .= '<br>' . $option['name'] . ': ' . $option['value'];
            }


            $name = explode(' ', $product['name']);

            if ($product['return_status'] == 1) {
                $return_info .= $product['name'] . ' <b>İADE</b> <br>';
            } else if ($product['return_status'] == 2) {
                $return_info .= $product['name'] . ' <b>İPTAL</b> <br>';
            } else if ($product['return_status'] == 3) {
                $return_info .= $product['name'] . ' <b>DEĞİŞİM</b> <br>';
            } else {
                $product_names[] = $product['model'] . ' - ' . str_replace('Tutacaklı', '<b style="color: red; font-size: 18px;">Tutacaklı</b>', $product['name']) . ' ' . $option_name;
            }
        }


        $product_names = implode('<br>', $product_names);

        $shipping_title = '';

        if ($order_info['payment_code'] == 'cod') {
            $shipping_title = 'Kapıda Nakit Ödemeli Normal Gönderi';
        } else {
            $shipping_title = 'Gönderici Ödemeli Normal Gönderi';
        }


        $html = '<html>
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

          <style>
            html { margin: 0; padding: 9px; }
            body { font-family: DejaVu Sans, sans-serif; margin: 0; padding: 9px;}

            .outer{
              width: 100%;
              padding: 0;
            }

            .title{
              width: 100%;
              font-size: 14px;
              margin-bottom: 4px;
            }

            .inner{
              width: 100%;
              float: left;
            }

            .alt{
              width: 100%;
            }

            .altBilgi{
              width: 100%;
              float:left;
            }

            .altBarkod{
              width: 100%;
              float: right;
              padding-top: 10px;
            }

            .barcode{
              right: 275px;
              top: 175px;
            }

            .alt-title{
              font-weight: bold;
              font-size: 11px;
            }

            .alt div{
              font-size: 10px;
            }

            .tarih{
              margin: 0;
              font-size: 8px;
              margin-top: 3px;
            }
          </style>

        </head>
        <body>

          <div class="outer">

            <div class="inner">
             ';

        if ($return_info) {

            $html .= '<div class="alt border-bottom" >
                <div class="alt-title">İptal/İade/Değişim Sipariş Notu  Sipariş No: ' . $order_id . '</div>
                <div style="height: 80%">' . $return_info . '</div>

              </div>';
        }

        if ($order_info['comment']) {

            $html .= '<div style="height: 100%; font-size:10px;">
                ' . $order_info['comment'] . '

              </div>';
        }

        if ($product_names) {

            $html .= '

            <div class="alt border-bottom">
                <div class="alt-title"><b>' . $order_info['shipping_firstname'] . ' ' . $order_info['shipping_lastname'] . ' ' . $order_info['telephone'] . ' - Sipariş No: ' . $order_info['order_id'] . ' - ' . @date('d:m:y h:i') . ' </b><</div>
              </div>


              <div class="alt border-bottom">
                <div class="alt-title">Tahsilat Bilgileri</div>
                <div>' . $product_names . '</div>
              
                <div>Toplam: ' . $total . '</div>
                <div>Tahsilat Türü: </div>
              </div>
            <div class="alt">
              <div><b>Sipariş Numarası: ' . $kargo_info['kargo_barcode'] . ' - Talep Numarası: ' . $kargo_info['kargo_barcode'] . '</b></div>
            <div class="altBarkod" style="margin-top:0;padding-top:0">
            <div><b>ARASKARGO</b> Cargokey - Sipariş No: <b>' . $order_id . '</b> <br>' . $barkod_cargokey . '
            </div>
            <div>Talep no <br>
            ' . $barkod_talepno . '
            </div>
          </div>
        </div>';
        }

        $html .= '
          </div>
        </body>
      </html>
        ';


        require_once(DIR_SYSTEM . 'dompdf/autoload.inc.php');

        $dompdf = new Dompdf\Dompdf(array('enable_remote' => true, 'debugLayout' => true));
        $dompdf->loadHtml($html);

        $customPaper = array(0, 0, 377, 302);
        //$customPaper = array(0, 0, 378, 330);
        $dompdf->set_paper($customPaper);

        $dompdf->render();
        // Output the generated PDF to Browser

        $dompdf->stream("dompdf_out.pdf", array("Attachment" => false));
    }

    public function surat_invoice()
    {
        # code...
    }

    public function mngcargo_invoice()
    {
        $order_id = $this->request->get['order_id'];

        $this->db->query("UPDATE ps_order_mngkargo SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . $order_id . "' ");


        $kargo_info = array();

        if ($this->config->get('scottycargo_status')) {

            $this->load->model('extension/module/mngkargo');

            $kargo_info = $this->db->query("SELECT * FROM ps_order_mngkargo WHERE order_id = '" . $order_id . "' ")->row;

            if (empty($kargo_info)) {
                exit('Kargo iptal edildi veya bulunamadı.');
            }
        }

        require_once(DIR_SYSTEM . 'picqer/php-barcode-generator/generate-verified-files.php');

        $generatorJPG = new Picqer\Barcode\BarcodeGeneratorJPG();
        $barkod_cargokey = $generatorJPG->getBarcode($kargo_info['kargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_cargokey = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_cargokey) . '" style="width: 320px;">';

        $this->load->model('sale/order');

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info['order_status_id'] == 7) {
            return 'Bu sipariş iptal edilmiştir.';
        }

        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

        $product_names = array();

        //Return Status -- veritabanındaki kayıt
        // 0 Geçerli sipariş
        // 1 İade
        // 2 İptal
        // 3 Değişim

        $products = $this->model_sale_order->getOrderProducts($order_id);

        $return_info = '';

        foreach ($products as $product) {

            $option_name = '';
            $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);
            foreach ($options as $option) {
                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => $option['value'],
                    'type' => $option['type']
                );
                $option_name .= '<br>' . $option['name'] . ': ' . $option['value'];
            }


            $name = explode(' ', $product['name']);

            if ($product['return_status'] == 1) {
                $return_info .= $product['name'] . ' <b>İADE</b> <br>';
            } else if ($product['return_status'] == 2) {
                $return_info .= $product['name'] . ' <b>İPTAL</b> <br>';
            } else if ($product['return_status'] == 3) {
                $return_info .= $product['name'] . ' <b>DEĞİŞİM</b> <br>';
            } else {
                $product_names[] = $product['model'] . ' - ' . str_replace('Tutacaklı', '<b style="color: red; font-size: 18px;">Tutacaklı</b>', $product['name']) . ' ' . $option_name;
            }
        }


        $product_names = implode('<br>', $product_names);

        $shipping_title = '';

        if ($order_info['payment_code'] == 'cod') {
            $shipping_title = 'Kapıda Nakit Ödemeli Normal Gönderi';
        } else {
            $shipping_title = 'Gönderici Ödemeli Normal Gönderi';
        }


        $html = '<html>
            <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <style>
                html{margin:0;padding:9px}
                body{font-family:DejaVu Sans,sans-serif;margin:0;padding:9px}
                .outer{width:100%;padding:0}
                .title{width:100%;font-size:14px;margin-bottom:4px}
                .inner{width:100%;float:left}.alt{width:100%}
                .altBilgi{width:100%;float:left}
                .altBarkod{width:100%;float:right;padding-top:10px}
                .altAdres{max-width:95%;}
                .barcode{right:275px;top:175px}
                .alt-title{font-weight:bold;font-size:11px}
                .alt div{font-size:12px}
                .tarih{margin:0;font-size:8px;margin-top:3px}
            </style>
            </head>
            <body>
            <div class="outer">
                <div class="inner">';

        if ($return_info) {
            $html .= '<div class="alt border-bottom">
                <div class="alt-title">İptal/İade/Değişim Sipariş Notu  Sipariş No: ' . $order_id . '</div>
                <div style="margin-bottom: 1rem">' . $return_info . '</div>
            </div>';
        }

        if ($order_info['comment']) {
            $html .= '<div class="alt border-bottom"  style="margin-bottom: 1rem; font-size:12px;">
                ' . $order_info['comment'] . '
            </div>';
        }

        if ($product_names) {
            $html .= '
                <div class="alt border-bottom">
                    <div class="alt-title"><b>' . $order_info['shipping_firstname'] . ' ' . $order_info['shipping_lastname'] . ' ' . $order_info['telephone'] . ' - Sipariş No: ' . $order_info['order_id'] . ' - ' . @date('d:m:y H:i') . ' </b></div>
                  </div>
    
                  <div class="alt border-bottom">
                    <div class="alt-title">Tahsilat Bilgileri</div>
                    <div style="font-size:10px">' . $product_names . '</div>
                  
                    <div>Toplam: ' . $total . '</div>
                  </div>
                  <br/>
                  <div class="altAdres">
                  <div><b style="font-size:11px">Adres</b></div>
                  <div style="text-transform:uppercase;font-size:11px">' . $order_info['shipping_address_1'] . " <br/> " . " " . $order_info['shipping_city'] . " " . $order_info['shipping_zone'] . '</div>
                  <br/>
                  </div>
                  <div class="alt">
                  <div><b style="font-size:11px">Sipariş Numarası: ' . $kargo_info['kargo_barcode'] . '</b></div>
                <div class="altBarkod" style="margin-top:0;padding-top:0">
                <div><b style="font-size:11px">MNG </b> Barcode <br>' . $barkod_cargokey . '
                </div>
              </div>
            </div>';
        }

        $html .= '
          </div>
        </body>
      </html>
        ';


        require_once(DIR_SYSTEM . 'dompdf/autoload.inc.php');

        $dompdf = new Dompdf\Dompdf(array('enable_remote' => true, 'debugLayout' => true));
        $dompdf->loadHtml($html);

        $customPaper = array(0, 0, 377, 302);
        //$customPaper = array(0, 0, 378, 330);
        $dompdf->set_paper($customPaper);

        $dompdf->render();
        // Output the generated PDF to Browser

        $dompdf->stream("dompdf_out.pdf", array("Attachment" => false));
    }

    public function mngcargo_invoicesecond()
    {
        $order_id = $this->request->get['order_id'];

        $this->db->query("UPDATE ps_order_mngkargo_second SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . $order_id . "' ");


        $kargo_info = array();

        if ($this->config->get('scottycargo_status')) {

            $this->load->model('extension/module/mngkargo');

            $kargo_info = $this->db->query("SELECT * FROM ps_order_mngkargo_second WHERE order_id = '" . $order_id . "' ")->row;

            if (empty($kargo_info)) {
                exit('Kargo iptal edildi veya bulunamadı.');
            }
        }

        require_once(DIR_SYSTEM . 'picqer/php-barcode-generator/generate-verified-files.php');

        $generatorJPG = new Picqer\Barcode\BarcodeGeneratorJPG();
        $barkod_cargokey = $generatorJPG->getBarcode($kargo_info['kargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_cargokey = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_cargokey) . '" style="width: 320px;">';

        $this->load->model('sale/order');

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info['order_status_id'] == 7) {
            return 'Bu sipariş iptal edilmiştir.';
        }

        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

        $product_names = array();

        //Return Status -- veritabanındaki kayıt
        // 0 Geçerli sipariş
        // 1 İade
        // 2 İptal
        // 3 Değişim

        $products = $this->model_sale_order->getOrderProducts($order_id);

        $return_info = '';

        foreach ($products as $product) {

            $option_name = '';
            $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);
            foreach ($options as $option) {
                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => $option['value'],
                    'type' => $option['type']
                );
                $option_name .= '<br>' . $option['name'] . ': ' . $option['value'];
            }


            $name = explode(' ', $product['name']);

            if ($product['return_status'] == 1) {
                $return_info .= $product['name'] . ' <b>İADE</b> <br>';
            } else if ($product['return_status'] == 2) {
                $return_info .= $product['name'] . ' <b>İPTAL</b> <br>';
            } else if ($product['return_status'] == 3) {
                $return_info .= $product['name'] . ' <b>DEĞİŞİM</b> <br>';
            } else {
                $product_names[] = $product['model'] . ' - ' . str_replace('Tutacaklı', '<b style="color: red; font-size: 18px;">Tutacaklı</b>', $product['name']) . ' ' . $option_name;
            }
        }


        $product_names = implode('<br>', $product_names);

        $shipping_title = '';

        if ($order_info['payment_code'] == 'cod') {
            $shipping_title = 'Kapıda Nakit Ödemeli Normal Gönderi';
        } else {
            $shipping_title = 'Gönderici Ödemeli Normal Gönderi';
        }


        $html = '<html>
            <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <style>
                html{margin:0;padding:9px}
                body{font-family:DejaVu Sans,sans-serif;margin:0;padding:9px}
                .outer{width:100%;padding:0}
                .title{width:100%;font-size:14px;margin-bottom:4px}
                .inner{width:100%;float:left}.alt{width:100%}
                .altBilgi{width:100%;float:left}
                .altBarkod{width:100%;float:right;padding-top:10px}
                .altAdres{max-width:95%;}
                .barcode{right:275px;top:175px}
                .alt-title{font-weight:bold;font-size:11px}
                .alt div{font-size:12px}
                .tarih{margin:0;font-size:8px;margin-top:3px}
            </style>
            </head>
            <body>
            <div class="outer">
                <div class="inner">';

        if ($return_info) {
            $html .= '<div class="alt border-bottom">
                <div class="alt-title">İptal/İade/Değişim Sipariş Notu  Sipariş No: ' . $order_id . '</div>
                <div style="margin-bottom: 1rem">' . $return_info . '</div>
            </div>';
        }

        if ($order_info['comment']) {
            $html .= '<div class="alt border-bottom"  style="margin-bottom: 1rem; font-size:12px;">
                ' . $order_info['comment'] . '
            </div>';
        }

        if ($product_names) {
            $html .= '
                <div class="alt border-bottom">
                    <div class="alt-title"><b>' . $order_info['shipping_firstname'] . ' ' . $order_info['shipping_lastname'] . ' ' . $order_info['telephone'] . ' - Sipariş No: ' . $order_info['order_id'] . ' - ' . @date('d:m:y H:i') . ' </b></div>
                  </div>
    
                  <div class="alt border-bottom">
                    <div class="alt-title">Tahsilat Bilgileri</div>
                    <div style="font-size:10px">' . $product_names . '</div>
                  
                    <div>Toplam: ' . $total . '</div>
                  </div>
                  <br/>
                  <div class="altAdres">
                  <div><b style="font-size:11px">Adres</b></div>
                  <div style="text-transform:uppercase;font-size:11px;">' . $order_info['shipping_address_1'] . " <br/> " . " " . $order_info['shipping_city'] . " " . $order_info['shipping_zone'] . '</div>
                  <br/>
                  </div>
                  <div class="alt">
                  <div><b style="font-size:11px">Sipariş Numarası: ' . $kargo_info['kargo_barcode'] . '</b></div>
                <div class="altBarkod" style="margin-top:0;padding-top:0">
                <div><b>MNG </b> Barcode <br>' . $barkod_cargokey . '
                </div>
              </div>
            </div>';
        }

        $html .= '
          </div>
        </body>
      </html>
        ';


        require_once(DIR_SYSTEM . 'dompdf/autoload.inc.php');

        $dompdf = new Dompdf\Dompdf(array('enable_remote' => true, 'debugLayout' => true));
        $dompdf->loadHtml($html);

        $customPaper = array(0, 0, 377, 302);
        //$customPaper = array(0, 0, 378, 330);
        $dompdf->set_paper($customPaper);

        $dompdf->render();
        // Output the generated PDF to Browser

        $dompdf->stream("dompdf_out.pdf", array("Attachment" => false));
    }

    public function suratkargo_invoice_old()
    {


        $order_id = $this->request->get['order_id'];

        $this->db->query("UPDATE ps_order_suratkargo SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . $order_id . "' ");


        $kargo_info = array();

        if ($this->config->get('suratkargo_status')) {

            $this->load->model('extension/module/suratkargo');

            $kargo_info = $ask = $this->db->query("SELECT * FROM ps_order_suratkargo WHERE order_id = '" . $order_id . "' ")->row;
        }

        require_once(DIR_SYSTEM . 'picqer/php-barcode-generator/generate-verified-files.php');

        $generatorJPG = new Picqer\Barcode\BarcodeGeneratorJPG();
        $barkod_cargokey = $generatorJPG->getBarcode($kargo_info['kargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_cargokey = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_cargokey) . '" style="width: 320px;">';
        $barkod_talepno = $generatorJPG->getBarcode($kargo_info['kargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_talepno = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_talepno) . '" style="width: 320px;">';


        $this->load->model('sale/order');

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info['order_status_id'] == 7) {
            return 'Bu sipariş iptal edilmiştir.';
        }

        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

        $product_names = array();


        //Return Status -- veritabanındaki kayıt
        // 0 Geçerli sipariş
        // 1 İade
        // 2 İptal
        // 3 Değişim

        $products = $this->model_sale_order->getOrderProducts($order_id);


        $return_info = '';

        foreach ($products as $product) {

            $option_name = '';
            $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);
            foreach ($options as $option) {
                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => $option['value'],
                    'type' => $option['type']
                );
                $option_name .= '<br>' . $option['name'] . ': ' . $option['value'];
            }


            $name = explode(' ', $product['name']);

            if ($product['return_status'] == 1) {
                $return_info .= $product['name'] . ' <b>İADE</b> <br>';
            } else if ($product['return_status'] == 2) {
                $return_info .= $product['name'] . ' <b>İPTAL</b> <br>';
            } else if ($product['return_status'] == 3) {
                $return_info .= $product['name'] . ' <b>DEĞİŞİM</b> <br>';
            } else {
                $product_names[] = $product['model'] . ' - ' . str_replace('Tutacaklı', '<b style="color: red; font-size: 18px;">Tutacaklı</b>', $product['name']) . ' ' . $option_name;
            }
        }


        $product_names = implode('<br>', $product_names);

        $shipping_title = '';

        if ($order_info['payment_code'] == 'cod') {
            $shipping_title = 'Kapıda Nakit Ödemeli Normal Gönderi';
        } else {
            $shipping_title = 'Gönderici Ödemeli Normal Gönderi';
        }


        $html = '<html>
        <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

          <style>
            html { margin: 0; padding: 9px; }
            body { font-family: DejaVu Sans, sans-serif; margin: 0; padding: 9px;}

            .outer{
              width: 100%;
              padding: 0;
            }

            .title{
              width: 100%;
              font-size: 14px;
              margin-bottom: 4px;
            }

            .inner{
              width: 100%;
              float: left;
            }

            .alt{
              width: 100%;
            }

            .altBilgi{
              width: 100%;
              float:left;
            }

            .altBarkod{
              width: 100%;
              float: right;
              padding-top: 10px;
            }

            .barcode{
              right: 275px;
              top: 175px;
            }

            .alt-title{
              font-weight: bold;
              font-size: 11px;
            }

            .alt div{
              font-size: 10px;
            }

            .tarih{
              margin: 0;
              font-size: 8px;
              margin-top: 3px;
            }
          </style>

        </head>
        <body>

          <div class="outer">

            <div class="inner">
             ';

        if ($return_info) {

            $html .= '<div class="alt border-bottom" >
                <div class="alt-title">İptal/İade/Değişim Sipariş Notu  Sipariş No: ' . $order_id . '</div>
                <div style="height: 80%">' . $return_info . '</div>

              </div>';
        }

        if ($order_info['comment']) {

            $html .= '<div style="height: 100%; font-size:10px;">
                ' . $order_info['comment'] . '

              </div>';
        }

        if ($product_names) {

            $html .= '

            <div class="alt border-bottom">
                <div class="alt-title"><b>' . $order_info['shipping_firstname'] . ' ' . $order_info['shipping_lastname'] . ' ' . $order_info['telephone'] . ' - Sipariş No: ' . $order_info['order_id'] . ' - ' . @date('d:m:y h:i') . ' </b><</div>
              </div>


              <div class="alt border-bottom">
                <div class="alt-title">Tahsilat Bilgileri</div>
                <div style="font-size:10px">' . $product_names . '</div>
              
                <div>Toplam: ' . $total . '</div>
                <div>Tahsilat Türü: </div>
              </div>
            <div class="alt">
              <div><b>Sipariş Numarası: ' . $kargo_info['kargo_barcode'] . ' - Talep Numarası: ' . $kargo_info['kargo_barcode'] . '</b></div>
            <div class="altBarkod" style="margin-top:0;padding-top:0">
            <div><b>SURATKARGO</b> Cargokey - Sipariş No: <b>' . $order_id . '</b> <br>' . $barkod_cargokey . '
            </div>
            <div>Talep no <br>
            ' . $barkod_talepno . '
            </div>
          </div>
        </div>';
        }

        $html .= '
          </div>
        </body>
      </html>
        ';


        require_once(DIR_SYSTEM . 'dompdf/autoload.inc.php');

        $dompdf = new Dompdf\Dompdf(array('enable_remote' => true, 'debugLayout' => true));
        $dompdf->loadHtml($html);

        $customPaper = array(0, 0, 377, 302);
        //$customPaper = array(0, 0, 378, 330);
        $dompdf->set_paper($customPaper);

        $dompdf->render();
        // Output the generated PDF to Browser

        $dompdf->stream("dompdf_out.pdf", array("Attachment" => false));
    }

    public function scottycargo_invoice()
    {
        $order_id = $this->request->get['order_id'];

        $this->db->query("UPDATE ps_order_scottycargo SET barcode_print_count = barcode_print_count+1 WHERE order_id = '" . $order_id . "' ");


        $kargo_info = array();

        if ($this->config->get('scottycargo_status')) {

            $this->load->model('extension/module/scottycargo');

            $kargo_info = $this->db->query("SELECT * FROM ps_order_scottycargo WHERE order_id = '" . $order_id . "' ")->row;

            if (empty($kargo_info)) {
                exit('Kargo iptal edildi veya bulunamadı.');
            }
        }

        require_once(DIR_SYSTEM . 'picqer/php-barcode-generator/generate-verified-files.php');

        $generatorJPG = new Picqer\Barcode\BarcodeGeneratorJPG();
        $barkod_cargokey = $generatorJPG->getBarcode($kargo_info['scottycargo_barcode'], $generatorJPG::TYPE_CODE_128_A);
        $barkod_cargokey = '<img src="data:image/jpeg;base64,' . base64_encode($barkod_cargokey) . '" style="width: 320px;">';

        $this->load->model('sale/order');

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info['order_status_id'] == 7) {
            return 'Bu sipariş iptal edilmiştir.';
        }

        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

        $product_names = array();

        //Return Status -- veritabanındaki kayıt
        // 0 Geçerli sipariş
        // 1 İade
        // 2 İptal
        // 3 Değişim

        $products = $this->model_sale_order->getOrderProducts($order_id);

        $return_info = '';

        foreach ($products as $product) {

            $option_name = '';
            $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);
            foreach ($options as $option) {
                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => $option['value'],
                    'type' => $option['type']
                );
                $option_name .= '<br>' . $option['name'] . ': ' . $option['value'];
            }


            $name = explode(' ', $product['name']);

            if ($product['return_status'] == 1) {
                $return_info .= $product['name'] . ' <b>İADE</b> <br>';
            } else if ($product['return_status'] == 2) {
                $return_info .= $product['name'] . ' <b>İPTAL</b> <br>';
            } else if ($product['return_status'] == 3) {
                $return_info .= $product['name'] . ' <b>DEĞİŞİM</b> <br>';
            } else {
                $product_names[] = $product['model'] . ' - ' . str_replace('Tutacaklı', '<b style="color: red; font-size: 18px;">Tutacaklı</b>', $product['name']) . ' ' . $option_name;
            }
        }


        $product_names = implode('<br>', $product_names);

        $shipping_title = '';

        if ($order_info['payment_code'] == 'cod') {
            $shipping_title = 'Kapıda Nakit Ödemeli Normal Gönderi';
        } else {
            $shipping_title = 'Gönderici Ödemeli Normal Gönderi';
        }


        $html = '<html>
            <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
            <style>
                html{margin:0;padding:9px}
                body{font-family:DejaVu Sans,sans-serif;margin:0;padding:25px}
                .outer{width:100%;padding:0}
                .title{width:100%;font-size:14px;margin-bottom:4px}
                .inner{width:100%;float:left}.alt{width:100%}
                .altBilgi{width:100%;float:left}
                .altBarkod{width:100%;float:right;padding-top:10px}
                .altAdres{max-width:95%;}
                .barcode{right:275px;top:175px}
                .alt-title{font-weight:bold;font-size:11px}
                .alt div{font-size:12px}
                .tarih{margin:0;font-size:8px;margin-top:3px}
            </style>
            </head>
            <body>
            <div class="outer">
                <div class="inner">';

        if ($return_info) {
            $html .= '<div class="alt border-bottom">
                <div class="alt-title">İptal/İade/Değişim Sipariş Notu  Sipariş No: ' . $order_id . '</div>
                <div style="margin-bottom: 1rem">' . $return_info . '</div>
            </div>';
        }

        if ($order_info['comment']) {
            $html .= '<div class="alt border-bottom"  style="margin-bottom: 1rem; font-size:12px;">
                ' . $order_info['comment'] . '
            </div>';
        }

        if ($product_names) {
            $html .= '
                <div class="alt border-bottom">
                    <div class="alt-title"><b>' . $order_info['shipping_firstname'] . ' ' . $order_info['shipping_lastname'] . ' ' . $order_info['telephone'] . ' - Sipariş No: ' . $order_info['order_id'] . ' - ' . @date('d:m:y H:i') . ' </b></div>
                  </div>
    
                  <div class="alt border-bottom">
                    <div class="alt-title" style="font-size:11px">Tahsilat Bilgileri</div>
                    <div style="font-size:10px">' . $product_names . '</div>
                  
                    <div>Toplam: ' . $total . '</div>
                  </div>
                  <br/>
                  <div class="altAdres">
                  <div><b style="font-size:11px">Adres</b></div>
                  <div style="text-transform:uppercase; font-size:11px;">' . $order_info['shipping_address_1'] . " <br/> " . " " . $order_info['shipping_city'] . " " . $order_info['shipping_zone'] . '</div>
                  <br/>
                  </div>
                  <div class="alt">
                  <div><b style="font-size:11px">Sipariş Numarası: ' . $kargo_info['scottycargo_barcode'] . '</b></div>
                <div class="altBarkod" style="margin-top:0;padding-top:0">
                <div><center><b>Scotty</b> Barcode <br>' . $barkod_cargokey . '</center>
                </div>
              </div>
            </div>';
        }

        /*
        if ($product_names) {
            $html .= '
            <div class="alt border-bottom">
                <div class="alt-title"><b>' . $order_info['shipping_firstname'] . ' ' . $order_info['shipping_lastname'] . ' ' . $order_info['telephone'] . ' - Sipariş No: ' . $order_info['order_id'] . ' - ' . @date('d:m:y h:i') . ' </b><</div>
              </div>

              <div class="alt border-bottom">
                <div class="alt-title">Tahsilat Bilgileri</div>
                <div>' . $product_names . '</div>
              
                <div>Toplam: ' . $total . '</div>
              </div>
              <br/>
              <div class="alt">
              <div><b>Adres</b></div>
              <div style="text-transform:uppercase;">'. $order_info['shipping_address_1']. " " . " " . $order_info['shipping_city'] . " " . $order_info['shipping_zone'] . '</div>
              <br/>
              </div>
              <div class="alt">
              <div><b>Sipariş Numarası: ' . $kargo_info['scottycargo_barcode'] . '</b></div>
            <div class="altBarkod" style="margin-top:0;padding-top:0">
            <div><b>Scotty</b> Barcode <br>' . $barkod_cargokey . '
            </div>
          </div>
        </div>';
        }
        */

        $html .= '
          </div>
        </body>
      </html>
        ';


        require_once(DIR_SYSTEM . 'dompdf/autoload.inc.php');

        $dompdf = new Dompdf\Dompdf(array('enable_remote' => true, 'debugLayout' => true));
        $dompdf->loadHtml($html);

        $customPaper = array(0, 0, 377, 302);
        //$customPaper = array(0, 0, 378, 330);
        $dompdf->set_paper($customPaper);

        $dompdf->render();
        // Output the generated PDF to Browser

        $dompdf->stream("dompdf_out.pdf", array("Attachment" => false));
    }

    public function downloadGeneratedImages()
    {

        $model = $this->request->post['model'];


        $Zip = new ZipArchive();

        $Zip->open("ZIP/CollectionZip.$model.zip", ZipArchive::CREATE);


        $this->load->model('sale/order');


        $sql = "SELECT o.order_id, CONCAT(o.firstname, ' ', o.lastname) AS customer, o.row_color_code,

        (SELECT os.name FROM ps_order_status os WHERE os.order_status_id = o.order_status_id AND os.language_id = '" . (int)$this->config->get('config_language_id') . "') AS order_status,

		o.shipping_code, o.total, o.currency_code, o.currency_value, o.date_added, o.date_modified, o.status FROM ps_order o WHERE o.status = 0 AND o.row_color_code = '#ABFF72' ORDER BY o.date_added ASC ";


        $results = $this->db->query($sql)->rows;


        foreach ($results as $result) {


            $order_products = $this->model_sale_order->getOrderProducts($result['order_id']);


            $this->load->model('tool/image');

            foreach ($order_products as $order_product)
                if (strpos($order_product['model'], $model) !== false)
                    $Zip->addFromString($order_product['admin_pattern_image'], file_get_contents($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''));
        }


        $Zip->close();


        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode(array("link" => "https://www.deercase.com/ps-panel/ZIP/CollectionZip.$model.zip")));
    }

    public function toggleStatus()
    {

        $OrderProductID = $this->request->post['order_product_id'];

        if (isset($OrderProductID))
            $this->db->query("UPDATE ps_order_product SET status = !(status) WHERE order_product_id='" . $OrderProductID . "'");
    }

    public function hideCompleted()
    {

        if (isset($this->request->get['order_id']) and $this->request->get['order_id']) {

            $order_id = $this->request->get['order_id'];

            $this->db->query("UPDATE ps_prepared_orders SET status = 1 WHERE order_id = '" . $order_id . "'");
            $this->db->query("UPDATE ps_order SET status = 1 WHERE order_id = '" . $order_id . "'");

            //$Results = $this->db->query("SELECT order_id FROM ps_order_product GROUP BY order_id HAVING SUM(status) = COUNT(*)");
            //$Results = $this->db->query("SELECT order_id FROM ps_order_product ");
            /*foreach ($Results->rows as $Result){

            } */
        }


        // $this->db->query("UPDATE ps_prepared_orders SET status = 1 WHERE order_id = '" . $OrderID . "'");
    }

    public function hideSelected()
    {
        $OrderIDs = $_GET["OrderIDs"];
        foreach ($OrderIDs as $OrderID) {
            $this->db->query("UPDATE ps_prepared_orders SET status = 1 WHERE order_id = '" . $OrderID . "'");
            $this->db->query("UPDATE ps_order SET status = 1 WHERE order_id = '" . $OrderID . "'");
        }
    }

    public function bulkDownload()
    {

        $OrderIDs = isset($this->request->post["selected_order_ids"]) ? $this->request->post["selected_order_ids"] : '';
        if (!$OrderIDs) {
            die;
        }
        $zipname = 'DeerCase-' . @date("Y-m-d-His") . 'BulkImages.zip';

        $zip = new ZipArchive();
        $zip_file_tmp = tempnam('.', '');
        $zip->open($zip_file_tmp, ZipArchive::CREATE);


        foreach ($OrderIDs as $OrderID) {
            $query = $this->db->query("SELECT admin_pattern_image,admin_gradient_pattern_image,customcase_image FROM ps_order_product  WHERE order_id = '" . $OrderID . "'");
            foreach ($query->rows as $row) {
                if ($row['customcase_image'] != '') {
                    $str = explode('***', $row['customcase_image']);
                    $filename = str_replace('cropped', '', $str[1]);
                    $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $filename;
                    // $name=str_replace('upload/cropped','',$str[1]);

                    $download_file = file_get_contents($customcase_image);
                    $zip->addFromString(basename($customcase_image), $download_file);
                } else {
                    if ($row['admin_pattern_image'] != '') {
                        $admin_pattern_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $row['admin_pattern_image'];

                        // $name=str_replace('admin_pattern_images/','',$row['admin_pattern_image']);
                        //$filepath = DIR_IMAGE.$row['admin_pattern_image'];

                        $download_file = file_get_contents($admin_pattern_image);
                        $zip->addFromString(basename($admin_pattern_image), $download_file);
                    }
                    if ($row['admin_gradient_pattern_image'] != NULL) {
                        $admin_gradient_pattern_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $row['admin_gradient_pattern_image'];
                        //$name=str_replace('admin_gradient_images/','',$row['admin_pattern_image']);

                        $download_file = file_get_contents($admin_gradient_pattern_image);
                        $zip->addFromString(basename($admin_gradient_pattern_image), $download_file);
                    }
                }
            }
        }
        $zip->close();

        header('Content-disposition: attachment; filename=' . $zipname);
        header('Content-type: application/zip');
        readfile($zip_file_tmp);
        exit;
    }

    // 18 Ağustos 2020 - @toturkmen - Tolga
    public function toggleReprint()
    {
        $OrderProductID = $this->request->post['order_product_id'];
        if (isset($OrderProductID))
            $this->db->query("UPDATE ps_order_product SET reprint = !(reprint) WHERE order_product_id='" . $OrderProductID . "'");
    }

    public function editReprintReason()
    {
        if (isset($this->request->get['reprint_reason_id']) and isset($this->request->get['order_product_id'])) {

            $order_product_id = $this->request->get['order_product_id'];
            $reprint_reason_id = $this->request->get['reprint_reason_id'];


            $this->db->query("UPDATE ps_order_product SET reprint_reason_id = '" . (int)$reprint_reason_id . "' WHERE order_product_id = '" . (int)$order_product_id . "' ");
        }
    }

    public function editRoomNumber()
    {
        if (isset($this->request->get['room_no']) and isset($this->request->get['order_product_id'])) {

            $order_product_id = $this->request->get['order_product_id'];
            $room_no = $this->request->get['room_no'];


            $this->db->query("UPDATE ps_order_product SET room_no = '" . (int)$room_no . "' WHERE order_product_id = '" . (int)$order_product_id . "' ");
        }
    }

    //22.09.20 decrease product idle stock (ali.a)
    public function decreaseProductIdleStock()
    { // 21.12.2022 - Özkan Can editng.
        if (isset($this->request->get['productId'])) {
            $this->load->model('catalog/product');
            $idleStock = $this->model_catalog_product->decreaseIdleStock($this->request->get['productId']);
            echo '{"idleStock":"' . $idleStock . '"}';
        }
    }

    public function increaseIdleStock()
    { // Ürüne atıl Stok Ekleme -Can 9.12.2021
        $product_id = $this->request->get['product_id'];

        if (isset($product_id)) {
            $this->load->model('catalog/product');

            $add_idle_stock = $this->model_catalog_product->increaseIdleStock($product_id);

            if ($add_idle_stock) {
                $idle_stock = $this->model_catalog_product->getProduct($product_id)['idle_stock'];
                $json = array(
                    'status' => 1,
                    'message' => 'Atıl stok eklendi.',
                    'data' => $idle_stock
                );
            } else {
                $json = array(
                    'status' => 0
                );
            }

            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode($json));
        }
    }

    public function IncreaseReprintDownloadCount()
    {
        $order_product_id = $this->request->post['order_product_id'];
        $order_product = $this->db->query("SELECT order_product_id, reprint FROM " . DB_PREFIX . "order_product WHERE order_product_id = '" . $order_product_id . "'")->row;

        if ($order_product['reprint'] == 1) {
            $this->db->query("UPDATE " . DB_PREFIX . "order_product SET reprint_download_count = reprint_download_count+1 WHERE order_product_id = '" . (int)$order_product_id . "' LIMIT 1");
            $json = 1;
        } else {
            $json = 0;
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
}
