<?php
class ControllerSaleOrderDev extends Controller
{
    use MngArasYurticiTrait;
    use Byexpress;
    use scottycargo;

    private $error = array();

    public function download_cases()
    {
        var_dump($this->request->post);
    }

    public function index()
    {

        $this->load->language('sale/order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');
        $this->getList();

    }

    protected function getList($params = [])
    {

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];

            if(strpos($filter_order_id,",") === false){
                $filter_order_id = $this->request->get['filter_order_id'];
                $to_filter_order_ids = array();
            }else{
                //var_dump("virgüm var"); die();
                $to_filter_order_ids = explode(',', $this->request->get['filter_order_id']);

            }
        } else {
            $filter_order_id = null;
            $to_filter_order_ids = array();
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }


        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }


        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_order_payment'])) {
            $filter_order_payment = $this->request->get['filter_order_payment'];
        } else {
            $filter_order_payment = null;
        }

        if (isset($this->request->get['filter_order_zone'])) {
            $filter_order_zone = $this->request->get['filter_order_zone'];
        } else {
            $filter_order_zone = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {

            $filter_tranfer_order_status = $this->request->get['filter_tranfer_order_status'];

        } else {

            $filter_tranfer_order_status = null;

        }


        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }


        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }


        $url = '';


        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {
            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }


        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }


        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true)
        );


        $data['download_cases'] = $this->url->link('sale/order/download_cases', 'token=' . $this->session->data['token'], true);
        $data['invoice'] = $this->url->link('sale/order/invoice', 'token=' . $this->session->data['token'], true);
        $data['excel_export'] = $this->url->link('sale/order/excel_export', 'token=' . $this->session->data['token'], true);
        $data['excel_download'] = $this->url->link('sale/order/excel_download', 'token=' . $this->session->data['token'], true);
        $data['v3_export'] = $this->url->link('sale/order/v3_export', 'token=' . $this->session->data['token'], true);
        $data['orderExcel'] = $this->url->link('sale/order/orderExcel', 'token=' . $this->session->data['token'], true);
        $data['shipping'] = $this->url->link('sale/order/shipping', 'token=' . $this->session->data['token'], true);
        $data['add'] = $this->url->link('sale/order/add', 'token=' . $this->session->data['token'], true);
        $data['kta'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&filter_order_status=18', true);
        $data['delete'] = $this->url->link('sale/order/delete', 'token=' . $this->session->data['token'], true);

        $data['move_prepared_orders'] = $this->url->link('sale/order/move_prepared_orders', 'token=' . $this->session->data['token'], true);
        $data['remove_prepared_orders'] = $this->url->link('sale/order/remove_prepared_orders', 'token=' . $this->session->data['token'], true);

        $row_color_code = null;
        $hazir_urunler=array();


        if ($filter_tranfer_order_status == '0') {
            $row_color_code = '';
        } elseif ($filter_tranfer_order_status == '1') {
            $row_color_code = '#ABFF72';
        }elseif ($filter_tranfer_order_status == '2') {
            $row_color_code = 'prepared_orders';
        }

        $data['orders'] = array();


        $filter_data = array(
            'filter_order_id' => $filter_order_id,
            'to_filter_order_ids' => $to_filter_order_ids,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_customer' => $filter_customer,
            'filter_order_status' => $filter_order_status,
            'filter_order_zone' => $filter_order_zone,
            'filter_order_payment' => $filter_order_payment,
            'filter_total' => $filter_total,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'filter_tranfer_order_status' => $row_color_code,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        if (isset($params['delayed_orders'])) {
            $filter_data['delayed_orders'] = true;
        }

        $order_total = $this->model_sale_order->getTotalOrders($filter_data);

        $results = $this->model_sale_order->getOrders($filter_data);

        foreach ($results as $result) {

            $order_customer_id = 0;
            $order_customer_id = $this->model_sale_order->getOrderCustomerId($result['order_id']);
            $hazir_urunler[$result['order_id']]=0;

            $total_customer_orders = 0;
            if ($order_customer_id > 0) {
                $total_customer_orders = $this->model_sale_order->getTotalOrdersByCustomer($order_customer_id);
            }

            $move_prepared_order_info = $this->model_sale_order->ismovePreparedOrder($result['order_id']);

            $data['orders'][] = array(
                'order_id' => $result['order_id'],
                'customer' => $result['customer'],
                'customer_id' => $order_customer_id,
                'total_customer_orders' => $total_customer_orders,
                'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                'total' => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'shipping_code' => $result['shipping_code'],
                'row_color_code' => $result['row_color_code'],
                'view' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . $result['order_id'] . $url, true),
                'edit' => $this->url->link('sale/order/edit', 'token=' . $this->session->data['token'] . '&order_id=' . $result['order_id'] . $url, true),
                'is_move_prepared_order' => isset($move_prepared_order_info['status']) ? 1 : 0,
                'prepared_order_row_color_code' => isset($move_prepared_order_info['row_color_code']) ? $move_prepared_order_info['row_color_code'] : '',
            );

        }


        /*         * *** HARU EDIT **** */
        $hazir_urunler=$this->model_sale_order->get_hazir_urunler($hazir_urunler,["bnd", "rpd", "tiny"]);
        $data['hazir_urunler']=$hazir_urunler;
        $data['button_update_status'] = $this->language->get('button_update_status');
        $data['add_comment'] = $this->language->get('add_comment');
        $data['add_notify'] = $this->language->get('add_notify');
        $data['token'] = $this->language->get('token');
        /*         * *** END HARU EDIT **** */

        $data['heading_title'] =  (isset($params['delayed_orders'])) ? 'Geciken Siparişler':$this->language->get('heading_title');


        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_missing'] = $this->language->get('text_missing');
        $data['text_loading'] = $this->language->get('text_loading');


        $data['column_order_id'] = $this->language->get('column_order_id');
        $data['column_customer'] = $this->language->get('column_customer');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_total'] = $this->language->get('column_total');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_date_modified'] = $this->language->get('column_date_modified');
        $data['column_action'] = $this->language->get('column_action');

        $data['entry_order_id'] = $this->language->get('entry_order_id');
        $data['entry_customer'] = $this->language->get('entry_customer');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_total'] = $this->language->get('entry_total');
        $data['entry_date_added'] = $this->language->get('entry_date_added');
        $data['entry_date_modified'] = $this->language->get('entry_date_modified');
        $data['text_tranferred_to_excel'] = $this->language->get('text_tranferred_to_excel');
        $data['text_not_tranferred_to_excel'] = $this->language->get('text_not_tranferred_to_excel');
        $data['text_prepared_orders'] = $this->language->get('text_prepared_orders');
        $data['entry_tranfer_order_status'] = $this->language->get('entry_tranfer_order_status');

        $data['button_invoice_print'] = $this->language->get('button_invoice_print');
        $data['button_shipping_print'] = $this->language->get('button_shipping_print');
        $data['button_add'] = $this->language->get('button_add');
        $data['button_edit'] = $this->language->get('button_edit');
        $data['button_delete'] = $this->language->get('button_delete');
        $data['button_filter'] = $this->language->get('button_filter');
        $data['button_view'] = $this->language->get('button_view');
        $data['button_ip_add'] = $this->language->get('button_ip_add');


        $this->load->model('localisation/zone');

        $data['zones'] = $this->model_localisation_zone->getZonesByCountryId($this->config->get('config_country_id'));


        $data['shipping_methods'] = $this->model_sale_order->getShippingMethods();


        $data['paymnet_methods'] = $this->model_sale_order->getPaymentMethods();


        $data['token'] = $this->session->data['token'];


        if (isset($this->error['warning'])) {

            $data['error_warning'] = $this->error['warning'];

        } else {

            $data['error_warning'] = '';

        }


        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }


        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {
            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }


        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }


        $data['sort_order'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=o.order_id' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=customer' . $url, true);
        $data['sort_status'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=order_status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=o.total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=o.date_modified' . $url, true);


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['filter_tranfer_order_status'])) {
            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }


        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }


        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');

        $pagination->url = $this->url->link( (isset($params['delayed_orders']))?'sale/order/delayedOrders':'sale/order', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();


        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));


        $data['filter_order_id'] = $filter_order_id;

        $data['filter_email'] = $filter_email;

        $data['filter_telephone'] = $filter_telephone;

        $data['filter_customer'] = $filter_customer;

        $data['filter_order_status'] = $filter_order_status;

        $data['filter_order_zone'] = $filter_order_zone;

        $data['filter_order_payment'] = $filter_order_payment;

        $data['filter_total'] = $filter_total;

        $data['filter_date_added'] = $filter_date_added;

        $data['filter_date_modified'] = $filter_date_modified;

        $data['filter_tranfer_order_status'] = $filter_tranfer_order_status;


        $data['sort'] = $sort;

        $data['order'] = $order;


        $this->load->model('localisation/order_status');


        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


        $data['header'] = $this->load->controller('common/header');

        $data['column_left'] = $this->load->controller('common/column_left');

        $data['footer'] = $this->load->controller('common/footer');


        /* HARUN EDIT */

        // API login

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


        $this->load->model('user/api');


        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));


        if ($api_info) {


            $data['api_id'] = $api_info['api_id'];

            $data['api_key'] = $api_info['key'];

            $data['api_ip'] = $this->request->server['REMOTE_ADDR'];

        } else {

            $data['api_id'] = '';

            $data['api_key'] = '';

            $data['api_ip'] = '';

        }

        /* END HARUN EDIT */

        
        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_list_hafiz.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_list', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_list', $data));
        }

    }

    public function getList2()
    {

        $this->load->model('sale/order');

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];

            if(strpos($filter_order_id,",") === false){
                $filter_order_id = $this->request->get['filter_order_id'];
                $to_filter_order_ids = array();
            }else{
                //var_dump("virgüm var"); die();
                $to_filter_order_ids = explode(',', $this->request->get['filter_order_id']);

            }
        } else {
            $filter_order_id = null;
            $to_filter_order_ids = array();
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }


        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }


        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_order_payment'])) {
            $filter_order_payment = $this->request->get['filter_order_payment'];
        } else {
            $filter_order_payment = null;
        }

        if (isset($this->request->get['filter_order_zone'])) {
            $filter_order_zone = $this->request->get['filter_order_zone'];
        } else {
            $filter_order_zone = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {

            $filter_tranfer_order_status = $this->request->get['filter_tranfer_order_status'];

        } else {

            $filter_tranfer_order_status = null;

        }


        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }


        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }


        $url = '';


        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {
            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }


        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }


        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true)
        );


        $data['download_cases'] = $this->url->link('sale/order/download_cases', 'token=' . $this->session->data['token'], true);
        $data['invoice'] = $this->url->link('sale/order/invoice', 'token=' . $this->session->data['token'], true);
        $data['excel_export'] = $this->url->link('sale/order/excel_export', 'token=' . $this->session->data['token'], true);
        $data['excel_download'] = $this->url->link('sale/order/excel_download', 'token=' . $this->session->data['token'], true);
        $data['orderExcel'] = $this->url->link('sale/order/orderExcel', 'token=' . $this->session->data['token'], true);
        $data['shipping'] = $this->url->link('sale/order/shipping', 'token=' . $this->session->data['token'], true);
        $data['add'] = $this->url->link('sale/order/add', 'token=' . $this->session->data['token'], true);
        $data['kta'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&filter_order_status=18', true);
        $data['delete'] = $this->url->link('sale/order/delete', 'token=' . $this->session->data['token'], true);

        $data['move_prepared_orders'] = $this->url->link('sale/order/move_prepared_orders', 'token=' . $this->session->data['token'], true);
        $data['remove_prepared_orders'] = $this->url->link('sale/order/remove_prepared_orders', 'token=' . $this->session->data['token'], true);

        $row_color_code = null;
        $hazir_urunler=array();


        if ($filter_tranfer_order_status == '0') {
            $row_color_code = '';
        } elseif ($filter_tranfer_order_status == '1') {
            $row_color_code = '#ABFF72';
        }elseif ($filter_tranfer_order_status == '2') {
            $row_color_code = 'prepared_orders';
        }

        $data['orders'] = array();


        $filter_data = array(
            'filter_order_id' => $filter_order_id,
            'to_filter_order_ids' => $to_filter_order_ids,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_customer' => $filter_customer,
            'filter_order_status' => $filter_order_status,
            'filter_order_zone' => $filter_order_zone,
            'filter_order_payment' => $filter_order_payment,
            'filter_total' => $filter_total,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'filter_tranfer_order_status' => $row_color_code,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        //$order_total = $this->model_sale_order->getTotalOrders($filter_data);
        //$results = $this->model_sale_order->getOrders($filter_data);


        $redis = new Redis();
        $redis->connect('127.0.0.1', 6379);

        $results = $redis->get('orders');
        $results = json_decode($results, true);

       // var_dump($results); die();

        $order_total = count($results);

        foreach ($results as $result) {

            $result = $result['order_row'];

            $order_customer_id = 0;
            $order_customer_id = $this->model_sale_order->getOrderCustomerId($result['order_id']);
            $hazir_urunler[$result['order_id']]=0;

            $total_customer_orders = 0;
            if ($order_customer_id > 0) {
                $total_customer_orders = $this->model_sale_order->getTotalOrdersByCustomer($order_customer_id);
            }

            $move_prepared_order_info = $this->model_sale_order->ismovePreparedOrder($result['order_id']);

            $data['orders'][] = array(
                'order_id' => $result['order_id'],
                'customer' => '66',
                'customer_id' => $order_customer_id,
                'total_customer_orders' => $total_customer_orders,
                'order_status' => isset($result['order_status']) ? $result['order_status'] : $this->language->get('text_missing'),
                'total' => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'shipping_code' => $result['shipping_code'],
                'row_color_code' => $result['row_color_code'],
                'view' => $this->url->link('sale/order/info', 'token=' . $this->session->data['token'] . '&order_id=' . $result['order_id'] . $url, true),
                'edit' => $this->url->link('sale/order/edit', 'token=' . $this->session->data['token'] . '&order_id=' . $result['order_id'] . $url, true),
                'is_move_prepared_order' => isset($move_prepared_order_info['status']) ? 1 : 0,
                'prepared_order_row_color_code' => isset($move_prepared_order_info['row_color_code']) ? $move_prepared_order_info['row_color_code'] : '',
            );

        }


        /*         * *** HARU EDIT **** */
        $hazir_urunler=$this->model_sale_order->get_hazir_urunler($hazir_urunler,["bnd", "rpd", "tiny"]);
        $data['hazir_urunler']=$hazir_urunler;
        $data['button_update_status'] = $this->language->get('button_update_status');
        $data['add_comment'] = $this->language->get('add_comment');
        $data['add_notify'] = $this->language->get('add_notify');
        $data['token'] = $this->language->get('token');
        /*         * *** END HARU EDIT **** */

        $data['heading_title'] = $this->language->get('heading_title');


        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_missing'] = $this->language->get('text_missing');
        $data['text_loading'] = $this->language->get('text_loading');


        $data['column_order_id'] = $this->language->get('column_order_id');
        $data['column_customer'] = $this->language->get('column_customer');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_total'] = $this->language->get('column_total');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_date_modified'] = $this->language->get('column_date_modified');
        $data['column_action'] = $this->language->get('column_action');

        $data['entry_order_id'] = $this->language->get('entry_order_id');
        $data['entry_customer'] = $this->language->get('entry_customer');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_total'] = $this->language->get('entry_total');
        $data['entry_date_added'] = $this->language->get('entry_date_added');
        $data['entry_date_modified'] = $this->language->get('entry_date_modified');
        $data['text_tranferred_to_excel'] = $this->language->get('text_tranferred_to_excel');
        $data['text_not_tranferred_to_excel'] = $this->language->get('text_not_tranferred_to_excel');
        $data['text_prepared_orders'] = $this->language->get('text_prepared_orders');
        $data['entry_tranfer_order_status'] = $this->language->get('entry_tranfer_order_status');

        $data['button_invoice_print'] = $this->language->get('button_invoice_print');
        $data['button_shipping_print'] = $this->language->get('button_shipping_print');
        $data['button_add'] = $this->language->get('button_add');
        $data['button_edit'] = $this->language->get('button_edit');
        $data['button_delete'] = $this->language->get('button_delete');
        $data['button_filter'] = $this->language->get('button_filter');
        $data['button_view'] = $this->language->get('button_view');
        $data['button_ip_add'] = $this->language->get('button_ip_add');


        $this->load->model('localisation/zone');

        $data['zones'] = $this->model_localisation_zone->getZonesByCountryId($this->config->get('config_country_id'));


        $data['shipping_methods'] = $this->model_sale_order->getShippingMethods();


        $data['paymnet_methods'] = $this->model_sale_order->getPaymentMethods();


        $data['token'] = $this->session->data['token'];


        if (isset($this->error['warning'])) {

            $data['error_warning'] = $this->error['warning'];

        } else {

            $data['error_warning'] = '';

        }


        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }


        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {
            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }


        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }


        $data['sort_order'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=o.order_id' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=customer' . $url, true);
        $data['sort_status'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=order_status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=o.total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&sort=o.date_modified' . $url, true);


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['filter_tranfer_order_status'])) {
            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }


        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }


        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();


        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));


        $data['filter_order_id'] = $filter_order_id;

        $data['filter_email'] = $filter_email;

        $data['filter_telephone'] = $filter_telephone;

        $data['filter_customer'] = $filter_customer;

        $data['filter_order_status'] = $filter_order_status;

        $data['filter_order_zone'] = $filter_order_zone;

        $data['filter_order_payment'] = $filter_order_payment;

        $data['filter_total'] = $filter_total;

        $data['filter_date_added'] = $filter_date_added;

        $data['filter_date_modified'] = $filter_date_modified;

        $data['filter_tranfer_order_status'] = $filter_tranfer_order_status;


        $data['sort'] = $sort;

        $data['order'] = $order;


        $this->load->model('localisation/order_status');


        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


        $data['header'] = $this->load->controller('common/header');

        $data['column_left'] = $this->load->controller('common/column_left');

        $data['footer'] = $this->load->controller('common/footer');


        /* HARUN EDIT */

        // API login

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


        $this->load->model('user/api');


        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));


        if ($api_info) {


            $data['api_id'] = $api_info['api_id'];

            $data['api_key'] = $api_info['key'];

            $data['api_ip'] = $this->request->server['REMOTE_ADDR'];

        } else {

            $data['api_id'] = '';

            $data['api_key'] = '';

            $data['api_ip'] = '';

        }

        /* END HARUN EDIT */


        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_list_hafiz.tpl')) {

            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_list', $data));

        } else {

            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_list', $data));

        }

    }

    public function add()
    {

        $this->load->language('sale/order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/order');

        $this->getForm();

    }

    public function getForm()
    {

        $data['heading_title'] = $this->language->get('heading_title');


        $data['text_form'] = !isset($this->request->get['order_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['text_no_results'] = $this->language->get('text_no_results');

        $data['text_default'] = $this->language->get('text_default');

        $data['text_select'] = $this->language->get('text_select');

        $data['text_none'] = $this->language->get('text_none');

        $data['text_loading'] = $this->language->get('text_loading');

        $data['text_ip_add'] = sprintf($this->language->get('text_ip_add'), $this->request->server['REMOTE_ADDR']);

        $data['text_product'] = $this->language->get('text_product');

        $data['text_voucher'] = $this->language->get('text_voucher');

        $data['text_order_detail'] = $this->language->get('text_order_detail');


        $data['entry_store'] = $this->language->get('entry_store');

        $data['entry_customer'] = $this->language->get('entry_customer');

        $data['entry_customer_group'] = $this->language->get('entry_customer_group');

        $data['entry_firstname'] = $this->language->get('entry_firstname');

        $data['entry_lastname'] = $this->language->get('entry_lastname');

        $data['entry_email'] = $this->language->get('entry_email');

        $data['entry_telephone'] = $this->language->get('entry_telephone');

        $data['entry_fax'] = $this->language->get('entry_fax');

        $data['entry_comment'] = $this->language->get('entry_comment');

        $data['entry_affiliate'] = $this->language->get('entry_affiliate');

        $data['entry_address'] = $this->language->get('entry_address');

        $data['entry_company'] = $this->language->get('entry_company');

        $data['entry_address_1'] = $this->language->get('entry_address_1');

        $data['entry_address_2'] = $this->language->get('entry_address_2');

        $data['entry_city'] = $this->language->get('entry_city');

        $data['entry_postcode'] = $this->language->get('entry_postcode');

        $data['entry_zone'] = $this->language->get('entry_zone');

        $data['entry_zone_code'] = $this->language->get('entry_zone_code');

        $data['entry_country'] = $this->language->get('entry_country');

        $data['entry_product'] = $this->language->get('entry_product');

        $data['entry_option'] = $this->language->get('entry_option');

        $data['entry_quantity'] = $this->language->get('entry_quantity');

        $data['entry_to_name'] = $this->language->get('entry_to_name');

        $data['entry_to_email'] = $this->language->get('entry_to_email');

        $data['entry_from_name'] = $this->language->get('entry_from_name');

        $data['entry_from_email'] = $this->language->get('entry_from_email');

        $data['entry_theme'] = $this->language->get('entry_theme');

        $data['entry_message'] = $this->language->get('entry_message');

        $data['entry_amount'] = $this->language->get('entry_amount');

        $data['entry_currency'] = $this->language->get('entry_currency');

        $data['entry_shipping_method'] = $this->language->get('entry_shipping_method');

        $data['entry_payment_method'] = $this->language->get('entry_payment_method');

        $data['entry_coupon'] = $this->language->get('entry_coupon');

        $data['entry_voucher'] = $this->language->get('entry_voucher');

        $data['entry_reward'] = $this->language->get('entry_reward');

        $data['entry_order_status'] = $this->language->get('entry_order_status');


        $data['column_product'] = $this->language->get('column_product');

        $data['column_model'] = $this->language->get('column_model');

        $data['column_quantity'] = $this->language->get('column_quantity');

        $data['column_price'] = $this->language->get('column_price');

        $data['column_total'] = $this->language->get('column_total');

        $data['column_action'] = $this->language->get('column_action');


        $data['button_save'] = $this->language->get('button_save');

        $data['button_cancel'] = $this->language->get('button_cancel');

        $data['button_continue'] = $this->language->get('button_continue');

        $data['button_back'] = $this->language->get('button_back');

        $data['button_refresh'] = $this->language->get('button_refresh');

        $data['button_product_add'] = $this->language->get('button_product_add');

        $data['button_voucher_add'] = $this->language->get('button_voucher_add');

        $data['button_apply'] = $this->language->get('button_apply');

        $data['button_upload'] = $this->language->get('button_upload');

        $data['button_remove'] = $this->language->get('button_remove');

        $data['button_ip_add'] = $this->language->get('button_ip_add');


        $data['tab_order'] = $this->language->get('tab_order');

        $data['tab_customer'] = $this->language->get('tab_customer');

        $data['tab_payment'] = $this->language->get('tab_payment');

        $data['tab_shipping'] = $this->language->get('tab_shipping');

        $data['tab_product'] = $this->language->get('tab_product');

        $data['tab_voucher'] = $this->language->get('tab_voucher');

        $data['tab_total'] = $this->language->get('tab_total');


        $url = '';


        if (isset($this->request->get['filter_order_id'])) {

            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];

        }


        if (isset($this->request->get['filter_customer'])) {

            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));

        }


        if (isset($this->request->get['filter_order_status'])) {

            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];

        }


        if (isset($this->request->get['filter_total'])) {

            $url .= '&filter_total=' . $this->request->get['filter_total'];

        }


        if (isset($this->request->get['filter_date_added'])) {

            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];

        }


        if (isset($this->request->get['filter_date_modified'])) {

            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];

        }


        if (isset($this->request->get['sort'])) {

            $url .= '&sort=' . $this->request->get['sort'];

        }


        if (isset($this->request->get['order'])) {

            $url .= '&order=' . $this->request->get['order'];

        }


        if (isset($this->request->get['page'])) {

            $url .= '&page=' . $this->request->get['page'];

        }


        $data['breadcrumbs'] = array();


        $data['breadcrumbs'][] = array(

            'text' => $this->language->get('text_home'),

            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)

        );


        $data['breadcrumbs'][] = array(

            'text' => $this->language->get('heading_title'),

            'href' => $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true)

        );


        $data['cancel'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true);


        $data['token'] = $this->session->data['token'];


        if (isset($this->request->get['order_id'])) {

            $order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);

        }


        if (!empty($order_info)) {

            $data['order_id'] = $this->request->get['order_id'];

            $data['store_id'] = $order_info['store_id'];

            $data['store_url'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


            $data['customer'] = $order_info['customer'];

            $data['customer_id'] = $order_info['customer_id'];

            $data['customer_group_id'] = $order_info['customer_group_id'];

            $data['firstname'] = $order_info['firstname'];

            $data['lastname'] = $order_info['lastname'];

            $data['email'] = $order_info['email'];

            $data['telephone'] = $order_info['telephone'];

            $data['fax'] = $order_info['fax'];

            $data['account_custom_field'] = $order_info['custom_field'];


            $this->load->model('customer/customer');


            $data['addresses'] = $this->model_customer_customer->getAddresses($order_info['customer_id']);


            $data['payment_firstname'] = $order_info['payment_firstname'];

            $data['payment_lastname'] = $order_info['payment_lastname'];

            $data['payment_company'] = $order_info['payment_company'];

            $data['payment_address_1'] = $order_info['payment_address_1'];

            $data['payment_address_2'] = $order_info['payment_address_2'];

            $data['payment_city'] = $order_info['payment_city'];

            $data['payment_postcode'] = $order_info['payment_postcode'];

            $data['payment_country_id'] = $order_info['payment_country_id'];

            $data['payment_zone_id'] = $order_info['payment_zone_id'];

            $data['payment_custom_field'] = $order_info['payment_custom_field'];

            $data['payment_method'] = $order_info['payment_method'];

            $data['payment_code'] = $order_info['payment_code'];


            $data['shipping_firstname'] = $order_info['shipping_firstname'];

            $data['shipping_lastname'] = $order_info['shipping_lastname'];

            $data['shipping_company'] = $order_info['shipping_company'];

            $data['shipping_address_1'] = $order_info['shipping_address_1'];

            $data['shipping_address_2'] = $order_info['shipping_address_2'];

            $data['shipping_city'] = $order_info['shipping_city'];

            $data['shipping_postcode'] = $order_info['shipping_postcode'];

            $data['shipping_country_id'] = $order_info['shipping_country_id'];

            $data['shipping_zone_id'] = $order_info['shipping_zone_id'];

            $data['shipping_custom_field'] = $order_info['shipping_custom_field'];

            $data['shipping_method'] = $order_info['shipping_method'];

            $data['shipping_code'] = $order_info['shipping_code'];


            // Products

            $data['order_products'] = array();


            $products = $this->model_sale_order->getOrderProducts($this->request->get['order_id']);


            foreach ($products as $product) {


                $data['order_products'][] = array(

                    'product_id' => $product['product_id'],

                    'name' => $product['name'],

                    //'image'      => $product['image'],

                    'model' => $product['model'],

                    'option' => $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']),

                    'quantity' => $product['quantity'],

                    'price' => $product['price'],

                    'total' => $product['total'],

                    'reward' => $product['reward'],

                    'p_11_pattern_img' => $product['p_11_pattern_img'],
                );

            }


            // Vouchers

            $data['order_vouchers'] = $this->model_sale_order->getOrderVouchers($this->request->get['order_id']);


            $data['coupon'] = '';

            $data['voucher'] = '';

            $data['reward'] = '';


            $data['order_totals'] = array();


            $order_totals = $this->model_sale_order->getOrderTotals($this->request->get['order_id']);


            foreach ($order_totals as $order_total) {

                // If coupon, voucher or reward points

                $start = strpos($order_total['title'], '(') + 1;

                $end = strrpos($order_total['title'], ')');


                if ($start && $end) {

                    $data[$order_total['code']] = substr($order_total['title'], $start, $end - $start);

                }

            }


            $data['order_status_id'] = $order_info['order_status_id'];

            $data['comment'] = $order_info['comment'];

            $data['affiliate_id'] = $order_info['affiliate_id'];

            $data['affiliate'] = $order_info['affiliate_firstname'] . ' ' . $order_info['affiliate_lastname'];

            $data['currency_code'] = $order_info['currency_code'];

        } else {

            $data['order_id'] = 0;

            $data['store_id'] = 0;

            $data['store_url'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


            $data['customer'] = '';

            $data['customer_id'] = '';

            $data['customer_group_id'] = $this->config->get('config_customer_group_id');

            $data['firstname'] = '';

            $data['lastname'] = '';

            $data['email'] = '';

            $data['telephone'] = '';

            $data['fax'] = '';

            $data['customer_custom_field'] = array();


            $data['addresses'] = array();


            $data['payment_firstname'] = '';

            $data['payment_lastname'] = '';

            $data['payment_company'] = '';

            $data['payment_address_1'] = '';

            $data['payment_address_2'] = '';

            $data['payment_city'] = '';

            $data['payment_postcode'] = '';

            $data['payment_country_id'] = '';

            $data['payment_zone_id'] = '';

            $data['payment_custom_field'] = array();

            $data['payment_method'] = '';

            $data['payment_code'] = '';


            $data['shipping_firstname'] = '';

            $data['shipping_lastname'] = '';

            $data['shipping_company'] = '';

            $data['shipping_address_1'] = '';

            $data['shipping_address_2'] = '';

            $data['shipping_city'] = '';

            $data['shipping_postcode'] = '';

            $data['shipping_country_id'] = '';

            $data['shipping_zone_id'] = '';

            $data['shipping_custom_field'] = array();

            $data['shipping_method'] = '';

            $data['shipping_code'] = '';


            $data['order_products'] = array();

            $data['order_vouchers'] = array();

            $data['order_totals'] = array();


            $data['order_status_id'] = $this->config->get('config_order_status_id');

            $data['comment'] = '';

            $data['affiliate_id'] = '';

            $data['affiliate'] = '';

            $data['currency_code'] = $this->config->get('config_currency');


            $data['coupon'] = '';

            $data['voucher'] = '';

            $data['reward'] = '';

        }


        // Stores

        $this->load->model('setting/store');


        $data['stores'] = array();


        $data['stores'][] = array(

            'store_id' => 0,

            'name' => $this->language->get('text_default')

        );


        $results = $this->model_setting_store->getStores();


        foreach ($results as $result) {

            $data['stores'][] = array(

                'store_id' => $result['store_id'],

                'name' => $result['name']

            );

        }


        // Customer Groups

        $this->load->model('customer/customer_group');


        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();


        // Custom Fields

        $this->load->model('customer/custom_field');


        $data['custom_fields'] = array();


        $filter_data = array(

            'sort' => 'cf.sort_order',

            'order' => 'ASC'

        );


        $custom_fields = $this->model_customer_custom_field->getCustomFields($filter_data);


        foreach ($custom_fields as $custom_field) {

            $data['custom_fields'][] = array(

                'custom_field_id' => $custom_field['custom_field_id'],

                'custom_field_value' => $this->model_customer_custom_field->getCustomFieldValues($custom_field['custom_field_id']),

                'name' => $custom_field['name'],

                'value' => $custom_field['value'],

                'type' => $custom_field['type'],

                'location' => $custom_field['location'],

                'sort_order' => $custom_field['sort_order']

            );

        }


        $this->load->model('localisation/order_status');


        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


        $this->load->model('localisation/country');


        $data['countries'] = $this->model_localisation_country->getCountries();


        $this->load->model('localisation/currency');


        $data['currencies'] = $this->model_localisation_currency->getCurrencies();


        $data['voucher_min'] = $this->config->get('config_voucher_min');


        $this->load->model('sale/voucher_theme');


        $data['voucher_themes'] = $this->model_sale_voucher_theme->getVoucherThemes();


        // API login

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


        $this->load->model('user/api');


        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));


        if ($api_info) {

            $data['api_id'] = $api_info['api_id'];

            $data['api_key'] = $api_info['key'];

            $data['api_ip'] = $this->request->server['REMOTE_ADDR'];

        } else {

            $data['api_id'] = '';

            $data['api_key'] = '';

            $data['api_ip'] = '';

        }


        $data['header'] = $this->load->controller('common/header');

        $data['column_left'] = $this->load->controller('common/column_left');

        $data['footer'] = $this->load->controller('common/footer');


        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_form.tpl')) {

            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_form', $data));

        } else {

            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_form', $data));

        }

    }

    public function edit()
    {

        $this->load->language('sale/order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/order');

        $this->getForm();

    }

    public function delete()
    {

        $this->load->language('sale/order');


        $this->document->setTitle($this->language->get('heading_title'));


        $this->load->model('sale/order');


        if (isset($this->request->post['selected']) && $this->validate()) {

            foreach ($this->request->post['selected'] as $order_id) {

                $this->model_sale_order->deleteOrder($order_id);

            }


            $this->session->data['success'] = $this->language->get('text_success');


            $url = '';


            if (isset($this->request->get['filter_order_id'])) {

                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];

            }


            if (isset($this->request->get['filter_customer'])) {

                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));

            }


            if (isset($this->request->get['filter_order_status'])) {

                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];

            }


            if (isset($this->request->get['filter_total'])) {

                $url .= '&filter_total=' . $this->request->get['filter_total'];

            }


            if (isset($this->request->get['filter_date_added'])) {

                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];

            }


            if (isset($this->request->get['filter_date_modified'])) {

                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];

            }


            if (isset($this->request->get['filter_tranfer_order_status'])) {

                $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];

            }


            $this->response->redirect($this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true));

        }


        $this->getList();

    }

    public function deleteItem()
    {

        $this->load->language('sale/order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');

        if(isset($this->request->get['order_id']) && $this->validate()){
            $this->model_sale_order->deleteOrder($this->request->get['order_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';


            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_customer'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            if (isset($this->request->get['filter_tranfer_order_status'])) {
                $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
            }

            $this->response->redirect($this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true));

        }

        $this->getList();

    }

    public function move_prepared_orders()
    {

        $this->load->language('sale/order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');

        if (isset($this->request->post['selected']) && $this->validate()) {//var_dump($this->request->post['selected']); die();
            foreach ($this->request->post['selected'] as $order_id) {
                $this->model_sale_order->movePreparedOrders($order_id, $this->request->get['color']);
            }


            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';


            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_customer'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            if (isset($this->request->get['filter_tranfer_order_status'])) {
                $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
            }

            $this->response->redirect($this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true));

        }

        $this->getList();

    }

    public function remove_prepared_orders()
    {

        $this->load->language('sale/order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');

        if (isset($this->request->post['selected']) && $this->validate()) {//var_dump($this->request->post['selected']); die();
            foreach ($this->request->post['selected'] as $order_id) {
                $this->model_sale_order->removePreparedOrders($order_id);
            }


            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';


            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_customer'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            if (isset($this->request->get['filter_tranfer_order_status'])) {
                $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
            }

            $this->response->redirect($this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true));

        }

        $this->getList();

    }

    protected function validate()
    {

        if (!$this->user->hasPermission('modify', 'sale/order')) {

            $this->error['warning'] = $this->language->get('error_permission');

        }


        return !$this->error;

    }
    
    
    public function info_detail()
    {

error_reporting(0);
        $this->load->model('sale/order');

        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];
        } else {
            $order_id = 0;
        }


        $order_info = $this->model_sale_order->getOrder($order_id);

   

            $this->load->language('sale/order');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');
            $data['text_ip_add'] = sprintf($this->language->get('text_ip_add'), $this->request->server['REMOTE_ADDR']);
            $data['text_order_detail'] = $this->language->get('text_order_detail');
            $data['text_customer_detail'] = $this->language->get('text_customer_detail');

            $data['text_option'] = $this->language->get('text_option');

            $data['text_store'] = $this->language->get('text_store');

            $data['text_date_added'] = $this->language->get('text_date_added');

            $data['text_payment_method'] = $this->language->get('text_payment_method');

            $data['text_shipping_method'] = $this->language->get('text_shipping_method');

            $data['text_customer'] = $this->language->get('text_customer');

            $data['text_customer_group'] = $this->language->get('text_customer_group');

            $data['text_email'] = $this->language->get('text_email');

            $data['text_telephone'] = $this->language->get('text_telephone');

            $data['text_invoice'] = $this->language->get('text_invoice');

            $data['text_reward'] = $this->language->get('text_reward');

            $data['text_affiliate'] = $this->language->get('text_affiliate');

            $data['text_order'] = sprintf($this->language->get('text_order'), $this->request->get['order_id']);

            $data['text_payment_address'] = $this->language->get('text_payment_address');

            $data['text_shipping_address'] = $this->language->get('text_shipping_address');

            $data['text_comment'] = $this->language->get('text_comment');

            $data['text_account_custom_field'] = $this->language->get('text_account_custom_field');

            $data['text_payment_custom_field'] = $this->language->get('text_payment_custom_field');

            $data['text_shipping_custom_field'] = $this->language->get('text_shipping_custom_field');

            $data['text_browser'] = $this->language->get('text_browser');

            $data['text_ip'] = $this->language->get('text_ip');

            $data['text_forwarded_ip'] = $this->language->get('text_forwarded_ip');

            $data['text_user_agent'] = $this->language->get('text_user_agent');

            $data['text_accept_language'] = $this->language->get('text_accept_language');

            $data['text_history'] = $this->language->get('text_history');

            $data['text_history_add'] = $this->language->get('text_history_add');

            $data['text_loading'] = $this->language->get('text_loading');


            $data['column_product'] = $this->language->get('column_product');

            $data['column_pattern_image'] = $this->language->get('column_pattern_image');

            $data['column_download_image'] = $this->language->get('column_download_image');

            $data['column_model'] = $this->language->get('column_model');

            $data['column_quantity'] = $this->language->get('column_quantity');

            $data['column_price'] = $this->language->get('column_price');

            $data['column_total'] = $this->language->get('column_total');


            $data['entry_order_status'] = $this->language->get('entry_order_status');

            $data['entry_notify'] = $this->language->get('entry_notify');

            $data['entry_override'] = $this->language->get('entry_override');

            $data['entry_comment'] = $this->language->get('entry_comment');


            $data['help_override'] = $this->language->get('help_override');


            $data['button_invoice_print'] = $this->language->get('button_invoice_print');

            $data['button_shipping_print'] = $this->language->get('button_shipping_print');

            $data['button_edit'] = $this->language->get('button_edit');

            $data['button_cancel'] = $this->language->get('button_cancel');

            $data['button_generate'] = $this->language->get('button_generate');

            $data['button_reward_add'] = $this->language->get('button_reward_add');

            $data['button_reward_remove'] = $this->language->get('button_reward_remove');

            $data['button_commission_add'] = $this->language->get('button_commission_add');

            $data['button_commission_remove'] = $this->language->get('button_commission_remove');

            $data['button_history_add'] = $this->language->get('button_history_add');

            $data['button_ip_add'] = $this->language->get('button_ip_add');


            $data['tab_history'] = $this->language->get('tab_history');

            $data['tab_additional'] = $this->language->get('tab_additional');


            $url = '';


            if (isset($this->request->get['filter_order_id'])) {

                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];

            }


            if (isset($this->request->get['filter_customer'])) {

                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));

            }


            if (isset($this->request->get['filter_order_status'])) {

                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];

            }


            if (isset($this->request->get['filter_total'])) {

                $url .= '&filter_total=' . $this->request->get['filter_total'];

            }


            if (isset($this->request->get['filter_date_added'])) {

                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];

            }


            if (isset($this->request->get['filter_date_modified'])) {

                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];

            }


            if (isset($this->request->get['sort'])) {

                $url .= '&sort=' . $this->request->get['sort'];

            }


            if (isset($this->request->get['order'])) {

                $url .= '&order=' . $this->request->get['order'];

            }


            if (isset($this->request->get['page'])) {

                $url .= '&page=' . $this->request->get['page'];

            }


            $data['breadcrumbs'] = array();


            $data['breadcrumbs'][] = array(

                'text' => $this->language->get('text_home'),

                'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)

            );


            $data['breadcrumbs'][] = array(

                'text' => $this->language->get('heading_title'),

                'href' => $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true)

            );


            $data['shipping'] = $this->url->link('sale/order/shipping', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['invoice'] = $this->url->link('sale/order/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['edit'] = $this->url->link('sale/order/edit', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['delete'] = $this->url->link('sale/order/deleteItem', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['cancel'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true);

            $data['token'] = $this->session->data['token'];

            $data['order_id'] = $this->request->get['order_id'];
            $data['store_id'] = $order_info['store_id'];
            $data['store_name'] = $order_info['store_name'];

            $data['shipping_info'] = '';

            $shipping_info = $this->db->query("SELECT * FROM ps_order_yurticikargo WHERE order_id = '" . $order_id . "' ")->row;

            if ($shipping_info) {
                $data['shipping_info'] = $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            $data['shipping_info_second'] = '';
            $shipping_info_second = $this->db->query("SELECT * FROM ps_order_yurticikargo_second WHERE order_id = '" . (int)$order_id . "' ")->row;
            if ($shipping_info_second) {
                $data['shipping_info_second'] = $this->url->link('sale/prepared_orders/invoice_second', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            $data['byexpress_shipping_info'] = '';
            $byexpress_shipping_info = $this->db->query("SELECT * FROM ps_order_byexpresskargo WHERE order_id = '" . (int)$order_id . "' ")->row;
            if($byexpress_shipping_info){
                $data['byexpress_shipping_info'] = $this->url->link('sale/prepared_orders/byexpress_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            $data['scottycargo_shipping_info'] = '';
            $scottycargo_shipping_info = $this->db->query("SELECT * FROM ps_order_scottycargo WHERE order_id = '" . (int)$order_id . "' ")->row;
            if($scottycargo_shipping_info){
                $data['scottycargo_shipping_info'] = $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            if ($order_info['store_id'] == 0) {
                $data['store_url'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;
            } else {
                $data['store_url'] = $order_info['store_url'];
            }


            if ($order_info['invoice_no']) {
                $data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
            } else {
                $data['invoice_no'] = '';
            }


            $data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
            $data['firstname'] = $order_info['firstname'];
            $data['lastname'] = $order_info['lastname'];


            $data['customer_id'] = 0;

            if ($order_info['customer_id']) {
                $data['customer'] = $this->url->link('customer/customer/edit', 'token=' . $this->session->data['token'] . '&customer_id=' . $order_info['customer_id'], true);
                $data['customer_id'] = $order_info['customer_id'];
            } else {
                $data['customer'] = '';
            }


            $this->load->model('customer/customer_group');

            $customer_group_info = $this->model_customer_customer_group->getCustomerGroup($order_info['customer_group_id']);

            if ($customer_group_info) {
                $data['customer_group'] = $customer_group_info['name'];
            } else {
                $data['customer_group'] = '';
            }


            $data['email'] = $order_info['email'];
            $data['telephone'] = $order_info['telephone'];
            $data['shipping_method'] = $order_info['shipping_method'];
            $data['payment_method'] = $order_info['payment_method'];

            // Payment Address

            if ($order_info['payment_address_format']) {
                $format = $order_info['payment_address_format'];
            } else {
                $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country} ' . "\n" . '{payment_company}' . "\n" .'{payment_company_taxno}' . "\n". '{payment_company_taxadmin}';
            }


            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}',
                '{payment_company}',
                '{payment_company_taxno}',
                '{payment_company_taxadmin}'

            );


            $replace = array(
                'firstname' => $order_info['payment_firstname'],
                'lastname' => $order_info['payment_lastname'],
                'company' => $order_info['payment_company'],
                'address_1' => $order_info['payment_address_1'],
                'address_2' => $order_info['payment_address_2'],
                'city' => $order_info['payment_city'],
                'postcode' => $order_info['payment_postcode'],
                'zone' => $order_info['payment_zone'],
                'zone_code' => $order_info['payment_zone_code'],
                'country' => $order_info['payment_country'],
                'payment_company' => $order_info['payment_company'],
                'payment_company_taxno' => $order_info['payment_company_taxno'],
                'payment_company_taxadmin' => $order_info['payment_company_taxadmin'],
            );


            $data['payment_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            // Shipping Address
            if ($order_info['shipping_address_format']) {
                $format = $order_info['shipping_address_format'];
            } else {
                $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
            }


            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}',
                '{payment_company}',
                '{payment_company_taxno}',
                '{payment_company_taxadmin}'
            );


            $replace = array(
                'firstname' => $order_info['shipping_firstname'],
                'lastname' => $order_info['shipping_lastname'],
                'company' => $order_info['shipping_company'],
                'address_1' => $order_info['shipping_address_1'],
                'address_2' => $order_info['shipping_address_2'],
                'city' => $order_info['shipping_city'],
                'postcode' => $order_info['shipping_postcode'],
                'zone' => $order_info['shipping_zone'],
                'zone_code' => $order_info['shipping_zone_code'],
                'country' => $order_info['shipping_country']
            );

            $data['shipping_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            // Uploaded files

            $this->load->model('tool/upload');

            $data['products'] = array();

            $products = $this->model_sale_order->getOrderProducts($this->request->get['order_id']);

            $data['column_image'] = $this->language->get('column_image');

            $this->load->model('tool/image');

            $this->load->model('tool/image');


            foreach ($products as $product) {


                $image = $this->db->query("SELECT * FROM ps_product WHERE product_id='" . $product['product_id'] . "' ")->row;
                $p_model2=$image['model2'];
                
               if($image['model2']!='' && $image['product_type']==7)
                    $p_model2=str_replace('cst001-','',str_replace('_','-',str_replace('kişiye_özel_telefon_kılıfları-','',$p_model2)));
                   
               
                $case_image=$image['image'];
                $product_type = isset($image['product_type']) ? $image['product_type'] : '';

                $image = isset($image['image']) ? $this->model_tool_image->resize($image['image'], 100, 100) : '';


                $option_data = array();

                $options = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);


                foreach ($options as $option) {

                    if ($option['type'] != 'file') {

                        $option_data[] = array(

                            'name' => $option['name'],

                            'value' => $option['value'],

                            'type' => $option['type']

                        );

                    } else {

                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);


                        if ($upload_info) {

                            $option_data[] = array(

                                'name' => $option['name'],

                                'value' => $upload_info['name'],

                                'type' => $option['type'],

                                'href' => $this->url->link('tool/upload/download', 'token=' . $this->session->data['token'] . '&code=' . $upload_info['code'], true)

                            );

                        }

                    }


                    $option_thumb_image = $this->model_sale_order->getOrderOptionValueThumb($option['product_option_value_id'], $product['product_id']);

                    $option_thumb_image = $option_thumb_image['option_thumb_image'] ? json_decode($option_thumb_image['option_thumb_image'], true) : false;

                    if ($option_thumb_image[0]) {

                        $image = $this->model_tool_image->resize($option_thumb_image[0], $this->config->get($this->config->get('config_theme') . '_image_cart_width'), $this->config->get($this->config->get('config_theme') . '_image_cart_height'));

                    }

                }


                // $case_pattern_image = $this->model_tool_image->resize($product['case_order_image'], 100, 100);

                     $customcase_image =  '';
                if ($product['customcase_image'] != '') {

                    $str = explode('***', $product['customcase_image']);
                   

                    $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];

                    if($case_image!='' &&  file_exists(DIR_IMAGE.$case_image))
                    $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/'.$case_image;
                  
                    else
                     $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/personal/' . $str[0] . '.png';
                }

                $this->load->model('catalog/product');
                if ($product_type == 11) {
                    $p_11_pattern_img = explode('***', $product['customcase_image']);
                    $customcase_image = $this->model_catalog_product->get_a_blob($p_11_pattern_img[1]);

                    $output_file = 'p_11/' . $p_11_pattern_img[0] . '_' . $product['order_product_id'] . '.png';

                    // open the output file for writing
                    $ifp = fopen( DIR_IMAGE . $output_file, 'wb' );

                    // we could add validation here with ensuring count( $data ) > 1
                    fwrite( $ifp, base64_decode( $customcase_image ) );

                    // clean up the file resource
                    fclose( $ifp );

                    $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $output_file;


                    /*
                    $p_11 = $this->model_catalog_product->get_c_blob($p_11_pattern_img[1]);
                    $file_name = token(32).'.png';
                    file_put_contents(DIR_IMAGE.$file_name, base64_decode($p_11));
                    $p_11 = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/'.$file_name; */
                }
                $data['products'][] = array(

                    'order_product_id' => $product['order_product_id'],

                    'product_id' => $product['product_id'],

                    'name' => $product['name'],

                    'image' => $image,

                    'p_11_pattern_img'=>$product['p_11_pattern_img'],

                    'product_type' => $product_type,

                    'case_order_image' => ($product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['case_order_image'] : ''),

                    'customer_pattern_data' => $product['customer_pattern_data'],

                    'admin_pattern_image' => ($product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['admin_pattern_image'] : ''),

                    'admin_gradient_pattern_image' => ($product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['admin_gradient_pattern_image'] : ''),

                    'customcase_image' => $customcase_image,

                    'case_image' => $case_image,

                    'model' => $product['model'],
                    
                    'model2' => $p_model2,

                    'option' => $option_data,

                    'quantity' => $product['quantity'],

                    'return_status' => $product['return_status'],

                    'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                    
                    'KDV'=>   $this->currency->format($product['total']+$product['tax'], $order_info['currency_code'], $order_info['currency_value']),

                    'total' => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),

                    'href' => "/product/product&product_id=" . $product['product_id'],

                    'idle_stock' => isset($product['idle_stock']) ? $product['idle_stock']:0, //20.09.20 idle stock (ali.a)
                );

            }


            $data['payment_code'] = $order_info['payment_code'];

            $data['payment_refund_status'] = false;


            $this->load->model('extension/payment/iyzico_checkout_form');

            $payment_refund_status = $this->model_extension_payment_iyzico_checkout_form->getOrderEntry($order_id);


            if ($payment_refund_status) {

                if ($payment_refund_status['total_refunded'] == 0) {

                    $data['payment_refund_status'] = false;

                } else {

                    $data['payment_refund_status'] = true;

                }

            }


            $data['vouchers'] = array();


            $vouchers = $this->model_sale_order->getOrderVouchers($this->request->get['order_id']);


            foreach ($vouchers as $voucher) {

                $data['vouchers'][] = array(

                    'description' => $voucher['description'],

                    'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value']),

                    'href' => $this->url->link('sale/voucher/edit', 'token=' . $this->session->data['token'] . '&voucher_id=' . $voucher['voucher_id'], true)

                );

            }


            $data['totals'] = array();


            $totals = $this->model_sale_order->getOrderTotals($this->request->get['order_id']);


            foreach ($totals as $total) {

                $data['totals'][] = array(

                    'title' => $total['title'],

                    'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'])

                );

            }


            $data['comment'] = nl2br($order_info['comment']);


            $this->load->model('customer/customer');


            $data['reward'] = $order_info['reward'];


            $data['reward_total'] = $this->model_customer_customer->getTotalCustomerRewardsByOrderId($this->request->get['order_id']);


            $data['affiliate_firstname'] = $order_info['affiliate_firstname'];

            $data['affiliate_lastname'] = $order_info['affiliate_lastname'];


            if ($order_info['affiliate_id']) {

                $data['affiliate'] = $this->url->link('marketing/affiliate/edit', 'token=' . $this->session->data['token'] . '&affiliate_id=' . $order_info['affiliate_id'], true);

            } else {

                $data['affiliate'] = '';

            }


            $data['commission'] = $this->currency->format($order_info['commission'], $order_info['currency_code'], $order_info['currency_value']);


            $this->load->model('marketing/affiliate');


            $data['commission_total'] = $this->model_marketing_affiliate->getTotalTransactionsByOrderId($this->request->get['order_id']);


            $this->load->model('localisation/order_status');


            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_info['order_status_id']);


            if ($order_status_info) {

                $data['order_status'] = $order_status_info['name'];

            } else {

                $data['order_status'] = '';

            }


            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


            $data['order_status_id'] = $order_info['order_status_id'];


            $data['account_custom_field'] = $order_info['custom_field'];


            // Custom Fields

            $this->load->model('customer/custom_field');


            $data['account_custom_fields'] = array();


            $filter_data = array(

                'sort' => 'cf.sort_order',

                'order' => 'ASC'

            );


            $custom_fields = $this->model_customer_custom_field->getCustomFields($filter_data);


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'account' && isset($order_info['custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['account_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['account_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['account_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['custom_field'][$custom_field['custom_field_id']]

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['account_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name']

                            );

                        }

                    }

                }

            }


            // Custom fields

            $data['payment_custom_fields'] = array();


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'address' && isset($order_info['payment_custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['payment_custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['payment_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['payment_custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['payment_custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['payment_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name'],

                                    'sort_order' => $custom_field['sort_order']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['payment_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['payment_custom_field'][$custom_field['custom_field_id']],

                            'sort_order' => $custom_field['sort_order']

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['payment_custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['payment_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }

                }

            }


            // Shipping

            $data['shipping_custom_fields'] = array();


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'address' && isset($order_info['shipping_custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['shipping_custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['shipping_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['shipping_custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['shipping_custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['shipping_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name'],

                                    'sort_order' => $custom_field['sort_order']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['shipping_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['shipping_custom_field'][$custom_field['custom_field_id']],

                            'sort_order' => $custom_field['sort_order']

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['shipping_custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['shipping_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }

                }

            }


            $data['ip'] = $order_info['ip'];

            $data['forwarded_ip'] = $order_info['forwarded_ip'];

            $data['user_agent'] = $order_info['user_agent'];

            $data['accept_language'] = $order_info['accept_language'];


            // Additional Tabs

            $data['tabs'] = array();


            $this->load->model('extension/extension');


            $extensions = $this->model_extension_extension->getInstalled('fraud');


            foreach ($extensions as $extension) {

                if ($this->config->get($extension . '_status')) {

                    $this->load->language('extension/fraud/' . $extension);


                    $content = $this->load->controller('extension/fraud/' . $extension . '/order');


                    if ($content) {

                        $data['tabs'][] = array(

                            'code' => $extension,

                            'title' => $this->language->get('heading_title'),

                            'content' => $content

                        );

                    }

                }

            }


            // The URL we send API requests to

            $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


            // API login

            $this->load->model('user/api');


            $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));


            if ($api_info) {

                $data['api_id'] = $api_info['api_id'];

                $data['api_key'] = $api_info['key'];

                $data['api_ip'] = $this->request->server['REMOTE_ADDR'];

            } else {

                $data['api_id'] = '';

                $data['api_key'] = '';

                $data['api_ip'] = '';

            }




            $data['header'] = $this->load->controller('common/header');

            $data['column_left'] = $this->load->controller('common/column_left');

            $data['footer'] = $this->load->controller('common/footer');

            //20.09.20 idle stock (ali.a)
            $data['editUrl'] = $this->url->link('catalog/product/edit', 'token=' . $this->session->data['token'] . '&product_id=' , true);


            if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_info_detail.tpl')) {

                $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_info_detail', $data));

            } else {

                $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_info_detail', $data));

            }

     

    }


    public function info()
    {


        $this->load->model('sale/order');

        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];
        } else {
            $order_id = 0;
        }


        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info) {

            $this->load->language('sale/order');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');
            $data['text_ip_add'] = sprintf($this->language->get('text_ip_add'), $this->request->server['REMOTE_ADDR']);
            $data['text_order_detail'] = $this->language->get('text_order_detail');
            $data['text_customer_detail'] = $this->language->get('text_customer_detail');

            $data['text_option'] = $this->language->get('text_option');

            $data['text_store'] = $this->language->get('text_store');

            $data['text_date_added'] = $this->language->get('text_date_added');

            $data['text_payment_method'] = $this->language->get('text_payment_method');

            $data['text_shipping_method'] = $this->language->get('text_shipping_method');

            $data['text_customer'] = $this->language->get('text_customer');

            $data['text_customer_group'] = $this->language->get('text_customer_group');

            $data['text_email'] = $this->language->get('text_email');

            $data['text_telephone'] = $this->language->get('text_telephone');

            $data['text_invoice'] = $this->language->get('text_invoice');

            $data['text_reward'] = $this->language->get('text_reward');

            $data['text_affiliate'] = $this->language->get('text_affiliate');

            $data['text_order'] = sprintf($this->language->get('text_order'), $this->request->get['order_id']);

            $data['text_payment_address'] = $this->language->get('text_payment_address');

            $data['text_shipping_address'] = $this->language->get('text_shipping_address');

            $data['text_comment'] = $this->language->get('text_comment');

            $data['text_account_custom_field'] = $this->language->get('text_account_custom_field');

            $data['text_payment_custom_field'] = $this->language->get('text_payment_custom_field');

            $data['text_shipping_custom_field'] = $this->language->get('text_shipping_custom_field');

            $data['text_browser'] = $this->language->get('text_browser');

            $data['text_ip'] = $this->language->get('text_ip');

            $data['text_forwarded_ip'] = $this->language->get('text_forwarded_ip');

            $data['text_user_agent'] = $this->language->get('text_user_agent');

            $data['text_accept_language'] = $this->language->get('text_accept_language');

            $data['text_history'] = $this->language->get('text_history');

            $data['text_history_add'] = $this->language->get('text_history_add');

            $data['text_loading'] = $this->language->get('text_loading');


            $data['column_product'] = $this->language->get('column_product');

            $data['column_pattern_image'] = $this->language->get('column_pattern_image');

            $data['column_download_image'] = $this->language->get('column_download_image');

            $data['column_model'] = $this->language->get('column_model');

            $data['column_quantity'] = $this->language->get('column_quantity');

            $data['column_price'] = $this->language->get('column_price');

            $data['column_total'] = $this->language->get('column_total');


            $data['entry_order_status'] = $this->language->get('entry_order_status');

            $data['entry_notify'] = $this->language->get('entry_notify');

            $data['entry_override'] = $this->language->get('entry_override');

            $data['entry_comment'] = $this->language->get('entry_comment');


            $data['help_override'] = $this->language->get('help_override');


            $data['button_invoice_print'] = $this->language->get('button_invoice_print');

            $data['button_shipping_print'] = $this->language->get('button_shipping_print');

            $data['button_edit'] = $this->language->get('button_edit');

            $data['button_cancel'] = $this->language->get('button_cancel');

            $data['button_generate'] = $this->language->get('button_generate');

            $data['button_reward_add'] = $this->language->get('button_reward_add');

            $data['button_reward_remove'] = $this->language->get('button_reward_remove');

            $data['button_commission_add'] = $this->language->get('button_commission_add');

            $data['button_commission_remove'] = $this->language->get('button_commission_remove');

            $data['button_history_add'] = $this->language->get('button_history_add');

            $data['button_ip_add'] = $this->language->get('button_ip_add');


            $data['tab_history'] = $this->language->get('tab_history');

            $data['tab_additional'] = $this->language->get('tab_additional');


            $url = '';


            if (isset($this->request->get['filter_order_id'])) {

                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];

            }


            if (isset($this->request->get['filter_customer'])) {

                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));

            }


            if (isset($this->request->get['filter_order_status'])) {

                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];

            }


            if (isset($this->request->get['filter_total'])) {

                $url .= '&filter_total=' . $this->request->get['filter_total'];

            }


            if (isset($this->request->get['filter_date_added'])) {

                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];

            }


            if (isset($this->request->get['filter_date_modified'])) {

                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];

            }


            if (isset($this->request->get['sort'])) {

                $url .= '&sort=' . $this->request->get['sort'];

            }


            if (isset($this->request->get['order'])) {

                $url .= '&order=' . $this->request->get['order'];

            }


            if (isset($this->request->get['page'])) {

                $url .= '&page=' . $this->request->get['page'];

            }


            $data['breadcrumbs'] = array();


            $data['breadcrumbs'][] = array(

                'text' => $this->language->get('text_home'),

                'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)

            );


            $data['breadcrumbs'][] = array(

                'text' => $this->language->get('heading_title'),

                'href' => $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true)

            );


            $data['shipping'] = $this->url->link('sale/order/shipping', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['invoice'] = $this->url->link('sale/order/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['edit'] = $this->url->link('sale/order/edit', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['delete'] = $this->url->link('sale/order/deleteItem', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['cancel'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true);

            $data['token'] = $this->session->data['token'];

            $data['order_id'] = $this->request->get['order_id'];
            $data['store_id'] = $order_info['store_id'];
            $data['store_name'] = $order_info['store_name'];

            $data['shipping_info'] = '';

            $shipping_info = $this->db->query("SELECT * FROM ps_order_yurticikargo WHERE order_id = '" . $order_id . "' ")->row;

            if ($shipping_info) {
                $data['shipping_info'] = $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            $data['shipping_info_second'] = '';
            $shipping_info_second = $this->db->query("SELECT * FROM ps_order_yurticikargo_second WHERE order_id = '" . (int)$order_id . "' ")->row;
            if ($shipping_info_second) {
                $data['shipping_info_second'] = $this->url->link('sale/prepared_orders/invoice_second', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            $data['scottycargo_shipping_info'] = '';
            $scottycargo_shipping_info = $this->db->query("SELECT * FROM ps_order_scottycargo WHERE order_id = '" . (int)$order_id . "' ")->row;
            if($scottycargo_shipping_info){
                $data['scottycargo_shipping_info'] = $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            $data['byexpress_shipping_info'] = '';
            $byexpress_shipping_info = $this->db->query("SELECT * FROM ps_order_byexpresskargo WHERE order_id = '" . (int)$order_id . "' ")->row;
            if($byexpress_shipping_info){
                $data['byexpress_shipping_info'] = $this->url->link('sale/prepared_orders/byexpress_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }


            if ($order_info['store_id'] == 0) {
                $data['store_url'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;
            } else {
                $data['store_url'] = $order_info['store_url'];
            }


            if ($order_info['invoice_no']) {
                $data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
            } else {
                $data['invoice_no'] = '';
            }


            $data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
            $data['firstname'] = $order_info['firstname'];
            $data['lastname'] = $order_info['lastname'];


            $data['customer_id'] = 0;

            if ($order_info['customer_id']) {
                $data['customer'] = $this->url->link('customer/customer/edit', 'token=' . $this->session->data['token'] . '&customer_id=' . $order_info['customer_id'], true);
                $data['customer_id'] = $order_info['customer_id'];
            } else {
                $data['customer'] = '';
            }


            $this->load->model('customer/customer_group');

            $customer_group_info = $this->model_customer_customer_group->getCustomerGroup($order_info['customer_group_id']);

            if ($customer_group_info) {
                $data['customer_group'] = $customer_group_info['name'];
            } else {
                $data['customer_group'] = '';
            }


            $data['email'] = $order_info['email'];
            $data['telephone'] = $order_info['telephone'];
            $data['shipping_method'] = $order_info['shipping_method'];
            $data['payment_method'] = $order_info['payment_method'];

            // Payment Address

            if ($order_info['payment_address_format']) {
                $format = $order_info['payment_address_format'];
            } else {
                $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country} ' . "\n" . '{payment_company}' . "\n" .'{payment_company_taxno}' . "\n". '{payment_company_taxadmin}';
            }


            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}',
                '{payment_company}',
                '{payment_company_taxno}',
                '{payment_company_taxadmin}'

            );


            $replace = array(
                'firstname' => $order_info['payment_firstname'],
                'lastname' => $order_info['payment_lastname'],
                'company' => $order_info['payment_company'],
                'address_1' => $order_info['payment_address_1'],
                'address_2' => $order_info['payment_address_2'],
                'city' => $order_info['payment_city'],
                'postcode' => $order_info['payment_postcode'],
                'zone' => $order_info['payment_zone'],
                'zone_code' => $order_info['payment_zone_code'],
                'country' => $order_info['payment_country'],
                'payment_company' => $order_info['payment_company'],
                'payment_company_taxno' => $order_info['payment_company_taxno'],
                'payment_company_taxadmin' => $order_info['payment_company_taxadmin'],
            );


            $data['payment_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            // Shipping Address
            if ($order_info['shipping_address_format']) {
                $format = $order_info['shipping_address_format'];
            } else {
                $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
            }


            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}',
                '{payment_company}',
                '{payment_company_taxno}',
                '{payment_company_taxadmin}'
            );


            $replace = array(
                'firstname' => $order_info['shipping_firstname'],
                'lastname' => $order_info['shipping_lastname'],
                'company' => $order_info['shipping_company'],
                'address_1' => $order_info['shipping_address_1'],
                'address_2' => $order_info['shipping_address_2'],
                'city' => $order_info['shipping_city'],
                'postcode' => $order_info['shipping_postcode'],
                'zone' => $order_info['shipping_zone'],
                'zone_code' => $order_info['shipping_zone_code'],
                'country' => $order_info['shipping_country']
            );

            $data['shipping_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            // Uploaded files

            $this->load->model('tool/upload');

            $data['products'] = array();

            $products = $this->model_sale_order->getOrderProducts($this->request->get['order_id']);

            $data['column_image'] = $this->language->get('column_image');

            $this->load->model('tool/image');

            $this->load->model('tool/image');

            $data['are_all_products_prepared'] = 1; // tüm ürünlerin hazırlanmış durumda olup olmadığını görmek için değişken. -Can 3.12.2021
            foreach ($products as $product) {
                if($product['status']==0) { // tüm ürünlerin hazırlanmış durumda olup olmadığını görmek için koşul. -Can 3.12.2021
                    $data['are_all_products_prepared'] = 0;
                }

                $image = $this->db->query("SELECT * FROM ps_product WHERE product_id='" . $product['product_id'] . "' ")->row;
                $p_model2=$image['model2'];
                
               if($image['model2']!='' && $image['product_type']==7)
                    $p_model2=str_replace('cst001-','',str_replace('_','-',str_replace('kişiye_özel_telefon_kılıfları-','',$p_model2)));
                   
               
                $case_image=$image['image'];
                $product_type = isset($image['product_type']) ? $image['product_type'] : '';

                $image = isset($image['image']) ? $this->model_tool_image->resize($image['image'], 100, 100) : '';


                $option_data = array();

                $options = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);


                foreach ($options as $option) {

                    if ($option['type'] != 'file') {

                        $option_data[] = array(

                            'name' => $option['name'],

                            'value' => $option['value'],

                            'type' => $option['type']

                        );

                    } else {

                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);


                        if ($upload_info) {

                            $option_data[] = array(

                                'name' => $option['name'],

                                'value' => $upload_info['name'],

                                'type' => $option['type'],

                                'href' => $this->url->link('tool/upload/download', 'token=' . $this->session->data['token'] . '&code=' . $upload_info['code'], true)

                            );

                        }

                    }


                    $option_thumb_image = $this->model_sale_order->getOrderOptionValueThumb($option['product_option_value_id'], $product['product_id']);

                    $option_thumb_image = $option_thumb_image['option_thumb_image'] ? json_decode($option_thumb_image['option_thumb_image'], true) : false;

                    if ($option_thumb_image[0]) {

                        $image = $this->model_tool_image->resize($option_thumb_image[0], $this->config->get($this->config->get('config_theme') . '_image_cart_width'), $this->config->get($this->config->get('config_theme') . '_image_cart_height'));

                    }

                }


                // $case_pattern_image = $this->model_tool_image->resize($product['case_order_image'], 100, 100);

                     $customcase_image =  '';
                if ($product['customcase_image'] != '') {

                    $str = explode('***', $product['customcase_image']);
                   

                    $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];

                    if($case_image!='' &&  file_exists(DIR_IMAGE.$case_image))
                    $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/'.$case_image;
                  
                    else
                     $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/personal/' . $str[0] . '.png';
                }

                $this->load->model('catalog/product');
                if ($product_type == 11) {
                    $p_11_pattern_img = explode('***', $product['customcase_image']);
                    $customcase_image = $this->model_catalog_product->get_a_blob($p_11_pattern_img[1]);

                    $output_file = 'p_11/' . $p_11_pattern_img[0] . '_' . $product['order_product_id'] . '.png';

                    // open the output file for writing
                    $ifp = fopen( DIR_IMAGE . $output_file, 'wb' );

                    // we could add validation here with ensuring count( $data ) > 1
                    fwrite( $ifp, base64_decode( $customcase_image ) );

                    // clean up the file resource
                    fclose( $ifp );

                    $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $output_file;


                    /*
                    $p_11 = $this->model_catalog_product->get_c_blob($p_11_pattern_img[1]);
                    $file_name = token(32).'.png';
                    file_put_contents(DIR_IMAGE.$file_name, base64_decode($p_11));
                    $p_11 = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/'.$file_name; */
                }
                $data['products'][] = array(

                    'order_product_id' => $product['order_product_id'],

                    'product_id' => $product['product_id'],

                    'name' => $product['name'],

                    'image' => $image,

                    'p_11_pattern_img'=>$product['p_11_pattern_img'],

                    'product_type' => $product_type,

                    'case_order_image' => ($product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['case_order_image'] : ''),

                    'customer_pattern_data' => $product['customer_pattern_data'],

                    'admin_pattern_image' => ($product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['admin_pattern_image'] : ''),

                    'admin_gradient_pattern_image' => ($product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['admin_gradient_pattern_image'] : ''),

                    'customcase_image' => $customcase_image,

                    'case_image' => $case_image,

                    'model' => $product['model'],
                    
                    'model2' => $p_model2,

                    'option' => $option_data,

                    'quantity' => $product['quantity'],

                    'return_status' => $product['return_status'],

                    'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                    
                    'status' => $product['status'],
                    
                    'KDV'=>   $this->currency->format($product['total']+$product['tax'], $order_info['currency_code'], $order_info['currency_value']),

                    'total' => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),

                    'href' => "/product/product&product_id=" . $product['product_id'],

                    'idle_stock' => isset($product['idle_stock']) ? $product['idle_stock']:0, //20.09.20 idle stock (ali.a)
                );

            }


            $data['payment_code'] = $order_info['payment_code'];

            $data['payment_refund_status'] = false;


            $this->load->model('extension/payment/iyzico_checkout_form');

            $payment_refund_status = $this->model_extension_payment_iyzico_checkout_form->getOrderEntry($order_id);


            if ($payment_refund_status) {

                if ($payment_refund_status['total_refunded'] == 0) {

                    $data['payment_refund_status'] = false;

                } else {

                    $data['payment_refund_status'] = true;

                }

            }


            $data['vouchers'] = array();


            $vouchers = $this->model_sale_order->getOrderVouchers($this->request->get['order_id']);


            foreach ($vouchers as $voucher) {

                $data['vouchers'][] = array(

                    'description' => $voucher['description'],

                    'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value']),

                    'href' => $this->url->link('sale/voucher/edit', 'token=' . $this->session->data['token'] . '&voucher_id=' . $voucher['voucher_id'], true)

                );

            }


            $data['totals'] = array();


            $totals = $this->model_sale_order->getOrderTotals($this->request->get['order_id']);


            foreach ($totals as $total) {

                $data['totals'][] = array(

                    'title' => $total['title'],

                    'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'])

                );

            }


            $data['comment'] = nl2br($order_info['comment']);


            $this->load->model('customer/customer');


            $data['reward'] = $order_info['reward'];


            $data['reward_total'] = $this->model_customer_customer->getTotalCustomerRewardsByOrderId($this->request->get['order_id']);


            $data['affiliate_firstname'] = $order_info['affiliate_firstname'];

            $data['affiliate_lastname'] = $order_info['affiliate_lastname'];


            if ($order_info['affiliate_id']) {

                $data['affiliate'] = $this->url->link('marketing/affiliate/edit', 'token=' . $this->session->data['token'] . '&affiliate_id=' . $order_info['affiliate_id'], true);

            } else {

                $data['affiliate'] = '';

            }


            $data['commission'] = $this->currency->format($order_info['commission'], $order_info['currency_code'], $order_info['currency_value']);


            $this->load->model('marketing/affiliate');


            $data['commission_total'] = $this->model_marketing_affiliate->getTotalTransactionsByOrderId($this->request->get['order_id']);


            $this->load->model('localisation/order_status');


            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_info['order_status_id']);


            if ($order_status_info) {

                $data['order_status'] = $order_status_info['name'];

            } else {

                $data['order_status'] = '';

            }


            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


            $data['order_status_id'] = $order_info['order_status_id'];
            $data['scottycargo_order_status_id'] = $this->config->get('scottycargo_order_status_id');


            $data['account_custom_field'] = $order_info['custom_field'];


            // Custom Fields

            $this->load->model('customer/custom_field');


            $data['account_custom_fields'] = array();


            $filter_data = array(

                'sort' => 'cf.sort_order',

                'order' => 'ASC'

            );


            $custom_fields = $this->model_customer_custom_field->getCustomFields($filter_data);


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'account' && isset($order_info['custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['account_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['account_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['account_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['custom_field'][$custom_field['custom_field_id']]

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['account_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name']

                            );

                        }

                    }

                }

            }


            // Custom fields

            $data['payment_custom_fields'] = array();


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'address' && isset($order_info['payment_custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['payment_custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['payment_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['payment_custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['payment_custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['payment_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name'],

                                    'sort_order' => $custom_field['sort_order']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['payment_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['payment_custom_field'][$custom_field['custom_field_id']],

                            'sort_order' => $custom_field['sort_order']

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['payment_custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['payment_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }

                }

            }


            // Shipping

            $data['shipping_custom_fields'] = array();


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'address' && isset($order_info['shipping_custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['shipping_custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['shipping_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['shipping_custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['shipping_custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['shipping_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name'],

                                    'sort_order' => $custom_field['sort_order']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['shipping_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['shipping_custom_field'][$custom_field['custom_field_id']],

                            'sort_order' => $custom_field['sort_order']

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['shipping_custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['shipping_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }

                }

            }


            $data['ip'] = $order_info['ip'];

            $data['forwarded_ip'] = $order_info['forwarded_ip'];

            $data['user_agent'] = $order_info['user_agent'];

            $data['accept_language'] = $order_info['accept_language'];


            // Additional Tabs

            $data['tabs'] = array();


            $this->load->model('extension/extension');


            $extensions = $this->model_extension_extension->getInstalled('fraud');


            foreach ($extensions as $extension) {

                if ($this->config->get($extension . '_status')) {

                    $this->load->language('extension/fraud/' . $extension);


                    $content = $this->load->controller('extension/fraud/' . $extension . '/order');


                    if ($content) {

                        $data['tabs'][] = array(

                            'code' => $extension,

                            'title' => $this->language->get('heading_title'),

                            'content' => $content

                        );

                    }

                }

            }


            // The URL we send API requests to

            $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


            // API login

            $this->load->model('user/api');


            $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));


            if ($api_info) {

                $data['api_id'] = $api_info['api_id'];

                $data['api_key'] = $api_info['key'];

                $data['api_ip'] = $this->request->server['REMOTE_ADDR'];

            } else {

                $data['api_id'] = '';

                $data['api_key'] = '';

                $data['api_ip'] = '';

            }




            $data['header'] = $this->load->controller('common/header');

            $data['column_left'] = $this->load->controller('common/column_left');

            $data['footer'] = $this->load->controller('common/footer');

            //20.09.20 idle stock (ali.a)
            $data['editUrl'] = $this->url->link('catalog/product/edit', 'token=' . $this->session->data['token'] . '&product_id=' , true);

            $this->load->model('user/user');
            $user_info = $this->model_user_user->getUser($this->user->getId());

            if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_info.tpl')) {
                $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_info_dev', $data));
            } else {
                $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_info', $data));
            }

        } else {

            return new Action('error/not_found');

        }

    }

    public function toplu()
    {


        $this->load->model('sale/order');

        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];
        } else {
            $order_id = 0;
        }


        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info) {

            $this->load->language('sale/order');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');
            $data['text_ip_add'] = sprintf($this->language->get('text_ip_add'), $this->request->server['REMOTE_ADDR']);
            $data['text_order_detail'] = $this->language->get('text_order_detail');
            $data['text_customer_detail'] = $this->language->get('text_customer_detail');

            $data['text_option'] = $this->language->get('text_option');

            $data['text_store'] = $this->language->get('text_store');

            $data['text_date_added'] = $this->language->get('text_date_added');

            $data['text_payment_method'] = $this->language->get('text_payment_method');

            $data['text_shipping_method'] = $this->language->get('text_shipping_method');

            $data['text_customer'] = $this->language->get('text_customer');

            $data['text_customer_group'] = $this->language->get('text_customer_group');

            $data['text_email'] = $this->language->get('text_email');

            $data['text_telephone'] = $this->language->get('text_telephone');

            $data['text_invoice'] = $this->language->get('text_invoice');

            $data['text_reward'] = $this->language->get('text_reward');

            $data['text_affiliate'] = $this->language->get('text_affiliate');

            $data['text_order'] = sprintf($this->language->get('text_order'), $this->request->get['order_id']);

            $data['text_payment_address'] = $this->language->get('text_payment_address');

            $data['text_shipping_address'] = $this->language->get('text_shipping_address');

            $data['text_comment'] = $this->language->get('text_comment');

            $data['text_account_custom_field'] = $this->language->get('text_account_custom_field');

            $data['text_payment_custom_field'] = $this->language->get('text_payment_custom_field');

            $data['text_shipping_custom_field'] = $this->language->get('text_shipping_custom_field');

            $data['text_browser'] = $this->language->get('text_browser');

            $data['text_ip'] = $this->language->get('text_ip');

            $data['text_forwarded_ip'] = $this->language->get('text_forwarded_ip');

            $data['text_user_agent'] = $this->language->get('text_user_agent');

            $data['text_accept_language'] = $this->language->get('text_accept_language');

            $data['text_history'] = $this->language->get('text_history');

            $data['text_history_add'] = $this->language->get('text_history_add');

            $data['text_loading'] = $this->language->get('text_loading');


            $data['column_product'] = $this->language->get('column_product');

            $data['column_pattern_image'] = $this->language->get('column_pattern_image');

            $data['column_download_image'] = $this->language->get('column_download_image');

            $data['column_model'] = $this->language->get('column_model');

            $data['column_quantity'] = $this->language->get('column_quantity');

            $data['column_price'] = $this->language->get('column_price');

            $data['column_total'] = $this->language->get('column_total');


            $data['entry_order_status'] = $this->language->get('entry_order_status');

            $data['entry_notify'] = $this->language->get('entry_notify');

            $data['entry_override'] = $this->language->get('entry_override');

            $data['entry_comment'] = $this->language->get('entry_comment');


            $data['help_override'] = $this->language->get('help_override');


            $data['button_invoice_print'] = $this->language->get('button_invoice_print');

            $data['button_shipping_print'] = $this->language->get('button_shipping_print');

            $data['button_edit'] = $this->language->get('button_edit');

            $data['button_cancel'] = $this->language->get('button_cancel');

            $data['button_generate'] = $this->language->get('button_generate');

            $data['button_reward_add'] = $this->language->get('button_reward_add');

            $data['button_reward_remove'] = $this->language->get('button_reward_remove');

            $data['button_commission_add'] = $this->language->get('button_commission_add');

            $data['button_commission_remove'] = $this->language->get('button_commission_remove');

            $data['button_history_add'] = $this->language->get('button_history_add');

            $data['button_ip_add'] = $this->language->get('button_ip_add');


            $data['tab_history'] = $this->language->get('tab_history');

            $data['tab_additional'] = $this->language->get('tab_additional');


            $url = '';


            if (isset($this->request->get['filter_order_id'])) {

                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];

            }


            if (isset($this->request->get['filter_customer'])) {

                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));

            }


            if (isset($this->request->get['filter_order_status'])) {

                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];

            }


            if (isset($this->request->get['filter_total'])) {

                $url .= '&filter_total=' . $this->request->get['filter_total'];

            }


            if (isset($this->request->get['filter_date_added'])) {

                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];

            }


            if (isset($this->request->get['filter_date_modified'])) {

                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];

            }


            if (isset($this->request->get['sort'])) {

                $url .= '&sort=' . $this->request->get['sort'];

            }


            if (isset($this->request->get['order'])) {

                $url .= '&order=' . $this->request->get['order'];

            }


            if (isset($this->request->get['page'])) {

                $url .= '&page=' . $this->request->get['page'];

            }


            $data['breadcrumbs'] = array();


            $data['breadcrumbs'][] = array(

                'text' => $this->language->get('text_home'),

                'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)

            );


            $data['breadcrumbs'][] = array(

                'text' => $this->language->get('heading_title'),

                'href' => $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true)

            );


            $data['shipping'] = $this->url->link('sale/order/shipping', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['invoice'] = $this->url->link('sale/order/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['edit'] = $this->url->link('sale/order/edit', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['delete'] = $this->url->link('sale/order/deleteItem', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $data['cancel'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . $url, true);

            $data['token'] = $this->session->data['token'];

            $data['order_id'] = $this->request->get['order_id'];
            $data['store_id'] = $order_info['store_id'];
            $data['store_name'] = $order_info['store_name'];

            $data['shipping_info'] = '';

            $shipping_info = $this->db->query("SELECT * FROM ps_order_yurticikargo WHERE order_id = '" . $order_id . "' ")->row;

            if ($shipping_info) {
                $data['shipping_info'] = $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            $data['shipping_info_second'] = '';
            $shipping_info_second = $this->db->query("SELECT * FROM ps_order_yurticikargo_second WHERE order_id = '" . (int)$order_id . "' ")->row;
            if ($shipping_info_second) {
                $data['shipping_info_second'] = $this->url->link('sale/prepared_orders/invoice_second', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }

            $data['byexpress_shipping_info'] = '';
            $byexpress_shipping_info = $this->db->query("SELECT * FROM ps_order_byexpresskargo WHERE order_id = '" . (int)$order_id . "' ")->row;
            if($byexpress_shipping_info){
                $data['byexpress_shipping_info'] = $this->url->link('sale/prepared_orders/byexpress_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$order_id, true);
            }


            if ($order_info['store_id'] == 0) {
                $data['store_url'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;
            } else {
                $data['store_url'] = $order_info['store_url'];
            }


            if ($order_info['invoice_no']) {
                $data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
            } else {
                $data['invoice_no'] = '';
            }


            $data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
            $data['firstname'] = $order_info['firstname'];
            $data['lastname'] = $order_info['lastname'];


            $data['customer_id'] = 0;

            if ($order_info['customer_id']) {
                $data['customer'] = $this->url->link('customer/customer/edit', 'token=' . $this->session->data['token'] . '&customer_id=' . $order_info['customer_id'], true);
                $data['customer_id'] = $order_info['customer_id'];
            } else {
                $data['customer'] = '';
            }


            $this->load->model('customer/customer_group');

            $customer_group_info = $this->model_customer_customer_group->getCustomerGroup($order_info['customer_group_id']);

            if ($customer_group_info) {
                $data['customer_group'] = $customer_group_info['name'];
            } else {
                $data['customer_group'] = '';
            }


            $data['email'] = $order_info['email'];
            $data['telephone'] = $order_info['telephone'];
            $data['shipping_method'] = $order_info['shipping_method'];
            $data['payment_method'] = $order_info['payment_method'];

            // Payment Address

            if ($order_info['payment_address_format']) {
                $format = $order_info['payment_address_format'];
            } else {
                $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country} ' . "\n" . '{payment_company}' . "\n" .'{payment_company_taxno}' . "\n". '{payment_company_taxadmin}';
            }


            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}',
                '{payment_company}',
                '{payment_company_taxno}',
                '{payment_company_taxadmin}'

            );


            $replace = array(
                'firstname' => $order_info['payment_firstname'],
                'lastname' => $order_info['payment_lastname'],
                'company' => $order_info['payment_company'],
                'address_1' => $order_info['payment_address_1'],
                'address_2' => $order_info['payment_address_2'],
                'city' => $order_info['payment_city'],
                'postcode' => $order_info['payment_postcode'],
                'zone' => $order_info['payment_zone'],
                'zone_code' => $order_info['payment_zone_code'],
                'country' => $order_info['payment_country'],
                'payment_company' => $order_info['payment_company'],
                'payment_company_taxno' => $order_info['payment_company_taxno'],
                'payment_company_taxadmin' => $order_info['payment_company_taxadmin'],
            );


            $data['payment_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            // Shipping Address
            if ($order_info['shipping_address_format']) {
                $format = $order_info['shipping_address_format'];
            } else {
                $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
            }


            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}',
                '{payment_company}',
                '{payment_company_taxno}',
                '{payment_company_taxadmin}'
            );


            $replace = array(
                'firstname' => $order_info['shipping_firstname'],
                'lastname' => $order_info['shipping_lastname'],
                'company' => $order_info['shipping_company'],
                'address_1' => $order_info['shipping_address_1'],
                'address_2' => $order_info['shipping_address_2'],
                'city' => $order_info['shipping_city'],
                'postcode' => $order_info['shipping_postcode'],
                'zone' => $order_info['shipping_zone'],
                'zone_code' => $order_info['shipping_zone_code'],
                'country' => $order_info['shipping_country']
            );

            $data['shipping_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            // Uploaded files

            $this->load->model('tool/upload');

            $data['products'] = array();

            $products = $this->model_sale_order->getOrderProducts($this->request->get['order_id']);

            $data['column_image'] = $this->language->get('column_image');

            $this->load->model('tool/image');

            $this->load->model('tool/image');


            foreach ($products as $product) {


                $image = $this->db->query("SELECT * FROM ps_product WHERE product_id='" . $product['product_id'] . "' ")->row;
                $p_model2=$image['model2'];

                if($image['model2']!='' && $image['product_type']==7)
                    $p_model2=str_replace('cst001-','',str_replace('_','-',str_replace('kişiye_özel_telefon_kılıfları-','',$p_model2)));


                $case_image=$image['image'];
                $product_type = isset($image['product_type']) ? $image['product_type'] : '';

                $image = isset($image['image']) ? $this->model_tool_image->resize($image['image'], 100, 100) : '';


                $option_data = array();

                $options = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);


                foreach ($options as $option) {

                    if ($option['type'] != 'file') {

                        $option_data[] = array(

                            'name' => $option['name'],

                            'value' => $option['value'],

                            'type' => $option['type']

                        );

                    } else {

                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);


                        if ($upload_info) {

                            $option_data[] = array(

                                'name' => $option['name'],

                                'value' => $upload_info['name'],

                                'type' => $option['type'],

                                'href' => $this->url->link('tool/upload/download', 'token=' . $this->session->data['token'] . '&code=' . $upload_info['code'], true)

                            );

                        }

                    }


                    $option_thumb_image = $this->model_sale_order->getOrderOptionValueThumb($option['product_option_value_id'], $product['product_id']);

                    $option_thumb_image = $option_thumb_image['option_thumb_image'] ? json_decode($option_thumb_image['option_thumb_image'], true) : false;

                    if ($option_thumb_image[0]) {

                        $image = $this->model_tool_image->resize($option_thumb_image[0], $this->config->get($this->config->get('config_theme') . '_image_cart_width'), $this->config->get($this->config->get('config_theme') . '_image_cart_height'));

                    }

                }


                // $case_pattern_image = $this->model_tool_image->resize($product['case_order_image'], 100, 100);

                $customcase_image =  '';

                if ($product['customcase_image'] != '') {

                    $str = explode('***', $product['customcase_image']);

                    $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];

                    if($case_image!='' &&  file_exists(DIR_IMAGE.$case_image))
                        $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/'.$case_image;

                    else
                        $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/personal/' . $str[0] . '.png';
                }
                $p_11;
                $this->load->model('catalog/product');
                if ($product_type==11) {
                    $customcase_image=$this->model_catalog_product->get_c_blob($product['p_11_pattern_img']);
                    $customcase_image='data:image;base64,'.($customcase_image);

                    $p_11=$this->model_catalog_product->get_a_blob($product['p_11_pattern_img']);
                    $file_name=token(32).'.png';
                    file_put_contents(DIR_IMAGE.$file_name, base64_decode($p_11));
                    $p_11=($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/'.$file_name;
                }
                $data['products'][] = array(

                    'order_product_id' => $product['order_product_id'],

                    'product_id' => $product['product_id'],

                    'name' => $product['name'],

                    'image' => $image,

                    'p_11_pattern_img'=>$product['p_11_pattern_img'],

                    'product_type' => $product_type,

                    'case_order_image' => ($product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['case_order_image'] : ''),

                    'customer_pattern_data' => $product['customer_pattern_data'],

                    'admin_pattern_image' => ($product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['admin_pattern_image'] : ''),

                    'admin_gradient_pattern_image' => ($product['admin_gradient_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $product['admin_gradient_pattern_image'] : ''),

                    'customcase_image' => $customcase_image,

                    'case_image' => $case_image,

                    'model' => $product['model'],

                    'model2' => $p_model2,

                    'option' => $option_data,

                    'quantity' => $product['quantity'],

                    'return_status' => $product['return_status'],

                    'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),

                    'KDV'=>   $this->currency->format($product['total']+$product['tax'], $order_info['currency_code'], $order_info['currency_value']),

                    'total' => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),

                    'href' => "/product/product&product_id=" . $product['product_id'],

                    'idle_stock' => isset($product['idle_stock']) ? $product['idle_stock']:0, //20.09.20 idle stock (ali.a)
                );

            }


            $data['payment_code'] = $order_info['payment_code'];

            $data['payment_refund_status'] = false;


            $this->load->model('extension/payment/iyzico_checkout_form');

            $payment_refund_status = $this->model_extension_payment_iyzico_checkout_form->getOrderEntry($order_id);


            if ($payment_refund_status) {

                if ($payment_refund_status['total_refunded'] == 0) {

                    $data['payment_refund_status'] = false;

                } else {

                    $data['payment_refund_status'] = true;

                }

            }


            $data['vouchers'] = array();


            $vouchers = $this->model_sale_order->getOrderVouchers($this->request->get['order_id']);


            foreach ($vouchers as $voucher) {

                $data['vouchers'][] = array(

                    'description' => $voucher['description'],

                    'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value']),

                    'href' => $this->url->link('sale/voucher/edit', 'token=' . $this->session->data['token'] . '&voucher_id=' . $voucher['voucher_id'], true)

                );

            }


            $data['totals'] = array();


            $totals = $this->model_sale_order->getOrderTotals($this->request->get['order_id']);


            foreach ($totals as $total) {

                $data['totals'][] = array(

                    'title' => $total['title'],

                    'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'])

                );

            }


            $data['comment'] = nl2br($order_info['comment']);


            $this->load->model('customer/customer');


            $data['reward'] = $order_info['reward'];


            $data['reward_total'] = $this->model_customer_customer->getTotalCustomerRewardsByOrderId($this->request->get['order_id']);


            $data['affiliate_firstname'] = $order_info['affiliate_firstname'];

            $data['affiliate_lastname'] = $order_info['affiliate_lastname'];


            if ($order_info['affiliate_id']) {

                $data['affiliate'] = $this->url->link('marketing/affiliate/edit', 'token=' . $this->session->data['token'] . '&affiliate_id=' . $order_info['affiliate_id'], true);

            } else {

                $data['affiliate'] = '';

            }


            $data['commission'] = $this->currency->format($order_info['commission'], $order_info['currency_code'], $order_info['currency_value']);


            $this->load->model('marketing/affiliate');


            $data['commission_total'] = $this->model_marketing_affiliate->getTotalTransactionsByOrderId($this->request->get['order_id']);


            $this->load->model('localisation/order_status');


            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_info['order_status_id']);


            if ($order_status_info) {

                $data['order_status'] = $order_status_info['name'];

            } else {

                $data['order_status'] = '';

            }


            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


            $data['order_status_id'] = $order_info['order_status_id'];


            $data['account_custom_field'] = $order_info['custom_field'];


            // Custom Fields

            $this->load->model('customer/custom_field');


            $data['account_custom_fields'] = array();


            $filter_data = array(

                'sort' => 'cf.sort_order',

                'order' => 'ASC'

            );


            $custom_fields = $this->model_customer_custom_field->getCustomFields($filter_data);


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'account' && isset($order_info['custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['account_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['account_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['account_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['custom_field'][$custom_field['custom_field_id']]

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['account_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name']

                            );

                        }

                    }

                }

            }


            // Custom fields

            $data['payment_custom_fields'] = array();


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'address' && isset($order_info['payment_custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['payment_custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['payment_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['payment_custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['payment_custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['payment_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name'],

                                    'sort_order' => $custom_field['sort_order']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['payment_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['payment_custom_field'][$custom_field['custom_field_id']],

                            'sort_order' => $custom_field['sort_order']

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['payment_custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['payment_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }

                }

            }


            // Shipping

            $data['shipping_custom_fields'] = array();


            foreach ($custom_fields as $custom_field) {

                if ($custom_field['location'] == 'address' && isset($order_info['shipping_custom_field'][$custom_field['custom_field_id']])) {

                    if ($custom_field['type'] == 'select' || $custom_field['type'] == 'radio') {

                        $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($order_info['shipping_custom_field'][$custom_field['custom_field_id']]);


                        if ($custom_field_value_info) {

                            $data['shipping_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $custom_field_value_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }


                    if ($custom_field['type'] == 'checkbox' && is_array($order_info['shipping_custom_field'][$custom_field['custom_field_id']])) {

                        foreach ($order_info['shipping_custom_field'][$custom_field['custom_field_id']] as $custom_field_value_id) {

                            $custom_field_value_info = $this->model_customer_custom_field->getCustomFieldValue($custom_field_value_id);


                            if ($custom_field_value_info) {

                                $data['shipping_custom_fields'][] = array(

                                    'name' => $custom_field['name'],

                                    'value' => $custom_field_value_info['name'],

                                    'sort_order' => $custom_field['sort_order']

                                );

                            }

                        }

                    }


                    if ($custom_field['type'] == 'text' || $custom_field['type'] == 'textarea' || $custom_field['type'] == 'file' || $custom_field['type'] == 'date' || $custom_field['type'] == 'datetime' || $custom_field['type'] == 'time') {

                        $data['shipping_custom_fields'][] = array(

                            'name' => $custom_field['name'],

                            'value' => $order_info['shipping_custom_field'][$custom_field['custom_field_id']],

                            'sort_order' => $custom_field['sort_order']

                        );

                    }


                    if ($custom_field['type'] == 'file') {

                        $upload_info = $this->model_tool_upload->getUploadByCode($order_info['shipping_custom_field'][$custom_field['custom_field_id']]);


                        if ($upload_info) {

                            $data['shipping_custom_fields'][] = array(

                                'name' => $custom_field['name'],

                                'value' => $upload_info['name'],

                                'sort_order' => $custom_field['sort_order']

                            );

                        }

                    }

                }

            }


            $data['ip'] = $order_info['ip'];

            $data['forwarded_ip'] = $order_info['forwarded_ip'];

            $data['user_agent'] = $order_info['user_agent'];

            $data['accept_language'] = $order_info['accept_language'];


            // Additional Tabs

            $data['tabs'] = array();


            $this->load->model('extension/extension');


            $extensions = $this->model_extension_extension->getInstalled('fraud');


            foreach ($extensions as $extension) {

                if ($this->config->get($extension . '_status')) {

                    $this->load->language('extension/fraud/' . $extension);


                    $content = $this->load->controller('extension/fraud/' . $extension . '/order');


                    if ($content) {

                        $data['tabs'][] = array(

                            'code' => $extension,

                            'title' => $this->language->get('heading_title'),

                            'content' => $content

                        );

                    }

                }

            }


            // The URL we send API requests to

            $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


            // API login

            $this->load->model('user/api');


            $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));


            if ($api_info) {

                $data['api_id'] = $api_info['api_id'];

                $data['api_key'] = $api_info['key'];

                $data['api_ip'] = $this->request->server['REMOTE_ADDR'];

            } else {

                $data['api_id'] = '';

                $data['api_key'] = '';

                $data['api_ip'] = '';

            }




            $data['header'] = $this->load->controller('common/header');

            $data['column_left'] = $this->load->controller('common/column_left');

            $data['footer'] = $this->load->controller('common/footer');

            //20.09.20 idle stock (ali.a)
            $data['editUrl'] = $this->url->link('catalog/product/edit', 'token=' . $this->session->data['token'] . '&product_id=' , true);


            if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_toplu.tpl')) {

                $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_toplu', $data));

            } else {

                $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_toplu', $data));

            }

        } else {

            return new Action('error/not_found');

        }

    }
    public function excel_returns()
    {
        /*
        //var_dump('sdsa'); die();

        $this->load->model('sale/order');
        //$orders = $this->model_sale_order->getcouponusedorders();



        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Return ID')
            ->setCellValue('B1', 'Sipariş No')
            ->setCellValue('C1', 'Ürün')
            ->setCellValue('D1', 'Ad')
            ->setCellValue('E1', 'Soyad')
            ->setCellValue('F1', 'İade/Değişim')
            ->setCellValue('G1', 'Durum')
            ->setCellValue('H1', 'Tarih');


        //SELECT pch.coupon_id,pch.order_id,pch.amount,po.total,po.date_added,pc.code FROM `ps_coupon_history` pch INNER JOIN ps_order po ON(po.order_id = pch.order_id) INNER JOIN ps_coupon pc ON(pc.coupon_id = pch.coupon_id) WHERE pc.name LIKE 'DENEBUNU'

        $orders = $this->model_sale_order->getreturnsiade();
        //var_dump($orders); die();

        $file_name = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . "-RETURNS.xls";

        $row_i = 2;

        foreach ($orders as $order) {

            if($order['return_status_id'] == 5){
                $status = 'Kupon Oluşturuldu';
            }else{
                $status = 'Tamamlandı';
            }

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . $row_i, $order['return_id'])
                ->setCellValue('B' . $row_i, $order['order_id'])
                ->setCellValue('C' . $row_i, $order['product'])
                ->setCellValue('D' . $row_i, $order['firstname'])
                ->setCellValue('E' . $row_i, $order['lastname'])
                ->setCellValue('F' . $row_i, $order['return_or_change'])
                ->setCellValue('G' . $row_i, $status)
                ->setCellValue('H' . $row_i, $order['date_modified']);

            $row_i++;


        }


        $objPHPExcel->getActiveSheet()->setTitle('Simple');


        $objPHPExcel->setActiveSheetIndex(0);


        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $file_name . '"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        exit;
        */
    }

    public function excel_coupon_orders()
    {

        $this->load->model('sale/order');
        //$orders = $this->model_sale_order->getcouponusedorders();



        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Sipariş ID')
            ->setCellValue('B1', 'Kupon ID')
            ->setCellValue('C1', 'Ad')
            ->setCellValue('D1', 'Soyad')
            ->setCellValue('E1', 'Kupon Kodu')
            ->setCellValue('F1', 'Sipariş Tutarı')
            ->setCellValue('G1', 'İndirim')
            ->setCellValue('H1', 'Tarih');


        //SELECT pch.coupon_id,pch.order_id,pch.amount,po.total,po.date_added,pc.code FROM `ps_coupon_history` pch INNER JOIN ps_order po ON(po.order_id = pch.order_id) INNER JOIN ps_coupon pc ON(pc.coupon_id = pch.coupon_id) WHERE pc.name LIKE 'DENEBUNU'

        $orders = $this->model_sale_order->getcouponusedforcoupon();
        //var_dump($orders); die();

        $file_name = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . "-orders.xls";

        $row_i = 2;

        foreach ($orders as $order) {


                $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row_i, $order['order_id'])
                    ->setCellValue('B' . $row_i, $order['coupon_id'])
                    ->setCellValue('C' . $row_i, $order['firstname'])
                    ->setCellValue('D' . $row_i, $order['lastname'])
                    ->setCellValue('E' . $row_i, $order['code'])
                    ->setCellValue('F' . $row_i, $order['total'])
                    ->setCellValue('G' . $row_i, $order['amount'])
                    ->setCellValue('H' . $row_i, $order['date_added']);

                $row_i++;


        }


        $objPHPExcel->getActiveSheet()->setTitle('Simple');


        $objPHPExcel->setActiveSheetIndex(0);


        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $file_name . '"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');

        exit;

    }

    public function excel_export()
    {


        $this->load->model('sale/order');

        $this->load->model('catalog/product');


        if (isset($this->request->get['filter_order_id'])) {

            $filter_order_id = $this->request->get['filter_order_id'];

        } else {

            $filter_order_id = null;

        }


        if (isset($this->request->get['filter_email'])) {

            $filter_email = $this->request->get['filter_email'];

        } else {

            $filter_email = null;

        }


        if (isset($this->request->get['filter_telephone'])) {

            $filter_telephone = $this->request->get['filter_telephone'];

        } else {

            $filter_telephone = null;

        }


        if (isset($this->request->get['filter_customer'])) {

            $filter_customer = $this->request->get['filter_customer'];

        } else {

            $filter_customer = null;

        }


        if (isset($this->request->get['filter_order_status'])) {

            $filter_order_status = $this->request->get['filter_order_status'];

        } else {

            $filter_order_status = null;

        }


        if (isset($this->request->get['filter_order_payment'])) {

            $filter_order_payment = $this->request->get['filter_order_payment'];

        } else {

            $filter_order_payment = null;

        }


        if (isset($this->request->get['filter_order_zone'])) {

            $filter_order_zone = $this->request->get['filter_order_zone'];

        } else {

            $filter_order_zone = null;

        }


        if (isset($this->request->get['filter_total'])) {

            $filter_total = $this->request->get['filter_total'];

        } else {

            $filter_total = null;

        }


        if (isset($this->request->get['filter_date_added'])) {

            $filter_date_added = $this->request->get['filter_date_added'];

        } else {

            $filter_date_added = null;

        }


        if (isset($this->request->get['filter_date_modified'])) {

            $filter_date_modified = $this->request->get['filter_date_modified'];

        } else {

            $filter_date_modified = null;

        }


        if (isset($this->request->get['sort'])) {

            $sort = $this->request->get['sort'];

        } else {

            $sort = 'o.order_id';

        }


        if (isset($this->request->get['order'])) {

            $order = $this->request->get['order'];

        } else {

            $order = 'DESC';

        }


        if (isset($this->request->get['page'])) {

            $page = $this->request->get['page'];

        } else {

            $page = 1;

        }


        $data['orders'] = array();


        $filter_data = array(

            'filter_order_id' => $filter_order_id,

            'filter_email' => $filter_email,

            'filter_telephone' => $filter_telephone,

            'filter_customer' => $filter_customer,

            'filter_order_status' => $filter_order_status,

            'filter_order_zone' => $filter_order_zone,

            'filter_order_payment' => $filter_order_payment,

            'filter_total' => $filter_total,

            'filter_date_added' => $filter_date_added,

            'filter_date_modified' => $filter_date_modified,

            'sort' => $sort,

            'order' => $order,

            'start' => ($page - 1) * $this->config->get('config_limit_admin'),

            'limit' => $this->config->get('config_limit_admin')

        );


        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';


        $objPHPExcel = new PHPExcel();

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Sipariş ID')
            ->setCellValue('B1', 'Müşteri ID')
            ->setCellValue('C1', 'Müşteri Adı Soyadı')
            ->setCellValue('D1', 'Müşteri E-Posta')
            ->setCellValue('E1', 'Müşteri Telefon')
            ->setCellValue('F1', 'Fatura Adı Soyadı')
            ->setCellValue('G1', 'Fatura Adresi')
            ->setCellValue('H1', 'Fatura Şehir')
            ->setCellValue('J1', 'Sipariş Durumu')
            ->setCellValue('K1', 'Fiyat')
            ->setCellValue('L1', 'Ürün');

        //->setCellValue('M1','');


        $orders = $this->model_sale_order->getOrders($filter_data);


        $file_name = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . "-orders.xls";


        $row_i = 2;


        foreach ($orders as $order) {

            $result_orders = $this->model_sale_order->getOrder($order['order_id']);

            $order_products = $this->model_sale_order->getOrderProducts($order['order_id']);

            //$p_name = $this->model_catalog_product->getProduct($order[]->['product_id']);

            //var_dump($order_products);

            //var_dump($order_products);


            /* if(stristr($order_products[0]['model'],"ism")){

              echo ' kelime var ';

              }else{

              echo ' kelime yok ';

              } */


            foreach ($order_products as $order_product) {


                //$p_name = $this->model_catalog_product->getProduct($order_product['product_id']);

                //var_dump($p_name['name']);

                //$product_price = $result_orders['total'];

                //$product_price = $this->currency->format($order_product['price'], $result_orders['currency_code'], $result_orders['currency_value']);


                $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $row_i, $result_orders['order_id'])
                    ->setCellValue('B' . $row_i, $result_orders['customer_id'])
                    ->setCellValue('C' . $row_i, $result_orders['firstname'] . ' ' . $result_orders['lastname'])
                    ->setCellValue('D' . $row_i, $result_orders['email'])
                    ->setCellValue('E' . $row_i, $result_orders['telephone'])
                    ->setCellValue('F' . $row_i, $result_orders['payment_firstname'] . ' ' . $result_orders['payment_lastname'])
                    ->setCellValue('G' . $row_i, $result_orders['payment_address_1'])
                    ->setCellValue('H' . $row_i, $result_orders['payment_city'])
                    ->setCellValue('J' . $row_i, $result_orders['order_status'])
                    ->setCellValue('K' . $row_i, $result_orders['total'])
                    ->setCellValue('L' . $row_i, $order_product['name']);

                //->setCellValue('M'. $row_i, $['']);


                $row_i++;

            }

        }


        $objPHPExcel->getActiveSheet()->setTitle('Simple');


        $objPHPExcel->setActiveSheetIndex(0);


        header('Content-Type: application/vnd.ms-excel');

        header('Content-Disposition: attachment;filename="' . $file_name . '"');

        header('Cache-Control: max-age=0');

        header('Cache-Control: max-age=1');

        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past

        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified

        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1

        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

        $objWriter->save('php://output');

        exit;

    }

    public function excel_download()
    {
        error_reporting(0);

        $productIdleStockCounts = [];
        $productIdleStockShown = [];

        $this->load->model('sale/order');

        $this->load->model('catalog/product');

        $this->load->model('catalog/category');

        $this->load->model('catalog/attribute');


        if (!isset($this->request->post['selected'])) {

            echo "Herhangi bir sipariş seçmediniz!";

            die();

        }


        $data['orders'] = array();


        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';


        $objPHPExcel = new PHPExcel();

        $objPHPExcel2 = new PHPExcel();


        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', '')
            ->setCellValue('B1', 'Order ID')
          //  ->setCellValue('C1', 'Product ID')
            ->setCellValue('C1', 'Adet')
            ->setCellValue('D1', 'Müşteri Adı')
         //   ->setCellValue('F1', 'Müşteri E-Maili')
            ->setCellValue('E1', 'Ödeme şekli')
            ->setCellValue('F1', 'Atıl Stok')
            ->setCellValue('G1', '');

    $styleArray = array(
    'font'  => array(
        'bold'  => true,
        'color' => array('rgb' => 'FF0000'),
        'size'  => 8,
        'name'  => 'Verdana'
    ));
    



        $objPHPExcel2->setActiveSheetIndex(0)
            ->setCellValue('A1', '')
            ->setCellValue('B1', 'Order ID')
           // ->setCellValue('C1', 'Product ID')
            ->setCellValue('C1', 'Adet')
            ->setCellValue('D1', 'Müşteri Adı')
          //  ->setCellValue('F1', 'Müşteri E-Maili')
             ->setCellValue('E1', 'Ödeme şekli')
            ->setCellValue('F1', '');
            
            



        $file_name = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . "-orders.xls";

        $file_name2 = $this->config->get('config_name') . '-' . @date("Y-m-d-isH") . "-orders.xls";


        $row_i = 2;

        $row_j = 2;


        foreach ($this->request->post['selected'] as $order) {

            $order_info = $this->model_sale_order->getOrder($order);
            

            // 3 => Kargoya verilmek üzere hazırlandı.

            if($order_info['order_status_id'] != 7 && $order_info['order_status_id'] !=5){
                $this->model_sale_order->_addHistoryForExcel($order_info, 3);
            }

            $order_products = $this->model_sale_order->getOrderProducts($order);



            foreach ($order_products as $order_product) {


                if (strpos($order_product ['model'], 'PY') === false and
                    strpos($order_product ['model'], 'RPD') === false and
                    $order_product['return_status'] != 2 AND
                    $order_info['order_status_id'] != 22 AND
					$order_info['order_status_id'] != 7
                ) {


                    $customer_pattern_data = json_decode($order_product['customer_pattern_data'], true);

                    $case_text = $gradient_text = '';

                    if (isset($customer_pattern_data)) {

                        $case_text = $customer_pattern_data['pattern_text'];

                        $gradient_text = $customer_pattern_data['gradienttext'];

                    }


                    $category_id = $this->model_catalog_category->getCategoryByProductId($order_product['product_id']);

                    $catss = $this->db->query("SELECT * FROM ps_product_to_category WHERE product_id = '" . $order_product['product_id'] . "'");

                    $cats_name = $this->model_catalog_category->getCategory(isset($category_id['category_id']));

                    $product_attrbts = $this->model_catalog_product->getProductAttributes($order_product['product_id']);

                    $idle_stock = $this->db->query("SELECT idle_stock FROM ps_product WHERE product_id=".$order_product['product_id'])->row['idle_stock'];
                    $productIdleStockCounts[$order_product['product_id']] = $idle_stock;

                    if ($productIdleStockCounts[$order_product['product_id']] > 0) {
                        $productIdleStockShown[$order_product['product_id']]++;
                    }


                    $product_att_names = '';

                    foreach ($product_attrbts as $product_attrbt) {

                        $product_att = $this->model_catalog_attribute->getAttribute($product_attrbt['attribute_id']);

                        $product_att_names .= $product_att['name'] . ' ';

                    }


                    if (isset($catss->rows[1]['category_id']))

                        $category_names = $this->model_catalog_category->getCategory($catss->rows[1]['category_id']);


                    $item_info = $order_product['model'] . ' - ';

                    $item_info .= ((isset($category_names)) ? str_replace("Telefon Kılıfı", "", $category_names['path']) : '') . ' / ';

                    $item_info .= ((isset($category_names)) ? str_replace("Telefon Kılıfı", "", $category_names['name']) : '') . '- ';

                    $item_info .= $product_att_names;


                    if (!empty($customer_pattern_data['pattern_text'])) {

                        if ($customer_pattern_data['product_type'] == 4) {

                            $href = HTTPS_CATALOG . 'index.php?route=piyerSoft/cases/GenerateDpiImageType4&order_product_id=' . $order_product['order_product_id'] . '&pattern_code=' . $order_product['model'] . '&order_id=' . $order;

                        } else {

                            $href = HTTPS_CATALOG . 'index.php?route=piyerSoft/cases/GenerateDpiImage&order_product_id=' . $order_product['order_product_id'] . '&pattern_code=' . $order_product['model'] . '&order_id=' . $order;

                        }

                    } else if (!empty($order_product['customcase_image'])) {

                        $case_image = $this->db->query("SELECT image FROM ps_product WHERE product_id='" . $order_product['product_id'] . "' ")->row;
                        $case_image=$case_image['image'];
                        $customcase_image =  '';


                        $str = explode('***', $order_product['customcase_image']);

                        $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];

                       // $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/personal/' . $str[0] . '.png';


                        $custom_image = explode('***', $order_product['customcase_image']);

                        $custom_image = explode('-', $custom_image[0]);

                        $custom_image_brand = ucfirst($custom_image[0]) . ' / ';

                        unset($custom_image[0]);

                        foreach ($custom_image as $c_image) {

                            $custom_image_brand .= ucfirst($c_image);

                        }

                        if ($case_image == '' || !file_exists(DIR_IMAGE . $case_image))
                            $item_info = $order_product['model'] . ' - ' . $custom_image_brand;
                       else
                      $item_info=  $order_product['model'] . ' - ' .$order_product['name'];

                        $href = str_replace('cropped', '', $customcase_image);

                    } else {

                        $href = '';

                    }
                     $quantity=$order_product['quantity'];

                     $payment_method= trim(str_replace('+ ₺7,90','',strip_tags($order_info['payment_method'])));
                    if (($case_text == '' && $gradient_text == '') && empty($order_product['customcase_image'])) {

                        //28.09.20 show idle stock as much as total idle stock (ali.a)
                        $idle_stock = '';
                        if ($productIdleStockCounts[$order_product['product_id']] > 0 &&
                            $productIdleStockCounts[$order_product['product_id']] >= $productIdleStockShown[$order_product['product_id']]) {
                            $idle_stock = 'Var';

                            $this->db->query("UPDATE ps_product SET idle_stock=idle_stock-1 WHERE product_id={$order_product['product_id']} AND idle_stock>0 LIMIT 1");

                            $this->db->query("UPDATE ps_order_product SET show_idle_stock=1 WHERE order_product_id={$order_product['order_product_id']} LIMIT 1");
                        }

                      
                       if($quantity>1){
                           for($temp=1;$temp<=$quantity;$temp++){
                             $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $row_i, $item_info)
                            ->setCellValue('B' . $row_i, $order_product['order_id'])
                           // ->setCellValue('C' . $row_i, $order_product['product_id'])
                            ->setCellValue('C' . $row_i, 1)
                            ->setCellValue('D' . $row_i, $order_info['firstname'] . ' ' . $order_info['lastname'])
                          //  ->setCellValue('F' . $row_i, $order_info['email'])
                            ->setCellValue('E' . $row_i, $payment_method)
                            ->setCellValue('F' . $row_i, $idle_stock)
                            ->setCellValue('G' . $row_i, $href);
                           
                           if($payment_method=='Kapıda Nakit Ödeme'){
                               $objPHPExcel->setActiveSheetIndex(0)->getStyle('E'.$row_i)->applyFromArray($styleArray);
                           }

                           $objPHPExcel->setActiveSheetIndex(0)->getStyle('F'.$row_i)->applyFromArray($styleArray);


                        $row_i++;  
                           }
                       }else{
                       
                       $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $row_i, $item_info)
                            ->setCellValue('B' . $row_i, $order_product['order_id'])
                           // ->setCellValue('C' . $row_i, $order_product['product_id'])
                            ->setCellValue('C' . $row_i, $quantity)
                            ->setCellValue('D' . $row_i, $order_info['firstname'] . ' ' . $order_info['lastname'])
                          //  ->setCellValue('F' . $row_i, $order_info['email'])
                            ->setCellValue('E' . $row_i, $payment_method)
                           ->setCellValue('F' . $row_i, $idle_stock)
                           ->setCellValue('G' . $row_i, $href);
                           
                           if($payment_method=='Kapıda Nakit Ödeme'){
                               $objPHPExcel->setActiveSheetIndex(0)->getStyle('E'.$row_i)->applyFromArray($styleArray);
                           }

                           $objPHPExcel->setActiveSheetIndex(0)->getStyle('F'.$row_i)->applyFromArray($styleArray);


                        $row_i++;
                           
                       }


                    } else {
                        
                        
                         if($quantity>1){
                           for($temp=1;$temp<=$quantity;$temp++){
                             $objPHPExcel2->setActiveSheetIndex(0)
                            ->setCellValue('A' . $row_j, $item_info)
                            ->setCellValue('B' . $row_j, $order_product['order_id'])
                          //  ->setCellValue('C' . $row_j, $order_product['product_id'])
                            ->setCellValue('C' . $row_j, 1)
                            ->setCellValue('D' . $row_j, $order_info['firstname'] . ' ' . $order_info['lastname'])
                         //   ->setCellValue('F' . $row_j, $order_info['email'])
                            ->setCellValue('E' . $row_j, $payment_method)
                            ->setCellValue('F' . $row_j, $href);
                            
                           if($payment_method=='Kapıda Nakit Ödeme'){
                               $objPHPExcel2->setActiveSheetIndex(0)->getStyle('E'.$row_j)->applyFromArray($styleArray);
                           }
                               

                        $row_j++;  
                           }
                       }else{
                       
                       $objPHPExcel2->setActiveSheetIndex(0)
                            ->setCellValue('A' . $row_j, $item_info)
                            ->setCellValue('B' . $row_j, $order_product['order_id'])
                          //  ->setCellValue('C' . $row_j, $order_product['product_id'])
                            ->setCellValue('C' . $row_j, $quantity)
                            ->setCellValue('D' . $row_j, $order_info['firstname'] . ' ' . $order_info['lastname'])
                         //   ->setCellValue('F' . $row_j, $order_info['email'])
                            ->setCellValue('E' . $row_j, $payment_method)
                            ->setCellValue('F' . $row_j, $href);
                            
                           if($payment_method=='Kapıda Nakit Ödeme'){
                               $objPHPExcel2->setActiveSheetIndex(0)->getStyle('E'.$row_j)->applyFromArray($styleArray);
                           }
                               

                        $row_j++;
                           
                       }
                        
                      
                    
                    }

                }

            }

          

                $this->db->query("UPDATE ps_order SET row_color_code = '#ABFF72' WHERE order_id = '" . (int)$order . "' ");

            

        }

        
        $objPHPExcel->getActiveSheet()->setTitle('Simple');

        $objPHPExcel2->getActiveSheet()->setTitle('Simple');


        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel2->setActiveSheetIndex(0);

        //  header('Content-Type: application/vnd.ms-excel');

        // header('Content-Disposition: attachment;filename="' . $file_name . '"');

        // header('Cache-Control: max-age=0');

        //  header('Cache-Control: max-age=1');

        // header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past

        // header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified

        // header('Cache-Control: cache, must-revalidate'); // HTTP/1.1

        // header('Pragma: public'); // HTTP/1.0


        $objWriter1 = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

        //  $objWriter1->save('php://output');

        $objWriter2 = PHPExcel_IOFactory::createWriter($objPHPExcel2, 'Excel5');


        $excel_file1_tmp = tempnam("/tmp", 'tamp_1');

        $objWriter1->save($excel_file1_tmp);


        $excel_file2_tmp = tempnam("/tmp", 'tamp_2');

        $objWriter2->save($excel_file2_tmp);


        $zip_file_tmp = tempnam("/tmp", 'tamp_12');

        $zip = new ZipArchive();

        $zip->open($zip_file_tmp, ZipArchive::OVERWRITE);

        $zip->addFile($excel_file1_tmp, $file_name);

        $zip->addFile($excel_file2_tmp, $file_name2);

        $zip->close();


        //download

        $download_filename = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . '-orders.zip';

        header("Content-Type: application/zip");

        header("Content-Length: " . filesize($zip_file_tmp));

        header("Content-Disposition: attachment; filename=\"" . $download_filename . "\"");

        readfile($zip_file_tmp);

        exit;

    }

    public function orderExcel(){

        $this->load->model('sale/order');

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_order_payment'])) {
            $filter_order_payment = $this->request->get['filter_order_payment'];
        } else {
            $filter_order_payment = null;
        }

        if (isset($this->request->get['filter_payment_method'])) {
            $filter_payment_method = $this->request->get['filter_payment_method'];
        } else {
            $filter_payment_method = null;
        }

        if (isset($this->request->get['filter_order_zone'])) {
            $filter_order_zone = $this->request->get['filter_order_zone'];
        } else {
            $filter_order_zone = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }

        /*if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = '2020-08-01';
        } else {
            $filter_date_added = '2020-08-01';
        }*/


        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['orders'] = array();


        $filter_data = array(
            'filter_order_id' => $filter_order_id,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_customer' => $filter_customer,
            'filter_order_status' => $filter_order_status,
            'filter_order_zone' => $filter_order_zone,
            'filter_order_payment' => $filter_order_payment,
            'filter_payment_method'=> $filter_payment_method,
            'filter_total' => $filter_total,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,

        );


        $this->load->model('sale/order');

        #Melih Zorlu 04/03/2020 Siparisler Excel Download

        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';


        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1','SIPARIS NO')
            ->setCellValue('B1', 'MUSTERI AD-SOYAD')
            ->setCellValue('C1', 'URUN ADET')
            ->setCellValue('D1', 'ARA TOPLAM')
            ->setCellValue('E1', 'TOPLAM TUTAR')
            ->setCellValue('F1', 'KAMPANYA KULLANIMI');


        $orders = $this->model_sale_order->getOrders($filter_data);

        $orders = array_filter (
            $orders,
            function ($order) {
                return  $order['order_status'] != 'İptal Edildi';
            }
        );

        $orders = array_filter (
            $orders,
            function ($orderA) {
                return  $orderA['order_status'] != 'İade Edildi';
            }
        );

        $file_name = $this->config->get('config_name').'-'.@date("Y-m-d-His")."-orders.xls" ;

        $row_i = 2;
        foreach ($orders as $order) {

            $result_orders = $this->model_sale_order->getOrder($order['order_id']);
            $for_coupon = $this->model_sale_order->getOrderTotals($order['order_id']);

            if ($for_coupon[0]['code'] == 'promotion_total'){
                $coupon = $for_coupon[0]['value'];
                $sub_total = $for_coupon[1]['value'];
            }elseif($for_coupon[0]['code'] = 'sub_total'){
                $coupon = 0;
                $sub_total = $for_coupon[0]['value'];
            }

            $order_product_count = count($this->model_sale_order->getOrderProducts($order['order_id']));
            if($result_orders['customer'] == ''){
                $result_orders['customer'] = $result_orders['firstname'].' '.$result_orders['lastname'];
            }
            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . $row_i, $result_orders['order_id'])
                ->setCellValue('B' . $row_i, $result_orders['customer'])
                ->setCellValue('C' . $row_i, $order_product_count)
                ->setCellValue('D' . $row_i, $sub_total)
                ->setCellValue('E' . $row_i, $order['total'])
                ->setCellValue('F' . $row_i, $coupon);

            $row_i++;
        }


        $objPHPExcel->getActiveSheet()->setTitle('Simple');

        $objPHPExcel->setActiveSheetIndex(0);

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$file_name.'"');
        header('Cache-Control: max-age=0');

        header('Cache-Control: max-age=1');

        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;

    }

    public function createInvoiceNo()
    {


        $this->load->language('sale/order');


        $json = array();


        if (!$this->user->hasPermission('modify', 'sale/order')) {

            $json['error'] = $this->language->get('error_permission');

        } elseif (isset($this->request->get['order_id'])) {

            if (isset($this->request->get['order_id'])) {

                $order_id = $this->request->get['order_id'];

            } else {

                $order_id = 0;

            }


            $this->load->model('sale/order');


            $invoice_no = $this->model_sale_order->createInvoiceNo($order_id);


            if ($invoice_no) {

                $json['invoice_no'] = $invoice_no;

            } else {

                $json['error'] = $this->language->get('error_action');

            }

        }


        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));

    }

    public function addReward()
    {

        $this->load->language('sale/order');


        $json = array();


        if (!$this->user->hasPermission('modify', 'sale/order')) {

            $json['error'] = $this->language->get('error_permission');

        } else {

            if (isset($this->request->get['order_id'])) {

                $order_id = $this->request->get['order_id'];

            } else {

                $order_id = 0;

            }


            $this->load->model('sale/order');


            $order_info = $this->model_sale_order->getOrder($order_id);


            if ($order_info && $order_info['customer_id'] && ($order_info['reward'] > 0)) {

                $this->load->model('customer/customer');


                $reward_total = $this->model_customer_customer->getTotalCustomerRewardsByOrderId($order_id);


                if (!$reward_total) {

                    $this->model_customer_customer->addReward($order_info['customer_id'], $this->language->get('text_order_id') . ' #' . $order_id, $order_info['reward'], $order_id);

                }

            }


            $json['success'] = $this->language->get('text_reward_added');

        }


        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));

    }

    public function removeReward()
    {

        $this->load->language('sale/order');


        $json = array();


        if (!$this->user->hasPermission('modify', 'sale/order')) {

            $json['error'] = $this->language->get('error_permission');

        } else {

            if (isset($this->request->get['order_id'])) {

                $order_id = $this->request->get['order_id'];

            } else {

                $order_id = 0;

            }


            $this->load->model('sale/order');


            $order_info = $this->model_sale_order->getOrder($order_id);


            if ($order_info) {

                $this->load->model('customer/customer');


                $this->model_customer_customer->deleteReward($order_id);

            }


            $json['success'] = $this->language->get('text_reward_removed');

        }


        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));

    }

    public function addCommission()
    {

        $this->load->language('sale/order');


        $json = array();


        if (!$this->user->hasPermission('modify', 'sale/order')) {

            $json['error'] = $this->language->get('error_permission');

        } else {

            if (isset($this->request->get['order_id'])) {

                $order_id = $this->request->get['order_id'];

            } else {

                $order_id = 0;

            }


            $this->load->model('sale/order');


            $order_info = $this->model_sale_order->getOrder($order_id);


            if ($order_info) {

                $this->load->model('marketing/affiliate');


                $affiliate_total = $this->model_marketing_affiliate->getTotalTransactionsByOrderId($order_id);


                if (!$affiliate_total) {

                    $this->model_marketing_affiliate->addTransaction($order_info['affiliate_id'], $this->language->get('text_order_id') . ' #' . $order_id, $order_info['commission'], $order_id);

                }

            }


            $json['success'] = $this->language->get('text_commission_added');

        }


        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));

    }

    public function removeCommission()
    {

        $this->load->language('sale/order');


        $json = array();


        if (!$this->user->hasPermission('modify', 'sale/order')) {

            $json['error'] = $this->language->get('error_permission');

        } else {

            if (isset($this->request->get['order_id'])) {

                $order_id = $this->request->get['order_id'];

            } else {

                $order_id = 0;

            }


            $this->load->model('sale/order');


            $order_info = $this->model_sale_order->getOrder($order_id);


            if ($order_info) {

                $this->load->model('marketing/affiliate');


                $this->model_marketing_affiliate->deleteTransaction($order_id);

            }


            $json['success'] = $this->language->get('text_commission_removed');

        }


        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));

    }

    public function history()
    {

        $this->load->language('sale/order');


        $data['text_no_results'] = $this->language->get('text_no_results');


        $data['column_date_added'] = $this->language->get('column_date_added');

        $data['column_status'] = $this->language->get('column_status');

        $data['column_notify'] = $this->language->get('column_notify');

        $data['column_comment'] = $this->language->get('column_comment');


        if (isset($this->request->get['page'])) {

            $page = $this->request->get['page'];

        } else {

            $page = 1;

        }


        $data['histories'] = array();


        $this->load->model('sale/order');


        $results = $this->model_sale_order->getOrderHistories($this->request->get['order_id'], ($page - 1) * 10, 10);


        foreach ($results as $result) {

            $data['histories'][] = array(

                'notify' => $result['notify'] ? $this->language->get('text_yes') : $this->language->get('text_no'),

                'status' => $result['status'],

                'comment' => nl2br($result['comment']),

                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))

            );

        }


        $history_total = $this->model_sale_order->getTotalOrderHistories($this->request->get['order_id']);


        $pagination = new Pagination();

        $pagination->total = $history_total;

        $pagination->page = $page;

        $pagination->limit = 10;

        $pagination->url = $this->url->link('sale/order/history', 'token=' . $this->session->data['token'] . '&order_id=' . $this->request->get['order_id'] . '&page={page}', true);


        $data['pagination'] = $pagination->render();


        $data['results'] = sprintf($this->language->get('text_pagination'), ($history_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($history_total - 10)) ? $history_total : ((($page - 1) * 10) + 10), $history_total, ceil($history_total / 10));


        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_history.tpl')) {

            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_history', $data));

        } else {

            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_history', $data));

        }

    }

    public function invoice()
    {


        $this->load->language('sale/order');


        $data['title'] = $this->language->get('text_invoice');


        if ($this->request->server['HTTPS']) {

            $data['base'] = HTTPS_SERVER;

        } else {

            $data['base'] = HTTP_SERVER;

        }


        $data['direction'] = $this->language->get('direction');

        $data['lang'] = $this->language->get('code');


        $data['text_invoice'] = $this->language->get('text_invoice');

        $data['text_order_detail'] = $this->language->get('text_order_detail');

        $data['text_order_id'] = $this->language->get('text_order_id');

        $data['text_invoice_no'] = $this->language->get('text_invoice_no');

        $data['text_invoice_date'] = $this->language->get('text_invoice_date');

        $data['text_date_added'] = $this->language->get('text_date_added');

        $data['text_telephone'] = $this->language->get('text_telephone');

        $data['text_fax'] = $this->language->get('text_fax');

        $data['text_email'] = $this->language->get('text_email');

        $data['text_website'] = $this->language->get('text_website');

        $data['text_payment_address'] = $this->language->get('text_payment_address');

        $data['text_shipping_address'] = $this->language->get('text_shipping_address');

        $data['text_payment_method'] = $this->language->get('text_payment_method');

        $data['text_shipping_method'] = $this->language->get('text_shipping_method');

        $data['text_comment'] = $this->language->get('text_comment');


        $data['column_product'] = $this->language->get('column_product');

        $data['column_model'] = $this->language->get('column_model');

        $data['column_quantity'] = $this->language->get('column_quantity');

        $data['column_price'] = $this->language->get('column_price');

        $data['column_total'] = $this->language->get('column_total');


        $this->load->model('sale/order');


        $this->load->model('setting/setting');


        $data['orders'] = array();


        $orders = array();


        if (isset($this->request->post['selected'])) {

            $orders = $this->request->post['selected'];

        } elseif (isset($this->request->get['order_id'])) {

            $orders[] = $this->request->get['order_id'];

        }


        foreach ($orders as $order_id) {

            $order_info = $this->model_sale_order->getOrder($order_id);


            if ($order_info) {

                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);


                if ($store_info) {

                    $store_address = $store_info['config_address'];

                    $store_email = $store_info['config_email'];

                    $store_telephone = $store_info['config_telephone'];

                    $store_fax = $store_info['config_fax'];

                } else {

                    $store_address = $this->config->get('config_address');

                    $store_email = $this->config->get('config_email');

                    $store_telephone = $this->config->get('config_telephone');

                    $store_fax = $this->config->get('config_fax');

                }


                if ($order_info['invoice_no']) {

                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];

                } else {

                    $invoice_no = '';

                }


                if ($order_info['payment_address_format']) {

                    $format = $order_info['payment_address_format'];

                } else {

                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';

                }


                $find = array(

                    '{firstname}',

                    '{lastname}',

                    '{company}',

                    '{address_1}',

                    '{address_2}',

                    '{city}',

                    '{postcode}',

                    '{zone}',

                    '{zone_code}',

                    '{country}'

                );


                $replace = array(

                    'firstname' => $order_info['payment_firstname'],

                    'lastname' => $order_info['payment_lastname'],

                    'company' => $order_info['payment_company'],

                    'address_1' => $order_info['payment_address_1'],

                    'address_2' => $order_info['payment_address_2'],

                    'city' => $order_info['payment_city'],

                    'postcode' => $order_info['payment_postcode'],

                    'zone' => $order_info['payment_zone'],

                    'zone_code' => $order_info['payment_zone_code'],

                    'country' => $order_info['payment_country']

                );


                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));


                if ($order_info['shipping_address_format']) {

                    $format = $order_info['shipping_address_format'];

                } else {

                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';

                }


                $find = array(

                    '{firstname}',

                    '{lastname}',

                    '{company}',

                    '{address_1}',

                    '{address_2}',

                    '{city}',

                    '{postcode}',

                    '{zone}',

                    '{zone_code}',

                    '{country}'

                );


                $replace = array(

                    'firstname' => $order_info['shipping_firstname'],

                    'lastname' => $order_info['shipping_lastname'],

                    'company' => $order_info['shipping_company'],

                    'address_1' => $order_info['shipping_address_1'],

                    'address_2' => $order_info['shipping_address_2'],

                    'city' => $order_info['shipping_city'],

                    'postcode' => $order_info['shipping_postcode'],

                    'zone' => $order_info['shipping_zone'],

                    'zone_code' => $order_info['shipping_zone_code'],

                    'country' => $order_info['shipping_country']

                );


                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));


                $this->load->model('tool/upload');


                $product_data = array();


                $products = $this->model_sale_order->getOrderProducts($order_id);


                foreach ($products as $product) {

                    $option_data = array();


                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);


                    foreach ($options as $option) {

                        if ($option['type'] != 'file') {

                            $value = $option['value'];

                        } else {

                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);


                            if ($upload_info) {

                                $value = $upload_info['name'];

                            } else {

                                $value = '';

                            }

                        }


                        $option_data[] = array(

                            'name' => $option['name'],

                            'value' => $value

                        );

                    }


                    $product_data[] = array(

                        'name' => $product['name'],

                        'model' => $product['model'],

                        'option' => $option_data,

                        'quantity' => $product['quantity'],

                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),

                        'total' => $this->currency->format($product['total'] * $product['quantity'], $order_info['currency_code'], $order_info['currency_value'])

                    );

                }


                $voucher_data = array();


                $vouchers = $this->model_sale_order->getOrderVouchers($order_id);


                foreach ($vouchers as $voucher) {

                    $voucher_data[] = array(

                        'description' => $voucher['description'],

                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])

                    );

                }


                $total_data = array();


                $sub_total = 0;

                $shipping = 0;

                $iyzico_checkout_form_fee = 0;

                $sort_order = 3;

                $totals = $this->model_sale_order->getOrderTotals($order_id);

                $tax_flag = 0;

                foreach ($totals as $total) {

                    if ($total['code'] == 'sub_total') {

                        $sub_total = $total['value'];

                        $sort_order = 3;

                    } else if ($total['code'] == 'shipping') {

                        $shipping = $total['value'];

                        $sort_order = 2;

                    } else if ($total['code'] == 'iyzico_checkout_form_fee') {

                        $iyzico_checkout_form_fee = $total['value'];

                        $sort_order = 1;

                    } else if ($total['code'] == 'tax') {

                        if ($tax_flag == 0) {

                            $sort_order = 4;

                            $tax_flag = 1;

                        } else {

                            $sort_order = 5;

                        }

                    } else if ($total['code'] == 'total') {

                        $sort_order = 6;

                    }


                    $total_data[$sort_order] = array(

                        'title' => $total['title'],

                        'code' => $total['code'],

                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),

                        'sort_order' => $sort_order

                    );

                }

                $sub_total += ($shipping + $iyzico_checkout_form_fee);


                foreach ($total_data as $key => $total) {

                    if ($total['code'] == 'sub_total') {

                        $total_data[$key]['text'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);

                    }

                }


                ksort($total_data);

                //var_dump($total_data); die();

                # CustomFields #Bilal 29/04/2019

                $this->load->model('customer/custom_field');

                $custom_fields = $this->model_customer_custom_field->getCustomFields();

                $fields = array();

                foreach ($custom_fields as $key => $c_fields) {

                    if (isset($order_info['shipping_custom_field']['address'])) {

                        $fields[] = array(

                            'name' => $c_fields['name'],

                            'value' => $order_info['shipping_custom_field']['address'][$c_fields['custom_field_id']],

                        );

                    } else {

                        $fields[] = array(

                            'name' => $c_fields['name'],

                            'value' => $order_info['shipping_custom_field'][$c_fields['custom_field_id']],

                        );

                    }

                }

                # CustomFields #Bilal 29/04/2019


                $data['orders'][] = array(

                    'order_id' => $order_id,

                    'invoice_no' => $invoice_no,

                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),

                    'store_name' => $order_info['store_name'],

                    'store_url' => rtrim($order_info['store_url'], '/'),

                    'store_address' => nl2br($store_address),

                    'store_email' => $store_email,

                    'store_telephone' => $store_telephone,

                    'store_fax' => $store_fax,

                    'email' => $order_info['email'],

                    'telephone' => $order_info['telephone'],

                    'shipping_address' => $shipping_address,

                    'shipping_method' => $order_info['shipping_method'],

                    'payment_address' => $payment_address,

                    'payment_method' => $order_info['payment_method'],

                    'product' => $product_data,

                    'voucher' => $voucher_data,

                    'total' => $total_data,

                    'comment' => nl2br($order_info['comment']),

                    'custom_fields' => $fields

                );

            }

        }


        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_invoice.tpl')) {

            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_invoice', $data));

        } else {

            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_invoice', $data));

        }

    }

    public function shipping()
    {


        $this->load->language('sale/order');


        $data['title'] = $this->language->get('text_shipping');


        if ($this->request->server['HTTPS']) {

            $data['base'] = HTTPS_SERVER;

        } else {

            $data['base'] = HTTP_SERVER;

        }


        $data['direction'] = $this->language->get('direction');

        $data['lang'] = $this->language->get('code');


        $data['text_shipping'] = $this->language->get('text_shipping');

        $data['text_picklist'] = $this->language->get('text_picklist');

        $data['text_order_detail'] = $this->language->get('text_order_detail');

        $data['text_order_id'] = $this->language->get('text_order_id');

        $data['text_invoice_no'] = $this->language->get('text_invoice_no');

        $data['text_invoice_date'] = $this->language->get('text_invoice_date');

        $data['text_date_added'] = $this->language->get('text_date_added');

        $data['text_telephone'] = $this->language->get('text_telephone');

        $data['text_fax'] = $this->language->get('text_fax');

        $data['text_email'] = $this->language->get('text_email');

        $data['text_website'] = $this->language->get('text_website');

        $data['text_contact'] = $this->language->get('text_contact');

        $data['text_shipping_address'] = $this->language->get('text_shipping_address');

        $data['text_shipping_method'] = $this->language->get('text_shipping_method');

        $data['text_sku'] = $this->language->get('text_sku');

        $data['text_upc'] = $this->language->get('text_upc');

        $data['text_ean'] = $this->language->get('text_ean');

        $data['text_jan'] = $this->language->get('text_jan');

        $data['text_isbn'] = $this->language->get('text_isbn');

        $data['text_mpn'] = $this->language->get('text_mpn');

        $data['text_comment'] = $this->language->get('text_comment');


        $data['text_payment_method'] = $this->language->get('text_payment_method');


        $data['column_location'] = $this->language->get('column_location');

        $data['column_reference'] = $this->language->get('column_reference');

        $data['column_product'] = $this->language->get('column_product');

        $data['column_weight'] = $this->language->get('column_weight');

        $data['column_model'] = $this->language->get('column_model');

        $data['column_quantity'] = $this->language->get('column_quantity');


        $this->load->model('sale/order');


        $this->load->model('catalog/product');


        $this->load->model('setting/setting');


        $data['orders'] = array();


        $orders = array();


        if (isset($this->request->post['selected'])) {

            $orders = $this->request->post['selected'];

        } elseif (isset($this->request->get['order_id'])) {

            $orders[] = $this->request->get['order_id'];

        }


        foreach ($orders as $order_id) {

            $order_info = $this->model_sale_order->getOrder($order_id);

            // var_dump($order_info); die();

            // Make sure there is a shipping method

            if ($order_info && $order_info['shipping_code']) {

                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);


                if ($store_info) {

                    $store_address = $store_info['config_address'];

                    $store_email = $store_info['config_email'];

                    $store_telephone = $store_info['config_telephone'];

                    $store_fax = $store_info['config_fax'];

                } else {

                    $store_address = $this->config->get('config_address');

                    $store_email = $this->config->get('config_email');

                    $store_telephone = $this->config->get('config_telephone');

                    $store_fax = $this->config->get('config_fax');

                }


                if ($order_info['invoice_no']) {

                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];

                } else {

                    $invoice_no = '';

                }


                if ($order_info['shipping_address_format']) {

                    $format = $order_info['shipping_address_format'];

                } else {

                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';

                }


                $find = array(

                    '{firstname}',

                    '{lastname}',

                    '{company}',

                    '{address_1}',

                    '{address_2}',

                    '{city}',

                    '{postcode}',

                    '{zone}',

                    '{zone_code}',

                    '{country}'

                );


                $replace = array(

                    'firstname' => $order_info['shipping_firstname'],

                    'lastname' => $order_info['shipping_lastname'],

                    'company' => $order_info['shipping_company'],

                    'address_1' => $order_info['shipping_address_1'],

                    'address_2' => $order_info['shipping_address_2'],

                    'city' => $order_info['shipping_city'],

                    'postcode' => $order_info['shipping_postcode'],

                    'zone' => $order_info['shipping_zone'],

                    'zone_code' => $order_info['shipping_zone_code'],

                    'country' => $order_info['shipping_country']

                );


                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));


                $this->load->model('tool/upload');


                $product_data = array();


                $products = $this->model_sale_order->getOrderProducts($order_id);


                foreach ($products as $product) {

                    $option_weight = '';


                    $product_info = $this->model_catalog_product->getProduct($product['product_id']);


                    if ($product_info) {

                        $option_data = array();


                        $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);


                        foreach ($options as $option) {

                            if ($option['type'] != 'file') {

                                $value = $option['value'];

                            } else {

                                $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);


                                if ($upload_info) {

                                    $value = $upload_info['name'];

                                } else {

                                    $value = '';

                                }

                            }


                            $option_data[] = array(

                                'name' => $option['name'],

                                'value' => $value

                            );


                            $product_option_value_info = $this->model_catalog_product->getProductOptionValue($product['product_id'], $option['product_option_value_id']);


                            if ($product_option_value_info) {

                                if ($product_option_value_info['weight_prefix'] == '+') {

                                    $option_weight += $product_option_value_info['weight'];

                                } elseif ($product_option_value_info['weight_prefix'] == '-') {

                                    $option_weight -= $product_option_value_info['weight'];

                                }

                            }

                        }


                        $product_data[] = array(

                            'name' => $product_info['name'],

                            'model' => $product_info['model'],

                            'option' => $option_data,

                            'quantity' => $product['quantity'],

                            'location' => $product_info['location'],

                            'sku' => $product_info['sku'],

                            'upc' => $product_info['upc'],

                            'ean' => $product_info['ean'],

                            'jan' => $product_info['jan'],

                            'isbn' => $product_info['isbn'],

                            'mpn' => $product_info['mpn'],

                            'weight' => $this->weight->format(($product_info['weight'] + $option_weight) * $product['quantity'], $product_info['weight_class_id'], $this->language->get('decimal_point'), $this->language->get('thousand_point'))

                        );

                    }

                }


                $data['orders'][] = array(

                    'order_id' => $order_id,

                    'invoice_no' => $invoice_no,

                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),

                    'store_name' => $order_info['store_name'],

                    'store_url' => rtrim($order_info['store_url'], '/'),

                    'store_address' => nl2br($store_address),

                    'store_email' => $store_email,

                    'store_telephone' => $store_telephone,

                    'store_fax' => $store_fax,

                    'email' => $order_info['email'],

                    'telephone' => $order_info['telephone'],

                    'shipping_address' => $shipping_address,

                    'shipping_method' => $order_info['shipping_method'],

                    'product' => $product_data,

                    'comment' => nl2br($order_info['comment']),

                    'payment_method' => $order_info['payment_method'],

                    'total' => $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']),

                );

            }

        }


        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/order_shipping.tpl')) {

            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/order_shipping', $data));

        } else {

            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/order_shipping', $data));

        }

    }

    public function kargola()
    {

        $json = $this->kargola_trait($this->request->get);
        $json['kargo_barcode'] = $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$json['order_id'], true);

        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));

    }

    public function byexpress()
    {
        $json = array();
        $this->load->model('sale/order');
        $order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);
        $response = $this->senCargo($order_info);

        if(isset($response['status'])){
            $json['status'] = $response['status'];
            $json['by_kargo_barcode'] = $this->url->link('sale/prepared_orders/byexpress_invoice_old', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
            $json['by_kargo_barcode_default'] = $this->url->link('sale/prepared_orders/byexpress_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);
        }else{
            $json['error'] = $response;
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));

    }

    
    public function scottycargo()
    {
        $json = array();
        $this->load->model('sale/order');
        $order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);
        $response = $this->sendScottyCargo($order_info);

        if($response['errors'] != []) {
            $json['error'] = $response['errors'][''][0]['description'];
        } else {
            $json['status'] = '1';
            $json['scottycargo_barcode'] = $this->url->link('sale/prepared_orders/scottycargo_invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$this->request->get['order_id'], true);            
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function kargola_second()
    {

        $json = $this->kargola_trait_second($this->request->get);
        $json['kargo_barcode'] = $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int)$json['order_id'], true);

        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));

    }

    public function takiplinki()
    {

        $this->takiplinki_trait($this->request->get);

    }

    public function changeOrderReturnStatus()
    {

        $json = array();

        if(isset($this->request->get['order_id']) AND isset($this->request->get['order_product_id']) AND isset($this->request->get['token']) AND isset($this->request->get['selected_value'])){

            $selected_value = $this->request->get['selected_value'];
            $order_product_id = $this->request->get['order_product_id'];
            $order_id = $this->request->get['order_id'];
            $product_id = $this->request->get['product_id'];



            $this->load->model('sale/order');
            $this->model_sale_order->changeOrderReturnStatus(array('selected_value' => $selected_value, 'order_product_id' => $order_product_id, 'order_id' => $order_id, 'product_id' => $product_id));

            $json['success'] = "Siparişteki ürün değişikliği yapılmıştır!";

        }else{
            $json['error'] = "Sorun oluştu!";
        }


        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));

    }

    public function delayedOrders()
    {

        $this->load->language('sale/order');
        $this->document->setTitle('Geciken Siparişler');
        $this->load->model('sale/order');
        $this->getList(['delayed_orders' => true]);

    }

    public function base64_to_jpeg() {

        $base64_string = $this->db->query("SELECT * FROM ps_blobs WHERE id = 43 ")->row;
        $client_pattern = $base64_string['client_pattern'];
        $admin_pattern = $base64_string['admin_pattern'];

       // var_dump($client_pattern); die();
        $output_file = 'deneme.jpg';

        // open the output file for writing
        $ifp = fopen( $output_file, 'wb' );

        // split the string on commas
        // $data[ 0 ] == "data:image/png;base64"
        // $data[ 1 ] == <actual base64 string>
        //$data = explode( ',', $client_pattern );

        // we could add validation here with ensuring count( $data ) > 1
        fwrite( $ifp, base64_decode( $admin_pattern ) );

        // clean up the file resource
        fclose( $ifp );

    }

    public function v3_export() {
        error_reporting(0);

        $productIdleStockCounts = [];
        $productIdleStockShown = [];

        $this->load->model('sale/order');
        $this->load->model('catalog/product');
        $this->load->model('catalog/category');
        $this->load->model('catalog/attribute');

        if (!isset($this->request->post['selected'])) {
            echo "Herhangi bir sipariş seçmediniz!";
            die();
        }

        $data['orders'] = array();

        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';

        $objPHPExcel = new PHPExcel();
        $objPHPExcel2 = new PHPExcel();

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', '')
            ->setCellValue('B1', 'Order ID')
            ->setCellValue('C1', 'Adet')
            ->setCellValue('D1', 'Müşteri Adı')
            ->setCellValue('E1', 'Ödeme şekli')
            ->setCellValue('F1', 'Atıl Stok')
            ->setCellValue('G1', '');

        $styleArray = array(
        'font'  => array(
            'bold'  => true,
            'color' => array('rgb' => 'FF0000'),
            'size'  => 8,
            'name'  => 'Verdana'
        ));
    
        $objPHPExcel2->setActiveSheetIndex(0)
            ->setCellValue('A1', '')
            ->setCellValue('B1', 'Order ID')
            ->setCellValue('C1', 'Adet')
            ->setCellValue('D1', 'Müşteri Adı')
            ->setCellValue('E1', 'Ödeme şekli')
            ->setCellValue('F1', '');
            
        $file_name = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . "-orders.xls";
        $file_name2 = $this->config->get('config_name') . '-' . @date("Y-m-d-isH") . "-orders.xls";

        $row_i = 2;
        $row_j = 2;


        foreach ($this->request->post['selected'] as $order) {

            $order_info = $this->model_sale_order->getOrder($order);
            
            /* // 3 => Kargoya verilmek üzere hazırlandı.

            if($order_info['order_status_id'] != 7 && $order_info['order_status_id'] !=5){
                $this->model_sale_order->_addHistoryForExcel($order_info, 3);
            } */

            $order_products = $this->model_sale_order->getOrderProducts($order);

            foreach ($order_products as $order_product) {

                if (strpos($order_product ['model'], 'PY') === false and
                    strpos($order_product ['model'], 'RPD') === false and
                    $order_product['return_status'] != 2 AND
                    $order_info['order_status_id'] != 22 AND
					$order_info['order_status_id'] != 7
                ) {

                    $customer_pattern_data = json_decode($order_product['customer_pattern_data'], true);
                    $case_text = $gradient_text = '';

                    if (isset($customer_pattern_data)) {
                        $case_text = $customer_pattern_data['pattern_text'];
                        $gradient_text = $customer_pattern_data['gradienttext'];
                    }

                    $category_id = $this->model_catalog_category->getCategoryByProductId($order_product['product_id']);

                    $catss = $this->db->query("SELECT * FROM ps_product_to_category WHERE product_id = '" . $order_product['product_id'] . "'");

                    $cats_name = $this->model_catalog_category->getCategory(isset($category_id['category_id']));

                    $product_attrbts = $this->model_catalog_product->getProductAttributes($order_product['product_id']);

                    $idle_stock = $this->db->query("SELECT idle_stock FROM ps_product WHERE product_id=".$order_product['product_id'])->row['idle_stock'];
                    $productIdleStockCounts[$order_product['product_id']] = $idle_stock;

                    if ($productIdleStockCounts[$order_product['product_id']] > 0) {
                        $productIdleStockShown[$order_product['product_id']]++;
                    }
                    $product_att_names = '';

                    foreach ($product_attrbts as $product_attrbt) {
                        $product_att = $this->model_catalog_attribute->getAttribute($product_attrbt['attribute_id']);
                        $product_att_names .= $product_att['name'] . ' ';
                    }

                    if (isset($catss->rows[1]['category_id']))
                        $category_names = $this->model_catalog_category->getCategory($catss->rows[1]['category_id']);


                    //$item_info = $order_product['model'] . ' - ';
                    //$item_info .= ((isset($category_names)) ? str_replace("Telefon Kılıfı", "", $category_names['path']) : '') . ' / ';
                    //$item_info .= ((isset($category_names)) ? str_replace("Telefon Kılıfı", "", $category_names['name']) : '') . '- ';
                    //$item_info .= $product_att_names;

                    $attributes = $this->model_catalog_product->getProductAttributes($order_product['product_id']);
                    $item_info  = $order_product['model'] . ' - ';
                    $item_info .= ((isset($category_names)) ? str_replace("Telefon Kılıfı", "", $category_names['path']) : '') . ' / ';
                    $item_info .= $order_product['name'];
                    $item_info .= (isset($attributes[0])) ? ' - ' . $this->model_catalog_attribute->getAttribute($attributes[0]['attribute_id'])['name'] : "";
                    $item_info .= (isset($attributes[1])) ? ' - ' . $this->model_catalog_attribute->getAttribute($attributes[1]['attribute_id'])['name'] : "";

                    if (!empty($customer_pattern_data['pattern_text'])) {
                        if ($customer_pattern_data['product_type'] == 4) {
                            $href = HTTPS_CATALOG . 'index.php?route=piyerSoft/cases/GenerateDpiImageType4&order_product_id=' . $order_product['order_product_id'] . '&pattern_code=' . $order_product['model'] . '&order_id=' . $order;
                        } else {
                            $href = HTTPS_CATALOG . 'index.php?route=piyerSoft/cases/GenerateDpiImage&order_product_id=' . $order_product['order_product_id'] . '&pattern_code=' . $order_product['model'] . '&order_id=' . $order;
                        }

                    } else if (!empty($order_product['customcase_image'])) {

                        $case_image = $this->db->query("SELECT image FROM ps_product WHERE product_id='" . $order_product['product_id'] . "' ")->row;
                        $case_image=$case_image['image'];
                        $customcase_image =  '';

                        $str = explode('***', $order_product['customcase_image']);

                        $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];

                        $custom_image = explode('***', $order_product['customcase_image']);
                        $custom_image = explode('-', $custom_image[0]);
                        $custom_image_brand = ucfirst($custom_image[0]) . ' / ';

                        unset($custom_image[0]);
                        /*
                        foreach ($custom_image as $c_image) {
                            $custom_image_brand .= ucfirst($c_image);
                        }
                        if ($case_image == '' || !file_exists(DIR_IMAGE . $case_image)) {
                            $item_info = $order_product['model'] . ' - ' . $custom_image_brand;
                        }
                       else {
                            $item_info=  $order_product['model'] . ' - ' .$order_product['name'];
                       }
                       */
                        $href = str_replace('cropped', '', $customcase_image);
                    } else {
                        $href = '';
                    }
                     $quantity=$order_product['quantity'];

                     $payment_method= trim(str_replace('+ ₺7,90','',strip_tags($order_info['payment_method'])));
                    if (($case_text == '' && $gradient_text == '') && empty($order_product['customcase_image'])) {

                        /*
                        //28.09.20 show idle stock as much as total idle stock (ali.a)
                        $idle_stock = '';
                        if ($productIdleStockCounts[$order_product['product_id']] > 0 &&
                            $productIdleStockCounts[$order_product['product_id']] >= $productIdleStockShown[$order_product['product_id']]) {
                            $idle_stock = 'Var';

                            $this->db->query("UPDATE ps_product SET idle_stock=idle_stock-1 WHERE product_id={$order_product['product_id']} AND idle_stock>0 LIMIT 1");

                            $this->db->query("UPDATE ps_order_product SET show_idle_stock=1 WHERE order_product_id={$order_product['order_product_id']} LIMIT 1");
                        }
                        */
                       if($quantity>1){
                           for($temp=1;$temp<=$quantity;$temp++){
                             $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $row_i, $item_info)
                            ->setCellValue('B' . $row_i, $order_product['order_id'])
                            ->setCellValue('C' . $row_i, 1)
                            ->setCellValue('D' . $row_i, $order_info['firstname'] . ' ' . $order_info['lastname'])
                            ->setCellValue('E' . $row_i, $payment_method)
                            ->setCellValue('F' . $row_i, $idle_stock)
                            ->setCellValue('G' . $row_i, $href);
                           
                           if($payment_method=='Kapıda Nakit Ödeme'){
                               $objPHPExcel->setActiveSheetIndex(0)->getStyle('E'.$row_i)->applyFromArray($styleArray);
                           }

                           $objPHPExcel->setActiveSheetIndex(0)->getStyle('F'.$row_i)->applyFromArray($styleArray);
                        $row_i++;  
                           }
                       }else{  
                       $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $row_i, $item_info)
                            ->setCellValue('B' . $row_i, $order_product['order_id'])
                            ->setCellValue('C' . $row_i, $quantity)
                            ->setCellValue('D' . $row_i, $order_info['firstname'] . ' ' . $order_info['lastname'])
                            ->setCellValue('E' . $row_i, $payment_method)
                           ->setCellValue('F' . $row_i, $idle_stock)
                           ->setCellValue('G' . $row_i, $href);
                           
                           if($payment_method=='Kapıda Nakit Ödeme'){
                               $objPHPExcel->setActiveSheetIndex(0)->getStyle('E'.$row_i)->applyFromArray($styleArray);
                           }
                           $objPHPExcel->setActiveSheetIndex(0)->getStyle('F'.$row_i)->applyFromArray($styleArray);
                        $row_i++;
                           
                       }
                    } else {  
                         if($quantity>1){
                           for($temp=1;$temp<=$quantity;$temp++){
                             $objPHPExcel2->setActiveSheetIndex(0)
                            ->setCellValue('A' . $row_j, $item_info)
                            ->setCellValue('B' . $row_j, $order_product['order_id'])
                            ->setCellValue('C' . $row_j, 1)
                            ->setCellValue('D' . $row_j, $order_info['firstname'] . ' ' . $order_info['lastname'])
                            ->setCellValue('E' . $row_j, $payment_method)
                            ->setCellValue('F' . $row_j, $href);
                            
                           if($payment_method=='Kapıda Nakit Ödeme'){
                               $objPHPExcel2->setActiveSheetIndex(0)->getStyle('E'.$row_j)->applyFromArray($styleArray);
                           }      
                        $row_j++;  
                           }
                       }else{ 
                       $objPHPExcel2->setActiveSheetIndex(0)
                            ->setCellValue('A' . $row_j, $item_info)
                            ->setCellValue('B' . $row_j, $order_product['order_id'])
                            ->setCellValue('C' . $row_j, $quantity)
                            ->setCellValue('D' . $row_j, $order_info['firstname'] . ' ' . $order_info['lastname'])
                            ->setCellValue('E' . $row_j, $payment_method)
                            ->setCellValue('F' . $row_j, $href);
                            
                           if($payment_method=='Kapıda Nakit Ödeme'){
                               $objPHPExcel2->setActiveSheetIndex(0)->getStyle('E'.$row_j)->applyFromArray($styleArray);
                           }                             
                        $row_j++;  
                       }            
                    }
                }
            }
                //$this->db->query("UPDATE ps_order SET row_color_code = '#ABFF72' WHERE order_id = '" . (int)$order . "' ");
        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');
        $objPHPExcel2->getActiveSheet()->setTitle('Simple');

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel2->setActiveSheetIndex(0);

        $objWriter1 = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter2 = PHPExcel_IOFactory::createWriter($objPHPExcel2, 'Excel5');

        $excel_file1_tmp = tempnam("/tmp", 'tamp_1');
        $objWriter1->save($excel_file1_tmp);

        $excel_file2_tmp = tempnam("/tmp", 'tamp_2');
        $objWriter2->save($excel_file2_tmp);

        $zip_file_tmp = tempnam("/tmp", 'tamp_12');
        $zip = new ZipArchive();
        $zip->open($zip_file_tmp, ZipArchive::OVERWRITE);
        $zip->addFile($excel_file1_tmp, $file_name);
        $zip->addFile($excel_file2_tmp, $file_name2);
        $zip->close();

        //download
        $download_filename = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . '-orders.zip';
        header("Content-Type: application/zip");
        header("Content-Length: " . filesize($zip_file_tmp));
        header("Content-Disposition: attachment; filename=\"" . $download_filename . "\"");
        readfile($zip_file_tmp);
        exit;

    }




}

