<?php

class ControllerSaleCouponHerbalifeOrder extends Controller {

    use MngArasYurticiTrait;

    private $error = array();

    public function index() {

        $this->load->language('sale/coupon_herbalife_order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');
        $this->getList();
    }

    protected function getList() {
        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_email'])) {
            $filter_email = $this->request->get['filter_email'];
        } else {
            $filter_email = null;
        }


        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }


        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_order_payment'])) {
            $filter_order_payment = $this->request->get['filter_order_payment'];
        } else {
            $filter_order_payment = null;
        }

        if (isset($this->request->get['filter_order_zone'])) {
            $filter_order_zone = $this->request->get['filter_order_zone'];
        } else {
            $filter_order_zone = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {

            $filter_tranfer_order_status = $this->request->get['filter_tranfer_order_status'];
        } else {

            $filter_tranfer_order_status = null;
        }


        if (isset($this->request->get['sort'])) {

            $sort = $this->request->get['sort'];
        } else {

            $sort = 'o.order_id';
        }


        if (isset($this->request->get['order'])) {

            $order = $this->request->get['order'];
        } else {

            $order = 'DESC';
        }


        if (isset($this->request->get['page'])) {

            $page = $this->request->get['page'];
        } else {

            $page = 1;
        }


        $url = '';


        if (isset($this->request->get['filter_order_id'])) {

            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {

            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {

            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {

            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {

            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {

            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {

            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {

            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {

            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {

            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {

            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if (isset($this->request->get['sort'])) {

            $url .= '&sort=' . $this->request->get['sort'];
        }


        if (isset($this->request->get['order'])) {

            $url .= '&order=' . $this->request->get['order'];
        }


        if (isset($this->request->get['page'])) {

            $url .= '&page=' . $this->request->get['page'];
        }


        $data['breadcrumbs'] = array();


        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );


        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . $url, true)
        );




        $row_color_code = null;


        if ($filter_tranfer_order_status == '0') {
            $row_color_code = '';
        } elseif ($filter_tranfer_order_status == '1') {
            $row_color_code = '#ABFF72';
        }

        $data['orders'] = array();


        $filter_data = array(
            'filter_order_id' => $filter_order_id,
            'filter_email' => $filter_email,
            'filter_telephone' => $filter_telephone,
            'filter_customer' => $filter_customer,
            'filter_order_status' => $filter_order_status,
            'filter_order_zone' => $filter_order_zone,
            'filter_order_payment' => $filter_order_payment,
            'filter_total' => $filter_total,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'filter_tranfer_order_status' => $row_color_code,
            'filter_coupon_name' => 'Herbalife',
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $order_total = $this->model_sale_order->getTotalOrders($filter_data);



        $results = $this->model_sale_order->getOrders($filter_data);

        $results = array_filter (
            $results,
            function ($result) {
                $a = '2020-06-30 23:59:59';
                return  strtotime($result['date_added']) > strtotime($a);
            }
        );

        foreach ($results as $result) {

            $order_customer_id = 0;
            $order_customer_id = $this->model_sale_order->getOrderCustomerId($result['order_id']);

            $total_customer_orders = 0;
            if ($order_customer_id > 0) {
                $total_customer_orders = $this->model_sale_order->getTotalOrdersByCustomer($order_customer_id);
            }

            $b =explode(" ",$result['customer']);
            $name = $this->private_str($b[0],1,7);

            if(isset($b[2])){
                $surname = $this->private_str($b[2],1,7);
            }else{
                $surname = '';
            }

            if (isset($b[4])){
                $surname2 = $this->private_str($b[4],1,7);
            }else{
                $surname2 = '';
            }

            $data['orders'][] = array(
                'order_id' => $result['order_id'],
                'coupon_name' => $result['coupon_name'],
                'customer' => $name.' '. $surname . ' '. $surname2,
                'customer_id' => $order_customer_id,
                'total_customer_orders' => $total_customer_orders,
                'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                'total' => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'shipping_code' => $result['shipping_code'],
                'row_color_code' => $result['row_color_code'],

            );
        }


        /*         * *** HARU EDIT **** */
        $data['button_update_status'] = $this->language->get('button_update_status');
        $data['add_comment'] = $this->language->get('add_comment');
        $data['add_notify'] = $this->language->get('add_notify');
        $data['token'] = $this->language->get('token');
        /*         * *** END HARU EDIT **** */

        $data['heading_title'] = $this->language->get('heading_title');


        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_missing'] = $this->language->get('text_missing');
        $data['text_loading'] = $this->language->get('text_loading');


        $data['column_order_id'] = $this->language->get('column_order_id');
        $data['column_coupon_name'] = $this->language->get('column_coupon_name');
        $data['column_customer'] = $this->language->get('column_customer');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_total'] = $this->language->get('column_total');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_date_modified'] = $this->language->get('column_date_modified');
        $data['column_action'] = $this->language->get('column_action');

        $data['entry_order_id'] = $this->language->get('entry_order_id');
        $data['entry_customer'] = $this->language->get('entry_customer');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_total'] = $this->language->get('entry_total');
        $data['entry_date_added'] = $this->language->get('entry_date_added');
        $data['entry_date_modified'] = $this->language->get('entry_date_modified');
        $data['text_tranferred_to_excel'] = $this->language->get('text_tranferred_to_excel');
        $data['text_not_tranferred_to_excel'] = $this->language->get('text_not_tranferred_to_excel');
        $data['entry_tranfer_order_status'] = $this->language->get('entry_tranfer_order_status');

        $data['button_invoice_print'] = $this->language->get('button_invoice_print');
        $data['button_shipping_print'] = $this->language->get('button_shipping_print');
        $data['button_add'] = $this->language->get('button_add');
        $data['button_edit'] = $this->language->get('button_edit');
        $data['button_delete'] = $this->language->get('button_delete');
        $data['button_filter'] = $this->language->get('button_filter');
        $data['button_view'] = $this->language->get('button_view');
        $data['button_ip_add'] = $this->language->get('button_ip_add');


        $this->load->model('localisation/zone');

        $data['zones'] = $this->model_localisation_zone->getZonesByCountryId($this->config->get('config_country_id'));


        $data['shipping_methods'] = $this->model_sale_order->getShippingMethods();


        $data['paymnet_methods'] = $this->model_sale_order->getPaymentMethods();


        $data['token'] = $this->session->data['token'];


        if (isset($this->error['warning'])) {

            $data['error_warning'] = $this->error['warning'];
        } else {

            $data['error_warning'] = '';
        }


        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }


        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }


        if (isset($this->request->get['filter_tranfer_order_status'])) {
            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }


        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }


        $data['sort_order'] = $this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . '&sort=o.order_id' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . '&sort=customer' . $url, true);
        $data['sort_status'] = $this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . '&sort=order_status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . '&sort=o.total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . '&sort=o.date_modified' . $url, true);


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }


        if (isset($this->request->get['filter_email'])) {
            $url .= '&filter_email=' . $this->request->get['filter_email'];
        }


        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . $this->request->get['filter_telephone'];
        }


        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }


        if (isset($this->request->get['filter_order_zone'])) {
            $url .= '&filter_order_zone=' . $this->request->get['filter_order_zone'];
        }


        if (isset($this->request->get['filter_order_payment'])) {
            $url .= '&filter_order_payment=' . $this->request->get['filter_order_payment'];
        }


        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }


        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }


        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['filter_tranfer_order_status'])) {
            $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
        }


        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }


        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }


        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();


        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));


        $data['filter_order_id'] = $filter_order_id;

        $data['filter_email'] = $filter_email;

        $data['filter_telephone'] = $filter_telephone;

        $data['filter_customer'] = $filter_customer;

        $data['filter_order_status'] = $filter_order_status;

        $data['filter_order_zone'] = $filter_order_zone;

        $data['filter_order_payment'] = $filter_order_payment;

        $data['filter_total'] = $filter_total;

        $data['filter_date_added'] = $filter_date_added;

        $data['filter_date_modified'] = $filter_date_modified;

        $data['filter_tranfer_order_status'] = $filter_tranfer_order_status;


        $data['sort'] = $sort;

        $data['order'] = $order;


        $this->load->model('localisation/order_status');


        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


        $data['header'] = $this->load->controller('common/header');

        $data['column_left'] = $this->load->controller('common/column_left');

        $data['footer'] = $this->load->controller('common/footer');


        /* HARUN EDIT */

        // API login

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;


        $this->load->model('user/api');


        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));


        if ($api_info) {


            $data['api_id'] = $api_info['api_id'];

            $data['api_key'] = $api_info['key'];

            $data['api_ip'] = $this->request->server['REMOTE_ADDR'];
        } else {

            $data['api_id'] = '';

            $data['api_key'] = '';

            $data['api_ip'] = '';
        }

        /* END HARUN EDIT */


        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/coupon_herbalife_order_list.tpl')) {

            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/coupon_herbalife_order_list', $data));
        } else {

            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/coupon_herbalife_order_list', $data));
        }
    }

    private function private_str($str, $start, $end){
        $after = mb_substr($str, 0, $start, 'utf8');
        $repeat = str_repeat('*', $end);
        $before = mb_substr($str, ($start + $end), strlen($str), 'utf8');
        return $after.$repeat.$before;
    }

    public function delete() {

        $this->load->language('sale/coupon_herbalife_order');


        $this->document->setTitle($this->language->get('heading_title'));


        $this->load->model('sale/order');


        if (isset($this->request->post['selected']) && $this->validate()) {

            foreach ($this->request->post['selected'] as $order_id) {

                $this->model_sale_order->deleteOrder($order_id);
            }


            $this->session->data['success'] = $this->language->get('text_success');


            $url = '';


            if (isset($this->request->get['filter_order_id'])) {

                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }


            if (isset($this->request->get['filter_customer'])) {

                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }


            if (isset($this->request->get['filter_order_status'])) {

                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }


            if (isset($this->request->get['filter_total'])) {

                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }


            if (isset($this->request->get['filter_date_added'])) {

                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }


            if (isset($this->request->get['filter_date_modified'])) {

                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }


            if (isset($this->request->get['filter_tranfer_order_status'])) {

                $url .= '&filter_tranfer_order_status=' . $this->request->get['filter_tranfer_order_status'];
            }


            $this->response->redirect($this->url->link('sale/coupon_herbalife_order', 'token=' . $this->session->data['token'] . $url, true));
        }


        $this->getList();
    }

    protected function validate() {

        if (!$this->user->hasPermission('modify', 'sale/coupon_herbalife_order')) {

            $this->error['warning'] = $this->language->get('error_permission');
        }


        return !$this->error;
    }

    public function kargola() {


        $json = $this->kargola_trait($this->request->get);


        $json['kargo_barcode'] = $this->url->link('sale/prepared_orders/invoice', 'token=' . $this->session->data['token'] . '&order_id=' . (int) $json['order_id'], true);


        $this->response->addHeader('Content-Type: application/json');

        $this->response->setOutput(json_encode($json));
    }

    public function takiplinki() {

        $this->takiplinki_trait($this->request->get);
    }

}
