<?php
class ControllerSaleBurcuOrders extends Controller {



    private $error = array();

    public function index() {

        error_reporting(0);
        $this->load->language('sale/burcu_orders');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');

        $this->getList();


    }

    protected function getList() {


        $this->load->language('sale/burcu_orders');

        $data['heading_title'] = $this->language->get('heading_title');
        $sql = "SELECT SUM(o.total) * 1.18 AS Result, COUNT(*) AS Amount FROM ps_order o LEFT JOIN ps_order_product od ON(o.order_id = od.order_id) WHERE od.model LIKE '%brc%' AND (o.order_status_id = 5) AND (o.date_added BETWEEN '2020-07-01' AND '2020-07-31') ";

        $query = $this->db->query($sql);

        $sql_june = "SELECT SUM(o.total) * 1.18 AS Result, COUNT(*) AS Amount FROM ps_order o LEFT JOIN ps_order_product od ON(o.order_id = od.order_id) WHERE od.model LIKE '%brc%' AND (o.order_status_id = 5) AND (o.date_added BETWEEN '2020-06-01' AND '2020-06-30') ";

        $query_june = $this->db->query($sql_june);

        $data['july_buy_three_pay_two'] = $this->currency->format((($query->row['Result'] /3) *2), 'TRY', 1.00000000) ;
        $data['july_percent_ten'] = $this->currency->format((((($query->row['Result'] /3) *2)/100)*10), 'TRY', 1.00000000) ;
        $data['july_total_burcu'] =$this->currency->format($query->row['Result'], 'TRY', 1.00000000) ;
        $data['july_total_orders'] = $query->row['Amount'];

        $data['june_buy_three_pay_two'] = $this->currency->format((($query_june->row['Result'] /3) *2), 'TRY', 1.00000000) ;
        $data['june_percent_ten'] = (($data['june_buy_three_pay_two'] /100)*10);
        $data['june_total_burcu'] =$this->currency->format($query_june->row['Result'], 'TRY', 1.00000000) ;
        $data['june_total_orders'] = $query_june->row['Amount'];


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/burcu_order_list.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/burcu_order_list', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/burcu_order_list', $data));
        }

    }
}
