<?php
class ControllerSalePreparedOrders extends Controller {  
  
    private $error = array();

    public function index() {
        
        $this->load->language('sale/prepared_orders');
        
        $this->document->setTitle($this->language->get('heading_title'));
        
        $this->load->model('sale/order');
        
        $this->getList();

    }

    public function getList() {

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . $url, true)
        );

///Buraya islemlerin linki gelcek

        $data['orders'] = array();

        $filter_data = array(
            'filter_order_id' => $filter_order_id,
            'filter_customer' => $filter_customer,
            'filter_order_status' => $filter_order_status,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $order_total = $this->model_sale_order->getTotalOrders($filter_data);
        
        $results = $this->model_sale_order->getOrders($filter_data);

        $data['products'] = array();
        

        foreach ($results as $result) {

            //$orders_id = $this->model_sale_order->getOrder($result['order_id']);
            //var_dump($orders); die();
            $order_customer_id = 0;
            $order_customer_id = $this->model_sale_order->getOrderCustomerId($result['order_id']);
            $order_products = $this->model_sale_order->getOrderProducts($result['order_id']);
            $order_comment = $this->model_sale_order->getOrder($result['order_id']);
             //var_dump($order_products); die();

            $this->load->model('tool/image');
            foreach ($order_products as $order_product) {


                $image = $this->db->query("SELECT * FROM ps_product WHERE product_id='" . $order_product['product_id'] . "' ")->row;
                $image = $this->model_tool_image->resize($image['image'], 100, 100);

                $option_data = array();
                $options = $this->model_sale_order->getOrderOptions($result['order_id'], $order_product['order_product_id']);

                foreach ($options as $option) {
                    if ($option['type'] != 'file') {
                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $option['value'],
                            'type' => $option['type']
                        );
                    } else {
                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                        if ($upload_info) {
                            $option_data[] = array(
                                'name' => $option['name'],
                                'value' => $upload_info['name'],
                                'type' => $option['type'],
                                'href' => $this->url->link('tool/upload/download', 'token=' . $this->session->data['token'] . '&code=' . $upload_info['code'], true)
                            );
                        }
                    }

                    $option_thumb_image = $this->model_sale_order->getOrderOptionValueThumb($option['product_option_value_id'], $order_product['product_id']);
                    $option_thumb_image = $option_thumb_image['option_thumb_image'] ? json_decode($option_thumb_image['option_thumb_image'], true) : false;
                    if ($option_thumb_image[0]) {
                        $image = $this->model_tool_image->resize($option_thumb_image[0], $this->config->get($this->config->get('config_theme') . '_image_cart_width'), $this->config->get($this->config->get('config_theme') . '_image_cart_height'));
                    }
                }




                $case_pattern_image = $this->model_tool_image->resize($order_product['case_order_image'], 100, 100);
                $customcase_image = $case_image = '';
                if ($order_product['customcase_image'] != '') {
                    $str = explode('***', $order_product['customcase_image']);
                    $customcase_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $str[1];
                    $case_image = ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/personal/' . $str[0] . '.png';
                }
                $data['products'][] = array(
                    'order_product_id' => $order_product['order_product_id'],
                    'product_id' => $order_product['product_id'],
                    'name' => $order_product['name'],
                    'image' => $image,
                    'case_order_image' => ($order_product['case_order_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['case_order_image'] : ''),
                    'customer_pattern_data' => $order_product['customer_pattern_data'],
                    'admin_pattern_image' => ($order_product['admin_pattern_image'] != '' ? ($this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG) . 'image/' . $order_product['admin_pattern_image'] : ''),
                    'customcase_image' => $customcase_image,
                    'case_image' => $case_image,
                    'model' => $order_product['model'],
                    'option' => $option_data,
                    'quantity' => $order_product['quantity'],
                    //'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                    //'total' => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),
                    //'href' => "/product/product&product_id=" . $order_product['product_id']
                );
            }//var_dump($data['products']); die();
            foreach($data['products'] as $product_image){

    
                    //var_dump($order_products); die();
                    $total_customer_orders = 0;
                    if ($order_customer_id > 0) {
                        $total_customer_orders = $this->model_sale_order->getTotalOrdersByCustomer($order_customer_id);
                    }
                    $data['orders'][] = array(
                        'order_id' => $result['order_id'],
                        'name' => $product_image['name'],
                        'quantity'=> $product_image['quantity'],
                        'image' => $product_image['image'],
                        'customer' => $result['customer'],
                        'comment' => $order_comment['comment'],
                        'customer_id' => $order_customer_id,
                        'total_customer_orders' => $total_customer_orders,
                        'order_status' => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                        'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                        'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                        'status' => $result['status']
                    );
                }//var_dump($data['orders']); die();
            }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_missing'] = $this->language->get('text_missing');
        $data['text_loading'] = $this->language->get('text_loading');

        $data['column_order_id'] = $this->language->get('column_order_id');
        $data['column_customer'] = $this->language->get('column_customer');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_product_name'] = $this->language->get('column_product_name');
        $data['column_quantity'] = $this->language->get('column_quantity');
        $data['column_comment'] = $this->language->get('column_comment');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_date_modified'] = $this->language->get('column_date_modified');
        $data['column_action'] = $this->language->get('column_action');
        $data['column_image'] = $this->language->get('column_image');

        $data['entry_order_id'] = $this->language->get('entry_order_id');
        $data['entry_customer'] = $this->language->get('entry_customer');
        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_date_added'] = $this->language->get('entry_date_added');
        $data['entry_date_modified'] = $this->language->get('entry_date_modified');

        $data['button_invoice_print'] = $this->language->get('button_invoice_print');
        $data['button_shipping_print'] = $this->language->get('button_shipping_print');
        $data['button_filter'] = $this->language->get('button_filter');
        $data['button_view'] = $this->language->get('button_view');
        $data['button_ip_add'] = $this->language->get('button_ip_add');


        $data['token'] = $this->session->data['token'];
        

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_order'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=o.order_id' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=customer' . $url, true);
        $data['sort_name'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=sort=name' . $url, true);
        $data['sort_quantity'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=sort=quantity' . $url, true);
        $data['sort_comment'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=sort=comment' . $url, true);
        $data['sort_status'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=order_status' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . '&sort=o.date_modified' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/prepared_orders', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['filter_order_id'] = $filter_order_id;
        $data['filter_customer'] = $filter_customer;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_date_added'] = $filter_date_added;
        $data['filter_date_modified'] = $filter_date_modified;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        

        if (file_exists(DIR_LOCAL_TEMPLATE . 'sale/prepared_orders.tpl')) {//var_dump($data['products']); die();
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'sale/prepared_orders', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'sale/prepared_orders', $data));
        }


    }

    public function toggleStatus () {
        $OrderID = $this->request->post ['order_id'];
        if (isset ($OrderID)) $this -> db -> query ("UPDATE ps_order SET status = !(status) WHERE order_id='" . $OrderID . "'");
    }

    public function hideCompleted () {
        $Results = $this -> db -> query ("SELECT customer_id FROM ps_order o GROUP BY o.customer_id HAVING SUM(o.status) = COUNT(*)");
        foreach ($Results -> rows as $Result)
            $this -> db -> query ("UPDATE ps_order SET status = 9 WHERE customer_id = '" . $Result ['customer_id'] . "'");
    }

}