<?php
/**
 * Materyale Göre Satış Raporu Controller Dosyası
 * @author Can Yiğit KAV
 */
class ControllerReportSalesByMaterial extends Controller {
 
	public function index() {
		$this->load->language('report/sales_by_material');

		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}
		
		if (isset($this->request->get['filter_attribute'])) {
			$filter_attribute = $this->request->get['filter_attribute'];
		} else {
			$filter_attribute = "";
		}
		
		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = "";
		}

		if (isset($this->request->get['filter_option'])) {
			$filter_option = $this->request->get['filter_option'];
		} else {
			$filter_option = "";
		}

		if (isset($this->request->get['filter_sort_order'])) {
			$filter_sort_order = $this->request->get['filter_sort_order'];
		} else {
			$filter_sort_order = 0;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_sort_order'])) {
			$url .= '&filter_sort_order=' . $this->request->get['filter_sort_order'];
		}

		if (isset($this->request->get['filter_attribute'])) {
			$url .= '&filter_attribute=' . $this->request->get['filter_attribute'];
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}


		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/sales_by_material', 'token=' . $this->session->data['token'] . $url, true)
		);

		$this->load->model('report/material');

		$data['products'] = array();

		$filter_data = array(
			'filter_date_start'	     => $filter_date_start,
			'filter_date_end'	     => $filter_date_end,
			'filter_order_status_id' => $filter_order_status_id,
			'filter_attribute' 	     => $filter_attribute,
			'filter_category'        => $filter_category,
			'filter_option'          => $filter_option,
			'filter_sort_order' 	 => $filter_sort_order,
			'start'                  => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                  => $this->config->get('config_limit_admin')
		);

		$config_language_id = (int)$this->config->get('config_language_id'); 
		$product_attributes = $this->db->query("select attribute_id,name from ".DB_PREFIX."attribute_description WHERE language_id = $config_language_id"); 
		
		$data['product_attributes'] = array();
		if($product_attributes->num_rows > 0){
			 $data['product_attributes'] = $product_attributes->rows;
		}

		$this->load->model('catalog/category');
		$categories = $this->model_catalog_category->getSubCategories();

		if(isset($categories)) {
			$data['categories'] = $this->model_catalog_category->getSubCategories();
		}

		$results = [];
		$total_q = $total_t = $product_total = 0;

		if(!empty($filter_data['filter_attribute'])) {
			$query_result  = $this->model_report_material->getSalesByMaterial($filter_data);
			$results       = $query_result->rows;
			$product_total = $query_result->num_rows;		
			
			foreach ($results as $result) {
				$result_name = '';
				if(isset($result['name'])) {
					$result_name = $result['name'];
				}	
				
				$category_name = (!empty($filter_data['filter_category'])) ? str_replace("Telefon Kılıfı", "", $result['category_name']) : "";

				$data['products'][] = array(
					'name'       => $result_name,
					'category_name' => $category_name,
					'model'      => $result['model'],
					'quantity'   => $result['quantitys'],
					'total'      => $this->currency->format($result['totals'], $this->config->get('config_currency'))
				);

				$total_q=$total_q+$result['quantitys'];
				$total_t=$total_t+$result['totals'];
			}

			$total_t = $this->currency->format($total_t, $this->config->get('config_currency'));
		}

		$data['heading_title'] = $this->language->get('heading_title');
		$data['total_quantities'] = $total_q;
		$data['total_money'] = $total_t;

		$select_category_text = $this->language->get('text_select_category');
		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = empty($filter_data['filter_attribute']) ? $select_category_text : $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');
		$data['text_all_status'] = $this->language->get('text_all_status');

		$data['column_name'] = $this->language->get('column_name');
		$data['column_model'] = $this->language->get('column_model');
		$data['column_quantity'] = $this->language->get('column_quantity');
		$data['column_total'] = $this->language->get('column_total');

		$data['entry_date_start'] = $this->language->get('entry_date_start');
		$data['entry_date_end'] = $this->language->get('entry_date_end');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_product_model'] = $this->language->get('entry_product_model');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_filter'] = $this->language->get('button_filter');

		$data['token'] = $this->session->data['token'];

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_attribute'])) {
			$url .= '&filter_attribute=' . $this->request->get['filter_attribute'];
		}
		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}

		if (isset($this->request->get['filter_sort_order'])) {
			$url .= '&filter_sort_order=' . $this->request->get['filter_sort_order'];
		}

		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/sales_by_material', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_order_status_id'] = $filter_order_status_id;

		$filter_attribute_data = array();
		if (strpos($filter_attribute, ',') !== false) {
			$filter_attribute_data = explode( ',' , $filter_attribute);
		}else{
			$filter_attribute_data = array($filter_attribute);
		}

		$data['filter_attribute']    = $filter_attribute_data;
	
		$filter_category_data = array();
		if (strpos($filter_category, ',') !== false) {
			$filter_category_data = explode( ',' , $filter_category);
		}else{
			$filter_category_data = array($filter_category);
		}

		$data['filter_category']    = $filter_category_data;

		$data['filter_sort_order'] = $filter_sort_order;

		$this->document->addStyle('https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css');
		$this->document->addScript('https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js');

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		if(file_exists(DIR_LOCAL_TEMPLATE .'report/sales_by_material.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'report/sales_by_material', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'report/sales_by_material', $data));
		}

	}
}