<?php
class ControllerReportSaleReprint extends Controller {

    // sale_reprint

    public function index() {

        $this->load->language('report/sale_reprint');

        $this->document->setTitle($this->language->get('heading_title'));

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date('Y-m-d', strtotime(date('Y') . '-' . date('m') . '-01'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date('Y-m-d');
        }

        if (isset($this->request->get['filter_group'])) {
            $filter_group = $this->request->get['filter_group'];
        } else {
            $filter_group = 'week';
        }

        if (isset($this->request->get['filter_reprint_reason_id'])) {
            $filter_reprint_reason_id = $this->request->get['filter_reprint_reason_id'];
        } else {
            $filter_reprint_reason_id = 0;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_start'])) {
            $url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
        }

        if (isset($this->request->get['filter_date_end'])) {
            $url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
        }

        if (isset($this->request->get['filter_group'])) {
            $url .= '&filter_group=' . $this->request->get['filter_group'];
        }

        if (isset($this->request->get['filter_reprint_reason_id'])) {
            $url .= '&filter_reprint_reason_id=' . $this->request->get['filter_reprint_reason_id'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('report/sale_reprint', 'token=' . $this->session->data['token'] . $url, true)
        );

        $this->load->model('report/reprint');

        $data['reprints'] = array();

        $filter_data = array(
            'filter_date_start'	     => $filter_date_start,
            'filter_date_end'	     => $filter_date_end,
            'filter_group'           => $filter_group,
            'filter_reprint_reason_id' => $filter_reprint_reason_id,
            'start'                  => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'                  => $this->config->get('config_limit_admin')
        );




        $results = $this->model_report_reprint->getReprints($filter_data);

        $reprint_total = count($results);

        foreach ($results as $result) {
            $data['reprints'][] = array(
                'name' => $result['name'],
                'order_id' => $result['order_id'],
                'reprint_reason_name' => $result['reprint_reason_name'],
            );
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['text_all_status'] = $this->language->get('text_all_status');

        $data['column_date_start'] = $this->language->get('column_date_start');
        $data['column_date_end'] = $this->language->get('column_date_end');
        $data['column_orders'] = $this->language->get('column_orders');
        $data['column_products'] = $this->language->get('column_products');
        $data['column_tax'] = $this->language->get('column_tax');
        $data['column_total'] = $this->language->get('column_total');

        $data['entry_date_start'] = $this->language->get('entry_date_start');
        $data['entry_date_end'] = $this->language->get('entry_date_end');
        $data['entry_group'] = $this->language->get('entry_group');
        $data['entry_status'] = $this->language->get('entry_status');

        $data['button_filter'] = $this->language->get('button_filter');

        $data['token'] = $this->session->data['token'];

        $this->load->model('localisation/reprint_reason');

        $data['reprint_reasons'] = $this->model_localisation_reprint_reason->getReprintReasons();

        $data['groups'] = array();

        $data['groups'][] = array(
            'text'  => $this->language->get('text_year'),
            'value' => 'year',
        );

        $data['groups'][] = array(
            'text'  => $this->language->get('text_month'),
            'value' => 'month',
        );

        $data['groups'][] = array(
            'text'  => $this->language->get('text_week'),
            'value' => 'week',
        );

        $data['groups'][] = array(
            'text'  => $this->language->get('text_day'),
            'value' => 'day',
        );

        $url = '';

        if (isset($this->request->get['filter_date_start'])) {
            $url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
        }

        if (isset($this->request->get['filter_date_end'])) {
            $url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
        }

        if (isset($this->request->get['filter_group'])) {
            $url .= '&filter_group=' . $this->request->get['filter_group'];
        }

        if (isset($this->request->get['filter_reprint_reason_id'])) {
            $url .= '&filter_reprint_reason_id=' . $this->request->get['filter_reprint_reason_id'];
        }

        $pagination = new Pagination();
        $pagination->total = $reprint_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('report/sale_reprint', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($reprint_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($reprint_total - $this->config->get('config_limit_admin'))) ? $reprint_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $reprint_total, ceil($reprint_total / $this->config->get('config_limit_admin')));

        $data['filter_date_start'] = $filter_date_start;
        $data['filter_date_end'] = $filter_date_end;
        $data['filter_group'] = $filter_group;
        $data['filter_reprint_reason_id'] = $filter_reprint_reason_id;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE .'report/sale_reprint.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'report/sale_reprint', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'report/sale_reprint', $data));
        }



    }

    public function excelDownload()
    {

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date('Y-m-d', strtotime(date('Y') . '-' . date('m') . '-01'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date('Y-m-d');
        }

        if (isset($this->request->get['filter_group'])) {
            $filter_group = $this->request->get['filter_group'];
        } else {
            $filter_group = 'week';
        }

        if (isset($this->request->get['filter_reprint_reason_id'])) {
            $filter_reprint_reason_id = $this->request->get['filter_reprint_reason_id'];
        } else {
            $filter_reprint_reason_id = 0;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }


        $file_name = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . "-reprint_products_report.xls";


        $this->load->model('report/reprint');

        $data['reprints'] = array();

        $filter_data = array(
            'filter_date_start'	     => $filter_date_start,
            'filter_date_end'	     => $filter_date_end,
            'filter_group'           => $filter_group,
            'filter_reprint_reason_id' => $filter_reprint_reason_id,
            'start'                  => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'                  => $this->config->get('config_limit_admin')
        );


        $results = $this->model_report_reprint->getReprints($filter_data);

        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Order ID')
            ->setCellValue('B1', 'Product Name')
            ->setCellValue('C1', 'Reprint Rerason');

        $row_i = 2;

        foreach ($results as $result){

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . $row_i, $result['order_id'])
                ->setCellValue('B' . $row_i, $result['name'])
                ->setCellValue('C' . $row_i, $result['reprint_reason_name']);

            $row_i++;

        }

        $objPHPExcel->getActiveSheet()->setTitle('Simple');

        $objPHPExcel->setActiveSheetIndex(0);


        $objWriter1 = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');


        $excel_file1_tmp = tempnam("/tmp", 'tamp_1');

        $objWriter1->save($excel_file1_tmp);


        $zip_file_tmp = tempnam("/tmp", 'tamp_12');

        $zip = new ZipArchive();

        $zip->open($zip_file_tmp, ZipArchive::OVERWRITE);

        $zip->addFile($excel_file1_tmp, $file_name);


        $zip->close();


        //download
        $download_filename = $this->config->get('config_name') . '-' . @date("Y-m-d-His") . '-reprint_products_report.zip';

        header("Content-Type: application/zip");
        header("Content-Length: " . filesize($zip_file_tmp));
        header("Content-Disposition: attachment; filename=\"" . $download_filename . "\"");
        readfile($zip_file_tmp);

        exit;

    }
}