<?php
class ControllerReportSaleOrder extends Controller {
	public function index() {
		$this->load->language('report/sale_order');

		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d', strtotime(date('Y') . '-' . date('m') . '-01'));
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}

		if (isset($this->request->get['filter_group'])) {
			$filter_group = $this->request->get['filter_group'];
		} else {
			$filter_group = 'week';
		}

		if (isset($this->request->get['filter_kargo'])) {
			$filter_kargo = $this->request->get['filter_kargo'];
		} else {
			$filter_kargo = '';
		}
		
		if (isset($this->request->get['filter_payment_code'])) {
		$filter_payment_code = $this->request->get['filter_payment_code'];

		} else {
			$filter_payment_code = 0;
		}
		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_group'])) {
			$url .= '&filter_group=' . $this->request->get['filter_group'];
		}

		if (isset($this->request->get['filter_kargo'])) {
			$url .= '&filter_kargo=' . $this->request->get['filter_kargo'];
		}
			if (isset($this->request->get['filter_payment_code'])) {
			$url .= '&filter_payment_code=' . $this->request->get['filter_payment_code'];
		}
	

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/sale_order', 'token=' . $this->session->data['token'] . $url, true)
		);

		$this->load->model('report/sale');

		$data['orders'] = array();


		$filter_data = array(
			'filter_date_start'	     => $filter_date_start,
			'filter_date_end'	     => $filter_date_end,
			'filter_kargo'           => $filter_kargo,
			'filter_payment_code'    => $filter_payment_code,
			'filter_group'           => $filter_group,
			'filter_order_status_id' => $filter_order_status_id,
			'start'                  => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                  => $this->config->get('config_limit_admin')
		);
 
  
		
		$order_total = $this->model_report_sale->getTotalOrders($filter_data);
		$results     = $this->model_report_sale->getOrders($filter_data);
		
		foreach ($results as $result) {

			$data['orders'][] = array(
				'date_start' => date($this->language->get('date_format_short'), strtotime($result['date_start'])),
				'date_end'   => date($this->language->get('date_format_short'), strtotime($result['date_end'])),
				'orders'     => $result['orders'],
				'products'   => $result['products'],
				'payment_code'   => $result['payment_code'],
                'cost_price' => $result['cost_price'],
				'tax'        => $this->currency->format($result['tax'], $this->config->get('config_currency')),
				'total'      => $this->currency->format($result['total'], $this->config->get('config_currency'))
			);
			
		}

		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_byexpresskargo'] = "By Express Kargo";
		$data['text_yurticikargo']   = "Yurtiçi Kargo";
		$data['text_kargo_title']    = "Kargo";
		$data['text_filter_kargo']   = "Kargo";

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');
		$data['text_all_status'] = $this->language->get('text_all_status');

		$data['column_date_start'] = $this->language->get('column_date_start');
		$data['column_date_end'] = $this->language->get('column_date_end');
		$data['column_orders'] = $this->language->get('column_orders');
		$data['column_products'] = $this->language->get('column_products');

        $data['column_cost_price'] = 'Toplam Malityet';#$this->language->get('column_cost_price');
		$data['column_tax'] = $this->language->get('column_tax');
		$data['column_total'] = $this->language->get('column_total');

		$data['entry_date_start'] = $this->language->get('entry_date_start');
		$data['entry_date_end'] = $this->language->get('entry_date_end');
		$data['entry_group'] = $this->language->get('entry_group');
		$data['entry_status'] = $this->language->get('entry_status');

		$data['button_filter'] = $this->language->get('button_filter');

		$data['token'] = $this->session->data['token'];

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$data['groups'] = array();

		$data['groups'][] = array(
			'text'  => $this->language->get('text_year'),
			'value' => 'year',
		);

		$data['groups'][] = array(
			'text'  => $this->language->get('text_month'),
			'value' => 'month',
		);

		$data['groups'][] = array(
			'text'  => $this->language->get('text_week'),
			'value' => 'week',
		);

		$data['groups'][] = array(
			'text'  => $this->language->get('text_day'),
			'value' => 'day',
		);

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_group'])) {
			$url .= '&filter_group=' . $this->request->get['filter_group'];
		}
		
			if (isset($this->request->get['filter_kargo'])) {
			$url .= '&filter_kargo=' . $this->request->get['filter_kargo'];
		}
	

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		$pagination = new Pagination();
		$pagination->total = $order_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/sale_order', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));


		if (isset($this->request->get['filter_kargo'])) {
			$filter_kargo = $this->request->get['filter_kargo'];
		}

		$data['filter_kargo'] = $filter_kargo;

		$data['filter_payment_code'] = $filter_payment_code;
		
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_group'] = $filter_group;
		$data['filter_order_status_id'] = $filter_order_status_id;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		if(file_exists(DIR_LOCAL_TEMPLATE .'report/sale_order.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'report/sale_order', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'report/sale_order', $data));
		}


		
	}

    public function special()
    {

        $all = [];

        $start = '2021-04-01';
        $end = '2021-06-31';

        $designs = $this->db->query("SELECT
	op.model,
	COUNT(op.order_product_id) toplam
FROM
	ps_order o
	LEFT JOIN ps_order_product op ON op.order_id = o.order_id
WHERE
	o.date_added BETWEEN '$start' AND '$end'
	AND model NOT IN ('bnd01', 'ism01', 'cst001', 'rpd01', 'tiny001', 'cst002', 'scr001', 'rpd02', 'PYEK002', 'PY0053', 'winder01')
GROUP BY op.model
ORDER BY toplam DESC
LIMIT 30")->rows;

        foreach ($designs as $design) {

            $renkler = $this->db->query("SELECT
	-- op.model, op.product_id, op.order_id, o.date_added, pa.attribute_id, ad.`name` 
	ad.`name` renk, SUM(op.quantity) sayi
FROM
	ps_order_product op
  LEFT JOIN ps_order o ON o.order_id = op.order_id 
	
	LEFT JOIN ps_product_attribute pa ON pa.product_id=op.product_id
	RIGHT JOIN ps_attribute a ON a.attribute_id=pa.attribute_id AND a.attribute_group_id=13
	LEFT JOIN ps_attribute_description ad ON ad.attribute_id=a.attribute_id
	
	WHERE o.date_added BETWEEN '$start' AND '$end' AND op.model='{$design['model']}'
GROUP BY renk")->rows;

            foreach ($renkler as $renk) {

                $all[$renk['renk']][$design['model']] = $renk['sayi'];

            }


        }



        //echo '<table border="1"><th><td>Design</td><td>Toplam</td>';
        echo 'Design, Toplam,';
        foreach ($all as $_ak => $_av) {
            //echo "<td>$_ak</td>";
            echo "$_ak,";
        }
        //echo '</th>';
        echo ".<br>";

        foreach ($designs as $design) {
            //echo '<tr>';
            //echo '<td>' . $design['model'] . '</td>';
            //echo '<td>' . $design['toplam'] . '</td>';
            echo $design['model'] . ',';
            echo $design['toplam'] . ',';

            foreach ($all as $ak => $av) {
                if (isset($all[$ak][$design['model']])) {
                    //echo "<td>{$all[$ak][$design['model']]}</td>";
                    echo $all[$ak][$design['model']]. ',';
                }
                else {
                    //echo "<td>0</td>";
                    echo "0,";
                }

            }

            //echo '</tr>';
            echo ".<br>";
        }

        //echo '</table>';


    }
}