<?php
class ControllerReportProductSales extends Controller {
	public function index() {
		$this->load->language('report/product_sales');

		//echo $this->request->get['filter_sort_order']; die;


		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = '';
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}

		if (isset($this->request->get['filter_product_model'])) {
			$filter_product_model = $this->request->get['filter_product_model'];
		} else {
			$filter_product_model = "";
		}

		if (isset($this->request->get['filter_sort_order'])) {
			$filter_sort_order = $this->request->get['filter_sort_order'];
		} else {
			$filter_sort_order = 0;
		}

		if (isset($this->request->get['filter_attribute'])) {
			$filter_attribute = $this->request->get['filter_attribute'];
		} else {
			$filter_attribute = "";
		}

		if (isset($this->request->get['filter_option'])) {
			$filter_option = $this->request->get['filter_option'];
		} else {
			$filter_option = "";
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['filter_except_gift'])) {
			$filter_except_gift = $this->request->get['filter_except_gift'];
		} else {
			$filter_except_gift = 0;
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_product_model'])) {
			$url .= '&filter_product_model=' . $this->request->get['filter_product_model'];
		}

		if (isset($this->request->get['filter_sort_order'])) {
			$url .= '&filter_sort_order=' . $this->request->get['filter_sort_order'];
		}
		if (isset($this->request->get['filter_attribute'])) {
			$url .= '&filter_attribute=' . $this->request->get['filter_attribute'];
		}
		if (isset($this->request->get['filter_option'])) {
			$url .= '&filter_option=' . $this->request->get['filter_option'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/product_sales', 'token=' . $this->session->data['token'] . $url, true)
		);

		$this->load->model('report/product');
        $config_language_id = (int)$this->config->get('config_language_id'); 

        $product_attributes = $this->db->query("select attribute_id,name from ".DB_PREFIX."attribute_description WHERE language_id = $config_language_id"); 
        
        $data['product_attributes'] = array();
        if($product_attributes->num_rows > 0){
	         $data['product_attributes'] = $product_attributes->rows;
        }

		$product_option_values = $this->db->query("select option_value_id,name from ".DB_PREFIX."option_value_description WHERE language_id = $config_language_id"); 
        
        $data['product_options'] = array();
        if($product_option_values->num_rows > 0){
	         $data['product_options'] = $product_option_values->rows;
        }

		$data['products'] = array();

		$filter_data = array(
			'filter_date_start'	     => $filter_date_start,
			'filter_date_end'	     => $filter_date_end,
			'filter_order_status_id' => $filter_order_status_id,
			'filter_product_model' 	 => $filter_product_model,
			'filter_sort_order' 	 => $filter_sort_order,
			'filter_except_gift'    => $filter_except_gift,
			'filter_attribute' 	     => $filter_attribute,
			'filter_option'          => $filter_option,
			'start'                  => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                  => $this->config->get('config_limit_admin')
		);

		$product_total = $this->model_report_product->getTotalPurchasedByModel($filter_data);

		$results = $this->model_report_product->getPurchasedByModel($filter_data);

		//echo "<pre>";
		//print_r($results);die;

		$total_q=$total_t=0;
		foreach ($results as $result) {
		
			$result_attribute_name = '';
		    if(isset($result['attribute_name'])){
		        $result_attribute_name = $result['attribute_name'];
		    }
	
			$result_option_value_name = '';
			if(isset($result['option_value_name'])){
		        $result_option_value_name = $result['option_value_name'];
		    }
			
			$data['products'][] = array(
				'attribute_name' => $result_attribute_name,
				'option_value_name' => $result_option_value_name,
				'name'       => $result['name'],
				'model'      => $result['model'],
				'quantity'   => $result['quantity'],
				'total'      => $this->currency->format($result['total'], $this->config->get('config_currency'))
			);
				//$total_q=$total_q+$result['quantity'];
				//$total_t=$total_t+$result['total'];
		}

		$data_total = $this->model_report_product->getDataTotal($filter_data); // sayfalamadan etkilenmeyen toplam datası. -Can 6.12.2021

		$data['heading_title'] = $this->language->get('heading_title');
		$data['total_quantities']= $data_total['quantity'];
		$data['total_money']= $this->currency->format($data_total['total'], $this->config->get('config_currency'));
		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');
		$data['text_all_status'] = $this->language->get('text_all_status');

		$data['column_name'] = $this->language->get('column_name');
		$data['column_model'] = $this->language->get('column_model');
		$data['column_quantity'] = $this->language->get('column_quantity');
		$data['column_total'] = $this->language->get('column_total');

		$data['entry_date_start'] = $this->language->get('entry_date_start');
		$data['entry_date_end'] = $this->language->get('entry_date_end');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_product_model'] = $this->language->get('entry_product_model');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');

		$data['button_filter'] = $this->language->get('button_filter');

		$data['token'] = $this->session->data['token'];

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_attribute'])) {
			$url .= '&filter_attribute=' . $this->request->get['filter_attribute'];
		}
		if (isset($this->request->get['filter_option'])) {
			$url .= '&filter_option=' . $this->request->get['filter_option'];
		}

		if (isset($this->request->get['filter_product_model'])) {
			$url .= '&filter_product_model=' . $this->request->get['filter_product_model'];
		}

		if (isset($this->request->get['filter_sort_order'])) {
			$url .= '&filter_sort_order=' . $this->request->get['filter_sort_order'];
		}
		if (isset($this->request->get['filter_except_gift'])) {
			$url .= '&filter_except_gift=' . $this->request->get['filter_except_gift'];
		}

		$filter_attribute_data = array();
		if (strpos($filter_attribute, ',') !== false) {
			$filter_attribute_data = explode( ',' , $filter_attribute);
		}else{
			$filter_attribute_data = array($filter_attribute);
		}

		$data['filter_attribute']  = $filter_attribute_data;

		$filter_option_data = array();
		if (strpos($filter_option, ',') !== false) {
			$filter_option_data = explode( ',' , $filter_option);
		}else{
			$filter_option_data = array($filter_option);
		}

		$data['filter_option'] = $filter_option_data;

		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/product_sales', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_order_status_id'] = $filter_order_status_id;
		$data['filter_product_model'] = $filter_product_model;
		$data['filter_sort_order'] = $filter_sort_order;
		$data['filter_except_gift'] = $filter_except_gift;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');


		if(file_exists(DIR_LOCAL_TEMPLATE .'report/product_sales.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'report/product_sales', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'report/product_sales', $data));
		}


		
	}
}