<?php
class ControllerReportOrderProduction extends Controller {
	public function index() {
		$this->load->language('report/order_production');

		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date("y-m-d",strtotime("-1 month"));
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = '';
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/order_production', 'token=' . $this->session->data['token'] . $url, true)
		);

		$this->load->model('report/sale');

		$data['orders'] = array();

		$orders = "SELECT order_id, date_added FROM ". DB_PREFIX ."order_history WHERE order_status_id = 1";
		
		if(!empty($filter_date_start) && empty($filter_date_end)) {
			$orders .= " AND date_added >= '" . $filter_date_start. "'";
		}

		if(!empty($filter_date_end) && empty($filter_date_start)) {
			$orders .= " AND date_added <= " . $filter_date_end;
		}

		if(!empty($filter_date_start) && !empty($filter_date_end)) {  
			$orders .= " AND date_added BETWEEN '" . $filter_date_start. "' AND DATE_ADD('" . $filter_date_end ."', INTERVAL 1 DAY)";
		}

		$orders = $this->db->query($orders)->rows;
		$durations = [];
		$selected_orders = [];
		foreach($orders as $order) {
			$order_shipment_status = $this->db->query("SELECT order_id, date_added FROM ". DB_PREFIX ."order_history WHERE order_status_id = 17 AND order_id =  " . $order['order_id'] . " LIMIT 1");
			if(!empty($order_shipment_status->row)) {
				$time_diff = strtotime($order_shipment_status->row['date_added'])-strtotime($order['date_added']);
				if(!in_array($order['order_id'],$selected_orders)) {
					array_push($durations, $time_diff);
					array_push($selected_orders, $order['order_id']);
				}
			}
		}

		$total_duration = 0;
		foreach($durations as $duration) {
			$total_duration += $duration;
		}

		if($total_duration>0) {
			$result = $total_duration/count($durations);
			$result = date("d",$result)-1 . ' Gün ' . date("H",$result) . ' Saat ' . date("i",$result) . ' Dk';			
		} else {
			$result = "Seçilen tarih aralığında kargoya teslim edilmiş sipariş bulunamadı.";
		}

		$data['result'] = [
			'date_start' => $filter_date_start,
			'date_end'   => $filter_date_end,
			'average'      => $result,
			'selected_orders' => $selected_orders
		];
		
		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_list'] = $this->language->get('text_list');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_confirm'] = $this->language->get('text_confirm');
		$data['text_all_status'] = $this->language->get('text_all_status');

		$data['column_date_start'] = $this->language->get('column_date_start');
		$data['column_date_end'] = $this->language->get('column_date_end');
		$data['column_average'] = $this->language->get('column_average');

		$data['entry_date_start'] = $this->language->get('entry_date_start');
		$data['entry_date_end'] = $this->language->get('entry_date_end');
		$data['entry_group'] = $this->language->get('entry_group');
		$data['entry_status'] = $this->language->get('entry_status');

		$data['button_filter'] = $this->language->get('button_filter');

		$data['token'] = $this->session->data['token'];

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}


		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		if(file_exists(DIR_LOCAL_TEMPLATE .'report/order_production.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'report/order_production', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'report/order_production', $data));
		}


		
	}
}