<?php
class ControllerModuledigitcartloadproducts extends Controller {
	private $error = array();
	private $moduleName = 'digitcart_load_products';
	private $moduleFilePath = 'module/digitcart_load_products';
	public function index() {
		$lang = $this->load->language($this->moduleFilePath);
		foreach($lang as $k => $v){
			$data[$k] = $v;
		}
		$this->document->setTitle($this->language->get('heading_title'));
		$this->document->addStyle('view/stylesheet/digitcart_load_products_assest/animate.min.css');
		$this->load->model('setting/setting');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting($this->moduleName, $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->cache->delete('settings');
			$this->response->redirect($this->url->link('module/digitcart_load_products', 'token=' . $this->session->data['token'] . '&type=module', 'SSL'));
		}
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'] . '&type=module', 'SSL')
		);
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link($this->moduleFilePath, 'token=' . $this->session->data['token'], 'SSL')
		);
		$data['action'] = $this->url->link($this->moduleFilePath, 'token=' . $this->session->data['token'], 'SSL');
		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'] . '&type=module', 'SSL');
		$data['all_effects'] = array(
			'Attention Seekers' => array(
				'bounce',
				'flash',
				'pulse',
				'rubberBand',
				'shake',
				'swing',
				'tada',
				'wobble',
				'jello'
			),
			'Bouncing' => array(
				'bounceIn',
				'bounceInDown',
				'bounceInLeft',
				'bounceInRight',
				'bounceInUp'
			),
			'Fading' => array(
				'fadeIn',
				'fadeInDown',
				'fadeInDownBig',
				'fadeInLeft',
				'fadeInLeftBig',
				'fadeInRight',
				'fadeInRightBig',
				'fadeInUp',
				'fadeInUpBig'
			),
			'Flippers' => array(
				'flip',
				'flipInX',
				'flipInY'
			),
			'Lightspeed' => array(
				'lightSpeedIn'
			),
			'Rotating' => array(
				'rotateIn',
				'rotateInDownLeft',
				'rotateInDownRight',
				'rotateInUpLeft',
				'rotateInUpRight'
			),
			'Sliding' => array(
				'slideInUp',
				'slideInDown',
				'slideInLeft',
				'slideInRight'
			),
			'Zoom' => array(
				'zoomIn',
				'zoomInDown',
				'zoomInLeft',
				'zoomInRight',
				'zoomInUp'
			),
			'Specials' => array(
				'rollIn'
			)
		);
		$vars = array(
			'status' => 0,
			'custom_html_status' => 0,
			'pagination_status' => 0,
			'wrap_status' => 0,
			'pages' => array(),
			'effect_status' => 0,
			'effects' => array(),
			'css_class' => '',
			'wrapper_class' => '',
			'selector' => '',
			'pagination_row' => '',
			'animation_delay' => '',
			'loading_icon' => array(),
			'finished_text' => array(),
			'button_load' => 0,
			'disable_mobile' => 0,
			'threshold' => 0,
			'wrap_count' => '',
			'custom_js' => '',
			'load_more_text' => array()
		);
		foreach($vars as $var => $default){
			if (isset($this->request->post[$this->moduleName . '_' . $var])) {
				$data[$this->moduleName . '_' . $var] = $this->request->post[$this->moduleName . '_' . $var];
			} elseif($this->config->get($this->moduleName . '_' . $var)) {
				$data[$this->moduleName . '_' . $var] = $this->config->get($this->moduleName . '_' . $var);
			} else {
				$data[$this->moduleName . '_' . $var] = $default;
			}
		}
		$this->load->model('localisation/language');
		$data['languages'] = $this->model_localisation_language->getLanguages();
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		$this->response->setOutput($this->load->view($this->moduleFilePath, $data));
	}
	protected function validate() {
		if (!$this->user->hasPermission('modify', $this->moduleFilePath)) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		return !$this->error;
	}
}