<?php
class ControllerModuleDescriptionBlock extends Controller {
    private $error = array();
    private $file_name = 'description_block';
    private $file_path = 'module/description_block';
    private $file_model_path = 'model_module_description_block';


    public function install() {
        //$this->load->model('module/description_block');
		//$this->model_module_description_block->install();

        /* // Modul kurulurken, hem burdan hem modelden çalıştırmayı denedim tabloyu oluşturmuyor çalışmadı. phpmyadminden sql girerek oluşturdum tabloyu.
        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "description_block` ( 
            `description_block_id` INT NOT NULL AUTO_INCREMENT , 
            `description_block_name` VARCHAR(255) NOT NULL , 
            `description_block_content` TEXT NOT NULL , 
            `description_block_category` JSON , 
            `description_block_attribute` JSON , 
            `description_block_status` TINYINT(1) ,
            PRIMARY KEY (`description_block_id`)) ENGINE = MyISAM CHARSET=utf8 COLLATE utf8_general_ci;"
        );
        */
    }

    public function index() {
        $this->load->language($this->file_path);
        $data = $this->load->language($this->file_path);
        $data['heading_title'] = $this->language->get('heading_title');
        $this->document->setTitle($data['heading_title']);
        $this->load->model('module/description_block');
        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting($this->file_name, $this->request->post);
            $data['success'] = 'Ayarlar kaydedildi';
            $this->response->redirect($this->url->link($this->file_path, 'token=' . $this->session->data['token'], true));
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => 'Açıklama Blokları',
            'href' => $this->url->link($this->file_path, 'token=' . $this->session->data['token'] . $url, true)
        );

        $data['token'] = $this->session->data['token'];

        $data['add_action'] = $this->url->link($this->file_path.'/add', 'token=' . $this->session->data['token'], true);

        $data['cancel'] = $this->url->link('common/dashboard', 'token=' . $this->session->data['token'] , true);

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['file_name'] = $this->file_name;

        $data['description_blocks'] = [];

        $description_blocks = $this->model_module_description_block->getDescriptionBlocks();

        if($description_blocks) {
            for($i=0;$i<count($description_blocks);$i++) {
                $description_blocks[$i]['edit'] = $this->url->link('module/description_block/edit', 'token=' . $this->session->data['token'] . '&description_block_id=' . $description_blocks[$i]['description_block_id'] . $url, true);
            }
            $data['description_blocks'] = $description_blocks;
        }

/*
        ## ERRORRS ----------------------------------------------------------------------------------------------
        if(isset($this->request->post[$this->file_name . '_account_mode'])){
            $data[$this->file_name . '_account_mode'] = $this->request->post[$this->file_name . '_account_mode'];
        }elseif ($this->config->get($this->file_name . '_account_mode')) {
            $data[$this->file_name . '_account_mode'] = $this->config->get($this->file_name . '_account_mode');
        }else{
            $data[$this->file_name . '_account_mode'] = '';
        }

*/

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE . $this->file_path .'.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->file_path, $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . $this->file_path, $data));
        }

    }
    public function add() {
        $this->load->language($this->file_path);
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->language($this->file_path);

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            /*
            $this->model_setting_setting->editSetting($this->file_name, $this->request->post);
            $data['success'] = 'Ayarlar kaydedildi';*/
            /*
            var_export($this->request->post['description_block_name']);
            var_export($this->request->post['description_block_content']);
            var_export($this->request->post['description_block_category']);
            var_export($this->request->post['description_block_attribute']);
            var_export($this->request->post['description_block_status']);
            */
            $this->load->model('module/description_block');
            $this->model_module_description_block->addDescriptionBlock($this->request->post);
            $this->response->redirect($this->url->link($this->file_path, 'token=' . $this->session->data['token'], true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language($this->file_path);
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->language($this->file_path);

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            /*
            $this->model_setting_setting->editSetting($this->file_name, $this->request->post);
            $data['success'] = 'Ayarlar kaydedildi';*/
            $this->load->model('module/description_block');
            $this->model_module_description_block->editDescriptionBlock($this->request->get['description_block_id'], $this->request->post);
            $this->response->redirect($this->url->link($this->file_path, 'token=' . $this->session->data['token'], true));
        }

        $this->getForm();
    }

    public function getForm() {
        $data = $this->load->language($this->file_path);

        $data['heading_title'] = !isset($this->request->get['description_block_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $this->document->setTitle($data['heading_title']);

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => 'Açıklama Blokları',
            'href' => $this->url->link($this->file_path, 'token=' . $this->session->data['token'] . $url, true)
        );

        $data['cancel'] = $this->url->link($this->file_path, 'token=' . $this->session->data['token'], true);
        $data['action'] = !isset($this->request->get['description_block_id']) ?  $this->url->link($this->file_path.'/add', 'token=' . $this->session->data['token'],  true) :  $this->url->link($this->file_path.'/edit', 'token=' . $this->session->data['token'], true);
        
        $data['token'] = $this->session->data['token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if(isset($this->request->get['description_block_id'])) {
            $data['action'] .= '&description_block_id=' . (int)$this->request->get['description_block_id'];
            $description_block = $this->db->query("SELECT * FROM ". DB_PREFIX . "description_block WHERE description_block_id = '" . (int)$this->request->get['description_block_id'] . "' LIMIT 1")->row;
        }
        $data['description_block_status'] = 1;
        $data['file_name'] = $this->file_name;
        $this->load->model('tool/image');

        $data['description_block_name'] = "";
        if (isset($description_block['description_block_name'])) {
            $data['description_block_name'] = $description_block['description_block_name'];
        }

        $data['description_block_content'] = "";
        if (isset($description_block['description_block_content'])) {
            $data['description_block_content'] = $description_block['description_block_content'];
        }
     
        $data['description_block_category'] = [];
        $this->load->model('catalog/category');
        if (isset($description_block['description_block_category'])) {
            foreach(json_decode($description_block['description_block_category']) as $category_id) {
                $category_info = $this->model_catalog_category->getCategory($category_id);
                if ($category_info) {
                    $data['description_block_category'][] = array(
                        'category_id' => $category_info['category_id'],
                        'name' => ($category_info['path']) ? $category_info['path'] . ' &gt; ' . $category_info['name'] : $category_info['name']
                    );
                }
            }
        }

        $data['description_block_attribute'] = [];
        $this->load->model('catalog/attribute');
        if (isset($description_block['description_block_attribute'])) {
            foreach(json_decode($description_block['description_block_attribute']) as $attribute_id) {
                $attribute_info = $this->model_catalog_attribute->getAttribute($attribute_id);
                if ($attribute_info) {
                    $data['description_block_attribute'][] = array(
                        'attribute_id' => $attribute_info['attribute_id'],
                        'name' => $attribute_info['name']
                    );
                }
            }
        }

        $data['description_block_status'] = "";
        if (isset($description_block['description_block_status'])) {
            $data['description_block_status'] = $description_block['description_block_status'];
        }

        $data['block_categories'] = array();

        $this->load->model('catalog/category');
        if (isset($this->request->post['block_category'])) {
            $categories = $this->request->post['block_category'];
        } elseif (isset($this->request->get['product_id'])) { // DÜZELT BURAYI PRODUCT DEĞİL DESCRIPTION BLOCK KATEGORİLERİ ÇEKİLECEK
            //$categories = $this->model_catalog_product->getProductCategories($this->request->get['product_id']);
        } else {
            $categories = array();
        }

        foreach ($categories as $category_id) {
            $category_info = $this->model_catalog_category->getCategory($category_id);
            if ($category_info) {
                $data['block_categories'][] = array(
                    'category_id' => $category_info['category_id'],
                    'name' => ($category_info['path']) ? $category_info['path'] . ' &gt; ' . $category_info['name'] : $category_info['name']
                );
            }
        }

        $data['block_attributes'] = array();

        $this->load->model('catalog/attribute');
        if (isset($this->request->post['attribute'])) {
            $attributes = $this->request->post['attribute'];
        } elseif (isset($this->request->get['attribute'])) { // DÜZELT BURAYI PRODUCT DEĞİL DESCRIPTION BLOCK KATEGORİLERİ ÇEKİLECEK
            //$attributes = $this->model_catalog_product->getProductAttributes($this->request->get['attribute']);
        } else {
            $attributes = array();
        }

        foreach ($attributes as $attribute_id) {
            $attribute_info = $this->model_catalog_attribute->getAttribute($attribute_id);
            if ($attribute_info) {
                $data['block_attributes'][] = array(
                    'attribute_id' => $attribute_info['attribute_id'],
                    'name' => $attribute_info['name']
                );
            }
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE . $this->file_path .'.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->file_path.'_form', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . $this->file_path.'_form', $data));
        }
        
    }
    public function validate() {
        if (!$this->user->hasPermission('modify', 'module/description_block')) {
                $this->error['warning'] = $this->language->get('error_permission');
        }      
/*
        if(empty($this->request->post['block_description_text'])) {
            $this->error['name'][1] = $this->language->get('error_text');
        }
        */

        /*Validate your form here ...*/
        if (!$this->error) {
                return true;
        } else {
                return false;
        }
    }

/*
    public function uninstall() {
        $this->{$this->file_model_path}->uninstall();
    }
*/
}