<?php
class ControllerExtensionModuleSuratkargo extends Controller {

    private $error = array();
    private $file_name = 'suratkargo';
    private $file_path = 'extension/module/suratkargo';
    private $file_model_path = 'model_extension_module_suratkargo';

    public function __construct($registry)
    {
        parent::__construct($registry);
        $this->load->model($this->file_path);
    }

    public function index()
    {

        $this->load->language($this->file_path);

        $data['heading_title'] = $this->language->get('heading_title');
        $this->document->setTitle($data['heading_title']);

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('suratkargo', $this->request->post);
            $data['success'] = 'Ayarlar kayıt edildi';
            $this->response->redirect($this->url->link($this->file_path, 'token=' . $this->session->data['token'], true));
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => 'Sürat Kargo Ayarları',
            'href' => $this->url->link($this->file_path, 'token=' . $this->session->data['token'] . $url, true)
        );

        $data['action'] = $this->url->link($this->file_path, 'token=' . $this->session->data['token'], true);
        $data['cancel'] = $this->url->link('common/dashboard', 'token=' . $this->session->data['token'] , true);

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }


        // -*---------


        if(isset($this->request->post['suratkargo_user_cari'])){ 
        	$data['suratkargo_user_cari'] = $this->request->post['suratkargo_user_cari'];
        }elseif ($this->config->get('suratkargo_user_cari')) {
        	$data['suratkargo_user_cari'] = $this->config->get('suratkargo_user_cari');
        }else{
        	$data['suratkargo_user_cari'] = '';
        }


        if(isset($this->request->post['suratkargo_user_password'])){
        	$data['suratkargo_user_password'] = $this->request->post['suratkargo_user_password'];
        }elseif ($this->config->get('suratkargo_user_password')) {
        	$data['suratkargo_user_password'] = $this->config->get('suratkargo_user_password');
        }else{
        	$data['suratkargo_user_password'] = '';
        }


        if(isset($this->request->post['suratkargo_webservice_password'])){
        	$data['suratkargo_webservice_password'] = $this->request->post['suratkargo_webservice_password'];
        }elseif ($this->config->get('suratkargo_webservice_password')) {
        	$data['suratkargo_webservice_password'] = $this->config->get('suratkargo_webservice_password');
        }else{
        	$data['suratkargo_webservice_password'] = '';
        }


        if(isset($this->request->post['suratkargo_user_ko_cari'])){
        	$data['suratkargo_user_ko_cari'] = $this->request->post['suratkargo_user_ko_cari'];
        }elseif ($this->config->get('suratkargo_user_ko_cari')) {
        	$data['suratkargo_user_ko_cari'] = $this->config->get('suratkargo_user_ko_cari');
        }else{
        	$data['suratkargo_user_ko_cari'] = '';
        }


        if(isset($this->request->post['suratkargo_user_ko_password'])){
        	$data['suratkargo_user_ko_password'] = $this->request->post['suratkargo_user_ko_password'];
        }elseif ($this->config->get('suratkargo_user_ko_password')) {
        	$data['suratkargo_user_ko_password'] = $this->config->get('suratkargo_user_ko_password');
        }else{
        	$data['suratkargo_user_ko_password'] = '';
        }

        if(isset($this->request->post['suratkargo_webservice_ko_password'])){
        	$data['suratkargo_webservice_ko_password'] = $this->request->post['suratkargo_webservice_ko_password'];
        }elseif ($this->config->get('suratkargo_webservice_ko_password')) {
        	$data['suratkargo_webservice_ko_password'] = $this->config->get('suratkargo_webservice_ko_password');
        }else{
        	$data['suratkargo_webservice_ko_password'] = '';
        }


        if(isset($this->request->post['suratkargo_follow_code'])){
        	$data['suratkargo_follow_code'] = $this->request->post['suratkargo_follow_code'];
        }elseif ($this->config->get('suratkargo_follow_code')) {
        	$data['suratkargo_follow_code'] = $this->config->get('suratkargo_follow_code');
        }else{
        	$data['suratkargo_follow_code'] = '';
        }


        if(isset($this->request->post['suratkargo_follow_ko_code'])){
        	$data['suratkargo_follow_ko_code'] = $this->request->post['suratkargo_follow_ko_code'];
        }elseif ($this->config->get('suratkargo_follow_ko_code')) {
        	$data['suratkargo_follow_ko_code'] = $this->config->get('suratkargo_follow_ko_code');
        }else{
        	$data['suratkargo_follow_ko_code'] = '';
        }

        if(isset($this->request->post['suratkargo_order_status_id'])){
        	$data['suratkargo_order_status_id'] = $this->request->post['suratkargo_order_status_id'];
        }elseif ($this->config->get('suratkargo_order_status_id')) {
        	$data['suratkargo_order_status_id'] = $this->config->get('suratkargo_order_status_id');
        }else{
        	$data['suratkargo_order_status_id'] = '';
        }

        if(isset($this->request->post['suratkargo_status'])){ 
        	$data['suratkargo_status'] = $this->request->post['suratkargo_status'];
        }elseif ($this->config->get('suratkargo_status')) { 
        	$data['suratkargo_status'] = $this->config->get('suratkargo_status');
        }else{
        	$data['suratkargo_status'] = 0;
        }


        if(isset($this->request->post['suratkargo_pays'])){
            $data['suratkargo_pays'] = $this->request->post['suratkargo_pays'];
        }elseif ($this->config->get('suratkargo_pays')) {
            $data['suratkargo_pays'] = $this->config->get('suratkargo_pays');
        }else{
            $data['suratkargo_pays'] = array();
        }

        if(isset($this->request->post['suratkargo_pays_c'])){
            $data['suratkargo_pays_c'] = $this->request->post['suratkargo_pays_c'];
        }elseif ($this->config->get('suratkargo_pays_c')) {
            $data['suratkargo_pays_c'] = $this->config->get('suratkargo_pays_c');
        }else{
            $data['suratkargo_pays_c'] = array();
        }

        $data['payment_methods'] = array();
        $files = glob(DIR_APPLICATION . 'controller/{extension/payment,payment}/*.php', GLOB_BRACE);

        if ($files) {
            foreach ($files as $file) {
                $extension = basename($file, '.php');
                $this->load->language('extension/payment/' . $extension);
                if($this->config->get($extension . '_status')) {
                    $data['payment_methods'][] = array(
                        'name'       => $this->language->get('heading_title'),
                        'code'      => $extension,
                    );
                }
            }
        }

        foreach ($data['payment_methods'] as $key => $value) {
            if ($value['code'] == 'free_checkout') {
                unset($data['payment_methods'][$key]);
            }
        }

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE . $this->file_path .'.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->file_path, $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . $this->file_path, $data));
        }

    }

    protected function validate(){

        if ( !$this->user->hasPermission('modify', $this->file_path) ) {
            $this->error['warning'] = 1;
        }

        return !$this->error;

    }

    public function install() {
        $this->{$this->file_model_path}->install();
    }

    public function uninstall() {
        $this->{$this->file_model_path}->uninstall();
    }


}