<?php

class ControllerExtensionModuleStokuyarisi extends Controller {

    private $error = array();

    public function __construct($registry)
    {
        parent::__construct($registry);
        $this->load->model('extension/module/stokuyarisi');
    }
    
	public function index() {
		$this->load->language('extension/module/stokuyarisi');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('extension/module/stokuyarisi');

        $data['heading_title'] = 'Azalan Stok Uyarısı';
        $this->document->setTitle($data['heading_title']);

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('stokuyarisi', $this->request->post);
            $data['success'] = 'Ayarlar kaydedildi';
            $this->response->redirect($this->url->link('extension/module/stokuyarisi', 'token=' . $this->session->data['token'], true));
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );
        
        $data['breadcrumbs'][] = array(
            'text' => 'Azalan Stok Uyarısı Ayarları',
            'href' => $this->url->link('extension/module/stokuyarisi', 'token=' . $this->session->data['token'], true)
        );

        $data['action'] = $this->url->link('extension/module/stokuyarisi', 'token=' . $this->session->data['token'], true);

        $data['cancel'] = $this->url->link('common/dashboard', 'token=' . $this->session->data['token'] , true);

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        ## ERRORRS ----------------------------------------------------------------------------------------------
        if(isset($this->request->post['stokuyarisi_miktar'])){
            $data['stokuyarisi_miktar'] = $this->request->post['stokuyarisi_miktar'];
        } elseif ($this->config->get('stokuyarisi_miktar')) {
            $data['stokuyarisi_miktar'] = $this->config->get('stokuyarisi_miktar');
        } else {
            $data['stokuyarisi_miktar'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        if(file_exists(DIR_LOCAL_TEMPLATE . 'extension/module/stokuyarisi' .'.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . 'extension/module/stokuyarisi', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'extension/module/stokuyarisi', $data));
        }
	}

	protected function validate() {
        if ( !$this->user->hasPermission('modify','extension/module/stokuyarisi') ) {
            $this->error['warning'] = 1;
        }
        return !$this->error;
    }
	
    public function install() {
        $this->model_extension_module_stokuyarisi->install();
    }
    public function uninstall() {
        $this->model_extension_module_stokuyarisi->uninstall();
    }
}