<?php

class ControllerExtensionModulePintaOpenGraph extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('extension/module/pinta_open_graph');
        $this->load->model('setting/setting');

	$this->document->setTitle($this->language->get('heading_title_modul'));
        $this->document->addScript('view/javascript/admin_open_graph.js');
        $this->document->addStyle('view/stylesheet/admin_open_graph.css');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') &&($this->validationForm())) {

            $this->model_setting_setting->editSetting('pinta_open_graph', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/module/pinta_open_graph', 'token=' . $this->session->data['token'] . '&type=module', true));
        }

        $setting = $this->model_setting_setting->getSetting('pinta_open_graph');

        foreach ($setting as $key => $item) {
            $data[$key] = $item;
        }

        $url = '';
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true)
        );
        
        $data['breadcrumbs'][] = array(
	    'text' => $this->language->get('heading_title_modul'),
            'href' => $this->url->link('extension/module/pinta_open_graph', 'token=' . $this->session->data['token'] . $url, true)
        );

        $data['save'] = $this->url->link('extension/module/pinta_open_graph', 'token=' . $this->session->data['token'] . $url, true);

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['column_enable'] = $this->language->get('column_enable');
        $data['colum_select'] = $this->language->get('colum_select');
        $data['button_save'] = $this->language->get('button_save');
        $data['on'] = $this->language->get('on');
        $data['off'] = $this->language->get('off');
        $data['colum_upload'] = $this->language->get('colum_upload');
        $data['colum_status'] = $this->language->get('colum_status');
        $data['colum_chose_file'] = $this->language->get('colum_chose_file');
        $data['colum_width'] = $this->language->get('colum_width');
        $data['colum_height'] = $this->language->get('colum_height');
        $data['error_file_load'] = $this->language->get('error_file_load');
        $data['colum_status'] = $this->language->get('colum_status');
        $data['column_setting'] = $this->language->get('column_setting');
        $data['text_upload'] = $this->language->get('text_upload');
        $data['colum_currencies'] = $this->language->get('colum_currencies');
        $data['off'] = $this->language->get('off');
        $data['off'] = $this->language->get('off');
        $data['off'] = $this->language->get('off');

        $data['token'] = $this->session->data['token'];

        $this->load->model('localisation/currency');

        $data['currencies'] = $this->curency();

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $pagination = new Pagination();

        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('extension/module/pinta_open_graph', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();
        $data['link'] = '';

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/pinta_open_graph', $data));
    }

private function curency()
{
    $this->load->model('localisation/currency');

       $results = $this->model_localisation_currency->getCurrencies();

    foreach ($results as $result) {
        if ($result['status']) {
            $currencies[] = array(
                'title'        => $result['title'],
                'code'         => $result['code'],
            );
        }
    }
    return $currencies;
}

    protected function validationForm()
    {
        if (!$this->user->hasPermission('modify', 'extension/module/pinta_open_graph')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if($this->request->files["pinta_open_graph_image_default"]['error'] == 0) {
            $f_type=$this->request->files['pinta_open_graph_image_default']['type'];
            if ($f_type == "image/gif" OR $f_type == "image/png" OR $f_type == "image/jpeg" OR $f_type == "image/JPEG" OR $f_type == "image/PNG" OR $f_type == "image/GIF") {
                if ($this->request->files["pinta_open_graph_image_default"]["size"] > 1024 * 20 * 1024) {
                    $this->error['warning'] = $this->language->get('error_file_size');
                }
                elseif (is_uploaded_file($this->request->files["pinta_open_graph_image_default"]["tmp_name"])) {
                    $name = preg_replace("@\s@",'-',$this->request->files["pinta_open_graph_image_default"]["name"]);
                    move_uploaded_file($this->request->files["pinta_open_graph_image_default"]["tmp_name"], DIR_IMAGE . $name);
                    $this->request->post['pinta_open_graph_image_default'] = HTTPS_CATALOG . 'image/' . $name;
                } else {
                    $this->error['warning'] = $this->language->get('error_file_load');
                    return false;
                }
            } else {
                $this->error['warning'] = $this->language->get('error_file_type');
            }
        } else {
            var_dump($this->request->post['pinta_open_graph_image_default_old']);

            $this->request->post["pinta_open_graph_image_default"] = $this->request->post['pinta_open_graph_image_default_old'];
        }
        return !$this->error;
    }

    public function install()
    {
        $this->load->model('setting/setting');

        $settings['pinta_open_graph_status'] = 1;
        $settings['pinta_open_graph_image_default'] = '';
        $settings['pinta_open_graph_width_image'] = 200;
        $settings['pinta_open_graph_height_image'] = 200;
        $settings['pinta_open_graph_curency'] = [];
        $settings['pinta_open_graph_id_application'] = '';

        foreach ($this->curency() as $curency){
            $settings['pinta_open_graph_curency'][$curency['code']] = 0;
        }

        $this->model_setting_setting->editSetting('pinta_open_graph', $settings);
    }

    public function uninstall()
    {
        $this->load->model('setting/setting');

        $this->model_setting_setting->deleteSetting('pinta_open_graph');
    }

    public function configure()
    {
        $this->load->language('extension/extension/module');

        if (!$this->user->hasPermission('modify', 'extension/extension/module')) {
            $this->response->redirect($this->url->link('marketplace/extension', 'token=' . $this->session->data['token'], true));
        } else {
            $this->load->model('setting/extension');
            $this->load->model('user/user_group');

            $this->model_setting_extension->install('module', 'pinta_open_graph');

            $this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'extension/module/pinta_open_graph');
            $this->model_user_user_group->addPermission($this->user->getGroupId(), 'modify', 'extension/module/pinta_open_graph');

            $this->install();

            $this->response->redirect($this->url->link('design/layout', 'token=' . $this->session->data['token'], true));
        }

    }

}

