<?php
class ControllerExtensionModuleGossippastaxdeercase extends Controller {

	public function index() {

		$this->load->language('extension/module/gossippastaxdeercase');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/module/gossippastaxdeercase');


		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');


		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/gossippastaxdeercase', 'token=' . $this->session->data['token'], 'SSL')
		);


		$orders = $this->model_extension_module_gossippastaxdeercase->getOrders();


		$data['total'] = 0;
		$data['counter'] = 0;
		foreach($orders as $order){
			$data['total'] += ($order['price'] + $order['tax']);
			$data['counter']++;
		}


		$data['total'] = $this->currency->format($data['total'], 'TRY', 1);



				
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');


        if(file_exists(DIR_LOCAL_TEMPLATE .'extension/module/gossippastaxdeercase.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'extension/module/gossippastaxdeercase', $data));
        }else{ 
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'extension/module/gossippastaxdeercase', $data));
        }

	}

}
