<?php
class ControllerExtensionModuleFeedCategories extends Controller{

    private $error = array();

    public function index()
    {
        $this->load->language('extension/module/feed_categories');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

            $this->model_setting_setting->editSetting('feedcategories', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('extension/module/feed_categories', 'token=' . $this->session->data['token'] . '&type=module', true));
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_edit'] = $this->language->get('text_edit');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        $data['entry_status'] = $this->language->get('entry_status');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/module/feed_categories', 'token=' . $this->session->data['token'], true)
        );

        $data['action'] = $this->url->link('extension/module/feed_categories', 'token=' . $this->session->data['token'], true);

        $data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true);

        if (isset($this->request->post['feedcategories_status'])) {
            $data['feedcategories_status'] = $this->request->post['feedcategories_status'];
        } else {
            $data['feedcategories_status'] = $this->config->get('feedcategories_status');
        }


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/feed_categories', $data));

    }

    protected function validate() {

        if (!$this->user->hasPermission('modify', 'extension/module/sendgrid')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function autocomplete() {

        $json = array();

        if (isset($this->request->get['filter_name'])) {
            $this->load->model('extension/module/feed_categories');

            $filter_data = array(
                'filter_name' => $this->request->get['filter_name'],
                'sort'        => 'name',
                'order'       => 'ASC',
                'start'       => 0,
                'limit'       => 20
            );

            $results = $this->model_extension_module_feed_categories->getCategories($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'feed_category_id' => $result['feed_category_id'],
                    'name'        => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'))
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['name'];
        }

        array_multisort($sort_order, SORT_ASC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function install()
    {

        $this->load->model('extension/module/feed_categories');
        $this->model_extension_module_feed_categories->install();

    }

    public function uninstall()
    {

        $this->load->model('extension/module/feed_categories');
        $this->model_extension_module_feed_categories->uninstall();

    }


}