<?php
class ControllerExtensionModuleByexpresskargo extends Controller {

    private $error = array();
    private $file_name = 'byexpresskargo';
    private $file_path = 'extension/module/byexpresskargo';
    private $file_model_path = 'model_extension_module_byexpresskargo';

    public function __construct($registry)
    {
        parent::__construct($registry);
        $this->load->model($this->file_path);
    }

    public function index()
    {
        $this->load->language($this->file_path);

        $data['heading_title'] = $this->language->get('heading_title');
        $this->document->setTitle($data['heading_title']);

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting($this->file_name, $this->request->post);
            $data['success'] = 'Ayarlar kayıt edildi';
            $this->response->redirect($this->url->link($this->file_path, 'token=' . $this->session->data['token'], true));
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => 'ByExpress Kargo Ayarları',
            'href' => $this->url->link($this->file_path, 'token=' . $this->session->data['token'] . $url, true)
        );

        $data['action'] = $this->url->link($this->file_path, 'token=' . $this->session->data['token'], true);

        // dışlanan şehirler ekle-sil actionları -Can 9.11.2021
        $data['create_risky_action'] = $this->url->link($this->file_path.DIRECTORY_SEPARATOR .'createRiskyCity', '&token=' . $this->session->data['token'], true);
        $data['delete_risky_action'] = $this->url->link($this->file_path.DIRECTORY_SEPARATOR .'deleteRiskyCity', '&token=' . $this->session->data['token'], true);
        // dışlanan şehirler ekle-sil actionları -Can 9.11.2021

        $data['cancel'] = $this->url->link('common/dashboard', 'token=' . $this->session->data['token'] , true);

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['file_name'] = $this->file_name;

        ## ERRORRS ----------------------------------------------------------------------------------------------
        if(isset($this->request->post[$this->file_name . '_account_mode'])){
            $data[$this->file_name . '_account_mode'] = $this->request->post[$this->file_name . '_account_mode'];
        }elseif ($this->config->get($this->file_name . '_account_mode')) {
            $data[$this->file_name . '_account_mode'] = $this->config->get($this->file_name . '_account_mode');
        }else{
            $data[$this->file_name . '_account_mode'] = '';
        }

        if(isset($this->request->post[$this->file_name . '_username'])){
            $data[$this->file_name . '_username'] = $this->request->post[$this->file_name . '_username'];
        }elseif ($this->config->get($this->file_name . '_username')) {
            $data[$this->file_name . '_username'] = $this->config->get($this->file_name . '_username');
        }else{
            $data[$this->file_name . '_username'] = '';
        }

        if(isset($this->request->post[$this->file_name . '_password'])){
            $data[$this->file_name . '_password'] = $this->request->post[$this->file_name . '_password'];
        }elseif ($this->config->get($this->file_name . '_password')) {
            $data[$this->file_name . '_password'] = $this->config->get($this->file_name . '_password');
        }else{
            $data[$this->file_name . '_password'] = '';
        }

        if(isset($this->request->post[$this->file_name . '_contrat_no'])){
            $data[$this->file_name . '_contrat_no'] = $this->request->post[$this->file_name . '_contrat_no'];
        }elseif ($this->config->get($this->file_name . '_contrat_no')) {
            $data[$this->file_name . '_contrat_no'] = $this->config->get($this->file_name . '_contrat_no');
        }else{
            $data[$this->file_name . '_contrat_no'] = '';
        }

        if(isset($this->request->post[$this->file_name . '_order_status_id'])){
            $data[$this->file_name . '_order_status_id'] = $this->request->post[$this->file_name . '_order_status_id'];
        }elseif ($this->config->get($this->file_name . '_order_status_id')) {
            $data[$this->file_name . '_order_status_id'] = $this->config->get($this->file_name . '_order_status_id');
        }else{
            $data[$this->file_name . '_order_status_id'] = '';
        }

        if(isset($this->request->post[$this->file_name . '_status'])){
            $data[$this->file_name . '_status'] = $this->request->post[$this->file_name . '_status'];
        }elseif ($this->config->get($this->file_name . '_status')) {
            $data[$this->file_name . '_status'] = $this->config->get($this->file_name . '_status');
        }else{
            $data[$this->file_name . '_status'] = 0;
        }

        if(isset($this->request->post[$this->file_name . '_pays'])){
            $data[$this->file_name . '_pays'] = $this->request->post[$this->file_name . '_pays'];
        }elseif ($this->config->get($this->file_name . '_pays')) {
            $data[$this->file_name . '_pays'] = $this->config->get($this->file_name . '_pays');
        }else{
            $data[$this->file_name . '_pays'] = array();
        }

        if(isset($this->request->post[$this->file_name . '_pays_c'])){
            $data[$this->file_name . '_pays_c'] = $this->request->post[$this->file_name . '_pays_c'];
        }elseif ($this->config->get($this->file_name . '_pays_c')) {
            $data[$this->file_name . '_pays_c'] = $this->config->get($this->file_name . '_pays_c');
        }else{
            $data[$this->file_name . '_pays_c'] = array();
        }

        $data['payment_methods'] = array();

        $files = glob(DIR_APPLICATION . 'controller/{extension/payment,payment}/*.php', GLOB_BRACE);

        if ($files) {
            foreach ($files as $file) {
                $extension = basename($file, '.php');
                $this->load->language('extension/payment/' . $extension);
                if($this->config->get($extension . '_status')) {
                    $data['payment_methods'][] = array(
                        'name'       => $this->language->get('heading_title'),
                        'code'      => $extension,
                    );
                }
            }
        }

        $data['risky_cities'] = $this->model_extension_module_byexpresskargo->getRiskyCities(); // Dışlanan Şehirler -Can 9.11.2021

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE . $this->file_path .'.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->file_path, $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . $this->file_path, $data));
        }
    }

    public function createRiskyCity() { // Dışlanacak Şehir Ekleme İşlemi -Can 9.11.2021
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            if(isset($this->request->post['zone']) && isset($this->request->post['city'])) { 
                $risky_data['city'] = $this->request->post['city'];
                $risky_data['zone'] = $this->request->post['zone'];
                $this->model_extension_module_byexpresskargo->createRiskyCity($risky_data);
                $this->response->redirect($this->url->link($this->file_path, 'token=' . $this->session->data['token'], true));
            }
        }
    }  
    
    public function deleteRiskyCity() { // Dışlanan Şehir Silme İşlemi -Can 9.11.2021
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_extension_module_byexpresskargo->deleteRiskyCity($this->request->post['risky_id']);
            $this->response->redirect($this->url->link($this->file_path, 'token=' . $this->session->data['token'], true));
        }
    }

    protected function validate() {
        if ( !$this->user->hasPermission('modify', $this->file_path) ) {
            $this->error['warning'] = 1;
        }
        return !$this->error;
    }

    public function install() {
        $this->{$this->file_model_path}->install();
    }
    public function uninstall() {
        $this->{$this->file_model_path}->uninstall();
    }
}