<?php
class ControllerExtensionModuleAdvReportsSales extends Controller {
	private $error = array(); 

	public function index() {

        $data['adv_current_version'] = '4.4';

		$this->load->language('extension/module/adv_reports_sales');
		
		$this->document->setTitle($this->language->get('heading_title_main'));

		$data['heading_title_main'] = $this->language->get('heading_title_main');
		$data['text_edit'] = $this->language->get('text_edit');
			
		$data['tab_about'] = $this->language->get('tab_about');
		
		$data['text_help_request'] = $this->language->get('text_help_request');
		$data['text_asking_help'] = $this->language->get('text_asking_help');		
		$data['text_terms'] = $this->language->get('text_terms');		
		
		$data['button_documentation'] = $this->language->get('button_documentation');

 		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['button_cancel'] = $this->language->get('button_cancel');

        $data['adv_text_ext_name'] = $this->language->get('adv_text_ext_name');
        $data['adv_ext_name'] = $this->language->get('adv_ext_name');
        $data['adv_ext_short_name'] = 'adv_sales';
        $data['adv_text_instal_version'] = $this->language->get('adv_text_instal_version');
        $data['adv_text_latest_version'] = $this->language->get('adv_text_latest_version');
        $data['adv_ext_version'] = $this->language->get('adv_ext_version');
        $data['adv_ext_type'] = $this->language->get('adv_ext_type');
        $data['adv_text_ext_compatibility'] = $this->language->get('adv_text_ext_compatibility');
        $data['adv_ext_compatibility'] = $this->language->get('adv_ext_compatibility');
        $data['adv_text_ext_url'] = $this->language->get('adv_text_ext_url');
        $data['adv_ext_url'] = 'https://www.opencart.com/index.php?route=marketplace/extension/info&extension_id=3803';
        $data['adv_all_ext_url'] = 'https://www.opencart.com/index.php?route=marketplace/extension&filter_member=cmerry';
        $data['adv_help_url'] = 'http://www.opencartreports.com/documentation/so/index.html#support';
        $data['adv_legal_notice_url'] = 'http://www.opencartreports.com/documentation/so/index.html#terms';
        $data['adv_text_reg_info'] = $this->language->get('adv_text_reg_info');
        $data['adv_text_reg_status'] = $this->language->get('adv_text_reg_status');
        $data['adv_text_ext_support'] = $this->language->get('adv_text_ext_support');
        $data['adv_ext_support'] = $this->language->get('adv_ext_support');
        $data['adv_ext_subject'] = sprintf($this->language->get('adv_ext_subject'), $this->language->get('adv_ext_name'));
        $data['adv_text_ext_legal'] = $this->language->get('adv_text_ext_legal');
        $data['adv_text_copyright'] = $this->language->get('adv_text_copyright');
        $data['auth'] = TRUE;
        $data['ldata'] = FALSE;
        $data['servers'] = '';

        $data['token'] = $this->session->data['token'];
		
  		$data['breadcrumbs'] = array();
		
   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_home'),
			'href'      => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)

   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('text_extension'),
			'href'      => $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true)
   		);

   		$data['breadcrumbs'][] = array(
       		'text'      => $this->language->get('heading_title_main'),
			'href'      => $this->url->link('extension/module/adv_reports_sales', 'token=' . $this->session->data['token'], true)
   		);
		
		$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'] . '&type=module', true);
				
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

        /*$adv_check = curl_init();
        // Set URL to download
        curl_setopt($adv_check, CURLOPT_URL,"http://opencartreports.com/version/adv_so_version.xml");
        // Include header in result? (0 = yes, 1 = no)
        curl_setopt($adv_check, CURLOPT_HEADER, 0);
        // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($adv_check, CURLOPT_RETURNTRANSFER, true);
        // Timeout in seconds
        curl_setopt($adv_check, CURLOPT_TIMEOUT, 10);
        // Download the given URL, and return output
        $adv_output = curl_exec($adv_check);
        // Close the cURL resource, and free system resources
        curl_close($adv_check);
        $adv_analyse = simplexml_load_string($adv_output,null);
        if ($adv_output != FALSE) {
            $data['version'] = $adv_analyse->children()->version;
            $data['whats_new'] = $adv_analyse->children()->whats_new;
        }*/

        $data['version'] = '';
        $data['whats_new'] = '';

        if(file_exists(DIR_LOCAL_TEMPLATE .'extension/module/adv_reports_sales.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'extension/module/adv_reports_sales', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'extension/module/adv_reports_sales', $data));
        }
	}
	
	public function install(){
		// Optimize all tables
		//$alltables = mysql_query("SHOW TABLES");
		//while ($table = mysql_fetch_assoc($alltables)) {
		//	foreach ($table as $db => $tablename) {
		//		mysql_query("OPTIMIZE TABLE `" . $tablename . "`")
		//		or die(mysql_error());
		//	}
		//}
		
		// Add indexes
		$query = $this->db->query("SHOW KEYS FROM ps_order_product WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_order_product ADD INDEX (product_id,total,price,tax,quantity);");
				$this->db->query("ALTER TABLE ps_order_product ADD INDEX (order_id);");
			}	
			
		$query = $this->db->query("SHOW KEYS FROM ps_order_total WHERE Key_name != 'PRIMARY' AND Key_name != 'idx_orders_total_orders_id';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_order_total ADD INDEX (order_id,value,code);");
			}	
			
		$query = $this->db->query("SHOW KEYS FROM ps_order_option WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_order_option ADD INDEX (order_product_id,type,name,product_option_value_id);");
				$this->db->query("ALTER TABLE ps_order_option ADD INDEX (order_id);");
			}
			
		$query = $this->db->query("SHOW KEYS FROM ps_order_history WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_order_history ADD INDEX (order_status_id);");
				$this->db->query("ALTER TABLE ps_order_history ADD INDEX (order_id);");
			}
			
		$query = $this->db->query("SHOW KEYS FROM ps_order WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_order ADD INDEX (customer_id,date_added,total,email,firstname,lastname,payment_company);");
			}

		$query = $this->db->query("SHOW KEYS FROM ps_product WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_product ADD INDEX (product_id,model,sku,manufacturer_id,sort_order,status);");
			}	

		$query = $this->db->query("SHOW KEYS FROM ps_category WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_category ADD INDEX (category_id,parent_id);");
			}	

		$query = $this->db->query("SHOW KEYS FROM ps_option WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_option ADD INDEX (sort_order);");
			}
			
		$query = $this->db->query("SHOW KEYS FROM ps_option_description WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_option_description ADD INDEX (name);");
			}	

		$query = $this->db->query("SHOW KEYS FROM ps_option_value WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_option_value ADD INDEX (option_id,sort_order);");
			}

		$query = $this->db->query("SHOW KEYS FROM ps_option_value_description WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_option_value_description ADD INDEX (option_id,name);");
			}

		$query = $this->db->query("SHOW KEYS FROM ps_product_option WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_product_option ADD INDEX (product_id,option_id);");
			}

		$query = $this->db->query("SHOW KEYS FROM ps_product_option_value WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_product_option_value ADD INDEX (product_id,option_id,option_value_id,quantity,price);");
				$this->db->query("ALTER TABLE ps_product_option_value ADD INDEX (product_option_id);");
			}

		$query = $this->db->query("SHOW KEYS FROM ps_return WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_return ADD INDEX (order_id);");
				$this->db->query("ALTER TABLE ps_return ADD INDEX (product_id);");
			}	

		$query = $this->db->query("SHOW KEYS FROM ps_customer_reward WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_customer_reward ADD INDEX (order_id);");
			}

		$query = $this->db->query("SHOW KEYS FROM ps_customer_activity WHERE Key_name != 'PRIMARY';");
			if (!$query->rows) {
				$this->db->query("ALTER TABLE ps_customer_activity ADD INDEX (customer_id);");
			}
			
		$this->load->model('user/user_group');
		$this->model_user_user_group->addPermission($this->user->getGroupId(), 'access', 'report/adv_sales');
		$this->model_user_user_group->addPermission($this->user->getGroupId(), 'modify', 'report/adv_sales');			
	}
}