<?php

class ControllerExtensionModuleToastMessages extends Controller {

    private $error = array();

    public function index() {
        
        $this->load->language('extension/module/ToastMessages');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $data_arr['ToastMessages'] = $this->request->post;

            $this->model_setting_setting->editSetting('ToastMessages', $data_arr);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_edit'] = $this->language->get('text_edit');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['item2_toast_message'] = $this->language->get('item2_toast_message');
        $data['item2_message_status'] = $this->language->get('item2_message_status');

        $data['item3_toast_message'] = $this->language->get('item3_toast_message');
        $data['item3_message_status'] = $this->language->get('item3_message_status');
        $data['tag_key'] = $this->language->get('tag_key');
        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['login'])) {
            $data['error_login'] = $this->error['login'];
        } else {
            $data['error_login'] = '';
        }

        if (isset($this->error['key'])) {
            $data['error_key'] = $this->error['key'];
        } else {
            $data['error_key'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_ToastMessages'),
            'href' => $this->url->link('extension/module/ToastMessages', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['action'] = $this->url->link('extension/module/ToastMessages', 'token=' . $this->session->data['token'], 'SSL');
        $data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL');

        $field_arr = $this->config->get('ToastMessages');
        $final_array = array();
        
        if(isset($field_arr['message'])){
            for ($i=0; $i < count($field_arr['message']) ; $i++) { 
                $final_array[$i]['no_of_item'] = $field_arr['no_of_item'][$i];
                $final_array[$i]['message'] = $field_arr['message'][$i];
                $final_array[$i]['status'] = $field_arr['status'][$i];
            }
        }
        
        
        //echo "<pre>";
        //print_r($final_array);die;

        $data['field_arr'] = $final_array;
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/ToastMessages', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module/ToastMessages')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

}
