<?php
class ControllerCommonSecurity extends Controller {
    private $error = array();

    public function index() {

        $this->load->language('common/security');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('user/user');

        if(!isset($this->session->data['sc_username'])){
            $this->response->redirect($this->url->link('common/logout', 'token=' . $this->session->data['token'], true));
        }

        $this->model_user_user->addUserSmsCode($this->user->isLogged());

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

            // $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('common/dashboard', 'token=' . $this->session->data['token'] . '', true));
        }

        $data['token'] = $this->session->data['token'];


        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_your_email'] = $this->language->get('text_your_email');
        $data['text_email'] = $this->language->get('text_email');

        $data['entry_sms_pin'] = $this->language->get('entry_sms_pin');

        $data['button_reset'] = $this->language->get('button_reset');
        $data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', '', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('common/security', 'token=' . '', true)
        );

        $data['action'] = $this->url->link('common/security', '', true);
        $data['cancel'] = $this->url->link('common/login', '', true);

        if (isset($this->request->post['sms_pin'])) {
            $data['sms_pin'] = $this->request->post['sms_pin'];
        } else {
            $data['sms_pin'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['footer'] = $this->load->controller('common/footer');


        if(file_exists(DIR_LOCAL_TEMPLATE .'common/login_security.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'common/login_security', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'common/login_security', $data));
        }

    }

    protected function validate() {

        if(!isset($this->request->post['sms_pin'])){
            $this->error['warning'] = $this->language->get('error_sms_pin');
        }else if(!$this->model_user_user->getUserSmsCode($this->user->isLogged(), $this->request->post['sms_pin'])){
            $this->error['warning'] = $this->language->get('error_sms_pin');
        }


        return !$this->error;
    }

    public function security()
    {
        $this->load->language('common/security');
        $this->load->model('user/user');

        $json = array();

        if(isset($this->request->post['sms_pin'])){

            if(!$this->model_user_user->getUserSmsCode($this->user->isLogged(), $this->request->post['sms_pin'])){
                $json['error'] = $this->language->get('error_sms_pin');
            }else{
                $json['redirect'] = $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true);
            }

        }else{
            $json['error'] = $this->language->get('error_post_smspin');
        }

        echo json_encode($json, true);

    }

    public function reset()
    {

        $json = array();

        $this->load->model('user/user');
        $this->model_user_user->smsPinReset();

        $json['redirect'] = $this->response->redirect($this->url->link('common/login', '', true));
        echo json_encode($json, true);

    }



}