<?php
class ControllerCommonHeader extends Controller {
    public function index() {

        if (isset($_GET['cron']) && ($_GET['cron'] == 2)) {
            unset($this->session->data['token']);
            $this->user->logout();
        }


        $data['title'] = $this->document->getTitle();

    
        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['description'] = $this->document->getDescription();
        $data['keywords'] = $this->document->getKeywords();
        $data['links'] = $this->document->getLinks();
        $data['styles'] = $this->document->getStyles();
        $data['scripts'] = $this->document->getScripts();
        $data['lang'] = $this->language->get('code');
        $data['direction'] = $this->language->get('direction');

        $this->load->language('common/header');




        $query = $this->db->query("SHOW COLUMNS FROM " . DB_PREFIX . "product_description WHERE field = 'custom_alt'");
        $exists = 0;
        foreach ($query->rows as $index) {$exists++;}
        if (!$exists) {$this->db->query("ALTER TABLE " . DB_PREFIX . "product_description ADD COLUMN `custom_alt` varchar(255) NULL DEFAULT '';");}


        $query = $this->db->query("SHOW COLUMNS FROM " . DB_PREFIX . "product_description WHERE field = 'custom_h1'");
        $exists = 0;
        foreach ($query->rows as $index) {$exists++;}
        if (!$exists) {$this->db->query("ALTER TABLE " . DB_PREFIX . "product_description ADD COLUMN `custom_h1` varchar(255) NULL DEFAULT '';");}


        $query = $this->db->query("SHOW COLUMNS FROM " . DB_PREFIX . "product_description WHERE field = 'custom_h2'");
        $exists = 0;
        foreach ($query->rows as $index) {$exists++;}
        if (!$exists) {$this->db->query("ALTER TABLE " . DB_PREFIX . "product_description ADD COLUMN `custom_h2` varchar(255) NULL DEFAULT '';");}


        $query = $this->db->query("SHOW COLUMNS FROM " . DB_PREFIX . "product_description WHERE field = 'custom_imgtitle'");
        $exists = 0;
        foreach ($query->rows as $index) {$exists++;}
        if (!$exists) {$this->db->query("ALTER TABLE " . DB_PREFIX . "product_description ADD COLUMN `custom_imgtitle` varchar(255) NULL DEFAULT '';");}





        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_order'] = $this->language->get('text_order');
        $data['text_processing_status'] = $this->language->get('text_processing_status');
        $data['text_complete_status'] = $this->language->get('text_complete_status');
        $data['text_return'] = $this->language->get('text_return');
        $data['text_customer'] = $this->language->get('text_customer');
        $data['text_online'] = $this->language->get('text_online');
        $data['text_approval'] = $this->language->get('text_approval');
        $data['text_product'] = $this->language->get('text_product');
        $data['text_stock'] = $this->language->get('text_stock');
        $data['text_review'] = $this->language->get('text_review');
        $data['text_affiliate'] = $this->language->get('text_affiliate');
        $data['text_store'] = $this->language->get('text_store');
        $data['text_front'] = $this->language->get('text_front');
        $data['text_help'] = $this->language->get('text_help');
        $data['text_homepage'] = $this->language->get('text_homepage');
        $data['text_documentation'] = $this->language->get('text_documentation');
        $data['text_support'] = $this->language->get('text_support');
        $data['text_logged'] = sprintf($this->language->get('text_logged'), $this->user->getUserName());
        $data['text_logout'] = $this->language->get('text_logout');

        $data['theme_path'] = 'http://root.piyersoft.com/ps-panel/';
        $data['logo'] = '//scripts.piyersoft.com/images/logo.png';


        if (!isset($this->request->get['token']) || !isset($this->session->data['token']) || ($this->request->get['token'] != $this->session->data['token'])) {
            $data['logged'] = '';

            $data['home'] = $this->url->link('common/dashboard', '', true);
        } else {
            
            $data['logged'] = true;
            
             
             $this->load->model('user/user');
	      $user_info = $this->model_user_user->getUser($this->user->getId());
	       $data['has_access']=true;
	       if ($user_info && $user_info['user_group_id']=='8') {
	         $data['has_access']=false;
	       }elseif ($user_info && $user_info['user_group_id']=='9'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='10'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='11'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='12'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='13'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='14'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='15'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='16'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='17'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='18'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='19'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='20'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='21'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='22'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='23'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='24'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='25'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='26'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='27'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='28'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='31'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='32'){
               $data['has_access']=false;
           }elseif ($user_info && $user_info['user_group_id']=='33'){
               $data['has_access']=false;
           }
	       

            $data['home'] = $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true);
            $data['logout'] = $this->url->link('common/logout', 'token=' . $this->session->data['token'], true);

            // Orders
            $this->load->model('sale/order');

            // Processing Orders
            $data['processing_status_total'] = $this->model_sale_order->getTotalOrders(array('filter_order_status' => implode(',', $this->config->get('config_processing_status'))));
            $data['processing_status'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&filter_order_status=' . implode(',', $this->config->get('config_processing_status')), true);

            // Complete Orders
            $data['complete_status_total'] = $this->model_sale_order->getTotalOrders(array('filter_order_status' => implode(',', $this->config->get('config_complete_status'))));
            $data['complete_status'] = $this->url->link('sale/order', 'token=' . $this->session->data['token'] . '&filter_order_status=' . implode(',', $this->config->get('config_complete_status')), true);

            // Returns
            $this->load->model('sale/return');

            $return_total = $this->model_sale_return->getTotalReturns(array('filter_return_status_id' => $this->config->get('config_return_status_id')));

            $data['return_total'] = $return_total;

            $data['return'] = $this->url->link('sale/return', 'token=' . $this->session->data['token'], true);

            // Customers
            $this->load->model('report/customer');

            $data['online_total'] = $this->model_report_customer->getTotalCustomersOnline();

            $data['online'] = $this->url->link('report/customer_online', 'token=' . $this->session->data['token'], true);

            $this->load->model('customer/customer');

            $customer_total = $this->model_customer_customer->getTotalCustomers(array('filter_approved' => false));

            $data['customer_total'] = $customer_total;
            $data['customer_approval'] = $this->url->link('customer/customer', 'token=' . $this->session->data['token'] . '&filter_approved=0', true);

            // Products
            $this->load->model('catalog/product');

            $product_total = $this->model_catalog_product->getTotalProducts(array('filter_quantity' => 0));

            $data['product_total'] = $product_total;

            $data['product'] = $this->url->link('catalog/product', 'token=' . $this->session->data['token'] . '&filter_quantity=0', true);

            // Reviews
            $this->load->model('catalog/review');

            $review_total = $this->model_catalog_review->getTotalReviews(array('filter_status' => 0));

            $data['review_total'] = $review_total;

            $data['review'] = $this->url->link('catalog/review', 'token=' . $this->session->data['token'] . '&filter_status=0', true);

            // Affliate
            $this->load->model('marketing/affiliate');

            $affiliate_total = $this->model_marketing_affiliate->getTotalAffiliates(array('filter_approved' => false));

            $data['affiliate_total'] = $affiliate_total;
            $data['affiliate_approval'] = $this->url->link('marketing/affiliate', 'token=' . $this->session->data['token'] . '&filter_approved=1', true);

            $data['alerts'] = $customer_total + $product_total + $review_total + $return_total + $affiliate_total;

            // Online Stores
            $data['stores'] = array();

            $data['stores'][] = array(
                'name' => $this->config->get('config_name'),
                'href' => HTTP_CATALOG
            );

            $data['http_catalog'] = HTTPS_CATALOG;




            $this->load->model('setting/store');
			$this->load->language('extension/payment/iyzico_checkout_form');
            $this->load->model('extension/payment/iyzico_checkout_form');
			$iyzico_version = "2.3.0.3";
            $versionCheck = $this->model_extension_payment_iyzico_checkout_form->versionCheck(VERSION, $iyzico_version);

            if (!empty($versionCheck['version_status']) AND $versionCheck['version_status'] == '1') {
                $data['error_version'] = $this->language->get('entry_error_version');
				$data['alerts']= 1;
				$data['version_status']= $versionCheck['version_status'];
                $data['iyzico_or_text'] = $this->language->get('entry_iyzico_or_text');
                $data['iyzico_update_button'] = $this->language->get('entry_iyzico_update_button');
                $version_updatable = $versionCheck['new_version_id'];
                $data['version_update_link'] = $this->url->link('extension/payment/iyzico_checkout_form/update', 'token=' . $this->session->data['token'] . "&version=$version_updatable", true);
            }else{
				$data['version_status']='0';
			}    
			
            $results = $this->model_setting_store->getStores();

            foreach ($results as $result) {
                $data['stores'][] = array(
                    'name' => $result['name'],
                    'href' => $result['url']
                );
            }
        }

        if(file_exists(DIR_LOCAL_TEMPLATE .'common/header.tpl')){
            return $this->load->view( DIR_LOCAL_TEMPLATE .'common/header', $data);
        }else{ 
            return $this->load->view(DIR_TEMPLATE . 'common/header', $data);
        }

        
    }


}
