<?php

class ControllerCatalogSticker extends Controller
{
    private $error = array();

    public function index()
    {
//        if (isset($this->session->data['user_id'])) {
//            if ($this->session->data['user_id'] === "65") {
//                print_r($this->session->data['user_id']);
//                die;
//            }
//        }
        $this->load->model('catalog/sticker');
        $this->document->setTitle("Etiket Yönetimi");
        $this->getList();
    }

    public function autocompleteEasySearch()
    {
        $json = array();

        if (isset($this->request->get['filter_name'])) {
            $this->load->model('catalog/sticker');

            $filter_data = array(
                'filter_name' => $this->request->get['filter_name'],
                'sort' => 'id',
                'order' => 'DESC',
            );

            $results = $this->model_catalog_sticker->getFilterSticker($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'id' => $result['id'],
                    'model_name' => $result['model_name'],
                    'name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'color' => $result['color'],
                    'text_size' => $result['text_size'],
                    'direction' => $result['direction'],
                    'finished_at' => $result['finished_at'],
                    'edit' => $this->url->link('catalog/sticker/edit', 'token=' . $this->session->data['token'] . '&sticker_id=' . $result['id'], true),
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['name'];
        }

        array_multisort($sort_order, SORT_ASC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function add()
    {
        $this->load->language('catalog/category');

        $this->document->setTitle("Etiket Yönetimi");

        $this->load->model('catalog/sticker');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validated()) {
            $this->model_catalog_sticker->addSticker($this->request->post);
            $success = "Kayıt Başarılı Bir Şekilde Eklendi";
            $this->response->redirect($this->url->link('catalog/sticker', 'token=' . $this->session->data['token'] . '&success=' . $success, true));
        }

        $this->getForm();
    }

    protected function validated()
    {
        if ($this->request->get['route'] !== "catalog/sticker/edit") {
            if (!empty($this->request->post['model_name'])) {
                $sticker = $this->model_catalog_sticker->getStickerModelName($this->request->post['model_name']);
                if (!empty($sticker)) {
                    $this->error['warning'] = "Model Adı Zaten Mevcut!";
                }
            } else {
                $this->error['warning'] = "Model Adı Zorunlu";
            }
        }

        if (!$this->user->hasPermission('modify', 'catalog/sticker')) {
            $this->error['warning'] = "Yetkiniz Yok!";
        }
        return !$this->error;
    }

    public function delete()
    {
        $this->load->model('catalog/sticker');
        $this->model_catalog_sticker->deleteSticker($this->request->post['selected']);
        $success = "Silme İşlemi Başarılı!";
        $this->response->redirect($this->url->link('catalog/sticker', 'token=' . $this->session->data['token'] . '&success=' . $success, true));

    }

    protected function getList()
    {
        $data = array();
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['heading_title'] = "Etiket Yönetimi";
        $data['text_list'] = "Etiket Yönetimi Listesi";
        $data['error_warning'] = '';
        $data['success'] = '';
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => "Etiket Yönetimi",
            'href' => $this->url->link('catalog/sticker', 'token=' . $this->session->data['token'], true)
        );
        $data['token'] = $this->session->data['token'];
        $data['add'] = $this->url->link('catalog/sticker/add', 'token=' . $this->session->data['token'], true);
        $data['delete'] = $this->url->link('catalog/sticker/delete', 'token=' . $this->session->data['token'], true);
        $data['edit'] = $this->url->link('catalog/sticker/edit', 'token=' . $this->session->data['token'], true);

        $data['stickers'] = $this->model_catalog_sticker->getStickers();


        if (file_exists(DIR_LOCAL_TEMPLATE . 'catalog/sticker.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'catalog/sticker', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/sticker', $data));
        }
    }

    protected function getForm()
    {
        $data['heading_title'] = "Etiket Yönetimi";
        $data['text_form'] = !isset($this->request->get['sticker_id']) ? "Etiket Ekle" : "Etiket Düzenle";
        $data['button_save'] = "Kaydet";


        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => "Etiket Yönetimi",
            'href' => $this->url->link('catalog/sticker', 'token=' . $this->session->data['token'], true)
        );

        if (!isset($this->request->get['sticker_id'])) {
            $data['action'] = $this->url->link('catalog/sticker/add', 'token=' . $this->session->data['token'], true);
        } else {
            $data['action'] = $this->url->link('catalog/sticker/edit', 'token=' . $this->session->data['token'] . '&sticker_id=' . $this->request->get['sticker_id'], true);
            $data['sticker'] = $this->model_catalog_sticker->getStickerById($this->request->get['sticker_id']);
        }
        if (isset($data['sticker'])) {
            $data['image'] = $data['sticker']['image'];
        } else {
            $data['image'] = '';
        }

        $this->load->model('tool/image');
        if (isset($data['image']) && is_file(DIR_IMAGE . $data['image'])) {
            $data['thumb'] = $this->model_tool_image->resize($data['image'], 100, 100);
        } else {
            $data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
        }

        $data['cancel'] = $this->url->link('catalog/sticker', 'token=' . $this->session->data['token'], true);

        $data['token'] = $this->session->data['token'];
        $this->load->model('localisation/language');
        $data['languages'] = $this->model_localisation_language->getLanguages();


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if (file_exists(DIR_LOCAL_TEMPLATE . 'catalog/sticker_form.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'catalog/sticker_form', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/sticker_form', $data));
        }
    }

    public function edit()
    {
        $this->document->setTitle("Etiket Yönetimi");
        $this->load->model('catalog/sticker');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validated()) {
            $this->model_catalog_sticker->updateSticker($this->request->get['sticker_id'], $this->request->post);
            $this->session->data['success'] = "Başarılı Bir Şekilde Güncellendi";
            $this->response->redirect($this->url->link('catalog/sticker', 'token=' . $this->session->data['token'], true));
        }

        $this->getForm();
    }
}