<?php
class ControllerCatalogProductConfig extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('catalog/review');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->getList();
	}

	public function add() {
        $this->load->language('catalog/review');

        $this->document->setTitle('Ürün Config Oluştur');

		if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            $this->db->query("UPDATE " . DB_PREFIX . "setting SET `value` = '" . $this->request->post['config_product'] . "' WHERE `key` = 'config_product'");

			$this->response->redirect($this->url->link('catalog/product_config', 'token=' . $this->session->data['token'], true));
		}
	}

	protected function getList() {
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => 'Ürün Config Oluştur',
			'href' => $this->url->link('catalog/product_config', 'token=' . $this->session->data['token'], true)
		);

		$data['add'] = $this->url->link('catalog/product_config/add', 'token=' . $this->session->data['token'], true);
		$data['delete'] = $this->url->link('catalog/review/delete', 'token=' . $this->session->data['token'], true);

		$data['heading_title'] = 'Ürün Config Oluştur';

		$data['text_list'] = 'Ürün Config\'i';
		$data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['button_save'] = 'Kaydet';
		$data['button_edit'] = $this->language->get('button_edit');
		$data['button_delete'] = $this->language->get('button_delete');
		$data['button_filter'] = $this->language->get('button_filter');

		$data['token'] = $this->session->data['token'];
        $data['action'] = $this->url->link('catalog/product_config/add', 'token=' . $data['token'], true);

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

        $data['config_product'] = $this->config->get('config_product');
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		if(file_exists(DIR_LOCAL_TEMPLATE .'catalog/review_list.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'catalog/product_config', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/product_config', $data));
		}

		
	}

}