<?php
class ControllerCatalogLogoMateryal extends Controller {

    private $error = array();

    public function index() {

        $this->load->language('catalog/logo_materyal');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('catalog/logo_materyal');
        $this->getList();

    }

    public function add() {

        $this->load->language('catalog/logo_materyal');

        $this->document->setTitle($this->language->get('heading_title'));


        $this->load->model('catalog/logo_materyal');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            if($this->model_catalog_logo_materyal->addMateryal($this->request->post)){
                $this->session->data['success'] = $this->language->get('text_success');
                $url = '';
                $this->response->redirect($this->url->link('catalog/logo_materyal', 'token=' . $this->session->data['token'] . $url, true));
            }else{
                $this->error['warning'] = "Hata Oluştu!";
            }


        }



        $this->getForm();

    }

    public function edit() {

        $this->load->language('catalog/product');



        $this->document->setTitle($this->language->get('heading_title'));



        $query = $this->db->query("SHOW COLUMNS FROM " . DB_PREFIX . "url_alias WHERE field = 'language_id'");



        $exists = 0;

        foreach ($query->rows as $index) {

            $exists++;

        }



        if (!$exists) {

            $this->db->query("ALTER TABLE " . DB_PREFIX . "url_alias ADD COLUMN `language_id` int(11) NOT NULL DEFAULT '" . $this->config->get('config_language_id') . "';");

        }







        $this->load->model('catalog/product');



        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {


            $this->model_catalog_product->editProduct($this->request->get['product_id'], $this->request->post);



            $this->session->data['success'] = $this->language->get('text_success');

            //$this->creatAllCache();

            $url = '';

            if (isset($this->request->get['filter_name'])) {

                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));

            }



            if (isset($this->request->get['filter_model'])) {

                $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));

            }



            if (isset($this->request->get['filter_price'])) {

                $url .= '&filter_price=' . $this->request->get['filter_price'];

            }



            if (isset($this->request->get['filter_quantity'])) {

                $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];

            }



            if (isset($this->request->get['filter_status'])) {

                $url .= '&filter_status=' . $this->request->get['filter_status'];

            }



            if (isset($this->request->get['sort'])) {

                $url .= '&sort=' . $this->request->get['sort'];

            }



            if (isset($this->request->get['order'])) {

                $url .= '&order=' . $this->request->get['order'];

            }



            if (isset($this->request->get['page'])) {

                $url .= '&page=' . $this->request->get['page'];

            }



            $this->response->redirect($this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, true));

        }



        $this->getForm();

    }

    public function delete() {

        $this->load->language('catalog/product');



        $this->document->setTitle($this->language->get('heading_title'));



        $query = $this->db->query("SHOW COLUMNS FROM " . DB_PREFIX . "url_alias WHERE field = 'language_id'");



        $exists = 0;

        foreach ($query->rows as $index) {

            $exists++;

        }



        if (!$exists) {

            $this->db->query("ALTER TABLE " . DB_PREFIX . "url_alias ADD COLUMN `language_id` int(11) NOT NULL DEFAULT '" . $this->config->get('config_language_id') . "';");

        }







        $this->load->model('catalog/product');



        if (isset($this->request->post['selected']) && $this->validateDelete()) {

            foreach ($this->request->post['selected'] as $product_id) {

                $this->model_catalog_product->deleteProduct($product_id);

            }



            $this->session->data['success'] = $this->language->get('text_success');



            $url = '';



            if (isset($this->request->get['filter_name'])) {

                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));

            }



            if (isset($this->request->get['filter_model'])) {

                $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));

            }



            if (isset($this->request->get['filter_price'])) {

                $url .= '&filter_price=' . $this->request->get['filter_price'];

            }



            if (isset($this->request->get['filter_quantity'])) {

                $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];

            }



            if (isset($this->request->get['filter_status'])) {

                $url .= '&filter_status=' . $this->request->get['filter_status'];

            }



            if (isset($this->request->get['sort'])) {

                $url .= '&sort=' . $this->request->get['sort'];

            }



            if (isset($this->request->get['order'])) {

                $url .= '&order=' . $this->request->get['order'];

            }



            if (isset($this->request->get['page'])) {

                $url .= '&page=' . $this->request->get['page'];

            }



            $this->response->redirect($this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, true));

        }



        $this->getList();

    }

    public function copy() {

        $this->load->language('catalog/product');



        $this->document->setTitle($this->language->get('heading_title'));



        $query = $this->db->query("SHOW COLUMNS FROM " . DB_PREFIX . "url_alias WHERE field = 'language_id'");



        $exists = 0;

        foreach ($query->rows as $index) {

            $exists++;

        }



        if (!$exists) {

            $this->db->query("ALTER TABLE " . DB_PREFIX . "url_alias ADD COLUMN `language_id` int(11) NOT NULL DEFAULT '" . $this->config->get('config_language_id') . "';");

        }







        $this->load->model('catalog/product');



        if (isset($this->request->post['selected']) && $this->validateCopy()) {

            foreach ($this->request->post['selected'] as $product_id) {

                $this->model_catalog_product->copyProduct($product_id);

            }



            $this->session->data['success'] = $this->language->get('text_success');



            $url = '';



            if (isset($this->request->get['filter_name'])) {

                $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));

            }



            if (isset($this->request->get['filter_model'])) {

                $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));

            }



            if (isset($this->request->get['filter_price'])) {

                $url .= '&filter_price=' . $this->request->get['filter_price'];

            }



            if (isset($this->request->get['filter_quantity'])) {

                $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];

            }



            if (isset($this->request->get['filter_status'])) {

                $url .= '&filter_status=' . $this->request->get['filter_status'];

            }



            if (isset($this->request->get['sort'])) {

                $url .= '&sort=' . $this->request->get['sort'];

            }



            if (isset($this->request->get['order'])) {

                $url .= '&order=' . $this->request->get['order'];

            }



            if (isset($this->request->get['page'])) {

                $url .= '&page=' . $this->request->get['page'];

            }



            $this->response->redirect($this->url->link('catalog/product', 'token=' . $this->session->data['token'] . $url, true));

        }



        $this->getList();

    }

    protected function getList() {



        $url = '';

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/logo_materyal', 'token=' . $this->session->data['token'] . $url, true)
        );


        $data['add'] = $this->url->link('catalog/logo_materyal/add', 'token=' . $this->session->data['token'] . $url, true);
        $data['copy'] = $this->url->link('catalog/logo_materyal/copy', 'token=' . $this->session->data['token'] . $url, true);
        $data['delete'] = $this->url->link('catalog/logo_materyal/delete', 'token=' . $this->session->data['token'] . $url, true);
        $data['all_product_delete'] = $this->url->link('catalog/product/allProductDelete', 'token=' . $this->session->data['token'] . $url, true);


        $data['log_materyal_list'] = array();


        $results = $this->model_catalog_logo_materyal->getMateryalList();

        $count = 0;
        foreach ($results as $result){
            $count++;
            $data['log_materyal_list'][] = array(
                'LOG0_ICI_URUN_KODU' => $result->LOG0_ICI_URUN_KODU,
                'URUN_ADI' => $result->URUN_ADI,
                'PYRSFT_URUN_KODU' => $result->PYRSFT_URUN_KODU,
                'URUN_BARKODU' => $result->URUN_BARKODU,
                'edit' => $this->url->link('catalog/logo_materyal/edit', 'token=' . $this->session->data['token'] . $url, true)
            );
        }


        $data['results'] = sprintf($this->language->get('test_result'), $count);


        $data['heading_title'] = $this->language->get('heading_title');


        $data['text_list'] = $this->language->get('text_list');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');
        $data['button_add'] = $this->language->get('button_add');
        $data['button_edit'] = $this->language->get('button_edit');


        $data['token'] = $this->session->data['token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        if (file_exists(DIR_LOCAL_TEMPLATE . 'catalog/logo_materyal.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'catalog/logo_materyal', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/logo_materyal', $data));
        }

    }

    protected function getForm() {



        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_form'] = !isset($this->request->get['logo_ici_urun_kodu']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');
        $data['button_edit'] = $this->language->get('button_edit');


        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }


        if (isset($this->error['logo_ici_urun_kodu'])) {
            $data['error_logo_ici_urun_kodu'] = $this->error['logo_ici_urun_kodu'];
        } else {
            $data['error_logo_ici_urun_kodu'] = array();
        }

        if (isset($this->error['urun_adi'])) {
            $data['error_urun_adi'] = $this->error['urun_adi'];
        } else {
            $data['error_urun_adi'] = array();
        }

        if (isset($this->error['piyersoft_urun_kodu'])) {
            $data['error_piyersoft_urun_kodu'] = $this->error['piyersoft_urun_kodu'];
        } else {
            $data['error_piyersoft_urun_kodu'] = array();
        }

        if (isset($this->error['urun_barkodu'])) {
            $data['error_urun_barkodu'] = $this->error['urun_barkodu'];
        } else {
            $data['error_urun_barkodu'] = array();
        }


        $url = '';


        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/logo_materyal', 'token=' . $this->session->data['token'] . $url, true)
        );


        $data['cancel'] = $this->url->link('catalog/logo_materyal', 'token=' . $this->session->data['token'] . $url, true);


        if (!isset($this->request->get['logo_ici_urun_kodu'])) {
            $data['action'] = $this->url->link('catalog/logo_materyal/add', 'token=' . $this->session->data['token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('catalog/logo_materyal/edit', 'token=' . $this->session->data['token'] . '&logo_ici_urun_kodu=' . $this->request->get['logo_ici_urun_kodu'] . $url, true);
        }


        if (isset($this->request->get['logo_ici_urun_kodu']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $logo_materyal__info = $this->model_catalog_logo_materyal->getMateryalListItem($this->request->get['logo_ici_urun_kodu']);
        }


        if(isset($this->request->post['logo_ici_urun_kodu'])){
            $data['logo_ici_urun_kodu'] = $this->request->post['logo_ici_urun_kodu'];
        }else if(!empty($logo_materyal__info)){
            $data['logo_ici_urun_kodu'] = $logo_materyal__info['LOG0_ICI_URUN_KODU'];
        }else{
            $rand = @rand(0,9);
            $rand = @date('mds') . $rand;
            $data['logo_ici_urun_kodu'] = '152.02.' . $rand;
        }

        if(isset($this->request->post['urun_adi'])){
            $data['urun_adi'] = $this->request->post['urun_adi'];
        }else if(!empty($logo_materyal__info)){
            $data['urun_adi'] = $logo_materyal__info['URUN_ADI'];
        }else{
            $data['urun_adi'] = '';
        }

        if(isset($this->request->post['piyersoft_urun_kodu'])){
            $data['piyersoft_urun_kodu'] = $this->request->post['piyersoft_urun_kodu'];
        }else if(!empty($logo_materyal__info)){
            $data['piyersoft_urun_kodu'] = $logo_materyal__info['PYRSFT_URUN_KODU'];
        }else{
            $data['piyersoft_urun_kodu'] = '';
        }

        if(isset($this->request->post['urun_barkodu'])){
            $data['urun_barkodu'] = $this->request->post['urun_barkodu'];
        }else if(!empty($logo_materyal__info)){
            $data['urun_barkodu'] = $logo_materyal__info['URUN_BARKODU'];
        }else{
            $data['urun_barkodu'] = '';
        }


        $data['token'] = $this->session->data['token'];


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');



        if (file_exists(DIR_LOCAL_TEMPLATE . 'catalog/logo_materyal_form.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'catalog/logo_materyal_form', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/logo_materyal_form', $data));
        }

    }

    protected function validateForm() {



        if (!$this->user->hasPermission('modify', 'catalog/logo_materyal')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }


        if(!$this->request->post['logo_ici_urun_kodu']){
            $this->error['logo_ici_urun_kodu'] = "Logo içi ürün kodu yazılmalıdır!";
        }

        if(!$this->request->post['urun_adi']){
            $this->error['urun_adi'] = "Logo içi ürün adı yazılmalıdır!";
        }

        if(!$this->request->post['piyersoft_urun_kodu']){
            $this->error['piyersoft_urun_kodu'] = "Piyersoft Ürün Kodu yazılmalıdır!";
        }

        if(!$this->request->post['urun_barkodu']){
            $this->error['urun_barkodu'] = "Ürün Barkodu yazılmalıdır!";
        }



        return !$this->error;

    }

    protected function validateEditStatus() {
        if (!$this->user->hasPermission('modify', 'catalog/logo_materyal')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;

    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('modify', 'catalog/logo_materyal')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }

}

