<?php
class ControllerCatalogInfinityStock extends Controller{

    private $error = array();

    public function index()
    {

        $this->load->language('catalog/infinity_stock');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/infinity_stock');

        $this->getList();



    }

    public function index2()
    {

        $this->load->language('catalog/infinity_stock');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/infinity_stock');


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] , true)
        );

        $data['add'] = $this->url->link('catalog/infinity_stock/add', 'token=' . $this->session->data['token'] , true);
        $data['add_product_stock'] = $this->url->link('catalog/infinity_stock/add_product_stock', 'token=' . $this->session->data['token'] , true);
        $data['delete'] = $this->url->link('catalog/infinity_stock/delete', 'token=' . $this->session->data['token'] , true);
        $data['get_stock_data'] = $this->url->link('catalog/infinity_stock/getListData', 'token=' . $this->session->data['token'] , true);


        $data['token'] = $this->session->data['token'];

        $data['heading_title']    = $this->language->get('heading_title');

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');

        $data['column_name'] = $this->language->get('column_name');
        $data['column_quantity'] = $this->language->get('column_quantity');
        $data['column_stock_no'] = $this->language->get('column_stock_no');
        $data['column_action'] = $this->language->get('column_action');
        $data['column_category'] = $this->language->get('column_category');
        $data['column_collection'] = $this->language->get('column_collection');
        $data['column_color'] = $this->language->get('column_color');
        $data['column_product_name'] = $this->language->get('column_product_name');
        $data['column_price'] = $this->language->get('column_price');
        $data['column_price_cost'] = $this->language->get('column_price_cost');

        $data['button_add'] = $this->language->get('button_add');
        $data['button_edit'] = $this->language->get('button_edit');
        $data['button_delete'] = $this->language->get('button_delete');


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE .'catalog/infinity_stock_list.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'catalog/infinity_stock_list', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/infinity_stock_list', $data));
        }





    }

    public function add() {

        $this->load->language('catalog/infinity_stock');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/infinity_stock');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_catalog_infinity_stock->addStock($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true));
        }

        $this->getForm();
    }

    public function add_product_stock() {

        $this->load->language('catalog/infinity_stock');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/infinity_stock');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormProductStock()) {
            $this->model_catalog_infinity_stock->addProductStock($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true));
        }

        $this->getProductStockForm();
    }

    public function edit() {

        $this->load->language('catalog/infinity_stock');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/infinity_stock');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_catalog_infinity_stock->editStock($this->request->get['stock_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit_product_stock() {

        $this->load->language('catalog/infinity_stock');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/infinity_stock');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateFormProductStock()) {
            $this->model_catalog_infinity_stock->editProductStock($this->request->get['stock_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true));
        }

        $this->getProductStockForm();
    }

    public function delete() {

        $this->load->language('catalog/infinity_stock');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('catalog/infinity_stock');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $stock_id) {
                $this->model_catalog_infinity_stock->deleteStock($stock_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true));
        }

        $this->getList();
    }

    public function getListData(){

        $json = array();

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'od.name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $json['stocks'] = array();

        $filter_data = array(
            'sort'  => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );


        $this->load->model('catalog/infinity_stock');

        $option_total = $this->model_catalog_infinity_stock->getTotalStock();

        $results = $this->model_catalog_infinity_stock->getStocks($filter_data);

        foreach ($results as $result) {
            $json['stocks'][] = array(
                'stock_id'         => $result['product_stock_id'],
                'barcode'         => $result['barcode'],
                'name'             => $result['name'],
                'quantity'         => $result['quantity'],
                'price'            => $this->currency->format($result['price'], $this->config->get('config_currency')),
                'price_cost'       => $this->currency->format($result['price_cost'], $this->config->get('config_currency')),
                'category_name'    => $result['category_name'],
                'collection_name'  => $result['collection_name'],
                'color_name'       => $result['color_name'],
                'product_name'     => $result['product_name'],
                'edit'             => $result['product_name'] ? $this->url->link('catalog/infinity_stock/edit_product_stock', 'token=' . $this->session->data['token'] . '&stock_id=' . $result['product_stock_id'], true) : $this->url->link('catalog/infinity_stock/edit', 'token=' . $this->session->data['token'] . '&stock_id=' . $result['product_stock_id'] , true)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));

    }

    protected function getList() {

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'od.name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true)
        );

        $data['add'] = $this->url->link('catalog/infinity_stock/add', 'token=' . $this->session->data['token'] . $url, true);
        $data['add_product_stock'] = $this->url->link('catalog/infinity_stock/add_product_stock', 'token=' . $this->session->data['token'] . $url, true);
        $data['delete'] = $this->url->link('catalog/infinity_stock/delete', 'token=' . $this->session->data['token'] . $url, true);

        $data['stocks'] = array();

        $filter_data = array(
            'sort'  => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['token'] = $this->session->data['token'];

        $option_total = $this->model_catalog_infinity_stock->getTotalStock();

        $results = $this->model_catalog_infinity_stock->getStocks($filter_data);

        foreach ($results as $result) {
            $data['stocks'][] = array(
                'stock_id'         => $result['product_stock_id'],
                'barcode'         => $result['barcode'],
                'name'             => $result['name'],
                'quantity'         => $result['quantity'],
                'price'            => $this->currency->format($result['price'], $this->config->get('config_currency')),
                'price_cost'       => $this->currency->format($result['price_cost'], $this->config->get('config_currency')),
                'category_name'    => $result['category_name'],
                'collection_name'  => $result['collection_name'],
                'color_name'       => $result['color_name'],
                'product_name'     => $result['product_name'],
                'edit'             => $result['product_name'] ? $this->url->link('catalog/infinity_stock/edit_product_stock', 'token=' . $this->session->data['token'] . '&stock_id=' . $result['product_stock_id'] . $url, true) : $this->url->link('catalog/infinity_stock/edit', 'token=' . $this->session->data['token'] . '&stock_id=' . $result['product_stock_id'] . $url, true)
            );
        }


		$smsatilacakliste   = array();
		$urunstokliste      = $this->db->query("SELECT * FROM ps_product_stock  WHERE quantity > 0 and kquantity > 0");
		$urunstoklistedatas = $urunstokliste->rows;
 
		foreach($urunstoklistedatas as $urunstoklistedata){

			$quantity    = $urunstoklistedata['quantity'];
			$kquantity   = $urunstoklistedata['kquantity'];

			$kritikdurum = $quantity - $kquantity ;

			if($kritikdurum < 5){
				$smsatilacakliste[] = array(

				'barcode'  => $urunstoklistedata['barcode'],
				'name'     => $urunstoklistedata['name'],
				'quantity' => $urunstoklistedata['quantity'],

				);


			}

		}
		
		 
		
		 
        $data['smsatilacakliste'] = $smsatilacakliste;
        $data['heading_title']    = $this->language->get('heading_title');

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        $data['text_confirm'] = $this->language->get('text_confirm');

        $data['column_name'] = $this->language->get('column_name');
        $data['column_quantity'] = $this->language->get('column_quantity');
        $data['column_stock_no'] = $this->language->get('column_stock_no');
        $data['column_action'] = $this->language->get('column_action');
        $data['column_category'] = $this->language->get('column_category');
        $data['column_collection'] = $this->language->get('column_collection');
        $data['column_color'] = $this->language->get('column_color');
        $data['column_product_name'] = $this->language->get('column_product_name');
        $data['column_price'] = $this->language->get('column_price');
        $data['column_price_cost'] = $this->language->get('column_price_cost');

        $data['button_add'] = $this->language->get('button_add');
        $data['button_edit'] = $this->language->get('button_edit');
        $data['button_delete'] = $this->language->get('button_delete');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . '&sort=od.name' . $url, true);
        $data['sort_sort_order'] = $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . '&sort=o.sort_order' . $url, true);

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $option_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($option_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($option_total - $this->config->get('config_limit_admin'))) ? $option_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $option_total, ceil($option_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        if(file_exists(DIR_LOCAL_TEMPLATE .'catalog/infinity_stock_list.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'catalog/infinity_stock_list', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/infinity_stock_list', $data));
        }


    }

   public function adetdegistir()
    {
 
        $product_stock_id = (int)$this->request->post['product_stock_id'];
        $quantity         = (int)$this->request->post['quantity'];
		
		if(isset($product_stock_id)){
		
			$this->db->query("UPDATE ps_product_stock SET quantity = '" . (int)$quantity . "' WHERE product_stock_id = '" . (int)$product_stock_id . "'");
			$json = array( 'success' => true );
		
		}else{
			
			 $json = array( 'success' => false );
			 
		}
		 
		
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
	
   public function kadetdegistir()
    {
 
        $product_stock_id = (int)$this->request->post['product_stock_id'];
        $kquantity        = (int)$this->request->post['kquantity'];
		
		if(isset($product_stock_id)){
		
			$this->db->query("UPDATE ps_product_stock SET kquantity = '" . (int)$kquantity . "' WHERE product_stock_id = '" . (int)$product_stock_id . "'");
			$json = array( 'success' => true );
		
		}else{
			
			 $json = array( 'success' => false );
			 
		}
		 
		
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

	public function infinity_stockdatatable() {
		
        $this->load->model('catalog/infinity_stock');
 
$url = '';
		$filter_data             = array( 'sort'  => "product_stock_id", 'order' => "DESC" );
		$getStocks               = $this->model_catalog_infinity_stock->getStocks($filter_data);
		
		if(count($getStocks) > 0 ){

			$stock_array        = array();
			$sira                     = 0;

			foreach ($getStocks as $getStock) {

				$sira++;
				
$product_stock_id                    = $getStock["product_stock_id"];
$barcode                             = $getStock["barcode"];
$name                                = $getStock["name"];
$quantity                            = $getStock["quantity"];
$kquantity                           = $getStock["kquantity"];
$price                               = $this->currency->format($getStock['price'], $this->config->get('config_currency'));
$price_cost                          = $this->currency->format($getStock['price_cost'], $this->config->get('config_currency'));
$category_name                       = $getStock["category_name"];
$collection_name                     = $getStock["collection_name"];
$product_name                        = $getStock["product_name"];
$color_name                          = $getStock["color_name"];
$edit                                = $getStock['product_name'] ? $this->url->link('catalog/infinity_stock/edit_product_stock', 'token=' . $this->session->data['token'] . '&stock_id=' . $getStock['product_stock_id'] . $url, true) : $this->url->link('catalog/infinity_stock/edit', 'token=' . $this->session->data['token'] . '&stock_id=' . $getStock['product_stock_id'] . $url, true); 
$duzenle                             = '<a href="'.$edit.'" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="Düzenle"><i class="fa fa-pencil"></i></a>';
               
//$barcode_emit = '<a data-toggle="tooltip" data-id="'.$product_stock_id.'" title="" class="btn btn-danger barcode_emit" data-original-title="Stok Dağıt"><i class="fa fa-arrows-alt"></i></a>';
                $barcode_emit_link = $this->url->link('catalog/infinity_stock/barcode_emit=', 'token=' . $this->session->data['token'] . '&barcode=' . $getStock['barcode'] . $url, true);
                $barcode_emit = '<a data-toggle="tooltip" href="'.$barcode_emit_link.'" target="_blank" title="" class="btn btn-danger barcode_emit" data-original-title="Stok Dağıt"><i class="fa fa-arrows-alt"></i></a>';

				
$stock_array["data"][]       = array('

'.$sira.'',
'<input type="checkbox" name="selected[]" value="'.$product_stock_id.'">',
"$barcode",
"$name",
"$category_name",
"$collection_name",
"$color_name",
"$price",
"$price_cost",
'<input type="text" value="'.$kquantity.'"  style="width:60%;"  id="k'.$product_stock_id.'"  onChange="kadetdegistir('.$product_stock_id.')"><span class="sk'.$product_stock_id.'"></span>',
'<input type="text" value="'.$quantity.'"   style="width:60%;"  id="a'.$product_stock_id.'"  onChange="adetdegistir('.$product_stock_id.')"><span class="ak'.$product_stock_id.'"></span>',
"$duzenle",
"$barcode_emit"

);
			
			}
			
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($stock_array));

		}
		

	}

    protected function getForm() {

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_form'] = !isset($this->request->get['stock_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');


        $data['entry_name'] = $this->language->get('entry_name');
        $data['entry_stock_no'] = $this->language->get('entry_stock_no');
        $data['entry_category'] = $this->language->get('entry_category');
        $data['entry_collection'] = $this->language->get('entry_collection');
        $data['entry_color'] = $this->language->get('entry_color');
        $data['entry_quantity'] = $this->language->get('entry_quantity');
        $data['entry_price'] = $this->language->get('entry_price');
        $data['entry_price_cost'] = $this->language->get('entry_price_cost');


        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = array();
        }

        if (isset($this->error['category'])) {
            $data['error_category'] = $this->error['category'];
        } else {
            $data['error_category'] = array();
        }

        if (isset($this->error['collection'])) {
            $data['error_collection'] = $this->error['collection'];
        } else {
            $data['error_collection'] = array();
        }

        if (isset($this->error['color'])) {
            $data['error_color'] = $this->error['color'];
        } else {
            $data['error_color'] = array();
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true)
        );

        if (!isset($this->request->get['stock_id'])) {
            $data['action'] = $this->url->link('catalog/infinity_stock/add', 'token=' . $this->session->data['token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('catalog/infinity_stock/edit', 'token=' . $this->session->data['token'] . '&stock_id=' . $this->request->get['stock_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true);

        if (isset($this->request->get['stock_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $stock_info = $this->model_catalog_infinity_stock->getStock($this->request->get['stock_id']);
        }

        $data['token'] = $this->session->data['token'];

        $data['categories'] = $this->model_catalog_infinity_stock->getCategories();
        $data['collections'] = $this->model_catalog_infinity_stock->getCollections(array('filter_attribute_group_id' => 11));
        $data['colors'] = $this->model_catalog_infinity_stock->getCollections(array('filter_attribute_group_id' => 13));



        if (isset($this->request->post['stock_id'])) {
            $data['stock_id'] = $this->request->post['stock_id'];
        } elseif (!empty($stock_info)) {
            $data['stock_id'] = $stock_info['barcode'];
        } else {
            $data['stock_id'] = '';
        }

        if (isset($this->request->post['name'])) {
            $data['name'] = $this->request->post['name'];
        } elseif (!empty($stock_info)) {
            $data['name'] = $stock_info['name'];
        } else {
            $data['name'] = '';
        }

        if (isset($this->request->post['category'])) {
            $data['category_id'] = $this->request->post['category'];
        } elseif (!empty($stock_info)) {
            $data['category_id'] = $stock_info['category_id'];
        } else {
            $data['category_id'] = '';
        }

        if (isset($this->request->post['collection'])) {
            $data['collection_id'] = $this->request->post['collection'];
        } elseif (!empty($stock_info)) {
            $data['collection_id'] = $stock_info['collection_id'];
        } else {
            $data['collection_id'] = '';
        }

        if (isset($this->request->post['color'])) {
            $data['color_id'] = $this->request->post['color'];
        } elseif (!empty($stock_info)) {
            $data['color_id'] = $stock_info['color_id'];
        } else {
            $data['color_id'] = '';
        }

        if (isset($this->request->post['quantity'])) {
            $data['quantity'] = $this->request->post['quantity'];
        } elseif (!empty($stock_info)) {
            $data['quantity'] = $stock_info['quantity'];
        } else {
            $data['quantity'] = '';
        }

        if (isset($this->request->post['kquantity'])) {
            $data['kquantity'] = $this->request->post['kquantity'];
        } elseif (!empty($stock_info)) {
            $data['kquantity'] = $stock_info['kquantity'];
        } else {
            $data['kquantity'] = 0;
        }

        if (isset($this->request->post['price'])) {
            $data['price'] = $this->request->post['price'];
        } elseif (!empty($stock_info)) {
            $data['price'] = $stock_info['price'];
        } else {
            $data['price'] = 0.00;
        }

        if (isset($this->request->post['price_cost'])) {
            $data['price_cost'] = $this->request->post['price_cost'];
        } elseif (!empty($stock_info)) {
            $data['price_cost'] = $stock_info['price_cost'];
        } else {
            $data['price_cost'] = 0.00;
        }



        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        if(file_exists(DIR_LOCAL_TEMPLATE .'catalog/infinity_stock_form.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'catalog/infinity_stock_form', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/infinity_stock_form', $data));
        }


    }

    protected function getProductStockForm() {

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_form'] = !isset($this->request->get['stock_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');


        $data['entry_name'] = $this->language->get('entry_name');
        $data['entry_stock_no'] = $this->language->get('entry_stock_no');
        $data['entry_product_name'] = $this->language->get('entry_product_name');
        $data['entry_quantity'] = $this->language->get('entry_quantity');
        $data['entry_price'] = $this->language->get('entry_price');
        $data['entry_price_cost'] = $this->language->get('entry_price_cost');


        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = array();
        }


        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true)
        );

        if (!isset($this->request->get['stock_id'])) {
            $data['action'] = $this->url->link('catalog/infinity_stock/add_product_stock', 'token=' . $this->session->data['token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('catalog/infinity_stock/edit_product_stock', 'token=' . $this->session->data['token'] . '&stock_id=' . $this->request->get['stock_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('catalog/infinity_stock', 'token=' . $this->session->data['token'] . $url, true);

        if (isset($this->request->get['stock_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $stock_info = $this->model_catalog_infinity_stock->getStock($this->request->get['stock_id']);
        }

        $data['token'] = $this->session->data['token'];


        if (isset($this->request->post['stock_id'])) {
            $data['stock_id'] = $this->request->post['stock_id'];
        } elseif (!empty($stock_info)) {
            $data['stock_id'] = $stock_info['product_stock_id'];
        } else {
            $data['stock_id'] = '';
        }

        if (isset($this->request->post['name'])) {
            $data['name'] = $this->request->post['name'];
        } elseif (!empty($stock_info)) {
            $data['name'] = $stock_info['name'];
        } else {
            $data['name'] = '';
        }

        if (isset($this->request->post['quantity'])) {
            $data['quantity'] = $this->request->post['quantity'];
        } elseif (!empty($stock_info)) {
            $data['quantity'] = $stock_info['quantity'];
        } else {
            $data['quantity'] = '';
        }

        if (isset($this->request->post['product_name'])) {
            $data['product_name'] = $this->request->post['product_name'];
        } elseif (!empty($stock_info)) {
            $data['product_name'] = $stock_info['product_name'];
        } else {
            $data['product_name'] = '';
        }

        if (isset($this->request->post['price'])) {
            $data['price'] = $this->request->post['price'];
        } elseif (!empty($stock_info)) {
            $data['price'] = $stock_info['price'];
        } else {
            $data['price'] = 0.00;
        }

        if (isset($this->request->post['price_cost'])) {
            $data['price_cost'] = $this->request->post['price_cost'];
        } elseif (!empty($stock_info)) {
            $data['price_cost'] = $stock_info['price_cost'];
        } else {
            $data['price_cost'] = 0.00;
        }



        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        if(file_exists(DIR_LOCAL_TEMPLATE .'catalog/infinity_product_stock_form.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE .'catalog/infinity_product_stock_form', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/infinity_product_stock_form', $data));
        }


    }

    protected function validateForm() {

        if (!$this->user->hasPermission('modify', 'catalog/infinity_stock')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }


        if(empty($this->request->post['name'])){
            $this->error['name'] = $this->language->get('error_name');
        }

        if($this->request->post['category'] == 0){
            $this->error['category'] = $this->language->get('error_category');
        }

        if($this->request->post['collection'] == 0){
            $this->error['collection'] = $this->language->get('error_collection');
        }

        if($this->request->post['color'] == 0){
            $this->error['color'] = $this->language->get('error_color');
        }



        return !$this->error;
    }

    protected function validateFormProductStock() {

        if (!$this->user->hasPermission('modify', 'catalog/infinity_stock')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }


        if(empty($this->request->post['name'])){
            $this->error['name'] = $this->language->get('error_name');
        }




        return !$this->error;
    }

    protected function validateDelete() {

        if (!$this->user->hasPermission('modify', 'catalog/infinity_stock')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function barcode_emit()
    {

        $json = array();
        if(isset($this->request->get['barcode'])){
            $barcode = $this->request->get['barcode'];
            

            $result = $this->db->query("SELECT * FROM ps_product_stock WHERE barcode = '". $this->db->escape($barcode) ."' ")->row;

            if($result){

                $category_id = $result['category_id'];
                $collection_id = $result['collection_id'];
                $color_id = $result['color_id'];

                $products = $this->db->query("SELECT p.product_id FROM ps_product p 
                LEFT JOIN ps_product_to_category p2c ON (p.product_id = p2c.product_id) 
                LEFT JOIN ps_category c ON (p2c.category_id = c.category_id) 
                WHERE (p2c.category_id = ".$category_id." OR c.infinityeditid = ".$category_id.")  GROUP BY p.product_id ")->rows;

                $products_f_1 = array();
                foreach ($products as $product){
                    $collection_query = $this->db->query("SELECT * FROM ps_product_attribute WHERE product_id = '". $product['product_id'] ."' AND attribute_id = '". $collection_id ."' ")->row;
                    if($collection_query){
                        $products_f_1[] = $collection_query['product_id'];
                    }
                }

                $products = array();
                foreach ($products_f_1 as $product){
                    $color_query = $this->db->query("SELECT * FROM ps_product_attribute WHERE product_id = '". $product ."' AND attribute_id = '". $color_id ."' ")->row;
                    if($color_query){
                        $products[] = $color_query['product_id'];
                    }
                }


                foreach ($products as $product){
                    $this->db->query("UPDATE ps_product SET product_stock_id = '". (int)$result['barcode']."', quantity = '". (int)$result['quantity']."' WHERE product_id = '". (int)$product ."' ");
                }

                $json['success'] = $barcode . " Stok dağıtım işlemi tamamlandı!";

            }

        }else{
            $json['error'] = "Barkod no bulunamadı!";
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));

    }

}