<?php



class ControllerCatalogExcel extends Controller {



    public function index() {

        unset($this->session->data['file_path']);

        $data['heading_title'] = 'Excel İle Ürün Yükle';
        $this->document->setTitle($data['heading_title']);
        $data['breadcrumbs'][] = array(
            'href' => 'dd',
            'text' => $data['heading_title'],
        );


        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {

            $path = DIR_UPLOAD . "XLS/" . $this->request->files['excel_file']['name'];

            $file_path = DIR_UPLOAD . "XLS";

            if (!is_dir($file_path)) {

                mkdir($file_path, 0777, true);

            }

            if (!isset($this->session->data['file_path'])) {
                $upload = move_uploaded_file($this->request->files['excel_file']['tmp_name'], $path);
                $this->session->data['file_path'] = $file_path . '/' . $this->request->files['excel_file']['name'];
            }
            $this->excelRead();

        }

        $data['error_warning'] = '';
        $data['success'] = '';

        $data['action'] = $this->url->link('catalog/excel', 'token=' . $this->session->data['token'], true);
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        if (file_exists(DIR_LOCAL_TEMPLATE . 'catalog/excel.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . 'catalog/excel', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'catalog/excel', $data));
        }

    }



    public function excelRead() {



        unset($this->session->data['excel_file']);

        header('Content-Type: text/html; charset=utf-8');

        set_time_limit(0);



        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';



        $file_path = $this->session->data['file_path'];

        $inputFileType = PHPExcel_IOFactory::identify($file_path);

        //  print_r($inputFileType);

        //  die;

        //$file_path = DIR_IMAGE . 'repository/DeerCase Ürün Excel.xlsx';

        $flag = 0;

        $valid = false;

        $types = array('Excel2007', 'Excel5');

        foreach ($types as $type) {

            $objReader = PHPExcel_IOFactory::createReader($type);

            if ($objReader->canRead($file_path)) {

                $valid = true;

                break;

            }

        }



        if (!$valid) {

            die("Bad file");

        }



        if (!isset($this->session->data['excel_file'])) {

            $objPHPExcel = new PHPExcel();

            $objReader->setReadDataOnly(true);

            $objPHPExcel = $objReader->load($file_path);

            $rowIterator = $objPHPExcel->getActiveSheet()->getRowIterator();

            $array_data = array();

            foreach ($rowIterator as $row) {

                $cellIterator = $row->getCellIterator();

                $cellIterator->setIterateOnlyExistingCells(false);

                $rowIndex = $row->getRowIndex();

                $columnIndex = 0;

                //if (!$flag) {

                foreach ($cellIterator as $cell) {

                    $this->session->data['excel_file'][$rowIndex - 1][$columnIndex++] = $cell->getCalculatedValue();

                }

                $flag++;

                //}

            }

            unset($this->session->data['excel_file'][0]);

        }



        $add_product_count = 0;
        $edit_product_count = 0;

        foreach ($this->session->data['excel_file'] as $k_row => $product_item) {

            if ($product_item[7] == '') {

            }

            // 0 => Ürün Adı

            // 1 => Ürün Kodu Model

            // 2 => Ürün Fiyat - Price

            // 3 => Ürün İndirimli Fiyat - Special

            // 4 => Ürün Adeti - Quantity

            // 5 => 2. Kategori - Category

            // 6 => 3. Kategori - Category

            // 7 => Ana Kategori - Category

            // 8 => Koleksiyon - Attribute

            // 9 => Koleksiyon - Renk - Attribute

            // 10 => Ürün Tipi - Product Type

            // 11 => Ürün Deseni - Desen

            // 12 => Ürün Meta Title - Prdouct Description

            // 13 => Ürün Meta Description - Prdouct Description

            // 14 => Ürün filtresi - İlk olarak WB için yapıldı



            if ($product_item[0] != '') {

                $product_name = $product_item[0];
                $product_meta_title = $product_item[12];
                $product_meta_description = $product_item[13];
                $product_filter_id = $product_item[14];
                $product_description = array();
                $product_description[1] = array(
                    'name' => $product_name,
                    'description' => $product_name,
                    'meta_title' => $product_meta_title,
                    'meta_description' => $product_meta_description,
                    'tag' => '',
                    'meta_keyword' => '',
                );


                $model = $this->seflink($product_item[1]);
                $quantity = $product_item[4];
                $price = $product_item[2];
                $special = $product_item[3];


                $category_1 = $this->findCategoryIdByName($product_item[7] . ' Telefon Kılıfı', 0);
                $category_2 = $this->findCategoryIdByName($product_item[5] . ' Telefon Kılıfı', $category_1);
                $category_3 = $this->findCategoryIdByName($product_item[6], $category_2);

                $product_category = array($category_1, $category_2, $category_3);

                $manufacturer = $product_item[7];

                $manufacturer_id = $this->findManufacturerIdByName($manufacturer);

                $koleksiyon = $this->findAttributeIDByName($product_item[8], 11);

                $renk = $this->findAttributeIDByName($product_item[9], 13, $product_item[8]);



                $product_attribute = array();
                $product_attribute_description = array();
                $product_attribute_description[1] = array(
                    'text' => ''
                );

                $product_attribute[] = array(
                    'attribute_id' => $koleksiyon,
                    'product_attribute_description' => $product_attribute_description
                );


                $product_attribute_description = array();
                $product_attribute_description[1] = array(
                    'text' => ''
                );

                $product_attribute[] = array(
                    'attribute_id' => $renk,
                    'product_attribute_description' => $product_attribute_description
                );


                if (trim($product_item[10]) == 'Özel') {
                    $product_type = 1;
                } else if (trim($product_item[10]) == 'Standart') {
                    $product_type = 0;
                } else if (trim($product_item[10]) == 'Harf') {
                    $product_type = 2;
                } else if (trim($product_item[10]) == 'Popsoket') {
                    $product_type = 3;
                } else if (trim($product_item[10]) == 'Type 5') {
                    $product_type = 4;
                } 

                $model2_data = array(
                    'model' => $model,
                    'koleksiyon' => $product_item[8],
                    'renk' => $product_item[9],
                    'category' => $product_item[6],
                );

                $model2 = $this->createModel2($model2_data);

                $product_special = array();

                if ($special) {
                    $product_special[] = array(
                        'price' => $special,
                        'customer_group_id' => 1
                    );
                }


                $image_path = '';

                switch ($product_item[8]) {
                    case 'Simli Sulu': $image_path = 'aquarium';
                        break;
                    case 'Neon': $image_path = 'neon';
                        break;
                    case 'Slide Case': $image_path = 'slidecase';
                        break;
                    case 'Arty Case': $image_path = 'impact';
                        break;
                    case 'Şeffaf': $image_path = 'seffaf';
                        break;
                    case 'Renkli Silikon': $image_path = 'silicon';
                        break;
                    case 'Glossy': $image_path = 'glossy';
                        break;
                }


                $product_image = array();
                $image = '';
                $images = $this->getImg($image_path, $model, $product_item[7], $product_item[5], $product_item[9]);

                if (isset($images[0])) {

                    $image = $images[0];
                    unset($images[0]);

                    foreach ($images as $i_key => $img) {
                        $product_image[] = array(
                            'image' => $img,
                            'sort_order' => $i_key,
                        );
                    }
                }

                $product_data = array(

                    'model' => $model,
                    'model2' => $model2,
                    'quantity' => $quantity,
                    'manufacturer_id' => $manufacturer_id,
                    'filter_id' => $product_filter_id,
                    'image' => $image,
                    'price' => $price,
                    'sku' => '',
                    'product_type' => $product_type,
                    'minimum' => '1',
                    'subtract' => '1',
                    'stock_status_id' => '1',
                    'date_available' => '',
                    'shipping' => '1',
                    'currency_id' => '1',
                    'points' => '',
                    'weight' => '',
                    'weight_class_id' => '',
                    'length' => '',
                    'width' => '',
                    'height' => '',
                    'length_class_id' => '',
                    'tax_class_id' => 1,
                    'status' => 1,
                    'sort_order' => 0,
                    'product_special' => $product_special,
                    'product_description' => $product_description,
                    'product_category' => $product_category,
                    'product_attribute' => $product_attribute,
                    'product_image' => $product_image,
                );

                

                $ask = $this->db->query("SELECT product_id FROM ps_product WHERE model2 = '" . $this->db->escape($model2) . "' ");
                
                
                if (!isset($ask->row['product_id'])) {

                   // flush();

                    if ($image) {
                        $add_product_count++;
                        $this->product->addProduct($product_data);
                        //var_dump($product_data['model']); die();

                    }else{
                        //var_dump("Yok");
                        //var_dump($product_data); die();
                    }

                } else {
                    $edit_product_count++;
                } 
                
                

            }

        }

        echo $add_product_count . ' Yeni Ürün Eklendi' . '<br>';
        echo $edit_product_count . ' Ürün güncellendi' . '<br>';

        return true;

    }



    private function koleksiyonRenkEslestirmesi($koleksiyon, $renk) {



        $return = '';

        switch ($renk) {

            //Neon

            case 'Violet' : $return = 'Violet';

                break;

            case 'Yeşil' : $return = 'Green';

                break;

            case 'Turuncu' : $return = 'Orange';

                break;

            case 'Siyah' : $return = 'Black';

                break;

            //Arty

            case 'Siyah' : $return = 'Black';

                break;

            case 'Pembe' : $return = 'Pink';

                break;

            case 'Beyaz' : $return = 'White';

                break;

            case 'Mavi Kırmızı' : $return = 'Blue_Red';

                break;

            case 'Cool Black' : $return = 'Cool_Black';

                break;

            case 'Azure' : $return = 'Azure';

                break;

            case 'Mango' : $return = 'Mango';

                break;

            case 'Fuşya' : $return = 'Fuchsia';

                break;

            case 'Turuncu' : $return = 'Orange';

                break;

            case 'Yeşil' : $return = 'Green';

                break;

            case 'Simli Mor' : $return = 'Simli_Mor';

                break;

            case 'Simli Pembe' : $return = 'Simli_Pembe';

                break;

            case 'Pembe Yeşil' : $return = 'Pink_Blue';

                break;

            //Aqua

            case 'Pembe' : $return = 'Red';

                break;

            case 'Pembe Beyaz' : $return = 'Pink_White';

                break;

            case 'Siyah' : $return = 'Black';

                break;

            case 'Gri' : $return = 'Silver';

				break;

			case 'Mavi' : $return = 'Blue';

                break;

            case 'Fuşya' : $return = 'Fuchsia';

                break;

            case 'Altın' : $return = 'Gold';

                break;

            case 'Mor' : $return = 'Purple';

                break;

            //Silicon

            case 'Siyah' : $return = 'Black';

                break;

            case 'Pembe' : $return = 'Pink';

                break;

            case 'Kırmızı' : $return = 'Red';

                break;

            case 'Sarı' : $return = 'Yellow';

                break;

            case 'Lila' : $return = 'Lilac';

                break;

            case 'Açık Yeşil' : $return = 'Light Green';

                break;

            case 'Mavi' : $return = 'Blue';

                break;

            case 'Yeşil' : $return = 'Green';

                break;

            case 'Gri' : $return = 'Silver';

                break;

            case 'Turuncu' : $return = 'Orange';

                break;

            case 'Kaktüs' : $return = 'Cactus';

                break;

			//Glossy

			case 'Popsoketli' : $return = 'Popsoketli';

                break;

            case 'Popsoketsiz' : $return = 'Popsoketsiz';

                break;

			//Slide_Camera

			case 'Siyah' : $return = 'Siyah';

                break;

            case 'Mavi' : $return = 'Mavi';

                break;

            case 'Kırmızı' : $return = 'Kırmızı';

                break;

            case 'Pembe' : $return = 'Pembe';

                break;

            case 'Lila' : $return = 'Lila';

                break;

            case 'Midnight Blue' : $return = 'Midnight_Blue';

                break;

        }

    }



    private function findManufacturerIdByName($manufacturer_name) {

        $ask = $this->db->query("SELECT * FROM ps_manufacturer WHERE name = '" . $this->db->escape($manufacturer_name) . "' ");

        if (isset($ask->row['manufacturer_id'])) {

            return $ask->row['manufacturer_id'];

        }

    }



    public function createModel2($data) {



        $koleksiyon = '';

        $renk = '';



        switch ($data['koleksiyon']) {

            case 'Neon': $koleksiyon = 'neon';

                break;

            case 'Simli Sulu': $koleksiyon = 'aquarium';

                break;

            case 'Arty Case': $koleksiyon = 'impact';

                break;

            case 'Renkli Silikon': $koleksiyon = 'silicon';

                break;

            case 'Şeffaf': $koleksiyon = 'seffaf';

                break;

            case 'Glossy': $koleksiyon = 'glossy';
                break;

            case 'Slide Case': $koleksiyon = 'slidecase';
                break;

        }



        switch ($data['renk']) {

            case 'Violet': $renk = 'violet';

                break;

            case 'Turuncu': $renk = 'orange';

                break;

            case 'Yeşil': $renk = 'green';

                break;

            case 'Pembe': $renk = 'pink';

                break;

            case 'Siyah': $renk = 'black';

                break;

            case 'Beyaz': $renk = 'white';

                break;

            case 'Gri': $renk = 'silver';

                break;

            case 'Kaktüs': $renk = 'Cactus';

                break;

			case 'Mavi' : $renk = 'blue';

                break;

            case 'Pembe Beyaz' : $renk = 'Pink_White';

                break;

            case 'Mavi Kırmızı' : $renk = 'Blue_Red';

                break;

            case 'Cool Black' : $renk = 'Cool_Black';

                break;

            case 'Azure' : $renk = 'Azure';

                break;

            case 'Mango' : $renk = 'Mango';

                break;

            case 'Simli Mor' : $renk = 'Simli_Mor';

                break;

            case 'Simli Pembe' : $renk = 'Simli_Pembe';

                break;

            case 'Pembe Yeşil' : $renk = 'Pink_Blue';

                break;

            case 'Fuşya' : $renk = 'Fuchsia';

                break;

            case 'Altın' : $renk = 'Gold';

                break;

            case 'Mor' : $renk = 'Purple';

                break;

            case 'Saydam': $renk = 'saydam';

                break;

			case 'Popsoketli': $renk = 'popsoketli';

                break;

			case 'Popsoketsiz': $renk = 'popsoketsiz';

                break;

            case 'Sarı': $renk = 'yellow';

                break;

            case 'Lila': $renk = 'lilac';

                break;

            case 'Açık Yeşil': $renk = 'Light Green';

                break;

            case 'Kırmızı': $renk = 'red';
                break;
            case 'Midnight Blue': $renk = 'Midnight_Blue';
                break;

        }



        $alt_category = str_replace(' ', '_', mb_convert_case($data['category'], MB_CASE_LOWER, "UTF-8"));



        return $data['model'] . '-' . $alt_category . '-' . $koleksiyon . '-' . $renk . '-kilif';

    }



    public function findAttributeIDByName($attribute_name, $attribute_group_id, $koleksiyon = '') {



        //Koleksiyonların içerisindeki renkleri ayırabilmek için attribute_key alanını yaptık. neon-red, auq-red gibi

        $attr_coll = '';

        if ($koleksiyon) {

            switch ($koleksiyon) {

                case 'Neon': $attr_coll = 'neon-';

                    break;

                case 'Arty Case': $attr_coll = 'impact-';

                    break;

                case 'Simli Sulu': $attr_coll = 'aqua-';

                    break;

                case 'Renkli Silikon': $attr_coll = 'silicon-';

                    break;
                
                case 'Slide Case': $attr_coll = 'slidecase-';

                    break;

                case 'Şeffaf': $attr_coll = 'seffaf-';

                    break;

                case 'Glossy': $attr_coll = 'glossy-';

                    break;

            }

            switch ($attribute_name) {

                case 'Violet': $attr_coll .= 'violet';

                    break;

                case 'Yeşil': $attr_coll .= 'green';

                    break;

                case 'Turuncu': $attr_coll .= 'orange';

                    break;

                case 'Pembe': $attr_coll .= 'pink';

                    break;

                case 'Siyah': $attr_coll .= 'black';

                    break;

                case 'Beyaz': $attr_coll .= 'white';

                    break;

                case 'Gri': $attr_coll .= 'silver';

                    break;

                case 'Kaktüs': $attr_coll .= 'Cactus';

                    break;

				case 'Mavi' : $attr_coll = 'blue';

                    break;

                case 'Pembe Beyaz' : $attr_coll = 'Pink_White';

                    break;

                case 'Mavi Kırmızı' : $attr_coll = 'Blue_Red';

                    break;

                case 'Cool Black' : $attr_coll = 'Cool_Black';

                    break;

                case 'Azure' : $attr_coll = 'Azure';

                    break;

                case 'Mango' : $attr_coll = 'Mango';

                    break;

                case 'Simli Mor' : $attr_coll = 'Simli_Mor';

                    break;

                case 'Simli Pembe' : $attr_coll = 'Simli_Pembe';

                    break;

                case 'Pembe Yeşil' : $attr_coll = 'Pink_Blue';

                    break;

                case 'Fuşya' : $attr_coll = 'Fuchsia';

                    break;

                case 'Altın' : $attr_coll = 'Gold';

                    break;

                case 'Mor' : $attr_coll = 'Purple';

                    break;

                case 'Saydam': $attr_coll .= 'saydam';

                    break;

                case 'Kırmızı': $attr_coll .= 'red';

                    break;

                case 'Sarı': $attr_coll .= 'yellow';

                    break;

                case 'Lila': $attr_coll .= 'lilac';

                    break;

                case 'Açık Yeşil': $attr_coll .= 'Light Green';

                    break;

                case 'Beyaz': $attr_coll .= 'beyaz';

                    break;

                case 'Midnight Blue': $attr_coll .= 'midnight_blue';

                    break;

				case 'Popsoketli': $renk = 'popsoketli';

					break;

				case 'Popsoketsiz': $renk = 'popsoketsiz';

					break;

            }

        }



        $ask = $this->db->query("SELECT * FROM ps_attribute a

        LEFT JOIN ps_attribute_description ad ON(a.attribute_id = ad.attribute_id)

        WHERE ad.name = '" . $this->db->escape($attribute_name) . "' AND ad.language_id = '1' AND a.attribute_group_id = '" . (int) $attribute_group_id . "' AND attribute_key = '" . $this->db->escape($attr_coll) . "' ");

        if (isset($ask->row['attribute_id'])) {

            return $ask->row['attribute_id'];

        } else {

            $attribute_description[1] = array(

                'name' => $attribute_name

            );



            $attribute_data = array(

                'attribute_group_id' => $attribute_group_id,

                'sort_order' => 0,

                'attribute_key' => $attr_coll,

                'attribute_description' => $attribute_description

            );

            echo $attr_coll . '<br>';

            return $this->addAttribute($attribute_data);

        }

    }



    public function addAttribute($data) {



        $this->db->query("INSERT INTO ps_attribute SET

            attribute_group_id = '" . (int) $data['attribute_group_id'] . "',

            attribute_key = '" . $data['attribute_key'] . "',

            sort_order = '" . (int) $data['sort_order'] . "' ");



        $attribute_id = $this->db->getLastId();



        foreach ($data['attribute_description'] as $language_id => $value) {

            $this->db->query("INSERT INTO ps_attribute_description SET

            attribute_id = '" . (int) $attribute_id . "',

            language_id = '" . (int) $language_id . "',

            name = '" . $this->db->escape($value['name']) . "'");

        }



        return $attribute_id;

    }



    public function findCategoryIdByName($category_name, $parent_id) {

        //gelen kategori adına göre kategori ID döner, Yoksa açar.



        $ask = $this->db->query("SELECT * FROM ps_category_description WHERE name = '" . $this->db->escape($category_name) . "' AND language_id = '1' ");

        if (isset($ask->row['category_id'])) {

            return $ask->row['category_id'];

        } else {

            $category_description[1] = array(

                'name' => $category_name,

            );



            $category_data = array(

                'parent_id' => $parent_id,

                'top' => 1,

                'column' => 0,

                'sort_order' => 0,

                'status' => 1,

                'keyword' => $this->seflink($category_name),

                'category_description' => $category_description

            );



            return $this->addCategory($category_data);

        }

    }



    public function addCategory($data) {

        $this->db->query("INSERT INTO ps_category SET

        parent_id = '" . (int) $data['parent_id'] . "',

        `top` = '" . (isset($data['top']) ? (int) $data['top'] : 0) . "',

        `column` = '" . (int) $data['column'] . "',

        sort_order = '" . (int) $data['sort_order'] . "',

        status = '" . (int) $data['status'] . "',

        date_modified = NOW(),

        date_added = NOW() ");



        $category_id = $this->db->getLastId();



        if (isset($data['category_description'])) {

            foreach ($data['category_description'] as $language_id => $value) {

                $this->db->query("INSERT INTO ps_category_description SET

                category_id = '" . (int) $category_id . "',

                language_id = '" . (int) $language_id . "',

                name = '" . $this->db->escape($value['name']) . "' ");

            }

        }





        $level = 0;

        $query = $this->db->query("SELECT * FROM ps_category_path WHERE category_id = '" . (int) $data['parent_id'] . "' ORDER BY `level` ASC");

        foreach ($query->rows as $result) {

            $this->db->query("INSERT INTO ps_category_path SET category_id = '" . (int) $category_id . "', path_id = '" . (int) $result['path_id'] . "', level = '" . (int) $level . "'");

            $level++;

        }



        $this->db->query("INSERT INTO ps_category_path SET category_id = '" . (int) $category_id . "', path_id = '" . (int) $category_id . "', level = '" . (int) $level . "'");



        $this->db->query("INSERT INTO ps_category_to_store SET category_id = '" . (int) $category_id . "', store_id = '0' ");



        $this->db->query("INSERT INTO ps_url_alias SET query = 'category_id=" . (int) $category_id . "', keyword = '" . $this->db->escape($data['keyword']) . "', language_id = '1' ");



        return $category_id;

    }



    function seflink($text) {

        $find = array('Ç', 'Ş', 'Ğ', 'Ü', 'İ', 'Ö', 'ç', 'ş', 'ğ', 'ü', 'ö', 'ı', '+', '#');

        $replace = array('c', 's', 'g', 'u', 'i', 'o', 'c', 's', 'g', 'u', 'o', 'i', 'plus', 'sharp');

        $text = strtolower(str_replace($find, $replace, $text));

        $text = preg_replace("@[^A-Za-z0-9\-_\.\+]@i", ' ', $text);

        $text = trim(preg_replace('/\s+/', ' ', $text));

        $text = str_replace(' ', '-', $text);

        return $text;

    }



    private function getImg($koleksiyon, $model, $main_category, $alt_category, $color) {







        //Koleksiyonların içerisindeki renkleri ayırabilmek için attribute_key alanını yaptık. neon-red, auq-red gibi

        $attr_coll = '';

        if ($koleksiyon) {

            switch ($koleksiyon) {

                case 'neon': $attr_coll = 'NEON_';

                    break;

                case 'aquarium': $attr_coll = 'AQUARIUM_';

                    break;

                case 'impact': $attr_coll = 'SEFFAF-SEFFAF_IMPACT_';

                    break;
                
                
                case 'silicon': $attr_coll = 'SILICON_';

                    break;

                case 'seffaf': $attr_coll = 'SEFFAF_SAYDAM';

                    break;

                case 'glossy': $attr_coll = 'PREMIUM_GLOSSY';

                    break;

                case 'Slide Case': $attr_coll = 'SLIDECASE';
                    break;

            }

            switch ($color) {

                case 'Violet': $attr_coll .= 'VIOLET';

                    break;

                case 'Yeşil': $attr_coll .= 'GREEN';

                    break;

                case 'Turuncu': $attr_coll .= 'ORANGE';

                    break;

                case 'Pembe': ( ($koleksiyon == 'silicon') ? $attr_coll .= 'PINK' : $attr_coll .= 'PINK');

                    break;

                case 'Siyah': $attr_coll .= 'BLACK';

                    break;

                case 'Beyaz': $attr_coll .= 'WHITE';

                    break;

                case 'Gri': $attr_coll .= 'GRAY';

                    break;

                case 'Haki': $attr_coll .= 'HAKI';

                    break;

                case 'Kaktüs': $attr_coll .= 'CACTUS';

                    break;

                case 'Mango': $attr_coll .= 'MANGO';

                    break;

                case 'Azure': $attr_coll .= 'AZURE';

                    break;

				 case 'Mavi': $attr_coll .= 'BLUE';

                    break;

                case 'Fuşya': $attr_coll .= 'FUCHSIA';

                    break;

                case 'Pembe Beyaz' : $attr_coll = 'AQUARIUM_PINK';

                    break;

                 case 'Mavi Kırmızı' : $attr_coll = 'SEFFAF-SEFFAF_IMPACT_BLUE_RED';

                    break;

                case 'Pembe Yeşil' : $attr_coll = 'SEFFAF-SEFFAF_IMPACT_PINK_GREEN';

                    break;

                case 'Cool Black' : $attr_coll = 'SEFFAF-SEFFAF_IMPACT_COOL_BLACK';

                    break;

                case 'Simli Mor' : $attr_coll = 'SEFFAF-SEFFAF_IMPACT_SIMLI_MOR';

                    break;

                case 'Simli Pembe' : $attr_coll = 'SEFFAF-SEFFAF_IMPACT_SIMLI_PEMBE';

                    break;

                case 'Altın': $attr_coll .= 'GOLD';

                    break;
                
                case 'Midnight Blue': $attr_coll = 'MIDNIGHT_BLUE';
                    break;

                case 'Mor': $attr_coll .= 'PURPLE';

                    break;

                case 'Kırmızı': $attr_coll .= 'RED';

                    break;

                case 'Sarı': $attr_coll .= 'YELLOW';

                    break;

                case 'Lila': $attr_coll .= 'LILAC';

                    break;

                case 'Açık Yeşil': $attr_coll .= 'GREEN';

                    break;

				case 'Popsoketli': $attr_coll .= '-POPSOCKETLI';

                    break;

                case 'Popsoketsiz': $attr_coll .= '-POPSOCKETSIZ';

                    break;

            }

        }


        $file_path = DIR_IMAGE . 'repository/';



        $model = mb_convert_case($model, MB_CASE_UPPER, "UTF-8");

        $koleksiyon = mb_convert_case($koleksiyon, MB_CASE_UPPER, "UTF-8");



        $model_prefix = substr($model, 0, 2);

        

        //Custom Case Yüklerken Bunları Kapalı Tut

        $main_category = mb_convert_case($main_category, MB_CASE_UPPER, "UTF-8");

        $alt_category = str_replace(' ', '_', mb_convert_case($alt_category, MB_CASE_UPPER, "UTF-8"));

        $color = str_replace(' ', '_', mb_convert_case($color, MB_CASE_UPPER, "UTF-8"));

        //Custom Case Yüklerken Bunları Açık Tut

        //$main_category = mb_convert_case($main_category, MB_CASE_LOWER, "UTF-8");

        //$alt_category = str_replace(' ', '-', mb_convert_case($alt_category, MB_CASE_LOWER, "UTF-8"));

        //$color = str_replace(' ', '_', mb_convert_case($color, MB_CASE_UPPER, "UTF-8"));

        $images = array();

        if ($model_prefix == 'ISM') {

            $image_1 = $file_path . 'ISM/' . $model . '/' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '.jpeg';

            if (is_file($image_1)) {

                $images[] = 'repository/' . 'ISM/' . $model . '/' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '.jpeg';

            } else {

                echo $image_1 . ' Bulunamadı! <br>';

            }

        }

        else if ($model_prefix == 'CLX') {

			

			$image_1 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-1.jpeg';

			

            $image_2 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

			

            $image_3 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-3.jpeg';


            if (is_file($image_1)) {
            $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-1.jpeg';
            } else {

                echo $image_1 . '<br>';

            }


            if (is_file($image_2)) {
            $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';
            } else {

                echo $image_2 . '<br>';

            }

            if (is_file($image_3)) {
            $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-3.jpeg';
            } else {

                echo $image_3 . '<br>';

            }
           

        }

        

		else if ($model_prefix == 'PSs') {

            $image_1 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            $image_2 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            $image_3 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            if (is_file($image_1)) {
            $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';
            } else {

                echo $image_1 . '<br>';

            }

            if (is_file($image_2)) {
            $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';
            } else {

                echo $image_2 . '<br>';

            }

            if (is_file($image_3)) {
            $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';
            } else {

                echo $image_3 . '<br>';

            }

        }

        else if ($model_prefix == 'PS') {

            

            $image_1 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-1.jpeg';

            

            $image_2 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-2.jpeg';

            

            $image_3 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-3.jpeg';


            if(is_file($image_1)){

                $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-1.jpeg';

            }  else { echo $image_1 . ' Bulunamadı <br>'; }


            if(is_file($image_2)){

                $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-2.jpeg';

            }  else { echo $image_2 . ' Bulunamadı <br>'; }


            if(is_file($image_3)){

                $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-3.jpeg';

            } else { echo $image_3 . ' Bulunamadı <br>'; }

        }

        else if ($model_prefix == 'GSPPx') {

            $image_1 = $file_path . 'GSPP/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-1.jpeg';


            $image_2 = $file_path . 'GSPP/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-2.jpeg';   

            $image_3 = $file_path . 'GSPP/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-3.jpeg';

            if(is_file($image_1)){

                $images[] = 'repository/' . 'GSPP/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-1.jpeg';

            }  else { echo $image_1 . ' Bulunamadı <br>'; }


            if(is_file($image_2)){

                $images[] = 'repository/' . 'GSPP/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-2.jpeg';

            }  else { echo $image_2 . ' Bulunamadı <br>'; }


            if(is_file($image_3)){

                $images[] = 'repository/' . 'GSPP/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-3.jpeg';

            } else { echo $image_3 . ' Bulunamadı <br>'; }

        }

        else if ($model_prefix == 'TWE') {

            $image_1 = $file_path . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-1.jpeg';

            $image_2 = $file_path . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-2.jpeg';

            $image_3 = $file_path . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-3.jpeg';

            $image_4 = $file_path . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-4.jpeg';

            $image_5 = $file_path . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-5.jpeg';


            if (is_file($image_1)) {

                $images[] = 'repository/' . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-1.jpeg';

            } else {

                echo $image_1 . '<br>';

            }

            if (is_file($image_2)) {

                $images[] = 'repository/' . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-2.jpeg';

            } else {

                echo $image_2 . '<br>';

            }

            if (is_file($image_3)) {

                $images[] = 'repository/' . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-3.jpeg';

            } else {

                echo $image_3 . '<br>';

            }

            if (is_file($image_4)) {

                $images[] = 'repository/' . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-4.jpeg';

            } else {

                echo $image_4 . '<br>';

            }

            if (is_file($image_5)) {

                $images[] = 'repository/' . 'TWE/BANDS/' . $model . '/' . $model . '-APPLE_WATCH-LEATHER_WHITE_STRAP-ROSE_GOLD_ACCESSORY-5.jpeg';

            } else {

                echo $image_5 . '<br>';

            }

        }

        else if ($model_prefix == 'MAC') {

            $image_1 = $file_path . 'MACBOOKS/' . $model . '/' . $model . '-APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-1.jpeg';

            $image_2 = $file_path . 'MACBOOKS/' . $model . '/' . $model . '-APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-2.jpeg';

            $image_3 = $file_path . 'MACBOOKS/MAC/APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-3.jpg';

            $image_4 = $file_path . 'MACBOOKS/MAC/APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-4.jpg';

            $image_5 = $file_path . 'MACBOOKS/MAC/APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-5.jpg';


            if (is_file($image_1)) {

                $images[] = 'repository/' . 'MACBOOKS/' . $model . '/' . $model . '-APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-1.jpeg';

            } else {

                echo $image_1 . '<br>';

            }

            if (is_file($image_2)) {

                $images[] = 'repository/' . 'MACBOOKS/' . $model . '/' . $model . '-APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-2.jpeg';

            } else {

                echo $image_2 . '<br>';

            }

            if (is_file($image_3)) {

                $images[] = 'repository/' . 'MACBOOKS/MAC/APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-3.jpg';

            } else {

                echo $image_3 . '<br>';

            }

            if (is_file($image_4)) {

                $images[] = 'repository/' . 'MACBOOKS/MAC/APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-4.jpg';

            } else {

                echo $image_4 . '<br>';

            }

            if (is_file($image_5)) {

                $images[] = 'repository/' . 'MACBOOKS/MAC/APPLE-MACBOOK_PRO-SEFFAF-SEFFAF_SAYDAM-5.jpg';

            } else {

                echo $image_5 . '<br>';

            }

        }


        else if ($model_prefix == 'CST') {

            

            $image_1 = $file_path . 'CST/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ.png';
            

            if(is_file($image_1)){

                $images[] = 'repository/' . 'CST/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ.png';

            }  else { echo $image_1 . ' Bulunamadı <br>'; }


        }


        else if ($model_prefix == 'CST') {

            $image_1 = $file_path . 'CST/' . $model . '/' . $main_category . '-' . $alt_category . '.png';

            if (is_file($image_1)) {

                $images[] = 'repository/' . 'CST/' . $model . '/' . $main_category . '-' . $alt_category .'.png';

            } else {

                echo $image_1 . ' Bulunamadı! <br>';

            }

        }


        else if ($model_prefix == 'SLC') {

            $image_1 = $file_path . 'SLC/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            $image_2 = $file_path . 'SLC/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            $image_3 = $file_path . 'SLC/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            $image_4 = $file_path . 'SLC/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-4.jpeg';

            if (is_file($image_1)) {

                $images[] = 'repository/' . 'SLC/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            } else {

                echo $image_1 . '<br>';

            }

            if (is_file($image_2)) {

                $images[] = 'repository/' . 'SLC/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            } else {

                echo $image_2 . '<br>';

            }

            if (is_file($image_3)) {

                $images[] = 'repository/' . 'SLC/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            } else {

                echo $image_3 . '<br>';

            }

            if (is_file($image_4)) {

                $images[] = 'repository/' . 'SLC/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-4.jpeg';

            } else {

                echo $image_4 . '<br>';

            }

        }

		else if ($model_prefix == 'ANMx') {

			

			$image_1 = $file_path . 'ANM/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-1.jpeg';

			

            $image_2 = $file_path . 'ANM/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-2.jpeg';

			

            $image_3 = $file_path . 'ANM/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-3.jpeg';


            if(is_file($image_1)){

                $images[] = 'repository/' . 'ANM/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-1.jpeg';

            }  else { echo $image_1 . ' Bulunamadı <br>'; }


            if(is_file($image_2)){

                $images[] = 'repository/' . 'ANM/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-2.jpeg';

            }  else { echo $image_2 . ' Bulunamadı <br>'; }


            if(is_file($image_3)){

                $images[] = 'repository/' . 'ANM/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-POPSOCKETSIZ-3.jpeg';

            } else { echo $image_3 . ' Bulunamadı <br>'; }

        }

		else if ($model_prefix == 'PS') {



            $image_1 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-1.jpeg';

            $image_2 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

            $image_3 = $file_path . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-3.jpeg';

            if(is_file($image_1)){

                $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-1.jpeg';

            }  else { echo $image_1 . ' Bulunamadı <br>'; }



            if(is_file($image_2)){

                $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

            }  else { echo $image_2 . ' Bulunamadı <br>'; }



            if(is_file($image_3)){

                $images[] = 'repository/' . 'PS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-3.jpeg';

            } else { echo $image_3 . ' Bulunamadı <br>'; }



        }

		/*

		else if ($model_prefix == 'VS') {

            $image_1 = $file_path . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            $image_2 = $file_path . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            $image_3 = $file_path . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            if (is_file($image_1)) {

                $images[] = 'repository/' . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            } else {

                echo $image_1 . '<br>';

            }

            if (is_file($image_2)) {

                $images[] = 'repository/' . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            } else {

                echo $image_2 . '<br>';

            }

            if (is_file($image_3)) {

                $images[] = 'repository/' . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            } else {

                echo $image_3 . '<br>';

            }

        }

        */

		/*

        else if ($model_prefix == 'MR') {

            if($attr_coll != 'PREMIUM_GLOSSY'){

                $image_1 = $file_path . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

                $image_2 = $file_path . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

                $image_3 = $file_path . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

                if (is_file($image_1)) {

                    $images[] = 'repository/' . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

                } else {

                    echo $image_1 . '<br>';

                }

                if (is_file($image_2)) {

                    $images[] = 'repository/' . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

                } else {

                    echo $image_2 . '<br>';

                }

                if (is_file($image_3)) {

                    $images[] = 'repository/' . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

                } else {

                    echo $image_3 . '<br>';

                }

            }else{

                $image_1 = $file_path . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-1.jpeg';

                $image_2 = $file_path . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

                $image_3 = $file_path . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-3.jpeg';

                if (is_file($image_1)) {

                    $images[] = 'repository/' . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-1.jpeg';

                } else {

                    echo $image_1 . '<br>';

                }

                if (is_file($image_2)) {

                    $images[] = 'repository/' . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

                } else {

                    echo $image_2 . '<br>';

                }

                if (is_file($image_3)) {

                    $images[] = 'repository/' . 'mermer/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-3.jpeg';

                } else {

                    echo $image_3 . '<br>';

                }

				

				}



        }

		*/

		/*

		else if ($model_prefix == 'VS') {

            if($attr_coll != 'PREMIUM_GLOSSY'){

                $image_1 = $file_path . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '.jpeg';

                $image_2 = $file_path . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

                if (is_file($image_1)) {

                    $images[] = 'repository/' . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '.jpeg';

                } else {

                    echo $image_1 . '<br>';

                }

                if (is_file($image_2)) {

                    $images[] = 'repository/' . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

                } else {

                    echo $image_2 . '<br>';

                }

            } else{

                $image_1 = $file_path . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '.jpeg';

                $image_2 = $file_path . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

                if (is_file($image_1)) {

                    $images[] = 'repository/' . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '.jpeg';

                } else {

                    echo $image_1 . '<br>';

                }

                if (is_file($image_2)) {

                    $images[] = 'repository/' . 'GB/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

                } else {

                    echo $image_2 . '<br>';

                }

            }



        }

		*/

		/*

		else if ($model_prefix == 'CL') {



            $image_1 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            $image_1_black = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-1.jpeg';

            $image_1_silver = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-1.jpeg';



            $image_2 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            $image_2_black = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-2.jpeg';

            $image_2_silver = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-2.jpeg';



            $image_3 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            $image_3_black = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-3.jpeg';

            $image_3_silver = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-3.jpeg';

			

             if (is_file($image_1)) {

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            } //else { echo $image_1 . ' Bulunamadı <br>'; }



            if(is_file($image_1_black)){

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-1.jpeg';

            }  //else { echo $image_1_black . ' Bulunamadı <br>'; }



            if(is_file($image_1_silver)){

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-1.jpeg';

            } //else { echo $image_1_silver . ' Bulunamadı <br>'; }





            if (is_file($image_2)) {

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            }  //else { echo $image_2 . ' Bulunamadı <br>'; }



            if(is_file($image_2_black)){

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-2.jpeg';

            }  //else { echo $image_2_black . ' Bulunamadı <br>'; }



            if(is_file($image_2_silver)){

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-2.jpeg';

            } //else { echo $image_2_silver . ' Bulunamadı <br>'; }



            if (is_file($image_3)) {

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            }  //else { echo $image_3 . ' Bulunamadı <br>'; }



            if(is_file($image_3_black)){

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-3.jpeg';

            }  //else { echo $image_3_black . ' Bulunamadı <br>'; }



            if(is_file($image_3_silver)){

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-3.jpeg';

            } //else { echo $image_3_silver . ' Bulunamadı <br>'; }



        }

		else if ($model_prefix == 'CL') {

            $image_1 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            $image_2 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            $image_3 = $file_path . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            if (is_file($image_1)) {

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            } else {

                echo $image_1 . '<br>';

            }

            if (is_file($image_2)) {

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            } else {

                echo $image_2 . '<br>';

            }

            if (is_file($image_3)) {

                $images[] = 'repository/' . 'COLORS/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            } else {

                echo $image_3 . '<br>';

            }

        }*/

		/*

		else if ($model_prefix == 'LMS1') {

            $image_1 = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            $image_2 = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            $image_3 = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            if (is_file($image_1)) {

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            } else {

                echo $image_1 . '<br>';

            }

            if (is_file($image_2)) {

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            } else {

                echo $image_2 . '<br>';

            }

            if (is_file($image_3)) {

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            } else {

                echo $image_3 . '<br>';

            }

        }

        else if ($model_prefix == 'SS') {



            $image_1 = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            $image_1_black = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-1.jpeg';

            $image_1_silver = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-1.jpeg';



            $image_2 = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            $image_2_black = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-2.jpeg';

            $image_2_silver = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-2.jpeg';



            $image_3 = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            $image_3_black = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-3.jpeg';

            $image_3_silver = $file_path . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-3.jpeg';

			

             if (is_file($image_1)) {

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

            } else { echo $image_1 . ' Bulunamadı <br>'; }



            if(is_file($image_1_black)){

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-1.jpeg';

            }  else { echo $image_1_black . ' Bulunamadı <br>'; }



            if(is_file($image_1_silver)){

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-1.jpeg';

            } else { echo $image_1_silver . ' Bulunamadı <br>'; }





            if (is_file($image_2)) {

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

            }  else { echo $image_2 . ' Bulunamadı <br>'; }



            if(is_file($image_2_black)){

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-2.jpeg';

            }  else { echo $image_2_black . ' Bulunamadı <br>'; }



            if(is_file($image_2_silver)){

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-2.jpeg';

            } else { echo $image_2_silver . ' Bulunamadı <br>'; }



            if (is_file($image_3)) {

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

            }  else { echo $image_3 . ' Bulunamadı <br>'; }



            if(is_file($image_3_black)){

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-BLACK-3.jpeg';

            }  else { echo $image_3_black . ' Bulunamadı <br>'; }



            if(is_file($image_3_silver)){

                $images[] = 'repository/' . 'new iphone 11 and blue/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-SILVER-3.jpeg';

            } else { echo $image_3_silver . ' Bulunamadı <br>'; }



        }*/

		/*

		else if ($model_prefix == 'OLD') {

            if($attr_coll != 'PREMIUM_GLOSSY'){

                $image_1 = $file_path . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

                $image_2 = $file_path . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

                $image_3 = $file_path . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

                if (is_file($image_1)) {

                    $images[] = 'repository/' . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-1.jpeg';

                } else {

                    echo $image_1 . '<br>';

                }

                if (is_file($image_2)) {

                    $images[] = 'repository/' . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-2.jpeg';

                } else {

                    //echo $image_2 . '<br>';

                }

                if (is_file($image_3)) {

                    $images[] = 'repository/' . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $koleksiyon . '-' . $attr_coll . '-3.jpeg';

                } else {

                    //echo $image_3 . '<br>';

                }

            }else{

                $image_1 = $file_path . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-1.jpeg';

                $image_2 = $file_path . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

                $image_3 = $file_path . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-3.jpeg';

                if (is_file($image_1)) {

                    $images[] = 'repository/' . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-1.jpeg';

                } else {

                    echo $image_1 . '<br>';

                }

                if (is_file($image_2)) {

                    $images[] = 'repository/' . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-2.jpeg';

                } else {

                    //echo $image_2 . '<br>';

                }

                if (is_file($image_3)) {

                    $images[] = 'repository/' . 'OLD/' . $model . '/' . $model . '-' . $main_category . '-' . $alt_category . '-' . $attr_coll . '-3.jpeg';

                } else {

                    //echo $image_3 . '<br>';

                }

            }



        }*/

        //var_dump($images);

        return $images;

    }



}

