<?php echo $header; ?>
<div class="container">
    <ul class="breadcrumb">
        <?php foreach ($breadcrumbs as $breadcrumb) { ?>
        <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
        <?php } ?>
    </ul>
    <?php if ($success) { ?>
    <div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
        <button type="button" class="close" data-dismiss="alert">&times;</button>
    </div>
    <?php } ?>
    <?php if ($error_warning) { ?>
    <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
        <button type="button" class="close" data-dismiss="alert">&times;</button>
    </div>
    <?php } ?>
    <div class="row"><?php echo $column_left; ?>
        <?php if ($column_left && $column_right) { ?>
        <?php $class = 'col-sm-6'; ?>
        <?php } elseif ($column_left || $column_right) { ?>
        <?php $class = 'col-sm-9'; ?>
        <?php } else { ?>
        <?php $class = 'col-sm-12'; ?>
        <?php } ?>
        <div id="content" class="<?php echo $class; ?>"><?php echo $content_top; ?>
            <h2><?php echo $heading_title; ?></h2>

            <form action="<?=$action;?>" method="post">
                <table class="table table-bordered table-hover">
                    <thead>
                    <tr>
                        <td class="text-left" colspan="2"><?php echo $text_order_detail; ?></td>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class="text-left" style="width: 50%;">
                            <b>Teslimat Bilgileri</b><br>
                            Adınız: <input type="text" name="shipping_firstname" value="<?=$shipping_firstname;?>">
                            <?php if($error_shipping_firstname){ ?>
                            <?=$error_shipping_firstname;?>
                            <?php } ?>
                            <br>
                            Soyadınız: <input type="text" name="shipping_lastname" value="<?=$shipping_lastname;?>">
                            <?php if($error_shipping_lastname){ ?>
                            <?=$error_shipping_lastname;?>
                            <?php } ?>
                            <br>
                            Telefon: <input type="text" name="telephone" value="<?=$telephone;?>">
                            <?php if($error_telephone){ ?>
                                <?=$error_telephone;?>
                            <?php } ?>
                            <br>
                            Teslimat Adresi: <textarea name="shipping_address_1"><?=$shipping_address_1;?></textarea>
                            <?php if($error_shipping_address_1){ ?>
                            <?=$error_shipping_address_1;?>
                            <?php } ?>
                            <br>
                            İlçe: <input type="text" name="shipping_city" value="<?=$shipping_city;?>">
                            <?php if($error_shipping_city){ ?>
                            <?=$error_shipping_city;?>
                            <?php } ?>
                            <br>
                            Şehir:
                            <select name="zone_id">

                            </select>
                            <?php if($error_zone_id){ ?>
                            <?=$error_zone_id;?>
                            <?php } ?>
                            <br>
                            Ülke: <select name="country_id" id="shipping-address">
                                <?php foreach($countries as $country){ ?>
                                    <?php if($country['country_id'] == $shipping_country_id){ ?>
                                        <option value="<?=$country['country_id'];?>" selected ><?=$country['name'];?></option>
                                    <?php }else{ ?>
                                        <option value="<?=$country['country_id'];?>"><?=$country['name'];?></option>
                                    <?php } ?>
                                <?php } ?>
                            </select>
                            <?php if($error_country_id){ ?>
                            <?=$error_country_id;?>
                            <?php } ?>
                            <br>
                            <input type="submit" value="Kaydet">
                        </td>

                    </tr>
                    </tbody>
                </table>
            </form>




            <?php echo $content_bottom; ?></div>
        <?php echo $column_right; ?></div>
</div>


<script type="text/javascript">

    $(function () {

        setTimeout(function () {
            $('select[name=\'country_id\']').trigger('change');
        }, 1000);

        $('select[name=\'country_id\']').on('change', function() {
            $.ajax({
                url: 'index.php?route=quickcheckout/checkout/country&country_id=' + this.value,
                dataType: 'json',
                cache: false,
                beforeSend: function() {
                    $('select[name=\'country_id\']').after('<i class="fa fa-spinner fa-spin"></i>');
                },
                complete: function() {
                    $('.fa-spinner').remove();
                },
                success: function(json) {

                    html = '';
                    if (json['zone'] != '') {

                        html += '<option value=""';
                        html += '> Seçiniz</option>';

                        for (i = 0; i < json['zone'].length; i++) {
                            html += '<option value="' + json['zone'][i]['zone_id'] + '"';

                            if (json['zone'][i]['zone_id'] == '<?php echo $shipping_zone_id; ?>') {
                                html += ' selected="selected"';
                            }

                            html += '>' + json['zone'][i]['name'] + '</option>';
                        }
                    } else {
                        html += '<option value="0" selected="selected"><?php echo $text_none; ?></option>';
                    }

                    $('select[name=\'zone_id\']').html(html).trigger('change');
                }
        });
        });
    });

  </script>

<?php echo $footer; ?>