<style>
    #HALLOWEEN.Hidden,
    #HALLOWEEN--Loading.Hidden {
        display: none !important;
    }
</style>
<script>
    window.onload = function () {
        jQuery (function ($) {
            $(window).resize (function () {
                $('#content').css ('padding-top', $('.halloween-desktop-bg').height () / 2);
                // $('.scroll-icon').css ('top', $('.halloween-desktop-bg').height () - 500);
            });
/* - */
if (sessionStorage.getItem ("HALLOWEEN--Loading"))
            {
                $('#HALLOWEEN--Loading').addClass ('Hidden');
                $('#HALLOWEEN').removeClass ('Hidden');
                /* - */
                $('#content').css ('padding-top', $('.halloween-desktop-bg').height () / 2);
                // $('.scroll-icon').css ('top', $('.halloween-desktop-bg').height () - 500);
            }
        });
    };
</script>
<div id="HALLOWEEN--Loading">
    <style>
        #HALLOWEEN--Loading {
            background:#000;
            overflow: hidden;
            text-align:center;
            height: 100%;
            width: 100%;
            margin: 0;
            padding: 0;
        }
#HALLOWEEN--Loading svg{
            width:100%;
            height:100%;
            visibility:hidden;
            display: flex;
            align-items: center;
            justify-content: center;
}
        #HALLOWEEN--Loading .hallowText {
            font-family: 'Creepster', cursive;
            text-anchor:middle;
            letter-spacing:2px;
            fill:#E48D29;
        }
        #HALLOWEEN--Loading .topText{
            font-size:105px;
        }
        #HALLOWEEN--Loading .botText{
            font-size:100px;
        }
        /* #D97624 */
        #HALLOWEEN--Loading .backgroundGradient{
            stop-color:#35409C;
            stop-color:#AE0000;
            stop-color:#C410B1;
            /* stop-color:#89B405; */
        }
@media (max-width: 768px)
        {
            #HALLOWEEN--Loading .topText{
                font-size:78px;
            }
            #HALLOWEEN--Loading .botText{
                font-size:56px;
            }
        }
    </style>
    <svg viewBox="0 0 600 600">
        <defs>
            <path id="pumpkinFace" d="M324.8,423.7c-2,1.8-3.8,3.3-5.5,4.8c-1.8,1.6-4,2.6-6.3,3.4
  c-4.6,1.3-9.1,1.4-13.4-1.1c-2.2-1.4-4.5-2.8-6.8-4.3c-2.4-1.4-4.9-1.8-7.7-0.6c-5.6,2.5-11.7,3.9-17.7,6c-2.2,0.8-4.6,1.1-7.1,1.4
  c-2.4,0.3-4.3-0.4-6.1-1.8c-2-2-4.1-4-6.2-5.8c-1.4-1.4-3-2.8-4.5-4.2c-3.3-2.4-6.8-4.2-10.9-5.2c-2.9-0.6-5.8-1.4-8.8-2
  c-7.1-1.3-13.7-3.6-20.2-6.3c-9.7-4-19.4-8.1-27.7-14.3c-0.4-0.3-0.7-0.6-1.3-0.9c-7.7-4.4-13.3-10.7-18.2-17.4
  c-2.2-3-4.1-6.2-6.1-9.3c-2-3-3-6-3-9.6c-0.1-3-1.2-6-1.9-9.3c0.1-3.1,0.6-6.5,0.6-9.8c0.1-12.6,2.6-24.9,6.7-36.8
  c4-11.3,8.8-22.3,16.8-31.9c6.4-7.9,13-15.5,21.4-22c1.6-1.3,3.3-2.5,5.4-3.2c2-0.8,3.8-1.9,5.7-2.8c6.3-3,12.5-6,19.6-7.6
  c5.1-1.1,10.2-2,15.4-2.5c11.4-0.9,22.6,0.2,33.7,2.5c1.8,0.4,3.6,1.2,5.4,1.8c1.3,0.4,2.5,0.8,4.1,1.1c0.9-0.7,1.9-1.3,2.3-2
  c4.5-7.6,7-21.8,5.4-30.1c-0.7-3.5-1.2-7.1-2.7-10.5c-0.3-0.6,0.1-1.4,0.2-2c12.2-4.8,22.8-11.7,32.3-19.8c1.2-1,2.2-2.2,3.5-3.1
  c1.5-1.1,3-2.1,5.1-1.9c0.5,0.1,1.2,0.2,1.6,0.4c3.7,3.2,7.9,5.9,12,8.7c3.5,2.5,6.7,5.2,9.8,7.7c1,0.8,1.8,1.8,2.8,2.8
  c0.1,1.4,0.1,2.8,0.2,3.9c-2.8,3.8-5.1,7.3-7.6,10.7c-1.9,2.6-4.5,4.8-8.5,5.7c-3.1,0-6.2-0.8-9.5-1.6c-4.2-1.1-7.2-3.4-9.3-6.7
  c-0.4-0.6-0.4-1.4-0.7-2.1c2-2.3,5-3.5,6.5-5.4c2.2,0.2,2.8,1.1,3.3,2c1.2,2.3,3,4,5.8,5c3.3-1.1,5-3.6,6.6-5.5
  c0.5-2.1-0.5-3.3-1.7-4.2c-4.2-2.9-8.8-5-13.7-6.3c-5.9,3.7-7.7,6-10.4,10.8c-4.5,7.7-5.9,16.1-5.9,24.4c0,6.4,2.2,12.3,7.2,17.2
  c0.1,0.1,0.4,0.2,1.2,0.4c2-0.9,4-1.9,6.2-2.9c2.1-0.9,4.4-2,6.7-2.9c11.2-4.5,22.6-7.5,35.1-6.2c3.9,0.4,7.7,0.6,11.6,0.8
  c7.1,0.3,13.4,2.5,19.6,5.2c0.4,0.2,0.9,0.6,1.4,0.8c7.8,2.1,13.4,7.2,18.8,12.4c1.2,1.1,2.1,2.2,3.3,3.2c5.3,4.4,9,9.7,12.4,15.2
  c5.2,8.4,10.1,17.1,13.5,26.2c0.7,1.8,1.7,3.5,2.5,5.3c1.5,4.1,3.5,8.2,4.3,12.3c2.1,10.9,3.8,21.9,3.5,32.9
  c-0.4,13.9-3,27.2-11.2,39.5c-6.2,9.5-15.2,16.1-26.4,20.8c-10.3,4.4-21.3,6.5-32,9.4c-1.4,0.4-2.8,0.4-4,0.9
  c-3.2,1.1-5.9,2.6-7.6,5.3c-1.3,1.8-2.5,3.7-3.9,5.5c-0.9,1.3-1.5,2.5-2.6,3.7c-2.5,2.8-5.8,4.4-9.9,4.6c-2.8,0.2-5.4,0-8.2-0.6
  c-3.8-0.8-7.7-1.4-11.3-2.3C333.4,422.8,329.3,422.8,324.8,423.7z"/>
<linearGradient id="pumpkinDepthGrad" data-name="New Gradient Swatch 1" x1="382.43" y1="262.77" x2="391.61" y2="261.46" gradientUnits="userSpaceOnUse">
                <stop class="depthGradMid" offset="0.01" stop-color="#f6b431"/>
                <stop offset="0.92" stop-color="#b42213"/>
            </linearGradient>
            <linearGradient id="pumpkinDepthGrad-2" x1="201.28" y1="341.55" x2="189.27" y2="346.13" xlink:href="#pumpkinDepthGrad"/>
            <linearGradient id="pumpkinDepthGrad-3" x1="248.29" y1="377.28" x2="238.47" y2="385.15" xlink:href="#pumpkinDepthGrad"/>
            <linearGradient id="pumpkinDepthGrad-4" x1="360.88" y1="373.64" x2="371.28" y2="381.58" xlink:href="#pumpkinDepthGrad"/>
            <linearGradient id="pumpkinDepthGrad-5" x1="398.22" y1="333.4" x2="413.73" y2="338.21" xlink:href="#pumpkinDepthGrad"/>
            <linearGradient id="pumpkinDepthGrad-6" x1="211.22" y1="270.28" x2="201.17" y2="268.54" xlink:href="#pumpkinDepthGrad"/>
            <linearGradient id="pumpkinDepthGrad-7" x1="283.51" y1="289.42" x2="296.66" y2="289.42" xlink:href="#pumpkinDepthGrad"/>
            <linearGradient id="pumpkinDepthGrad-8" x1="302.37" y1="288.79" x2="315.19" y2="288.79" xlink:href="#pumpkinDepthGrad"/>
            <linearGradient id="pumpkinDepthGrad-9" x1="281.14" y1="390.57" x2="273.87" y2="396.38" xlink:href="#pumpkinDepthGrad"/>
            <linearGradient id="pumpkinDepthGrad-10" x1="327.22" y1="384.21" x2="333.69" y2="389.15" xlink:href="#pumpkinDepthGrad"/>
<radialGradient id="pumpkinBgGrad" cx="300" cy="300" r="150" gradientUnits="userSpaceOnUse">
                <stopoffset="0.1" style="stop-color:#F7B93F"/>
                <stop class="lanternMid"  offset="0.2" style="stop-color:#F6B431"/>
                <stop   class="lanternTop"  offset="0.57" style="stop-color:#B42213"/>
                <stop  offset="1" style="stop-color:#542213"/>
            </radialGradient>
<filter id="goo" color-interpolation-filters="sRGB">
                <feGaussianBlur in="SourceGraphic" stdDeviation="6" result="blur" />
                <feColorMatrix in="blur" mode="matrix" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 17 -7" result="cm" />
</filter>
            <radialGradient id="bgGrad" cx="290" cy="390" r="120" gradientUnits="userSpaceOnUse">
<stop  offset="1.899808e-002" style="stop-color:#4C587A"/>
                <stop  offset="5.148149e-002" style="stop-color:#7D8090"/>
                <stop  offset="8.377692e-002" style="stop-color:#A5A2A3"/>
                <stop  offset="0.1153" style="stop-color:#C5BBB1"/>
                <stop  offset="0.1457" style="stop-color:#DBCEBC"/>
                <stop  offset="0.1747" style="stop-color:#E8D9C2"/>
                <stop  offset="0.2006" style="stop-color:#EDDDC4"/>
                <stop  offset="0.2603" style="stop-color:#EFE1CB"/>
                <stop  offset="0.3462" style="stop-color:#F5ECDE"/>
                <stop  offset="0.4477" style="stop-color:#FEFEFD"/>
                <stop  offset="0.4531" style="stop-color:#FFFFFF"/>
                <stop  offset="0.4902" style="stop-color:#FEF3DD"/>
                <stop  offset="0.5714" style="stop-color:#FAD488"/>
                <stop  offset="0.6375" style="stop-color:#F7B93F"/>
                <stop  offset="0.767" style="stop-color:#F6B431"/>
                <stop  offset="0.9223" style="stop-color:#B42213"/>
            </radialGradient>
            <path id="dot" fill="#fff" d="M303,300c0,1.7-1.3,3-3,3s-3-1.3-3-3s1.3-3,3-3S303,298.3,303,300z"/>
            <radialGradient id="bgGlowGrad" cx="300" cy="310" r="290" gradientUnits="userSpaceOnUse">
                <stop class="backgroundGradient" offset="0" stop-color="#A30001"/>
                <stop offset="1"  stop-color="#000"/>
            </radialGradient>
</defs>
        <rect class="glowBg" width="600" height="600" fill="url(#bgGlowGrad)" opacity="0.41"/>
        <g class="topTextGroup">
            <use xlink:href="#topText" fill="#101000" stroke="url(#pumpkinBgGrad)" stroke-width="6" y="-1"/>
            <use xlink:href="#topText" fill="#101000" stroke="#101010" stroke-width="3" />
        </g>
        <g class="wholePumpkin" opacity="1">
            <use xlink:href="#pumpkinFace" fill="url(#pumpkinBgGrad)"/>
<mask id="flameMask"></mask>
<g id="pumpkinDepthGroup">
                <path d="M323.16,269.26h0s0,.08,0,.12Z"/>
                <path d="M390.22,270a7.58,7.58,0,0,1-2.17.75c-1.8,0-3.59,0-5.39,0a18.27,18.27,0,0,0,.32-3.14c.07-4.59-1.77-9-3.85-13.1a19.47,19.47,0,0,1,8.12.67,27.63,27.63,0,0,1,2.1,3.46A21.63,21.63,0,0,1,390.22,270Z" fill="url(#pumpkinDepthGrad)"/>
                <path d="M211.3,356.6c3.86,4.75,6.49,10.34,8.85,16-2.1,1.75-4.37,3.35-6.34,5.21-.58.51-1.53.57-2.68.95a14.49,14.49,0,0,1-2.39-1.64c-1.45-1.83-2.9-3.53-4.28-5.35-2.82-4-5.86-8.06-8.47-12.35-3.11-5.22-6.23-10.64-7.89-16.56-.73-2.2-1.52-4.53-2.25-6.92a17.83,17.83,0,0,1-1-3.47c-.8-7.43-1.52-14.79-2.25-22.22a5.24,5.24,0,0,1,.73-2.71c.07-.38.65-.57,1.3-.82,2.1.13,3.19,1.51,4.64,2.71,3.1,2.73,6.23,5.44,9.26,8.22.37,8.41,2.58,16.67,4.77,24.83a30.18,30.18,0,0,0,2.61,7.23C207.33,352.26,209.45,354.34,211.3,356.6Z" fill="url(#pumpkinDepthGrad-2)"/>
                <path d="M252.39,381.78a61.57,61.57,0,0,1,6.26,9.22,12.38,12.38,0,0,1-3.93,4.77,6,6,0,0,1-4.85-2.9c-5.43-6.36-10.79-12.78-16-19.2-1.51-1.77-2.84-3.64-4-5.28l8.46-.06A7.4,7.4,0,0,1,242,369a7.28,7.28,0,0,1,2.06,2Z" fill="url(#pumpkinDepthGrad-3)"/>
                <path d="M377.85,361.8a47,47,0,0,0-4.72,7,168.78,168.78,0,0,1-13.33,18.07c-1.3,1.76-3.4,3.08-5.21,4.47-.51.44-1.45.38-2.32.5a8.26,8.26,0,0,1-1.52-1.7c-.23-.84-.48-1.67-.72-2.51,1-1,1.89-2,2.8-3.1q8.08-9.34,15.8-19a10.8,10.8,0,0,1,3.32-3.14,8.12,8.12,0,0,1,3.26-.73A14.58,14.58,0,0,1,377.85,361.8Z" fill="url(#pumpkinDepthGrad-4)"/>
                <path d="M415.64,302.76c-.65,4.79-.94,9.64-2.1,14.3-3.26,12.09-6.59,24.18-10.21,36.33a35.55,35.55,0,0,1-7.75,14.17c-.07.25-.44.38-.58.5a7.89,7.89,0,0,1-5.8.57c-2.07-1.55-2.3-4.08-3.48-6.07q.83-2.22,1.77-4.41c3-6.87,6.65-13.45,8.9-20.58,2.38-7.54,3.08-15.48,3.53-23.39,4.44-4.37,8.7-8.83,13-13.24.29-.32.94-.38,1.44-.57A2.16,2.16,0,0,1,415.64,302.76Z" fill="url(#pumpkinDepthGrad-5)"/>
                <path d="M219.48,259.18c-3,1.1-4.83,4.14-6,7.12a34.72,34.72,0,0,0-2.39,12.86c-1.59.37-3.16.81-4.73,1.31-.95.32-2,.63-3.19,1-.58-.7-1.45-1.2-1.45-1.77a14.35,14.35,0,0,1,.22-4.28c1-4.41,2.32-8.88,3.47-13.29a9.73,9.73,0,0,1,1.16-2.14c1.6-1.13,3-1,4.42-1C213.85,258.9,216.68,259,219.48,259.18Z" fill="url(#pumpkinDepthGrad-6)"/>
                <path d="M289.27,288a15.5,15.5,0,0,1,7.39-3.21,23.27,23.27,0,0,0-5.48,8.92L285,294a4.58,4.58,0,0,1-1.44-.5c0-.38-.15-1,.14-1.2C285.57,290.8,287.38,289.48,289.27,288Z" fill="url(#pumpkinDepthGrad-7)"/>
                <path d="M315.19,292.25a27.94,27.94,0,0,1-3.11.5l-4.83.24c-.09-.4-.18-.8-.28-1.2a13.85,13.85,0,0,0-1.66-4.28,11.78,11.78,0,0,0-2.94-2.91,12.75,12.75,0,0,1,5.15,1.6c2.46,1.58,4.92,3,7.31,4.54C315.19,290.92,315,291.55,315.19,292.25Z" fill="url(#pumpkinDepthGrad-8)"/>
                <path d="M290.21,402a8.19,8.19,0,0,1-1.89.42,14.56,14.56,0,0,1-7.45-5c-1.89-2.45-3.84-4.72-5.51-7.11a24.24,24.24,0,0,0-7.75-6.55,4.37,4.37,0,0,0-.78-.31l5.46,0A7.4,7.4,0,0,1,276,384a7.28,7.28,0,0,1,2.06,2l8.32,10.79C287.7,398.48,289,400.18,290.21,402Z" fill="url(#pumpkinDepthGrad-9)"/>
                <path d="M340.28,374.68c-2,2.15-3.93,4.35-5.9,6.61-3.62,4.21-7.09,8.56-10.71,12.84a10.3,10.3,0,0,1-2.25,1.95,3.92,3.92,0,0,1-3.67.4q7.61-8.82,14.88-17.92a10.8,10.8,0,0,1,3.32-3.14,8.12,8.12,0,0,1,3.26-.73C339.57,374.67,339.92,374.67,340.28,374.68Z" fill="url(#pumpkinDepthGrad-10)"/>
            </g>
            <g class="pContainer" filter="url(#goo)"></g>
            <g class="flameGroup">
                <rect mask="url(#flameMask)" width="100%" height="100%" fill="url(#bgGrad)"/>
            </g>
            <path class="pumpkin" d="M324.8,423.7c-2,1.8-3.8,3.3-5.5,4.8c-1.8,1.6-4,2.6-6.3,3.4c-4.6,1.3-9.1,1.4-13.4-1.1
  c-2.2-1.4-4.5-2.8-6.8-4.3c-2.4-1.4-4.9-1.8-7.7-0.6c-5.6,2.5-11.7,3.9-17.7,6c-2.2,0.8-4.6,1.1-7.1,1.4c-2.4,0.3-4.3-0.4-6.1-1.8
  c-2-2-4.1-4-6.2-5.8c-1.4-1.4-3-2.8-4.5-4.2c-3.3-2.4-6.8-4.2-10.9-5.2c-2.9-0.6-5.8-1.4-8.8-2c-7.1-1.3-13.7-3.6-20.2-6.3
  c-9.7-4-19.4-8.1-27.7-14.3c-0.4-0.3-0.7-0.6-1.3-0.9c-7.7-4.4-13.3-10.7-18.2-17.4c-2.2-3-4.1-6.2-6.1-9.3c-2-3-3-6-3-9.6
  c-0.1-3-1.2-6-1.9-9.3c0.1-3.1,0.6-6.5,0.6-9.8c0.1-12.6,2.6-24.9,6.7-36.8c4-11.3,8.8-22.3,16.8-31.9c6.4-7.9,13-15.5,21.4-22
  c1.6-1.3,3.3-2.5,5.4-3.2c2-0.8,3.8-1.9,5.7-2.8c6.3-3,12.5-6,19.6-7.6c5.1-1.1,10.2-2,15.4-2.5c11.4-0.9,22.6,0.2,33.7,2.5
  c1.8,0.4,3.6,1.2,5.4,1.8c1.3,0.4,2.5,0.8,4.1,1.1c0.9-0.7,1.9-1.3,2.3-2c4.5-7.6,7-21.8,5.4-30.1c-0.7-3.5-1.2-7.1-2.7-10.5
  c-0.3-0.6,0.1-1.4,0.2-2c12.2-4.8,22.8-11.7,32.3-19.8c1.2-1,2.2-2.2,3.5-3.1c1.5-1.1,3-2.1,5.1-1.9c0.5,0.1,1.2,0.2,1.6,0.4
  c3.7,3.2,7.9,5.9,12,8.7c3.5,2.5,6.7,5.2,9.8,7.7c1,0.8,1.8,1.8,2.8,2.8c0.1,1.4,0.1,2.8,0.2,3.9c-2.8,3.8-5.1,7.3-7.6,10.7
  c-1.9,2.6-4.5,4.8-8.5,5.7c-3.1,0-6.2-0.8-9.5-1.6c-4.2-1.1-7.2-3.4-9.3-6.7c-0.4-0.6-0.4-1.4-0.7-2.1c2-2.3,5-3.5,6.5-5.4
  c2.2,0.2,2.8,1.1,3.3,2c1.2,2.3,3,4,5.8,5c3.3-1.1,5-3.6,6.6-5.5c0.5-2.1-0.5-3.3-1.7-4.2c-4.2-2.9-8.8-5-13.7-6.3
  c-5.9,3.7-7.7,6-10.4,10.8c-4.5,7.7-5.9,16.1-5.9,24.4c0,6.4,2.2,12.3,7.2,17.2c0.1,0.1,0.4,0.2,1.2,0.4c2-0.9,4-1.9,6.2-2.9
  c2.1-0.9,4.4-2,6.7-2.9c11.2-4.5,22.6-7.5,35.1-6.2c3.9,0.4,7.7,0.6,11.6,0.8c7.1,0.3,13.4,2.5,19.6,5.2c0.4,0.2,0.9,0.6,1.4,0.8
  c7.8,2.1,13.4,7.2,18.8,12.4c1.2,1.1,2.1,2.2,3.3,3.2c5.3,4.4,9,9.7,12.4,15.2c5.2,8.4,10.1,17.1,13.5,26.2c0.7,1.8,1.7,3.5,2.5,5.3
  c1.5,4.1,3.5,8.2,4.3,12.3c2.1,10.9,3.8,21.9,3.5,32.9c-0.4,13.9-3,27.2-11.2,39.5c-6.2,9.5-15.2,16.1-26.4,20.8
  c-10.3,4.4-21.3,6.5-32,9.4c-1.4,0.4-2.8,0.4-4,0.9c-3.2,1.1-5.9,2.6-7.6,5.3c-1.3,1.8-2.5,3.7-3.9,5.5c-0.9,1.3-1.5,2.5-2.6,3.7
  c-2.5,2.8-5.8,4.4-9.9,4.6c-2.8,0.2-5.4,0-8.2-0.6c-3.8-0.8-7.7-1.4-11.3-2.3C333.4,422.8,329.3,422.8,324.8,423.7z M323.2,269.3
  c1.8,0.4,3.8,0.3,5.6,0c3.5-0.4,7.2-0.9,10.6-0.8c9.9,0.4,19.8,0.8,29.6,1.6c6.3,0.6,12.7,0.6,19,0.6c0.7,0,1.4-0.5,2.2-0.8
  c0.7-3.9,0.4-7.6-0.9-11.3c-0.6-1.3-1.5-2.5-2.1-3.5c-3.4-1.1-6.4-0.8-9.4-0.6c-11.2,1-22.4,2.5-33.2,5c-6.1,1.6-12.1,3.3-17.5,6.2
  c-1.7,0.9-3.4,1.6-4,3.5V269.3z M395,368.1c0.1-0.1,0.5-0.3,0.6-0.5c3.8-4.2,6.3-9,7.7-14.2c3.6-12.2,7-24.2,10.2-36.3
  c1.2-4.7,1.4-9.5,2.1-14.3c0.1-0.9-0.1-1.9-1.3-2.4c-0.5,0.2-1.2,0.3-1.4,0.6c-4.6,4.7-9.1,9.5-13.9,14.2c-3.4,3.4-5.9,7.5-8.9,11.1
  c-0.6,0.6-1.2,1-2,1.4c-1.9,0.4-4.7,1.3-7.4-0.9c-2.4-2.3-4.9-4.7-7.6-7.2c-0.9-0.8-1.8-1-3-0.6c-3.6,2.7-2.2,7.2-4.8,10.5
  c-0.9,0-1.7,0.1-2.3-0.2c-1.1-0.4-2-0.9-2.8-1.7c-6.7-6-15.3-9.3-24-12.2c-1.6-0.6-3.3-0.8-5.1,0.3c-2.8,4.7-4.9,9.8-6.7,15
  c-1.3,2.3-2.8,3.8-5.2,4.2c-2.6,0.1-4.3-0.9-5.6-2.1c-1.7-1.5-3.3-3.2-5.1-4.8c-1.4-1.3-2.8-2.4-5.2-2.6c-0.9,0.7-1.9,1.4-2.7,2.3
  c-2.2,2.7-4.4,5.5-6.7,8.2c-0.6,0.9-1.4,1.4-3.1,1.4c-2.4-2-4.1-3.8-4.9-5.4c-2-2-4.1-4-5.7-6.2c-2.5-3-5.7-5.2-9.6-6.4
  c-0.9,0.3-2,0.3-2.5,0.6c-3,1.8-5.9,3.7-8.8,5.5c-4.8,2.8-8.6,6.5-12,10.1c-1.9,1.4-3.8-0.1-5-1.3c-0.7-0.6-1.2-1.5-1.8-2.3
  c-1.7-2.2-3.6-4.2-6.1-5.3c-1.7,0-2.5,0.5-2.8,1.5c-1,2.8-1.9,5.5-3,8.2c-0.9,2.2-3.3,4.6-5.6,3.6c-0.9-0.6-1.7-1.3-2.4-1.8
  c-2.7-2.8-5-5.8-7.8-8.4c-3-2.8-6.9-4.8-9.9-7.7c-4.3-4.3-9.1-8.3-13.7-12.4c-1.4-1.2-2.5-2.6-4.6-2.7c-0.7,0.3-1.2,0.4-1.3,0.8
  c-0.4,0.8-0.8,1.8-0.7,2.7c0.7,7.4,1.4,14.8,2.2,22.2c0.1,1.3,0.7,2.3,1,3.5c0.7,2.4,1.5,4.7,2.2,6.9c1.7,5.9,4.8,11.3,7.9,16.6
  c2.6,4.3,5.6,8.3,8.5,12.3c1.4,1.8,2.8,3.5,4.3,5.4c0.7,0.7,1.7,1.1,2.4,1.6c1.2-0.4,2.1-0.4,2.7-0.9c3.3-3.1,7.5-5.5,10.3-9.2
  c1.2-1.6,3-2,5.4-0.8c1.3,1.8,2.8,3.8,4.4,5.8c5.2,6.4,10.6,12.8,16,19.2c1,1.4,2.3,2.8,4.9,2.9c4.6-3.1,4.7-8.9,8.8-12.3
  c0.7-0.1,1.3-0.4,1.7-0.4c0.9,0.1,1.7,0.3,2.4,0.6c3,1.8,5.7,3.7,7.7,6.5c1.7,2.4,3.6,4.7,5.5,7.1c1.8,2.4,4.4,4.1,7.5,5
  c2.3-0.3,3.9-1.3,5-2.6c2.1-2.5,4-5.3,6.2-7.7c2.2-2.2,3-3.9,5.9-8.5c0.1-0.5,0.5-1,1.3-1.5c1.4,4,4.4,7.5,6.9,10.7
  c0.9,1.1,2,2.2,3.2,3.2c1.1,1,3.5,1.1,4.6,0.1c0.9-0.6,1.7-1.3,2.2-2c3.6-4.3,7.1-8.6,10.7-12.8c2-2.3,4-4.6,6.1-6.8
  c0.7-0.7,1.7-1.3,3.3-0.6c2.4,2.6,4.2,5.8,5,9.4c0.6,2.3,1.3,4.6,2,6.9c0.3,0.6,1,1.1,1.5,1.7c0.9-0.1,1.8-0.1,2.3-0.5
  c1.8-1.4,3.9-2.7,5.2-4.5c4.9-5.9,9.5-11.8,13.3-18.1c1.8-3,3.5-6,5.9-8.2c3.2-1.1,5.2-0.4,6.6,1.9c1.2,2,1.4,4.6,3.5,6.2
  C391.4,369.2,393.3,368.9,395,368.1z M282.2,275.1c-2.9-2.3-6.4-3.6-10.1-4.4c-8-1.8-16.1-3.5-24.2-5.3c-3.1-0.7-6.4-1.3-9.5-2.4
  c-8.8-3.1-18-4.2-27.4-4c-1.4,0-2.8-0.1-4.4,1c-0.2,0.4-0.9,1.3-1.2,2.1c-1.2,4.4-2.5,8.9-3.5,13.3c-0.3,1.4-0.4,2.9-0.2,4.3
  c0,0.6,0.9,1.1,1.4,1.8c1.2-0.3,2.2-0.6,3.2-0.9c5.5-1.8,11.1-2.7,16.9-3.3c5.4-0.6,10.9-1,16.4-1.4c6.1-0.5,12.1-1.3,18.2-0.5
  c6.3,0.8,12.6,1.1,19,0.9c1.5,0,3.3,0.1,4.8,0.1C281.8,276.3,282,275.5,282.2,275.1z M315.2,292.2c-0.1-0.7,0-1.3-0.4-1.5
  c-2.4-1.6-4.9-3-7.3-4.5c-2.4-1.4-5-1.8-7.8-1.7c-4,0.2-7.5,1.1-10.4,3.5c-1.9,1.4-3.7,2.8-5.6,4.3c-0.3,0.2-0.1,0.8-0.1,1.2
  c0.4,0.2,1,0.5,1.4,0.5c9.1-0.4,18-0.8,27.1-1.3C313.2,292.8,314.1,292.4,315.2,292.2z"/>
            <use class="pumpkinCover" xlink:href="#pumpkinFace" fill="#000"/>
        </g>
        <rect class="plinth" fill="#000" x="160" y="416"  width="270" height="600" rx="8"/>
<g class="botTextGroup">
            <use xlink:href="#botText" fill="#101000" stroke="url(#pumpkinBgGrad)" stroke-width="6" y="-1"/>
            <use xlink:href="#botText" fill="#101000" stroke="#101010" stroke-width="3" />
        </g>
    </svg>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/2.0.2/TweenMax.min.js"></script>
    <script>
        var xmlns = "http://www.w3.org/2000/svg",
            xlinkns = "http://www.w3.org/1999/xlink",
            select = function(s) {
                return document.querySelector(s);
            },
            selectAll = function(s) {
                return document.querySelectorAll(s);
            },
            dot = select('#dot'),
            flameMask = select('#flameMask'),
            flameGroup = select('.flameGroup'),
            pContainer = select('.pContainer'),
            mainTl = new TimelineMax()
TweenMax.set('svg', {
            visibility: 'visible'
        })
TweenMax.set(pContainer, {
            x:20,
            y: 15,
            transformOrigin: '50% 50%'
        })
        var tl = new TimelineMax({});
        tl.from('.wholePumpkin',0, {
            y:-500,
            ease:Power3.easeIn
        })
.to('.wholePumpkin',0, {
                rotation:-12,
                transformOrigin:'50% 70%',
                ease:Power3.easeOut
            },'-=0')
            .to('.wholePumpkin',0, {
                rotation:0,
                ease:Sine.easeInOut
            },'-=0.3')
.to('.pumpkinCover', 1.5, {
                alpha:0,
                onStart:createParticles,
                ease: RoughEase.ease.config({
                    template: Power0.easeNone,
                    strength: 1,
                    points: 50,
                    taper: "none",
                    randomize: true,
                    clamp: false
                })
            },'-=0')
tl.eventCallback ("onComplete", function () {
            setTimeout (function () {
                $('#HALLOWEEN--Loading').addClass ('Hidden');
                $('#HALLOWEEN').removeClass ('Hidden');
                /* - */
                $('#content').css ('padding-top', $('.halloween-desktop-bg').height () / 2);
                // $('.scroll-icon').css ('top', $('.halloween-desktop-bg').height () - 500);
sessionStorage.setItem ("HALLOWEEN--Loading", true);
            }, 500);
        });
function createParticles(){
var i = 100,  p;
            while (--i > -1) {
                p = dot.cloneNode(true)
                pContainer.appendChild(p);
                //p.setAttributeNS(xlinkns, "xlink:href", '#dot');
//set the particles' transform origin to be in the middle
                TweenMax.set(p, {
                    transformOrigin: '50% 50%',
                    x: randomBetween(-26, -20),
                    y: randomBetween(80, 90)
                })
var particleTl = new TimelineMax({});
                particleTl.to(p, randomBetween(1, 4), {
                    physics2D: {
                        velocity: randomBetween(10, 30),
                        angle: randomBetween(-90, -80),
                        gravity: 0
                    },
scale: 0.58,
                    repeat: -1
                });
mainTl.add(particleTl, i / 20)
}
mainTl.seek(0).timeScale(6) ;
innerLightFlicker();
//ScrubGSAPTimeline(mainTl)
        }
function innerLightFlicker() {
TweenMax.to('.lanternTop', randomBetween(12, 19) / 10, {
                stopColor: '#741B16',
                repeat: 1,
                ease: RoughEase.ease.config({
                    template: Power0.easeNone,
                    strength: 3,
                    points: 10,
                    taper: "none",
                    randomize: true,
                    clamp: false
                }),
                onRepeat: innerLightFlicker
            })
TweenMax.to('.depthGradMid', 0.6, {
                stopColor: '#B24A1D',
                repeat: 1,
                ease: RoughEase.ease.config({
                    template: Power0.easeNone,
                    strength: 3,
                    points: 2,
                    taper: "none",
                    randomize: true,
                    clamp: false
                }),
                yoyo: true
            })
TweenMax.to('#pumpkinBgGrad', 0.2,{
                attr:{
                    cy:randomBetween(330, 360)
                },
                ease: RoughEase.ease.config({
                    template: Power0.easeNone,
                    strength: 1,
                    points: 2,
                    taper: "none",
                    randomize: false,
                    clamp: false
                }),
            })
}
        function randomBetween(min, max) {
            return Math.floor(Math.random() * (max - min + 1) + min);
        }
    </script>
</div>
<div id="HALLOWEEN" class="Hidden">
<?php
    $product_ids=array();
    echo $header; ?>
    <div class="container-fluid p-0 bread_backg">
        <div class="container">
            <ul class="breadcrumb">
                <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>
<!-- Halloween: Genel: Başlar -->
    <style>
        html, body {
            background-color: #0C0A0C;
        }
.product-layout {
            margin-bottom: 20px;
        }
            .product-layout .product-thumb {
                border-radius: 20px 20px 0 0;
            }
                .product-layout .product-thumb .image {
                    border-radius: 20px 20px 0 0;
                    background-color: #FFF;
                }
                    .product-layout .product-thumb .image .img-responsive {
                        border-radius: 20px 20px 0 0;
                    }
                .product-layout .product-thumb .custom-0007 {
                    padding: 0 30px 0 0;
                }
                    .product-layout .product-thumb .custom-0007 .FlexScroller {
                        border-radius: 0 0 20px 20px;
                        padding: 20px 10px 15px 17px;
                        justify-content: center;
                        overflow: hidden;
                    }
                .product-layout .product-thumb .price,
                .product-layout .product-thumb .caption a {
                    color: #FFF;
                }
.bread_backg {
            background: transparent;
        }
            .bread_backg a {
                color: #FFF !important;
            }
#dcloading-icon {
            color: #FFF;
        }
            #dcloading-icon a {
                text-decoration: underline;
                color: #FFF;
            }
@media (max-width: 768px)
        {
            .CategorySelectBox {
                margin-bottom: 0;
                margin-top: 10px;
                width: 132px;
            }
            .CategorySelectBox#category_select_box_3 {
                margin-bottom: 40px;
            }
        }
    </style>
    <!-- Halloween: Genel: Biter -->
    <!-- Halloween: Masaüstü BG: Başlar -->
    <style>
        svg.halloween-desktop-bg {
            position: absolute;
            width: 102vw;
            z-index: -1;
            left: -1vw;
            top: 0;
        }
    </style>
    <svg class="halloween-desktop-bg" viewBox="0 0 753.6 500.2">
        <g>
            <radialGradient id="SVGID_1_" cx="376.3316" cy="310.0154" r="250.0006" gradientTransform="matrix(1.5 0 0 1 -187.4321 0)" gradientUnits="userSpaceOnUse">
                <stop  offset="0" style="stop-color:#25BCAF"/>
                <stop  offset="1" style="stop-color:#1857BD"/>
            </radialGradient>
            <rect x="0.6" fill="url(#SVGID_1_)" width="750" height="500"/>
            <linearGradient id="SVGID_2_" gradientUnits="userSpaceOnUse" x1="656.2274" y1="379.2318" x2="656.2274" y2="293.2076">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_2_)" d="M640,372.2c-2.8,0.6-5.6,0.2-8.4,0c1.7-2.6,4-4.8,5.7-7.4c-0.8,0.2-2-0.2-2.8-0.1
        c-0.2-3.1,2.5-6,3.5-8.9c-2,0.5-4,1-6,0.9c4.5-5.6,10.3-11.9,11.9-19.3c-2.6,0-5.5,0.9-7.8,1.9c3.3-3.9,9.7-11,10.8-16.3
        c-1.7,0.9-3.5,2-5.4,2.3c0.7-2.4,1.5-4.8,3.3-6.5c-1.6,0.7-3.3,0.6-4.7,0.1c3.5-7.1,9.5-12.6,14.4-18.5c-1.1,0.4-2.3,0.3-3.4,0.5
        c3.3-2.6,7.2-4.5,10.2-7.5c-1.4,4.6,10.5,10.4,12.7,14.4c-1.6-0.2-3.4-0.6-5-0.9c2.5,3.8,4.9,9.1,6.4,13.4c-1.2-0.8-3-1-4.3-1.5
        c0.7,7,5.4,13,8.4,19c-1.6,0.3-3.3,0.7-4.9,1c-1.6,4.6,4.1,11.1,5.8,15.6c-1.9-2.1-5.3-2.7-7.8-1.7c2,5.2,5.6,11.1,8.3,16.2
        c-3.4-0.4-8-0.7-10.5,1.5c2.7,1.4,4.6,3.8,5.6,6.7c-5.1,0.9-10.7,2.6-15.9,2.1c-6.3-0.6-11.9-4.6-18-6.5"/>
            <linearGradient id="SVGID_3_" gradientUnits="userSpaceOnUse" x1="672.0797" y1="386.6714" x2="672.0797" y2="175.7987">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_3_)" d="M725.9,237.8c0-0.2-0.1-0.2-0.2-0.3c-0.1-0.2-0.3-0.3-0.5-0.3c-0.6-0.1-1.2-0.3-1.7-0.4l-0.4-0.1
        l-0.8-0.1c-0.4-0.1-0.8-0.2-1.1-0.4c-0.2-0.1-0.4-0.3-0.6-0.4c-0.1,0-0.3-0.1-0.4-0.1c-0.5-0.2-1,0-1.5-0.1c-0.1,0-1.1,0.2-4,0.1
        c-0.1,0-0.1-0.1-0.2-0.1c0.5-0.5,1-1,1.4-1.5c0.4-0.5,0.8-1,1.3-1.5c0.4-0.5,0.8-0.9,1.2-1.5c0.2-0.4,0.5-0.7,0.6-1.1
        c0.2-0.3,0.2-0.7,0.3-1.1c0.1-0.4-0.3-0.6-0.6-0.8c-0.1-0.1-0.2-0.1-0.3-0.1c-0.2,0-0.3,0-0.5,0.1c-0.2,0.1-0.4,0.3-0.6,0.5
        c-0.6,0.5-0.9,1-1.3,1.5c-1.2,1.4-2.6,2.6-4,3.7l-1.1,0.8c-0.7,0.5-1.4,1-2.1,1.4c-1.1,0.7-2.2,1.3-3.4,1.8
        c-0.6,0.3-1.3,0.4-1.9,0.7c-0.5,0.2-0.9,0.4-1.3,0.6c-1.5,0.6-2.7,1.7-4.2,2.3c-0.1,0.1-0.8,0.6-2.6,1.7c-0.4,0.3-0.9,0.6-1.5,1
        c-0.6,0.4-1.3,0.9-2,1.5c-0.9,0.8-2,1.7-3.1,2.8c0-0.1,0-0.2,0-0.3l0-0.2l0,0v0c0-0.1-0.1,0.1-0.1,0.1l0,0l0,0l0,0l0,0l0-0.1l0-0.4
        c0-0.3,0-0.5,0-0.8c-0.1-1.6,0.4-3,1.3-4c0.5-0.6,1-1.3,1.4-2c0.5-0.8,0.7-1.8,1.3-2.5c0.5-0.7,1.1-1.4,1.5-2.2
        c0.5-1,0.4-2.1,0.5-3.1c0-0.8,0.8-1.1,1.2-1.6c0.1-0.2,0.2-0.5,0.3-0.7c0.2-0.3,0.3-0.7,0.5-1c0.2-0.6,0.4-1.1,0.6-1.6
        c0.2-0.6,0.6-1.4,0.5-2.1c0-0.3-0.1-0.6-0.1-1c0-0.4-0.1-1.7-0.9-1.2c-0.3,0.2-0.5,0.5-0.6,0.6c-0.5,0.8-1.1,1.6-1.5,2.5
        c-0.3,0.7-0.7,1.3-1,2c-0.3,0.6-0.5,1.3-0.9,1.9c-0.9,1.3-1.9,2.5-3,3.7c-1.5,1.8-2.2,3.9-3.2,5.9c-0.2,0.4-0.4,0.8-0.7,1.2
        c0,0.1-0.1,0.1-0.1,0.2l0.2-1.1l0.2-1.3l0.3-1.3l0.3-1.3l0.3-1.2l0.3-1.2l0.3-1.2l0.3-1.2l0.3-1.1c0.8-1.7,0.9-4,1.2-4.8
        c0.2-0.5,0.2-1.1,0.2-1.7c0-0.4,0-0.8,0-1.2c0-0.4,0.1-0.8,0.1-1.2c0-0.3-0.1-0.5-0.1-0.8c0-0.2-0.3-0.4-0.4-0.6
        c-0.1-0.2-0.7-0.2-1.2-0.2c-0.2,0-0.3,0-0.5,0.1c-0.2,0.1-0.3,0.1-0.4,0.2c-0.1,0.1-0.1,0.3-0.2,0.5c-0.2,0.4-0.1,0.8-0.1,1.2
        c0,1.1-0.2,2.2-0.5,3.3l-0.2,0.8c-0.1,0.5-0.3,1-0.4,1.5c-0.2,0.8-0.6,1.5-0.9,2.2c-0.2,0.4-0.5,0.7-0.7,1.1
        c-0.1,0.3-0.2,0.6-0.4,0.8c-0.4,0.9-0.5,1.9-0.9,2.9c0,0.1-0.1,0.6-0.4,1.9c-0.2,1.3-0.6,3.2-1.1,6.2c-0.1,0.3-0.3,0.5-0.3,0.9
        c0,0.4,0,0.7,0,1.1c0,0.5,0.2,1,0.2,1.4c0.1,0.7,0,1.3-0.1,2c0,0.4,0,0.8,0,1.2c-0.3,0.5-0.7,1.1-0.8,1.6c-0.2,1.1-1.2,1.9-1.5,2.9
        c-0.2,0.7-0.4,1.3-0.5,2c-0.1,0.7-0.2,1.4-0.2,2.1c-0.1,0.8-0.1,1.6-0.1,2.4c-0.5-0.3-1.2-0.5-2-0.7c0-0.3,0-0.6,0-0.9l0-0.8
        c0-0.2,0-0.5,0-0.7l0-1.4c0-1.9,0-3.8-0.4-5.7c-0.4-2.1-1.1-4.2-1.7-6.3c-0.1-0.3-0.1-0.7-0.2-1c0.1-0.5,0.2-0.9,0.4-1.3
        c0.6-1,0.7-2,0.3-3.1c-0.2-0.7-0.1-1.3,0.1-2c0.6-2.4,1.1-4.7,1.5-7c0.2-1,0.6-1.9,0.9-2.8c0.4,0.1,0.8,0.2,1,0.1
        c0.2-0.1,0.3-0.3,0.5-0.4c0.4-0.4,0.6-0.8,0.9-1.3c0.1-0.3,0.3-0.5,0.5-0.8c0.2-0.3,0.4-0.6,0.5-0.9l0.6-0.9l0.7-1l0.8-1l0.9-1.1
        l1-1.1c0.4-0.4,0.7-0.7,1.1-1.1c0.4-0.4,0.8-0.7,1.2-1.1c0.4-0.4,0.8-0.7,1.2-1c0.4-0.3,0.9-0.7,1.3-1c0.4-0.3,0.9-0.6,1.4-1
        l1.4-0.9l1.5-0.9l1.5-0.9l1.5-0.9l1.4-0.9c0.5-0.3,0.9-0.6,1.4-0.9c0.4-0.3,0.9-0.6,1.3-1c0.4-0.3,0.8-0.6,1.2-1
        c0.5-0.3,1-0.8,1.4-1.2c0.5-0.5,0.9-0.9,1.3-1.3c0.8-0.9,1.4-1.6,1.7-2c0.5-0.5,0.9-1,1.3-1.5c0.3-0.4,0.6-0.7,0.9-1
        c0.3-0.3,0.7-0.6,1-0.9c0.2-0.2,0.4-0.4,0.6-0.6c0.2-0.2,0.3-0.5,0.4-0.7c0.2-0.2-0.1-0.7-0.4-1.1c-0.1-0.1-0.2-0.2-0.3-0.3
        c-0.2-0.1-0.3-0.1-0.4-0.1c-0.2,0-0.4,0.1-0.6,0.2c-0.6,0.2-1,0.7-1.4,1.1c-1.2,1.1-2.3,2.2-3.3,3.2l-0.8,0.8
        c-0.5,0.5-0.9,1-1.4,1.4c-0.4,0.3-0.7,0.6-1.2,0.9c-0.4,0.3-0.8,0.5-1.2,0.8c-0.4,0.3-0.9,0.4-1.4,0.6c-0.3,0.2-0.6,0.4-1,0.5
        c-1.1,0.5-2,1.4-3.1,1.9c-0.1,0-0.6,0.4-2,1.3c-0.3,0.2-0.7,0.4-1.2,0.7c-0.4,0.3-0.9,0.6-1.5,0.9c-1.2,0.7-2.5,1.6-4.1,2.7
        c-0.3,0.2-0.8,0.3-1.1,0.5c-0.3,0.3-0.7,0.7-1,1c-0.4,0.4-0.7,1-1.1,1.5c-0.5,0.7-1.2,1.3-1.7,1.9c-0.6,0.7-1.2,1.4-1.7,2.1l0,0
        c0-0.1,0-0.3,0.1-0.4c0.2-1.2,0.9-2.1,1.4-3.1c0.8-1.4,1-3.2,0.7-5c-0.2-1.4,0.2-2.7,0.9-3.8c0.4-0.6,0.8-1.3,1.1-1.9
        c0.4-0.8,0.6-1.7,1.1-2.5c0.4-0.7,0.9-1.4,1.2-2.2c0.4-1,0.3-2,0.2-3c0-0.7,0.6-1.1,0.9-1.7c0.1-0.2,0.1-0.5,0.2-0.7
        c0.1-0.3,0.2-0.7,0.3-1.1c0.1-0.6,0.1-1.1,0.2-1.7c0-0.6,0.2-1.5,0-2.1c-0.1-0.3-0.2-0.5-0.3-0.8c-0.1-0.4-0.3-1.5-0.8-0.8
        c-0.2,0.2-0.3,0.6-0.4,0.8c-0.3,0.9-0.7,1.7-0.9,2.5c-0.2,0.7-0.5,1.3-0.6,2c-0.2,0.6-0.3,1.3-0.5,1.8c-0.6,1.3-1.4,2.6-2.2,3.8
        c-1.2,1.8-1.7,3.8-2.5,5.8c-0.2,0.4-0.3,0.8-0.6,1.2c-0.4,0.6-0.7,1.2-1,1.9c-0.7,1.7-1.2,3.4-2.1,5c-0.5,0.8-1,1.6-1.3,2.4
        c-0.1,0.5-0.4,0.9-0.6,1.4c-0.1,0.2-0.3,0.4-0.4,0.7c-0.1,0.2-0.2,0.4-0.3,0.7c-0.4,1.1-0.7,2.5-0.8,3.8c-0.1,1.3-0.2,2.6-0.3,3.9
        c-0.1,1.2,1.3,2.7,0.1,3.7c-0.1,0.1-0.2,0.1-0.3,0.2c-0.1-0.1-0.1-0.1-0.2-0.2c-0.4-0.5-0.8-0.9-1.1-1.4c-0.2-0.3-0.3-0.5-0.4-0.8
        c-0.1-0.2-0.2-0.5-0.4-0.7c-0.2-0.4-0.3-0.7-0.4-1.1l0.2-0.9l0.3-1.3l0.4-1.4l0.4-1.5l0.4-1.6l0.5-1.7l0.5-1.8l0.5-1.9l0.6-1.9
        l0.6-1.9l0.6-1.9c0.2-0.7,0.4-1.3,0.7-1.9c0.2-0.6,0.5-1.3,0.7-1.9l0.8-1.9l0.8-1.9l0.7-1.5c0.3,0,0.5-0.1,0.6-0.2
        c0.1-0.1,0.1-0.2,0.1-0.3c0.1-0.2,0-0.5,0-0.7l0-0.3l0.3-0.7l0.8-1.8l0.8-1.7l0.7-1.6c1.4-2.5,2.3-5.8,2.8-7
        c0.3-0.8,0.5-1.6,0.7-2.4c0.1-0.6,0.3-1.2,0.4-1.8c0.2-0.6,0.3-1.1,0.4-1.7c0-0.4,0.1-0.8,0.1-1.2c0-0.3-0.1-0.7-0.2-1
        c0-0.4-0.5-0.4-1-0.5c-0.1,0-0.3,0-0.4,0c-0.2,0.1-0.3,0.2-0.4,0.3c-0.2,0.2-0.2,0.4-0.3,0.7c-0.3,0.6-0.3,1.3-0.5,1.9
        c-0.4,1.7-0.9,3.4-1.5,5.1c-0.1,0.4-0.3,0.8-0.5,1.2c-0.3,0.8-0.6,1.5-0.9,2.3c-0.5,1.1-1.1,2.2-1.7,3.3c-0.1,0.2-0.3,0.5-0.5,0.7
        l-0.1-0.4l-0.1-0.7l-0.1-0.7l-0.1-0.7L676,188l-0.1-0.7l-0.1-0.7l-0.1-0.6l-0.1-0.6l-0.1-0.6c0.1-1-0.3-2-0.3-2.5
        c0-0.3-0.1-0.5-0.1-0.8c-0.1-0.2-0.1-0.4-0.1-0.6c0-0.2,0-0.4,0-0.6c0-0.1-0.1-0.3-0.1-0.4c0-0.1-0.2-0.2-0.3-0.3
        c-0.1-0.1-0.7-0.1-1.2-0.1c-0.2,0-0.3,0-0.4,0c-0.2,0-0.3,0.1-0.4,0.1c-0.1,0.1-0.1,0.2-0.2,0.3c-0.2,0.2,0,0.5,0,0.7
        c0.1,0.6,0.1,1.3,0.1,2l0,0.5c0,0.3,0.1,0.6,0.1,0.9c0.1,0.4,0,0.9,0,1.3c0,0.2-0.2,0.5-0.2,0.7c0,0.2,0,0.3,0,0.5
        c0,0.6,0.3,1,0.3,1.6c0,0.1,0.5,1.1,1,4.2c0,0.2-0.1,0.3-0.1,0.5c0.1,0.2,0.1,0.3,0.2,0.5c0.1,0.2,0.3,0.4,0.4,0.7
        c0.2,0.3,0.2,0.7,0.2,1c0,0,0,0.1,0,0.1c-0.4,0.8-0.7,1.5-1.2,2.3c-0.1,0.1-0.4,0.9-1.2,2.7c-0.8,1.8-2.2,4.6-3.8,9
        c-0.2,0.4-0.5,0.8-0.7,1.2c-0.1,0.5-0.2,1.1-0.3,1.6c-0.1,0.7-0.1,1.4-0.2,2.1c0,0.2-0.1,0.3-0.1,0.5c0-0.8,0-1.7-0.1-2.5
        c-0.3-1.6-1.2-2.9-2.1-4.3c-0.6-1,0.2-2,0.3-2.9c0-0.4-0.1-0.7-0.1-1.1c0-0.6,0-1.2-0.1-1.7l-0.4-2.6c-0.1-1-0.2-2.2-0.4-3.1
        c-0.1-0.4-0.3-0.8-0.2-1.3c0-0.3,0.1-0.9,0.1-1.3c0-0.4-0.1-0.6-0.8-0.3c-0.1,0.1-0.3,0.2-0.4,0.3c-0.1,0.1-0.1,0.1-0.2,0.2
        l-0.1,0.2c-0.2,0.2-0.3,0.5-0.4,0.6c-0.8,1.6-1.3,3.2-1.5,4.8c-0.1,0.6-0.2,1.2-0.2,1.8l-0.1,0.9l0,0.9c0,1,0.2,2.3,0,3.3
        c-0.1,0.5-0.1,1-0.2,1.5l-0.4-0.7l-0.9-1.4l-0.9-1.4l-0.9-1.5l-0.8-1.5c-0.3-0.5-0.6-1-0.8-1.5l-0.8-1.5c-0.3-0.5-0.5-1-0.7-1.5
        l-0.7-1.4l-0.6-1.4c-0.2-0.5-0.4-0.9-0.5-1.4l-0.2-0.7c0.2-0.1,0.3-0.3,0.3-0.4c0-0.1,0-0.2,0-0.3c-0.1-0.2-0.2-0.3-0.3-0.5
        l-0.2-0.3l-0.1-0.2c-0.2-0.8-0.3-1.6-0.5-2.3c-0.2-1-0.3-1.9-0.4-2.4c0-0.6-0.1-1.2-0.2-1.9c-0.1-0.4-0.1-0.9-0.1-1.3
        c0-0.4,0.1-0.9,0.1-1.3c0-0.3,0-0.6-0.1-1c0-0.3-0.2-0.6-0.3-0.8c-0.1-0.3-0.7-0.3-1.3-0.3c-0.2,0-0.4,0-0.5,0
        c-0.2,0.1-0.3,0.2-0.4,0.2c-0.2,0.2-0.2,0.4-0.2,0.6c-0.2,0.5-0.1,1.1-0.2,1.6c-0.1,0.7,0,1.6,0,2.3c0,0.7,0,1.4,0.1,2.1l-0.2-0.2
        c-0.2-0.1-0.3-0.3-0.5-0.4l-0.5-0.4c-0.2-0.1-0.3-0.3-0.5-0.4l-0.5-0.4l-0.5-0.3l-0.5-0.3l-0.4-0.3c-0.6-0.6-1.6-0.9-1.9-1.1
        c-0.2-0.2-0.4-0.2-0.7-0.3c-0.2-0.1-0.3-0.1-0.5-0.2c-0.2-0.1-0.3-0.2-0.4-0.2c-0.1,0-0.2,0-0.3-0.1c-0.1,0-0.3,0.1-0.4,0.1
        c-0.1,0-0.3,0.4-0.5,0.8c-0.1,0.1-0.1,0.2-0.1,0.3c0,0.1,0,0.2,0,0.3c0,0.1,0.1,0.1,0.1,0.2c0.1,0.2,0.3,0.2,0.5,0.3
        c0.5,0.2,0.9,0.4,1.3,0.7l0.3,0.2c0.2,0.1,0.4,0.2,0.6,0.4c0.3,0.2,0.5,0.4,0.8,0.7c0.1,0.1,0.2,0.3,0.3,0.5
        c0.1,0.1,0.2,0.2,0.3,0.3c0.3,0.3,0.7,0.4,1,0.7c0,0.1,0.9,0.3,2.6,2.2c0.1,0.1,0.1,0.3,0.2,0.4c0.1,0.1,0.2,0.2,0.4,0.3
        c0.1,0.1,0.3,0.2,0.5,0.2c0.1,0.4,0.2,0.9,0.2,1.3c0.1,0.5,0.2,1,0.3,1.6c0.1,0.5,0,1.1,0.2,1.6c0.1,0.4,0.2,0.8,0.3,1.2
        c0.3,1.3,1.1,2.4,1.5,3.6c0,0.1,0.4,0.7,1.2,2.1c0.8,1.4,2.1,3.6,4,6.9c0.2,0.3,0.2,0.7,0.4,1.1c0.3,0.4,0.5,0.7,0.8,1
        c0.4,0.5,0.8,0.8,1.2,1.3c0.5,0.6,0.9,1.3,1.3,2c0,0,0,0.1,0.1,0.1c0,0.1,0,0.3,0,0.4c-0.4,3.8,0.9,7.2,1.9,10.6
        c0.2,0.7,0.3,1.4,0.4,2.1c0,0.6,0.1,1.2,0.2,1.7l0.2,0.8c0.1,0.3,0.1,0.6,0.2,0.8l0.3,1.3c-0.2,0.4-0.4,0.7-0.6,1.1
        c-0.1,0.2-0.4,0.4-0.6,0.7c-0.1,0.2-0.2,0.4-0.3,0.5c-0.4,0.5-0.5,1.2-0.9,1.8c0,0-0.1,0.4-0.5,1.2c-0.3,0.8-1,2-2.1,3.6
        c-0.1,0.1-0.4,0.2-0.5,0.4c-0.1,0.2-0.2,0.5-0.3,0.7c-0.1,0.3-0.1,0.7-0.2,1c-0.1,0.4-0.3,0.8-0.5,1.1c-0.2-0.9-0.4-1.8-0.7-2.6
        c-0.5-1.2-1.3-2.1-2.2-3c-0.6-0.6-0.5-1.5-0.7-2.3c-0.1-0.3-0.3-0.5-0.5-0.8c-0.2-0.4-0.4-0.8-0.7-1.2c-0.4-0.6-0.9-1.1-1.3-1.7
        c-0.5-0.6-1.1-1.5-1.9-1.8c-0.3-0.2-0.7-0.2-1-0.4c-0.4-0.3-1.7-0.9-1.6,0.2c0.1,0.4,0.3,0.8,0.4,1c0.3,0.5,0.6,1,0.9,1.5
        c0.2,0.5,0.5,1,0.8,1.4l0.7,1.1c0.2,0.4,0.4,0.7,0.7,1.1c0.4,0.7,0.9,1.3,1.2,2c0.7,1.7,1.1,3.4,1.5,5.2c0.6,2.6,1.8,4.9,2.8,7.4
        c0.2,0.5,0.3,1,0.5,1.5c0,0.1,0.1,0.2,0.1,0.3l0,0l-1.3-0.6l-1.4-0.6l-1.5-0.6c-0.5-0.2-1.1-0.4-1.6-0.6c-0.6-0.2-1.1-0.4-1.7-0.6
        c-0.6-0.2-1.2-0.4-1.8-0.5c-0.6-0.2-1.3-0.3-2-0.4c-0.7-0.1-1.2-0.2-1.9-0.2c-0.7-0.1-1.3-0.1-2-0.1l-1.9,0l-1.9,0l-1.8-0.1
        c-0.6,0-1.2-0.1-1.7-0.1c-0.6-0.1-1.1-0.1-1.6-0.2c-0.1,0-0.2,0-0.3-0.1l0-0.1l-0.1-0.4l-0.1-0.5l-0.1-0.5l-0.1-0.5l-0.1-0.6
        l-0.1-0.6c0-0.2,0-0.4-0.1-0.6l0-0.7l0-0.7l-0.1-0.7l0-0.7l0-0.7l0-0.7l0-0.7l0-0.7l0-0.6l-0.1-0.6l-0.1-0.6
        c0.1-0.9-0.1-2.1-0.1-2.5c0-0.3,0-0.6-0.1-0.8c-0.1-0.2-0.1-0.4-0.1-0.6c0-0.2,0-0.4-0.1-0.6c0-0.1-0.1-0.2-0.1-0.4
        c0-0.1-0.2-0.2-0.3-0.3c-0.1-0.1-0.5,0-0.9,0c-0.1,0-0.2,0-0.3,0.1c-0.1,0.1-0.2,0.1-0.2,0.2l-0.1,0.3c-0.1,0.2,0,0.4,0.1,0.6
        c0.1,0.6,0.1,1.1,0.2,1.7l0,0.4c0,0.3,0,0.5,0,0.8c0,0.4,0,0.8-0.1,1.2c0,0.2-0.2,0.4-0.2,0.6c0,0.2-0.1,0.3-0.1,0.5
        c-0.1,0.5,0,1-0.1,1.5c0,0.1,0.1,1.1-0.2,4.1c0,0.2-0.2,0.3-0.2,0.5c0,0.2,0.1,0.4,0.1,0.5c0.1,0.2,0.2,0.5,0.3,0.7
        c0.1,0.3,0.1,0.7,0.1,1c0,0.1,0,0.2,0,0.2c-0.1,0-0.1-0.1-0.2-0.1c-0.8-0.7-1.7-1.4-2.4-2.3c-0.7-0.8-1.2-1.6-1.5-2.1
        c-0.3-0.6-0.7-1.2-1-1.8c-0.2-0.4-0.5-0.9-0.7-1.4c-0.2-0.4-0.4-0.9-0.6-1.3c-0.2-0.3-0.3-0.6-0.5-0.9c-0.1-0.3-0.4-0.5-0.6-0.7
        c-0.2-0.3-0.6-0.1-0.9,0.1c-0.1,0.1-0.2,0.1-0.3,0.2c-0.1,0.1-0.1,0.3-0.1,0.4c0,0.2,0.1,0.4,0.1,0.6c0.1,0.6,0.4,1.1,0.6,1.7
        c0.6,1.5,1.2,3.1,2,4.5c0.2,0.4,0.4,0.7,0.6,1.1c0.4,0.7,0.9,1.3,1.4,1.9c0.8,0.9,1.6,1.8,2.6,2.5c0.5,0.4,1,0.8,1.5,1.1
        c0.5,0.3,0.7,0.4,1.3,0.6c1.5,0.6,2.9,0.6,4.3,0.9c0.1,0,0.9,0,2.6,0.1c0.9,0,2,0,3.4,0.1c0.7,0,1.4,0.1,2.2,0.2
        c0.2,0,0.4,0,0.6,0.1c0.2,0,0.4,0.1,0.6,0.1c0.2,0,0.5,0.1,0.7,0.1c0.2,0.1,0.4,0.1,0.6,0.2c0.3,0.1,0.6,0.4,1,0.5
        c0.4,0.1,0.9,0.2,1.3,0.2c0.6,0.1,1.2,0.1,1.8,0.3c0.8,0.2,1.6,0.6,2.4,0.9c1.3,0.6,2.6,1.1,3.9,1.7l0.1,0.1l2.2,1.2
        c0.1,0,0.1,0.1,0.2,0.1c0.4,1.3,0.9,2.6,1.2,3.9c0.2,1.1,0.4,2.2,0.8,3.3c0.4,1.2,0.6,2.4,0.9,3.5c0.6,1.5,1.2,3,2,4.4l0.6,1.1
        l0.3,0.5l0.3,0.5c0.4,0.7,0.9,1.4,1.3,2c0.8,1.2,2.6,2,2.7,3.6c0,0.4,0,0.8,0,1.1c-0.2-0.2-0.3-0.4-0.5-0.5
        c-0.4-0.4-0.8-0.7-1.2-1.1c-0.4-0.3-0.8-0.6-1.3-0.9c-0.9-0.8-2.3-1.5-3.2-1.9c-1-0.5-1.8-0.9-2.3-1.2c-0.6-0.4-1.2-0.7-1.9-0.9
        c-0.5-0.2-0.9-0.4-1.4-0.6c-0.4-0.2-0.9-0.4-1.4-0.5c-0.3-0.1-0.7-0.1-1.1-0.2c-0.3,0-0.7,0-1,0.1c-0.3,0.1-0.3,0.5-0.3,0.8
        c0,0.1,0,0.2,0,0.3c0.1,0.1,0.2,0.2,0.3,0.3c0.2,0.1,0.3,0.1,0.5,0.2c0.4,0.2,0.9,0.3,1.4,0.5c1.3,0.5,2.6,1.3,3.8,2.1l0.9,0.6
        c0.6,0.4,1.2,0.7,1.8,1.1l0.6,0.4c0.2,0.1,0.4,0.3,0.6,0.4c0.4,0.3,0.7,0.6,1.1,1c0.4,0.3,0.6,0.8,0.9,1.2c0.2,0.3,0.5,0.5,0.7,0.8
        c0.7,0.9,1.6,1.7,2.1,2.7c0,0,0.1,0.2,0.3,0.5c0.1,0.1,0.2,0.3,0.4,0.5c0.2,0.2,0.3,0.5,0.6,0.9c0.8,1.3,2.1,3.4,3.6,6.8
        c0.1,0.4,0.1,0.7,0.3,1.1c0.2,0.4,0.4,0.8,0.7,1.1c0.3,0.5,0.7,0.9,1,1.4c0.1,0.1,0.1,0.2,0.2,0.3c0.2,5.7,0,11.5-0.7,17.2
        c-0.7,6-2.3,12.9-1.8,18.9c0.4,5.1,2.1,9.6,1.6,14.9c-0.5,5-3.2,8.4-4.9,13.1c-2.4,6.4-3.6,14.5-3.6,21.3
        c8.2,3.3,16.8,3.1,25.5,3.1l-1.5-1c0.2-9.7-1.7-19.2-2.6-28.8c-1.4-13.7-1.4-25.6,0.3-39.1c0.8-6.3,1.2-12.7,0.9-19.1
        c-0.2-3.3-1-6.5-1.9-9.6l0.2-0.3c0.2-0.3,0.3-0.6,0.5-1l0.5-1c0.2-0.4,0.4-0.7,0.5-1.1l0.5-1.2l0.5-1.3l0.5-1.3l0.5-1.3l0.5-1.4
        l0.6-1.4l0.6-1.4l0.6-1.4c0.2-0.4,0.4-0.9,0.6-1.3l0.6-1.3c0.2-0.4,0.4-0.9,0.6-1.3l0.7-1.2c0.2-0.4,0.5-0.8,0.7-1.1l0.7-1.1
        c0.2-0.3,0.5-0.6,0.7-1c0.3-0.3,0.6-0.7,1-1.1c0.3-0.3,0.7-0.7,1-1c0.6-0.7,1.2-1.1,1.5-1.4c0.2-0.1,0.4-0.3,0.6-0.5
        c0.2-0.2,0.4-0.3,0.6-0.5c0.3-0.2,0.6-0.4,0.9-0.6c0.3-0.2,0.7-0.3,1-0.5c0.2-0.1,0.5-0.3,0.7-0.4c0.2-0.1,0.4-0.4,0.6-0.5
        c0.2-0.2,0-0.6-0.2-1c-0.1-0.1-0.1-0.2-0.2-0.3c-0.1-0.1-0.2-0.2-0.3-0.2c-0.2,0-0.3,0-0.5,0c-0.5,0-0.9,0.3-1.3,0.5
        c-0.6,0.2-1.3,0.7-1.9,1c-0.3,0.2-0.6,0.3-0.9,0.5l-0.8,0.6l-0.8,0.6c-0.5,0.4-0.9,0.8-1.4,1.3c-0.7,0.6-1.4,1.3-2,2
        c-0.4,0.3-0.8,0.6-1.1,1c-0.2,0.3-0.5,0.5-0.7,0.8c0,0-0.1,0.1-0.1,0.1c0.3-1.2,0.2-2.5,0.3-3.1c0.1-0.4,0-0.8,0-1.2
        c0-0.3,0-0.6-0.1-0.9c0-0.3,0-0.5-0.1-0.8c0-0.2-0.1-0.4-0.1-0.5c0-0.2-0.2-0.3-0.3-0.4c-0.1-0.2-0.5-0.1-0.9-0.1
        c-0.1,0-0.2,0-0.3,0c-0.1,0.1-0.2,0.1-0.3,0.2c-0.1,0.1-0.1,0.2-0.1,0.3c-0.1,0.3-0.1,0.6-0.1,0.9c-0.1,0.8,0,1.6-0.1,2.4l-0.1,0.6
        c0,0.4-0.1,0.7-0.1,1.1c-0.1,0.5-0.3,1.1-0.4,1.6c-0.1,0.3-0.3,0.5-0.4,0.8c-0.1,0.2-0.1,0.4-0.2,0.6c-0.2,0.6-0.2,1.3-0.5,2
        c-0.1,0.1-0.1,1.5-1.4,5.4c-0.1,0.2-0.3,0.3-0.3,0.5c0,0.2-0.1,0.5-0.1,0.7c0,0.3,0,0.7,0,1c0,0,0,0,0,0.1
        c-0.2,0.2-0.3,0.3-0.4,0.6c-0.1,0.4-0.2,0.7-0.3,1.1c-0.1,0.5-0.2,1-0.3,1.5c-0.1,0.7-0.5,1.4-0.8,2c-0.1,0.2-0.1,0.4-0.2,0.5
        c-0.4-1.6-0.8-3.2-1.1-4.8c-0.1-0.4-0.1-0.8-0.1-1.2c0.3-0.9,0.4-1.8,0-2.8c-0.2-0.7-0.2-1.4,0-2.1c0.3-1.4,0.5-2.9,0.8-4.3
        c0.3-0.5,0.5-1,0.7-1.5l0.5-1.1c0.2-0.4,0.4-0.8,0.6-1.2l0.7-1.3l0.8-1.4l0.8-1.5c0.3-0.5,0.6-1,0.9-1.6c0.3-0.5,0.6-1.1,1-1.6
        c0.3-0.6,0.7-1.1,1.1-1.6c0.4-0.5,0.8-1.1,1.2-1.6c0.4-0.5,0.8-1.1,1.2-1.6c0.4-0.5,0.9-1.1,1.3-1.5c0.5-0.5,0.9-1,1.4-1.5l0.7-0.7
        l0.8-0.6c0.5-0.4,1.1-0.8,1.7-1.3l0.4-0.3l0.4-0.3l0.9-0.6l1.8-1.1l1.8-1.1l1.7-1.1l1.7-1.1l1.6-1c0.6-0.3,1.2-0.7,1.7-1.1
        c0,0,0,0.1,0.1,0.1c0.1,0.1,0.2,0.1,0.3,0.1c0.2,0.1,0.4,0,0.5,0l0.3-0.1c0.1,0,0.2,0,0.4-0.1c0.1,0,0.3-0.1,0.4-0.1l0.4-0.1
        c0.2,0,0.3-0.1,0.5-0.1l0.5-0.1c0.2,0,0.4-0.1,0.5-0.1l0.6-0.1c0.2,0,0.4,0,0.6-0.1l0.6,0l0.6,0l0.6,0l0.6,0l0.6,0l0.6,0l0.6,0
        l0.6,0l0.6,0l0.5,0l0.5,0c0.8,0.3,1.8,0.1,2.1,0.2c0.2,0.1,0.5,0.1,0.7,0c0.2,0,0.3,0,0.5,0c0.2,0,0.3,0.1,0.5,0.1
        c0.1,0,0.3-0.1,0.4-0.1c0.1-0.1,0.2-0.1,0.4-0.3c0.1-0.2,0.2-0.4,0.3-0.7c0-0.1,0-0.2,0-0.3C725.9,238,725.9,237.9,725.9,237.8z
         M666.8,273c-0.5-1.3-1-2.7-1.7-4c-0.7-1.5-1.4-2.9-2.1-4.4c-0.6-1.4-0.8-2.8-1.1-4.3c-0.3-1.6-0.9-3.3-1.8-4.8
        c0-0.4,0.1-0.8-0.1-1c-0.1-0.2-0.4-0.3-0.6-0.4c-0.1-0.1-0.2-0.1-0.3-0.2c-0.8-1.3-1.3-2.7-1.5-4.1c-0.1-0.4-0.1-0.7-0.2-1.1
        c0.2-0.1,0.3-0.1,0.4-0.2c0.1-0.1,0.1-0.2,0.1-0.3c0.1-0.2,0.1-0.4,0.1-0.6l0-0.4c0-0.1,0-0.3,0-0.4c0-0.2,0-0.3,0.1-0.5
        c0-0.2,0.1-0.4,0.2-0.5c0.1-0.2,0.1-0.4,0.2-0.6c0.1-0.2,0.2-0.4,0.3-0.6c0.1-0.2,0.2-0.5,0.3-0.7l0.4-0.7l0.4-0.8l0.5-0.8l0.5-0.8
        l0.4-0.9l0.4-0.9l0.4-0.9l0.4-0.9l0.4-0.9l0.3-0.7c0.1,0.9,0.2,1.7,0.2,2.6c0,1.4-0.2,2.9,0.1,4.3c0.4,1.6-0.2,3.1-0.1,4.7
        c0.4,4.1,1.9,8.1,3.2,12.2c0.1,0.4,0.4,0.8,0.7,1.2c-2.8,4,0.9,13.6,2.7,18.9c-0.5-0.9-1-1.8-1.5-2.7
        C667.9,275.7,667.3,274.4,666.8,273z"/>
            <linearGradient id="SVGID_4_" gradientUnits="userSpaceOnUse" x1="61.4913" y1="381.338" x2="61.4913" y2="269.132">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_4_)" d="M90.1,302.1c0-0.1-0.1-0.1-0.1-0.1c-0.1-0.1-0.2-0.2-0.3-0.2c-0.3-0.1-0.6-0.2-0.9-0.2l-0.2,0
        l-0.4-0.1c-0.2,0-0.4-0.1-0.6-0.2c-0.1,0-0.2-0.2-0.3-0.2c-0.1,0-0.2,0-0.2-0.1c-0.3-0.1-0.5,0-0.8-0.1c0,0-0.6,0.1-2.1,0.1
        c0,0-0.1,0-0.1-0.1c0.3-0.2,0.5-0.5,0.8-0.8c0.2-0.3,0.5-0.5,0.7-0.8c0.2-0.2,0.4-0.5,0.6-0.8c0.1-0.2,0.3-0.4,0.3-0.6
        c0.1-0.2,0.1-0.4,0.1-0.6c0.1-0.2-0.1-0.3-0.3-0.4c-0.1,0-0.1-0.1-0.2-0.1c-0.1,0-0.2,0-0.2,0.1c-0.1,0.1-0.2,0.2-0.3,0.3
        c-0.3,0.2-0.5,0.5-0.7,0.8c-0.6,0.7-1.4,1.4-2.1,2l-0.6,0.4c-0.4,0.3-0.7,0.5-1.1,0.8c-0.6,0.4-1.2,0.7-1.8,1
        c-0.3,0.2-0.7,0.2-1,0.4c-0.2,0.1-0.5,0.2-0.7,0.3c-0.8,0.3-1.5,0.9-2.3,1.2c-0.1,0-0.4,0.3-1.4,0.9c-0.2,0.2-0.5,0.3-0.8,0.5
        c-0.3,0.2-0.7,0.5-1,0.8c-0.5,0.4-1.1,0.9-1.6,1.5c0-0.1,0-0.1,0-0.2l0-0.1v0v0c0,0,0,0.1,0,0.1l0,0l0,0l0,0l0,0l0,0l0-0.2
        c0-0.1,0-0.3,0-0.4c-0.1-0.9,0.2-1.6,0.7-2.2c0.3-0.3,0.5-0.7,0.7-1c0.3-0.4,0.4-0.9,0.7-1.3c0.3-0.4,0.6-0.8,0.8-1.2
        c0.2-0.5,0.2-1.1,0.2-1.7c0-0.4,0.4-0.6,0.6-0.9c0.1-0.1,0.1-0.3,0.2-0.4c0.1-0.2,0.2-0.4,0.2-0.5c0.1-0.3,0.2-0.6,0.3-0.9
        c0.1-0.3,0.3-0.7,0.3-1.1c0-0.2-0.1-0.3-0.1-0.5c0-0.2,0-0.9-0.5-0.6c-0.1,0.1-0.3,0.3-0.3,0.3c-0.3,0.4-0.6,0.8-0.8,1.3
        c-0.2,0.4-0.4,0.7-0.5,1.1c-0.2,0.3-0.3,0.7-0.5,1c-0.5,0.7-1,1.3-1.6,2c-0.8,1-1.2,2.1-1.7,3.2c-0.1,0.2-0.2,0.4-0.4,0.6
        c0,0,0,0.1-0.1,0.1l0.1-0.6l0.1-0.7l0.1-0.7l0.1-0.7l0.2-0.7l0.2-0.6l0.2-0.6l0.2-0.6l0.2-0.6c0.4-0.9,0.5-2.1,0.6-2.6
        c0.1-0.3,0.1-0.6,0.1-0.9c0-0.2,0-0.4,0-0.6c0-0.2,0-0.4,0-0.6c0-0.1,0-0.3-0.1-0.4c0-0.1-0.1-0.2-0.2-0.3
        c-0.1-0.1-0.4-0.1-0.7-0.1c-0.1,0-0.2,0-0.2,0c-0.1,0-0.2,0.1-0.2,0.1c-0.1,0.1-0.1,0.2-0.1,0.2c-0.1,0.2,0,0.4,0,0.6
        c0,0.6-0.1,1.2-0.2,1.8l-0.1,0.4c-0.1,0.3-0.1,0.5-0.2,0.8c-0.1,0.4-0.3,0.8-0.5,1.2c-0.1,0.2-0.3,0.4-0.4,0.6
        c-0.1,0.1-0.1,0.3-0.2,0.5c-0.2,0.5-0.3,1-0.5,1.5c0,0-0.1,0.3-0.2,1c-0.1,0.7-0.3,1.7-0.6,3.3c0,0.2-0.2,0.3-0.2,0.5
        c0,0.2,0,0.4,0,0.6c0,0.3,0.1,0.5,0.1,0.8c0,0.4,0,0.7,0,1.1c0,0.2,0,0.4,0,0.6c-0.2,0.3-0.4,0.6-0.4,0.9c-0.1,0.6-0.6,1-0.8,1.5
        c-0.1,0.4-0.2,0.7-0.3,1.1c-0.1,0.4-0.1,0.7-0.1,1.1c0,0.4,0,0.9,0,1.3c-0.3-0.1-0.6-0.3-1.1-0.4c0-0.2,0-0.3,0-0.5l0-0.4
        c0-0.1,0-0.2,0-0.4l0-0.8c0-1,0-2-0.2-3.1c-0.2-1.1-0.6-2.2-0.9-3.4c0-0.2-0.1-0.4-0.1-0.5c0-0.2,0.1-0.5,0.2-0.7
        c0.3-0.6,0.4-1.1,0.2-1.7c-0.1-0.4-0.1-0.7,0-1.1c0.3-1.3,0.6-2.5,0.8-3.7c0.1-0.5,0.3-1,0.5-1.5c0.2,0.1,0.4,0.1,0.5,0.1
        c0.1,0,0.2-0.2,0.3-0.2c0.2-0.2,0.3-0.4,0.5-0.7c0.1-0.1,0.2-0.3,0.2-0.4c0.1-0.2,0.2-0.3,0.3-0.5l0.3-0.5l0.4-0.5l0.4-0.5l0.5-0.6
        l0.5-0.6c0.2-0.2,0.4-0.4,0.6-0.6c0.2-0.2,0.4-0.4,0.6-0.6c0.2-0.2,0.4-0.4,0.7-0.5c0.2-0.2,0.5-0.4,0.7-0.5
        c0.2-0.2,0.5-0.3,0.7-0.5l0.7-0.5l0.8-0.5l0.8-0.5l0.8-0.5l0.8-0.5c0.2-0.2,0.5-0.3,0.7-0.5c0.2-0.2,0.5-0.3,0.7-0.5
        c0.2-0.2,0.4-0.3,0.6-0.5c0.3-0.2,0.5-0.4,0.8-0.6c0.3-0.2,0.5-0.5,0.7-0.7c0.4-0.5,0.7-0.9,0.9-1c0.3-0.2,0.5-0.5,0.7-0.8
        c0.2-0.2,0.3-0.4,0.5-0.6c0.2-0.2,0.4-0.3,0.5-0.5c0.1-0.1,0.2-0.2,0.3-0.3c0.1-0.1,0.1-0.3,0.2-0.4c0.1-0.1-0.1-0.4-0.2-0.6
        c0-0.1-0.1-0.1-0.1-0.2c-0.1,0-0.2-0.1-0.2-0.1c-0.1,0-0.2,0.1-0.3,0.1c-0.3,0.1-0.5,0.4-0.7,0.6c-0.6,0.6-1.2,1.2-1.8,1.7
        l-0.4,0.4c-0.3,0.3-0.5,0.5-0.8,0.7c-0.2,0.2-0.4,0.3-0.6,0.5c-0.2,0.2-0.4,0.3-0.7,0.4c-0.2,0.1-0.5,0.2-0.7,0.3
        c-0.2,0.1-0.3,0.2-0.5,0.3c-0.6,0.3-1.1,0.7-1.7,1c-0.1,0-0.3,0.2-1.1,0.7c-0.2,0.1-0.4,0.2-0.6,0.4c-0.2,0.1-0.5,0.3-0.8,0.5
        c-0.6,0.4-1.3,0.8-2.2,1.5c-0.2,0.1-0.4,0.1-0.6,0.3c-0.2,0.2-0.4,0.4-0.5,0.5c-0.2,0.2-0.4,0.5-0.6,0.8c-0.3,0.4-0.6,0.7-0.9,1
        c-0.3,0.3-0.6,0.7-0.9,1.1l0,0c0,0,0-0.2,0-0.2c0.1-0.6,0.5-1.1,0.8-1.7c0.4-0.7,0.5-1.7,0.4-2.7c-0.1-0.8,0.1-1.5,0.5-2
        c0.2-0.3,0.4-0.7,0.6-1c0.2-0.4,0.3-0.9,0.6-1.3c0.2-0.4,0.5-0.8,0.6-1.2c0.2-0.5,0.1-1.1,0.1-1.6c0-0.4,0.3-0.6,0.5-0.9
        c0.1-0.1,0.1-0.3,0.1-0.4c0.1-0.2,0.1-0.4,0.1-0.6c0-0.3,0.1-0.6,0.1-0.9c0-0.3,0.1-0.8,0-1.1c0-0.2-0.1-0.3-0.1-0.4
        c0-0.2-0.2-0.8-0.4-0.4c-0.1,0.1-0.2,0.3-0.2,0.4c-0.2,0.5-0.4,0.9-0.5,1.3c-0.1,0.3-0.2,0.7-0.3,1.1c-0.1,0.3-0.1,0.7-0.3,1
        c-0.3,0.7-0.7,1.4-1.2,2c-0.7,1-0.9,2-1.3,3.1c-0.1,0.2-0.2,0.4-0.3,0.6c-0.2,0.3-0.4,0.7-0.5,1c-0.4,0.9-0.7,1.8-1.1,2.6
        c-0.2,0.4-0.6,0.8-0.7,1.3c-0.1,0.3-0.2,0.5-0.3,0.7c-0.1,0.1-0.1,0.2-0.2,0.4c-0.1,0.1-0.1,0.2-0.2,0.3c-0.2,0.6-0.4,1.3-0.4,2
        c-0.1,0.7-0.1,1.4-0.2,2c-0.1,0.6,0.7,1.5,0,2c0,0-0.1,0.1-0.1,0.1c0,0-0.1-0.1-0.1-0.1c-0.2-0.3-0.4-0.5-0.6-0.7
        c-0.1-0.1-0.2-0.2-0.2-0.4c-0.1-0.1-0.1-0.3-0.2-0.4c-0.1-0.2-0.1-0.4-0.2-0.6l0.1-0.5l0.2-0.7l0.2-0.8l0.2-0.8l0.2-0.9l0.2-0.9
        l0.3-1l0.3-1l0.3-1l0.3-1l0.3-1c0.1-0.4,0.2-0.7,0.4-1c0.1-0.3,0.3-0.7,0.4-1l0.4-1l0.4-1l0.3-0.8c0.1,0,0.3,0,0.3-0.1
        c0.1-0.1,0.1-0.1,0.1-0.2c0-0.1,0-0.3,0-0.4l0-0.2l0.2-0.4l0.4-0.9l0.4-0.9l0.4-0.9c0.7-1.3,1.2-3.1,1.5-3.7
        c0.2-0.4,0.3-0.9,0.4-1.3c0.1-0.3,0.1-0.6,0.2-0.9c0.1-0.3,0.2-0.6,0.2-0.9c0-0.2,0-0.4,0-0.6c0-0.2-0.1-0.4-0.1-0.6
        c0-0.2-0.3-0.2-0.5-0.2c-0.1,0-0.1,0-0.2,0c-0.1,0-0.2,0.1-0.2,0.2c-0.1,0.1-0.1,0.2-0.2,0.4c-0.1,0.3-0.2,0.7-0.2,1
        c-0.2,0.9-0.5,1.8-0.8,2.7c-0.1,0.2-0.2,0.4-0.2,0.7c-0.2,0.4-0.3,0.8-0.5,1.2c-0.3,0.6-0.6,1.2-0.9,1.7c-0.1,0.1-0.2,0.3-0.3,0.4
        l0-0.2l-0.1-0.4l-0.1-0.4l-0.1-0.4l-0.1-0.4l-0.1-0.4l-0.1-0.4l-0.1-0.3l-0.1-0.3l-0.1-0.3c0-0.5-0.2-1.1-0.2-1.3
        c0-0.1,0-0.3-0.1-0.4c0-0.1,0-0.2-0.1-0.3c0-0.1,0-0.2,0-0.3c0-0.1,0-0.1-0.1-0.2c0-0.1-0.1-0.1-0.2-0.2c-0.1-0.1-0.4-0.1-0.6,0
        c-0.1,0-0.2,0-0.2,0c-0.1,0-0.2,0-0.2,0.1c-0.1,0-0.1,0.1-0.1,0.1c-0.1,0.1,0,0.2,0,0.4c0,0.3,0,0.7,0.1,1.1l0,0.3
        c0,0.2,0,0.3,0.1,0.5c0,0.2,0,0.5,0,0.7c0,0.1-0.1,0.3-0.1,0.4c0,0.1,0,0.2,0,0.3c0,0.3,0.2,0.6,0.2,0.8c0,0,0.3,0.6,0.5,2.2
        c0,0.1-0.1,0.2,0,0.3c0,0.1,0.1,0.2,0.1,0.3c0,0.1,0.2,0.2,0.2,0.3c0.1,0.2,0.1,0.4,0.1,0.5c0,0,0,0,0,0.1
        c-0.2,0.4-0.4,0.8-0.6,1.2c0,0.1-0.2,0.5-0.6,1.4c-0.4,0.9-1.1,2.5-2,4.8c-0.1,0.2-0.3,0.4-0.4,0.6c-0.1,0.3-0.1,0.6-0.2,0.9
        c-0.1,0.4-0.1,0.8-0.1,1.1c0,0.1,0,0.2,0,0.2c0-0.4,0-0.9-0.1-1.3c-0.1-0.8-0.7-1.5-1.1-2.3c-0.3-0.5,0.1-1,0.1-1.6
        c0-0.2-0.1-0.4-0.1-0.6c0-0.3,0-0.6,0-0.9l-0.2-1.4c-0.1-0.5-0.1-1.2-0.2-1.7c-0.1-0.2-0.1-0.4-0.1-0.7c0-0.2,0-0.5,0.1-0.7
        c0-0.2,0-0.3-0.4-0.1c-0.1,0-0.1,0.1-0.2,0.2c0,0-0.1,0.1-0.1,0.1l-0.1,0.1c-0.1,0.1-0.2,0.3-0.2,0.3c-0.4,0.9-0.7,1.7-0.8,2.6
        c0,0.3-0.1,0.6-0.1,1l0,0.5l0,0.5c0,0.6,0.1,1.2,0,1.8c0,0.3-0.1,0.5-0.1,0.8l-0.2-0.4l-0.5-0.8l-0.5-0.8l-0.5-0.8l-0.4-0.8
        c-0.1-0.3-0.3-0.5-0.4-0.8l-0.4-0.8c-0.1-0.3-0.3-0.5-0.4-0.8l-0.4-0.8l-0.3-0.7c-0.1-0.2-0.2-0.5-0.3-0.7l-0.1-0.4
        c0.1-0.1,0.1-0.1,0.2-0.2c0-0.1,0-0.1,0-0.1c0-0.1-0.1-0.2-0.2-0.3l-0.1-0.1l-0.1-0.1c-0.1-0.4-0.2-0.8-0.3-1.2
        c-0.1-0.5-0.2-1-0.2-1.3c0-0.3,0-0.7-0.1-1c0-0.2,0-0.5-0.1-0.7c0-0.2,0.1-0.5,0-0.7c0-0.2,0-0.3,0-0.5c0-0.1-0.1-0.3-0.2-0.4
        c-0.1-0.2-0.4-0.2-0.7-0.2c-0.1,0-0.2,0-0.3,0c-0.1,0-0.2,0.1-0.2,0.1c-0.1,0.1-0.1,0.2-0.1,0.3c-0.1,0.3-0.1,0.6-0.1,0.9
        c0,0.4,0,0.8,0,1.2c0,0.4,0,0.7,0,1.1l-0.1-0.1c-0.1-0.1-0.2-0.1-0.3-0.2l-0.3-0.2c-0.1-0.1-0.2-0.1-0.3-0.2l-0.3-0.2l-0.3-0.2
        l-0.2-0.2l-0.2-0.1c-0.3-0.3-0.8-0.5-1-0.6c-0.1-0.1-0.2-0.1-0.4-0.2c-0.1,0-0.2-0.1-0.3-0.1c-0.1,0-0.1-0.1-0.2-0.1
        c-0.1,0-0.1,0-0.2,0c-0.1,0-0.1,0-0.2,0.1c-0.1,0-0.2,0.2-0.3,0.4c0,0.1-0.1,0.1-0.1,0.2c0,0.1,0,0.1,0,0.2c0,0.1,0,0.1,0.1,0.1
        c0.1,0.1,0.2,0.1,0.3,0.1c0.2,0.1,0.5,0.2,0.7,0.4l0.2,0.1c0.1,0.1,0.2,0.1,0.3,0.2c0.2,0.1,0.3,0.2,0.4,0.4
        c0.1,0.1,0.1,0.2,0.2,0.2c0,0.1,0.1,0.1,0.1,0.1c0.2,0.2,0.4,0.2,0.5,0.4c0,0,0.5,0.2,1.4,1.1c0,0.1,0,0.1,0.1,0.2
        c0.1,0,0.1,0.1,0.2,0.1c0.1,0.1,0.2,0.1,0.3,0.1c0,0.2,0.1,0.5,0.1,0.7c0,0.3,0.1,0.6,0.1,0.8c0.1,0.3,0,0.6,0.1,0.9
        c0.1,0.2,0.1,0.4,0.2,0.6c0.2,0.7,0.6,1.3,0.8,1.9c0,0.1,0.2,0.4,0.6,1.1c0.4,0.7,1.1,1.9,2.1,3.7c0.1,0.2,0.1,0.4,0.2,0.6
        c0.1,0.2,0.3,0.4,0.4,0.6c0.2,0.2,0.4,0.4,0.6,0.7c0.3,0.3,0.5,0.7,0.7,1.1c0,0,0,0,0,0c0,0.1,0,0.1,0,0.2c-0.2,2,0.5,3.8,1,5.7
        c0.1,0.4,0.2,0.7,0.2,1.1c0,0.3,0.1,0.6,0.1,0.9l0.1,0.4c0,0.1,0.1,0.3,0.1,0.4l0.2,0.7c-0.1,0.2-0.2,0.4-0.3,0.6
        c-0.1,0.1-0.2,0.2-0.3,0.3c-0.1,0.1-0.1,0.2-0.2,0.3c-0.2,0.3-0.3,0.7-0.5,0.9c0,0-0.1,0.2-0.3,0.6c-0.2,0.4-0.5,1-1.1,1.9
        c-0.1,0.1-0.2,0.1-0.3,0.2c-0.1,0.1-0.1,0.2-0.1,0.4c-0.1,0.2-0.1,0.4-0.1,0.5c-0.1,0.2-0.2,0.4-0.3,0.6c-0.1-0.5-0.2-0.9-0.4-1.4
        c-0.3-0.6-0.7-1.1-1.2-1.6c-0.3-0.3-0.3-0.8-0.4-1.2c-0.1-0.2-0.2-0.3-0.3-0.4c-0.1-0.2-0.2-0.4-0.4-0.6c-0.2-0.3-0.5-0.6-0.7-0.9
        c-0.3-0.3-0.6-0.8-1-1c-0.2-0.1-0.4-0.1-0.5-0.2c-0.2-0.2-0.9-0.5-0.8,0.1c0,0.2,0.2,0.4,0.2,0.5c0.2,0.3,0.3,0.5,0.5,0.8
        c0.1,0.3,0.3,0.5,0.4,0.8l0.4,0.6c0.1,0.2,0.2,0.4,0.4,0.6c0.2,0.4,0.5,0.7,0.6,1.1c0.3,0.9,0.6,1.8,0.8,2.8c0.3,1.4,1,2.6,1.5,3.9
        c0.1,0.3,0.2,0.5,0.2,0.8c0,0.1,0,0.1,0,0.1l0,0l-0.7-0.3l-0.7-0.3l-0.8-0.3c-0.3-0.1-0.6-0.2-0.9-0.3c-0.3-0.1-0.6-0.2-0.9-0.3
        c-0.3-0.1-0.6-0.2-1-0.3c-0.3-0.1-0.7-0.2-1-0.2c-0.4-0.1-0.6-0.1-1-0.1c-0.4,0-0.7,0-1-0.1l-1,0l-1,0l-1,0c-0.3,0-0.6,0-0.9-0.1
        c-0.3,0-0.6-0.1-0.9-0.1c-0.1,0-0.1,0-0.2,0l0,0l-0.1-0.2l0-0.2l-0.1-0.3l0-0.3l0-0.3l0-0.3c0-0.1,0-0.2,0-0.3l0-0.3l0-0.4l0-0.4
        l0-0.4l0-0.4l0-0.4l0-0.4l0-0.4l0-0.3l0-0.3l0-0.3c0.1-0.5-0.1-1.1-0.1-1.3c0-0.1,0-0.3-0.1-0.4c0-0.1,0-0.2-0.1-0.3
        c0-0.1,0-0.2,0-0.3c0-0.1,0-0.1-0.1-0.2c0-0.1-0.1-0.1-0.2-0.2c-0.1-0.1-0.3,0-0.5,0c-0.1,0-0.1,0-0.2,0c-0.1,0-0.1,0.1-0.1,0.1
        l0,0.1c0,0.1,0,0.2,0,0.3c0.1,0.3,0.1,0.6,0.1,0.9l0,0.2c0,0.1,0,0.3,0,0.4c0,0.2,0,0.4-0.1,0.6c0,0.1-0.1,0.2-0.1,0.3
        c0,0.1,0,0.2-0.1,0.2c-0.1,0.3,0,0.5-0.1,0.8c0,0,0,0.6-0.1,2.2c0,0.1-0.1,0.2-0.1,0.2c0,0.1,0,0.2,0.1,0.3c0,0.1,0.1,0.3,0.2,0.4
        c0.1,0.2,0.1,0.4,0.1,0.5c0,0,0,0.1,0,0.1c0,0-0.1,0-0.1-0.1c-0.5-0.3-0.9-0.8-1.3-1.2c-0.4-0.4-0.7-0.9-0.8-1.1
        c-0.2-0.3-0.4-0.6-0.5-1c-0.1-0.2-0.2-0.5-0.4-0.7c-0.1-0.2-0.2-0.5-0.3-0.7c-0.1-0.2-0.2-0.3-0.2-0.5c-0.1-0.1-0.2-0.3-0.3-0.4
        c-0.1-0.1-0.3,0-0.5,0c-0.1,0-0.1,0-0.1,0.1c-0.1,0.1-0.1,0.1-0.1,0.2c0,0.1,0,0.2,0.1,0.3c0,0.3,0.2,0.6,0.3,0.9
        c0.3,0.8,0.7,1.6,1.1,2.4c0.1,0.2,0.2,0.4,0.3,0.6c0.2,0.4,0.5,0.7,0.7,1c0.4,0.5,0.9,1,1.4,1.4c0.3,0.2,0.5,0.4,0.8,0.6
        c0.3,0.1,0.4,0.2,0.7,0.3c0.8,0.3,1.6,0.3,2.3,0.5c0.1,0,0.5,0,1.4,0c0.5,0,1.1,0,1.8,0.1c0.4,0,0.8,0,1.2,0.1c0.1,0,0.2,0,0.3,0
        c0.1,0,0.2,0,0.3,0.1c0.1,0,0.2,0,0.4,0.1c0.1,0,0.2,0.1,0.3,0.1c0.2,0.1,0.3,0.2,0.5,0.2c0.2,0,0.5,0.1,0.7,0.1
        c0.3,0.1,0.6,0.1,0.9,0.1c0.4,0.1,0.9,0.3,1.3,0.5c0.7,0.3,1.4,0.6,2.1,0.9l0.1,0l1.2,0.6c0,0,0.1,0,0.1,0.1
        c0.2,0.7,0.5,1.4,0.6,2.1c0.1,0.6,0.2,1.2,0.5,1.7c0.2,0.6,0.3,1.3,0.5,1.9c0.3,0.8,0.6,1.6,1.1,2.3l0.3,0.6l0.2,0.3l0.2,0.3
        c0.2,0.4,0.5,0.7,0.7,1.1c0.4,0.7,1.4,1.1,1.5,1.9c0,0.2,0,0.4,0,0.6c-0.1-0.1-0.2-0.2-0.3-0.3c-0.2-0.2-0.4-0.4-0.7-0.6
        c-0.2-0.2-0.4-0.3-0.7-0.5c-0.5-0.4-1.2-0.8-1.7-1c-0.5-0.3-1-0.5-1.2-0.6c-0.3-0.2-0.6-0.4-1-0.5c-0.2-0.1-0.5-0.2-0.7-0.3
        c-0.2-0.1-0.5-0.2-0.7-0.3c-0.2-0.1-0.4-0.1-0.6-0.1c-0.2,0-0.4,0-0.5,0.1c-0.2,0-0.2,0.2-0.2,0.4c0,0.1,0,0.1,0,0.2
        c0,0.1,0.1,0.1,0.1,0.1c0.1,0,0.2,0.1,0.2,0.1c0.2,0.1,0.5,0.2,0.7,0.3c0.7,0.3,1.4,0.7,2,1.1l0.5,0.3c0.3,0.2,0.6,0.4,1,0.6
        l0.3,0.2c0.1,0.1,0.2,0.1,0.3,0.2c0.2,0.2,0.4,0.3,0.6,0.5c0.2,0.2,0.3,0.4,0.5,0.6c0.1,0.1,0.3,0.3,0.4,0.4
        c0.4,0.5,0.8,0.9,1.1,1.5c0,0,0.1,0.1,0.2,0.2c0.1,0.1,0.1,0.2,0.2,0.3c0.1,0.1,0.2,0.3,0.3,0.5c0.4,0.7,1.1,1.8,1.9,3.6
        c0.1,0.2,0,0.4,0.1,0.6c0.1,0.2,0.2,0.4,0.4,0.6c0.1,0.3,0.4,0.5,0.5,0.8c0,0.1,0.1,0.1,0.1,0.2c0.1,3.1,0,6.1-0.4,9.1
        c-0.4,3.2-1.2,6.9-1,10.1c0.2,2.7,1.1,5.1,0.8,7.9c-0.3,2.6-1.7,4.5-2.6,7c-1.3,3.4-1.9,7.7-1.9,11.3c4.4,1.8,8.9,1.7,13.6,1.7
        l-0.8-0.5c0.1-5.1-0.9-10.2-1.4-15.3c-0.7-7.3-0.8-13.6,0.1-20.8c0.4-3.4,0.7-6.8,0.5-10.2c-0.1-1.8-0.5-3.4-1-5.1l0.1-0.2
        c0.1-0.2,0.2-0.3,0.3-0.5l0.3-0.6c0.1-0.2,0.2-0.4,0.3-0.6L69,327l0.3-0.7l0.3-0.7l0.3-0.7l0.3-0.7l0.3-0.7l0.3-0.7L71,322
        c0.1-0.2,0.2-0.5,0.3-0.7l0.3-0.7c0.1-0.2,0.2-0.5,0.3-0.7l0.4-0.6c0.1-0.2,0.2-0.4,0.4-0.6l0.4-0.6c0.1-0.2,0.3-0.3,0.4-0.5
        c0.2-0.2,0.3-0.4,0.5-0.6c0.2-0.2,0.4-0.4,0.5-0.5c0.3-0.4,0.6-0.6,0.8-0.7c0.1-0.1,0.2-0.2,0.3-0.3c0.1-0.1,0.2-0.2,0.3-0.2
        c0.2-0.1,0.3-0.2,0.5-0.3c0.1-0.1,0.4-0.2,0.6-0.3c0.1-0.1,0.3-0.1,0.4-0.2c0.1-0.1,0.2-0.2,0.3-0.3c0.1-0.1,0-0.3-0.1-0.5
        c0-0.1-0.1-0.1-0.1-0.2c-0.1-0.1-0.1-0.1-0.2-0.1c-0.1,0-0.2,0-0.3,0c-0.3,0-0.5,0.2-0.7,0.2c-0.3,0.1-0.7,0.3-1,0.5
        c-0.2,0.1-0.3,0.2-0.5,0.3l-0.4,0.3L74,315c-0.3,0.2-0.5,0.4-0.7,0.7c-0.4,0.3-0.7,0.7-1.1,1c-0.2,0.2-0.4,0.3-0.6,0.5
        c-0.1,0.1-0.2,0.3-0.4,0.4c0,0,0,0.1-0.1,0.1c0.1-0.6,0.1-1.4,0.1-1.6c0-0.2,0-0.4,0-0.6c0-0.2,0-0.3,0-0.5c0-0.1,0-0.3,0-0.4
        c0-0.1-0.1-0.2-0.1-0.3c0-0.1-0.1-0.2-0.2-0.2c-0.1-0.1-0.3-0.1-0.5-0.1c-0.1,0-0.1,0-0.2,0c-0.1,0-0.1,0.1-0.1,0.1
        c-0.1,0.1-0.1,0.1-0.1,0.2c-0.1,0.2,0,0.3,0,0.5c0,0.4,0,0.8-0.1,1.3l0,0.3c0,0.2-0.1,0.4-0.1,0.6c0,0.3-0.1,0.6-0.2,0.9
        c-0.1,0.1-0.2,0.3-0.2,0.4c0,0.1-0.1,0.2-0.1,0.3c-0.1,0.3-0.1,0.7-0.3,1c0,0.1,0,0.8-0.7,2.9c0,0.1-0.2,0.2-0.2,0.3
        c0,0.1,0,0.3,0,0.4c0,0.2,0,0.4,0,0.5c0,0,0,0,0,0c-0.1,0.1-0.2,0.2-0.2,0.3c-0.1,0.2-0.1,0.4-0.2,0.6c-0.1,0.3-0.1,0.5-0.1,0.8
        c-0.1,0.4-0.3,0.7-0.4,1.1c0,0.1-0.1,0.2-0.1,0.3c-0.2-0.8-0.4-1.7-0.6-2.6c0-0.2,0-0.4-0.1-0.7c0.2-0.5,0.2-1,0-1.5
        c-0.1-0.4-0.1-0.8,0-1.1c0.2-0.8,0.3-1.5,0.4-2.3c0.1-0.3,0.3-0.5,0.4-0.8l0.3-0.6c0.1-0.2,0.2-0.4,0.3-0.6l0.3-0.7l0.4-0.7
        l0.4-0.8c0.1-0.3,0.3-0.6,0.5-0.8c0.2-0.3,0.3-0.6,0.5-0.9c0.2-0.3,0.4-0.6,0.6-0.9c0.2-0.3,0.4-0.6,0.6-0.9
        c0.2-0.3,0.4-0.6,0.7-0.9c0.2-0.3,0.5-0.6,0.7-0.8c0.3-0.3,0.5-0.5,0.8-0.8l0.4-0.4l0.4-0.3c0.2-0.2,0.6-0.5,0.9-0.7l0.2-0.1
        l0.2-0.2l0.5-0.3l1-0.6l1-0.6l0.9-0.6l0.9-0.6l0.8-0.6c0.3-0.2,0.6-0.4,0.9-0.6c0,0,0,0,0,0.1c0.1,0.1,0.1,0,0.1,0.1
        c0.1,0,0.2,0,0.3,0l0.2,0c0.1,0,0.1,0,0.2,0c0.1,0,0.1,0,0.2,0l0.2,0c0.1,0,0.2,0,0.3,0l0.3,0c0.1,0,0.2,0,0.3,0l0.3,0
        c0.1,0,0.2,0,0.3,0l0.3,0l0.3,0l0.3,0l0.3,0l0.3,0l0.3,0l0.3,0l0.3,0l0.3,0l0.3,0l0.3,0c0.4,0.1,1,0,1.1,0.1c0.1,0,0.3,0,0.4,0
        c0.1,0,0.2,0,0.3,0c0.1,0,0.2,0.1,0.3,0c0.1,0,0.1,0,0.2-0.1c0.1,0,0.1-0.1,0.2-0.2c0.1-0.1,0.1-0.2,0.2-0.4c0-0.1,0-0.1,0-0.1
        C90.1,302.2,90.1,302.2,90.1,302.1z M58.7,320.9c-0.3-0.7-0.5-1.4-0.9-2.1c-0.4-0.8-0.8-1.5-1.1-2.4c-0.3-0.7-0.4-1.5-0.6-2.3
        c-0.2-0.9-0.5-1.7-1-2.5c0-0.2,0-0.4,0-0.5c-0.1-0.1-0.2-0.2-0.3-0.2c-0.1,0-0.1-0.1-0.2-0.1c-0.4-0.7-0.7-1.4-0.8-2.2
        c0-0.2-0.1-0.4-0.1-0.6c0.1,0,0.2-0.1,0.2-0.1c0.1-0.1,0.1-0.1,0.1-0.1c0.1-0.1,0-0.2,0-0.3l0-0.2c0-0.1,0-0.1,0-0.2
        c0-0.1,0-0.2,0.1-0.3c0-0.1,0-0.2,0.1-0.3c0-0.1,0.1-0.2,0.1-0.3c0-0.1,0.1-0.2,0.1-0.3c0.1-0.1,0.1-0.2,0.2-0.4l0.2-0.4l0.2-0.4
        l0.2-0.4l0.2-0.5l0.2-0.5l0.2-0.5l0.2-0.5l0.2-0.5l0.2-0.5l0.2-0.4c0.1,0.5,0.1,0.9,0.1,1.4c0,0.8-0.1,1.5,0.1,2.3
        c0.2,0.8-0.1,1.7,0,2.5c0.2,2.2,1,4.3,1.7,6.5c0.1,0.2,0.2,0.4,0.4,0.6c-1.5,2.1,0.5,7.2,1.4,10.1c-0.3-0.5-0.6-0.9-0.8-1.4
        C59.3,322.3,59,321.6,58.7,320.9z"/>
            <linearGradient id="SVGID_5_" gradientUnits="userSpaceOnUse" x1="625.2855" y1="379.0504" x2="625.2855" y2="294.6607">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_5_)" d="M651,371.7c-3-2.6-0.9-5.9-1.6-9.2c-0.5-2.4-1.9-5.3-4.2-6.5c0.3-0.1,0.6-0.6,0.9-0.7
        c-0.9-0.6-3.5-1.4-3.7-2.5c-0.1-0.4,0.3-1.2,0.3-1.2c-0.3-1.3-1.4-2.6-2.7-3.8c0.5-0.4,1.1-0.6,1.7-0.8c-1.3-1.7-3.1-3.6-3.9-5.6
        c1.2-0.1,2.5,0,3.7,0c-1.4-2.4-3.8-4.7-6.1-6.3c1.7-0.6,3.6-0.2,5.4-0.6c-2-2-3.6-5.3-4.7-7.9c1.2,0,2.7,0.1,4.1,0
        c-1.2-2.2-3-4.6-4.9-6.3c1-0.1,2,0,3,0.3c-2.1-2.8-4.3-5.9-7-8.3c-1.9-1.8-3.6-3.3-5.3-5.3c-1.7-2-4.2-3.9-5.7-5.9
        c-0.8-1-1-2.4-1.7-3.6c-0.5-0.9-1.9-1.8-2.3-2.6c1.1,2.6,3,6-1,6.6c0.5,5.5-2.8,9.3-4.6,13.5c-1.9,4.5-8.4,13.4-7.8,17.6
        c1.2-1.4,2.9-2.4,4.7-2.7c-0.8,4.5-2.8,9.3-3.6,13.7c-0.2,0.9,0.3,2.5,0.1,3.7c-0.4,1.9-2.4,4.6-3.3,6.4c1.7-1.6,4-2.8,6.1-3.7
        c-1.6,4.9-4.1,9.2-6,13.8c6.7,0.6-2,11.3-2,15c3.6,1.2,7.1-0.5,10.7-1c6-0.9,11.4,0.8,17.3,1.1c5.4,0.3,8.7-2.1,13.7-2.5
        c3.8-0.4,7.1,2.1,10.7,0"/>
            <linearGradient id="SVGID_6_" gradientUnits="userSpaceOnUse" x1="33.9522" y1="379.7171" x2="33.9522" y2="295.3273">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_6_)" d="M59.7,372.3c-3-2.6-0.9-5.9-1.6-9.2c-0.5-2.4-1.9-5.3-4.2-6.5c0.3-0.2,0.6-0.6,0.9-0.7
        c-0.9-0.6-3.5-1.4-3.7-2.5c-0.1-0.4,0.3-1.2,0.3-1.2c-0.3-1.3-1.3-2.6-2.7-3.8c0.5-0.4,1.1-0.6,1.7-0.8c-1.3-1.7-3.1-3.6-3.9-5.6
        c1.2-0.1,2.5,0,3.7,0c-1.4-2.4-3.8-4.7-6.1-6.3c1.7-0.6,3.6-0.2,5.4-0.6c-2-2-3.6-5.3-4.7-7.9c1.2,0,2.7,0.1,4.1,0
        c-1.2-2.2-3-4.6-4.9-6.3c1-0.1,2,0,3,0.3c-2.1-2.8-4.3-5.9-7-8.3c-1.9-1.8-3.6-3.3-5.3-5.3c-1.7-2-4.2-3.9-5.7-5.9
        c-0.8-1-1-2.4-1.7-3.6c-0.5-0.9-1.9-1.8-2.3-2.6c1.1,2.6,3,6-1,6.6c0.5,5.5-2.8,9.3-4.6,13.5c-1.9,4.5-8.4,13.4-7.8,17.6
        c1.2-1.4,2.9-2.4,4.7-2.7c-0.8,4.5-2.8,9.3-3.6,13.7c-0.2,0.9,0.3,2.5,0.1,3.7c-0.4,1.9-2.4,4.6-3.3,6.4c1.7-1.6,4-2.8,6.1-3.7
        c-1.6,4.9-4.1,9.2-6,13.8c6.7,0.6-2,11.3-2,15c3.6,1.2,7.1-0.5,10.7-1c6-0.9,11.4,0.8,17.3,1.1c5.4,0.3,8.7-2.1,13.7-2.5
        c3.8-0.4,7.1,2.1,10.7,0"/>
            <linearGradient id="SVGID_7_" gradientUnits="userSpaceOnUse" x1="378.9226" y1="391.2799" x2="378.9226" y2="358.4498">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_7_)" d="M362.7,384.2c-2.2-0.4-4.5-0.7-6.7-0.7c1.3-1,3-1.8,3.6-3.2c-1.7,0-3.5-0.9-3.6-2.6
        c2.1-0.4,3.9-1.7,5.6-3c-0.5-0.2-0.9-0.6-1.5-0.7c0.8-0.9,2.1-1.5,3.1-2.4c-1.4-0.7-2.2-2-2.9-3.3c1.8-0.2,3.7-0.2,5.4,0.3
        c-0.4-0.8-0.1-1.9-0.3-2.6c0.8,0.3,1.9,0.1,2.7,0.5c1.8-2.9,5-6.1,8-7.9c-0.3,1.1-0.5,2.3-0.6,3.4c1.3-0.3,2.2-1.3,3.2-2
        c-0.1,0.5,0.1,1.1,0,1.6c1,0,9.6-1.2,5.5,2c1.9-0.6,6.5-5.9,8.7-4.6c1.7,1,0.6,3.7-0.5,4.5c0.8,0.3,1.4,1,2,1.4c-0.3,0-0.7,0-1,0.1
        c2.2,1.7,4.9,4.4,6.2,6.9c-1.2-0.1-2.5-0.4-3.7-0.2c1.6,1.4,3.9,2.7,5.9,3.3c-1.7-0.3-3.5-0.1-5,0.7c1.4,1.3,3.5,2.2,5.2,3.2
        c-2.3,0.1-3.4,1.4-4.2,3.1c0.6,2.1,2.6,2.5,3.2,4.5c-1.3,0.9-3,0.6-4.5,1.2c0.9,0.6,1.8,1.4,2.4,2.4c-2.6,0.8-6.9,1.9-9.7,1.2
        c-2.1-0.5-2.1-1.5-3.9-2.3c-2.3-1-3.6-0.8-6-0.6c-5.5,0.3-6.4,0.2-10.8-2.3c-1.7-0.9-5.6-1.2-6.1-2.4"/>
<linearGradient id="SVGID_8_" gradientUnits="userSpaceOnUse" x1="687.5769" y1="584.5275" x2="699.7097" y2="532.6618" gradientTransform="matrix(0.9737 -0.2278 0.2278 0.9737 -86.1071 -40.0113)">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_8_)" d="M692.5,370.4c-3.6,0.2-7.4,0.6-10.8,1.3c1.6-2,4-4,4.5-6.4c-2.7,0.6-5.8-0.1-6.6-2.8
        c3.1-1.5,5.6-4.1,7.7-6.8c-0.9-0.1-1.7-0.5-2.6-0.6c0.9-1.7,2.7-3.2,4.1-4.9c-2.4-0.6-4.2-2.4-5.9-4.1c2.8-0.9,5.7-1.6,8.7-1.5
        c-0.9-1.1-0.8-3-1.5-4c1.3,0.1,3-0.5,4.4-0.2c1.8-5.3,5.7-11.5,9.7-15.5c-0.1,1.8,0,3.9,0.3,5.5c1.9-0.9,3-2.8,4.3-4.3
        c0.1,0.8,0.5,1.7,0.7,2.5c1.5-0.3,14.8-5.4,9.4,1.1c2.7-1.7,8.1-11.7,12-10.4c3.1,1,2.3,5.6,0.9,7.3c1.4,0.2,2.5,1.1,3.6,1.4
        c-0.5,0.2-1.1,0.3-1.5,0.5c4.1,1.9,9.4,5.2,12.3,8.6c-2,0.2-4.1,0.3-6,1c3,1.6,7.1,2.8,10.5,3.1c-2.8,0.2-5.5,1.2-7.6,2.9
        c2.7,1.6,6.3,2.3,9.4,3.1c-3.6,1-4.9,3.4-5.5,6.4c1.7,3.2,5.1,3,6.8,5.8c-1.7,2-4.6,2.1-6.7,3.5c1.7,0.6,3.3,1.6,4.6,2.9
        c-3.7,2.2-10.1,5.5-14.8,5.5c-3.4,0-3.9-1.7-6.9-2.2c-4-0.7-5.9,0.1-9.7,1.2c-8.5,2.5-10,2.6-17.8,0.4c-2.9-0.8-9.3,0.1-10.5-1.5"
            />
<linearGradient id="SVGID_9_" gradientUnits="userSpaceOnUse" x1="238.6613" y1="498.6733" x2="250.7941" y2="446.8076" gradientTransform="matrix(0.9737 -0.2278 0.2278 0.9737 -86.1071 -40.0113)">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_9_)" d="M235.8,389c-3.6,0.2-7.4,0.6-10.8,1.3c1.6-2,4-4,4.5-6.4c-2.7,0.6-5.8-0.1-6.6-2.8
        c3.1-1.5,5.6-4.1,7.7-6.8c-0.9-0.1-1.7-0.5-2.6-0.6c0.9-1.7,2.7-3.2,4.1-4.9c-2.4-0.6-4.2-2.4-5.9-4.1c2.8-0.9,5.7-1.6,8.7-1.5
        c-0.9-1.1-0.8-3-1.5-4c1.3,0.1,3-0.5,4.4-0.2c1.8-5.3,5.7-11.5,9.7-15.5c-0.1,1.8,0,3.9,0.3,5.5c1.9-0.9,3-2.8,4.3-4.3
        c0.1,0.8,0.5,1.7,0.7,2.5c1.5-0.3,14.8-5.4,9.4,1.1c2.7-1.7,8.1-11.7,12-10.4c3.1,1,2.3,5.6,0.9,7.3c1.4,0.2,2.5,1.1,3.6,1.4
        c-0.5,0.2-1.1,0.3-1.5,0.5c4.1,1.9,9.4,5.2,12.3,8.6c-2,0.2-4.1,0.3-6,1c3,1.6,7.1,2.8,10.5,3.1c-2.8,0.2-5.5,1.2-7.6,2.9
        c2.7,1.6,6.3,2.3,9.4,3.1c-3.6,1-4.9,3.4-5.5,6.4c1.7,3.2,5.1,3,6.8,5.8c-1.7,2-4.6,2.1-6.7,3.5c1.7,0.6,3.3,1.6,4.6,2.9
        c-3.7,2.2-10.1,5.5-14.8,5.5c-3.4,0-3.9-1.7-6.9-2.2c-4-0.7-5.9,0.1-9.7,1.2c-8.5,2.5-10,2.6-17.8,0.4c-2.9-0.8-9.3,0.1-10.5-1.5"
            />
            <linearGradient id="SVGID_10_" gradientUnits="userSpaceOnUse" x1="339.9887" y1="387.1028" x2="339.9887" y2="366.4848">
                <stop  offset="0" style="stop-color:#277A9F"/>
                <stop  offset="0.6049" style="stop-color:#294E95"/>
                <stop  offset="1" style="stop-color:#1D3973"/>
            </linearGradient>
            <path fill="url(#SVGID_10_)" d="M347,384.8c0.8-2.1,3.6-4,3.6-6.2c-1.1-0.6-2.3-0.5-3.4,0.2c1.9-3.2-3.6-4.1-5.9-4.1
        c0.5-2.6,0.4-6.4-1.7-8.3c-0.1,1.4-0.6,2.7-1.7,3.3c-0.8-1-2-1.8-3.3-2c0,1.5,1,2.7,0.9,4.3c-1.7,0-3.4-0.1-4.9,0.4
        c0.4,1.5,2.1,2.9,2.9,4.2c-1.6,0-3.3,0.4-4.3,1.7c3.9,4,1.9,3,1,8c3.4,1.2,11.7,0.5,15-1"/>
            <g id="house">
                <linearGradient id="SVGID_11_" gradientUnits="userSpaceOnUse" x1="149.4008" y1="260.501" x2="149.4008" y2="546.787">
                    <stop  offset="0" style="stop-color:#0C0A0C"/>
                    <stop  offset="1" style="stop-color:#1857BD"/>
                </linearGradient>
                <path fill="url(#SVGID_11_)" d="M227.4,354.9c0.4-10,13.8-34.6,13.8-34.6c-7.1,1.4-15.3,2.4-23.6,3.1l3.2-14.8l6.9-0.3
            c-9.2-11.2-10.4-19-10.4-19c-4.4,0-19.1,0.4-24.8,0.5l1-11.7c3.3,0.1,5.3,0.2,5.3,0.2c-10.4-7.5-18.4-31.7-20.7-38.6
            c0,0-1.7,7.8-10.4,22.2c-1.4,2.3-2.7,4.3-4,6c-3.8-4.3-9.3-12.1-6.4-18.6l-7.1-0.2l-0.3-5.1l4.4,0.2c-5.8-3.3-12.1-15.6-12.1-15.6
            s-4,11.9-8.8,14.6l3.6,0.2l-0.4,5.4l-43.4-1c0,0,1.5,6.1-0.4,10.8c-1.9,4.6-13.4,14.2-13.4,14.2l15,1.9l1,42.6l-29.8-3.1
            c0,0,19.6,26.1,21.9,40.7c1.2,7.3,0.7,12.9-0.1,16.6l-29.9,14.1h182.8l-14.7-11.1C226.2,370.6,227.1,362.2,227.4,354.9z
             M197.2,316.2l5.8,0.2v6.1C199.7,321.9,196.6,319.5,197.2,316.2z M210,317.3C210,317.4,210,317.4,210,317.3c0,3.5-2.3,5-4.9,5.3
            c-0.1-1.6-0.2-3.9-0.3-6.2l5.1,0.1C210,316.8,210,317.1,210,317.3z M137.6,334.2c0,0,10.3,1,21.3,2l-0.5,10.5l-18.8,0.2
            C139.1,342.2,138.4,337.5,137.6,334.2z M169.8,295l6-0.3l-0.4,11l-6.1-0.3L169.8,295z M179.8,346.4l-17.9,0.2l0.5-10.2
            c7.2,0.6,14.2,1.1,18.4,1.2L179.8,346.4z M158.2,349.1l-0.8,15.5c-6.6-0.2-13.1-0.3-16.4-0.4c0,0-0.4-7.4-1.2-15.3L158.2,349.1z
             M161.8,349.1l17.7,0.2l-1.8,15.8c0,0-7.9-0.2-16.6-0.4L161.8,349.1z M192,349.2l0.4-12.1l5.2-0.1l-0.3,12.2H192z M202.1,349.2
            l0.4-12.1l5.2-0.1l-0.3,12.2H202.1z M216.7,349.2h-5.3l0.4-12.1l5.2-0.1L216.7,349.2z M183,306.1l-6-0.3l0.6-11.1l6.2-0.3
            L183,306.1z M183.9,293.2l-6.2,0.1l0.5-9.7h6.4L183.9,293.2z M175.9,293.3l-6,0.1l0.4-9.8h5.9L175.9,293.3z M116.6,365.6l-6.7,0.4
            v-32.6l5.8,0.4L116.6,365.6z M98.3,333.3l5.8,0.4l1,31.9l-6.7,0.4V333.3z M209.7,315.6c-1.3,0-3.1,0-4.9-0.1
            c-0.1-1.9-0.1-3.7-0.2-5c0.6,0.1,1.2,0.2,1.8,0.5C208,311.8,209.2,313.8,209.7,315.6z M203,310.6v4.9c-2.2-0.1-4.3-0.2-5.5-0.2
            c0.3-0.6,0.7-1.2,1-1.8C199.6,311.8,201.2,310.8,203,310.6z M141.6,304l-9.9,0.1l0.1-13.2h10C141.5,296.3,141.2,302.1,141.6,304z
             M118.2,290.9h10.7l-1.1,13.2l-11.8,0.1C116,304.2,118,299.8,118.2,290.9z M142,288.8l-10.2,0.2l0.1-8.9l10.9,0.2
            C142.8,280.3,142.4,284.2,142,288.8z M129.8,280l-0.8,9l-10.9,0.2c0-2.8-0.2-6-0.7-9.5L129.8,280z"/>
                <radialGradient id="SVGID_12_" cx="148.2436" cy="340.5693" r="8.7751" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <path fill="url(#SVGID_12_)" d="M158.9,336.2c-11-0.9-21.3-2-21.3-2c0.8,3.3,1.5,8,2,12.7l18.8-0.2L158.9,336.2z"/>
                <radialGradient id="SVGID_13_" cx="149.0292" cy="356.7537" r="8.5518" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <path fill="url(#SVGID_13_)" d="M157.4,364.6l0.8-15.5l-18.4-0.2c0.8,7.9,1.2,15.3,1.2,15.3C144.4,364.3,150.9,364.4,157.4,364.6z
            "/>
                <radialGradient id="SVGID_14_" cx="170.2647" cy="357.0706" r="8.5992" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <path fill="url(#SVGID_14_)" d="M177.6,365l1.8-15.8l-17.7-0.2l-0.7,15.6C169.7,364.9,177.6,365,177.6,365z"/>
                <radialGradient id="SVGID_15_" cx="171.3461" cy="341.5607" r="7.5949" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <path fill="url(#SVGID_15_)" d="M162.4,336.5l-0.5,10.2l17.9-0.2l1-8.8C176.5,337.6,169.5,337.1,162.4,336.5z"/>
                <radialGradient id="SVGID_16_" cx="194.846" cy="343.0647" r="4.7626" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_16_)" points="192.5,337.1 192,349.2 197.4,349.2 197.7,336.9 		"/>
                <radialGradient id="SVGID_17_" cx="204.929" cy="343.0647" r="4.7626" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_17_)" points="202.6,337.1 202.1,349.2 207.4,349.2 207.7,336.9 		"/>
                <radialGradient id="SVGID_18_" cx="214.1476" cy="343.0647" r="4.7626" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_18_)" points="211.3,349.2 216.7,349.2 217,336.9 211.8,337.1 		"/>
                <radialGradient id="SVGID_19_" cx="113.1982" cy="349.6666" r="11.7854" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_19_)" points="109.8,366 116.6,365.6 115.6,333.7 109.8,333.3 		"/>
                <radialGradient id="SVGID_20_" cx="101.6749" cy="349.6666" r="11.7854" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_20_)" points="104.1,333.7 98.3,333.3 98.3,366 105,365.6 		"/>
                <g id="window-group-1">
                    <radialGradient id="SVGID_21_" cx="122.4464" cy="297.5714" r="6.5695" gradientUnits="userSpaceOnUse">
                        <stop  offset="0" style="stop-color:#B3C691"/>
                        <stop  offset="1" style="stop-color:#8DC39C"/>
                    </radialGradient>
                    <path fill="url(#SVGID_21_)" d="M128.9,290.9h-10.7c-0.1,8.9-2.2,13.3-2.2,13.3l11.8-0.1L128.9,290.9z"/>
                    <radialGradient id="SVGID_22_" cx="137.3138" cy="284.5557" r="4.9893" gradientUnits="userSpaceOnUse">
                        <stop  offset="0" style="stop-color:#B3C691"/>
                        <stop  offset="1" style="stop-color:#8DC39C"/>
                    </radialGradient>
                    <path fill="url(#SVGID_22_)" d="M131.9,289l10.2-0.2c0.4-4.6,0.8-8.5,0.8-8.5l-10.9-0.2L131.9,289z"/>
                    <radialGradient id="SVGID_23_" cx="136.8096" cy="297.4828" r="5.8698" gradientUnits="userSpaceOnUse">
                        <stop  offset="0" style="stop-color:#B3C691"/>
                        <stop  offset="1" style="stop-color:#8DC39C"/>
                    </radialGradient>
                    <path fill="url(#SVGID_23_)" d="M131.8,290.9l-0.1,13.2l9.9-0.1c-0.4-1.9-0.1-7.7,0.2-13.1H131.8z"/>
                    <radialGradient id="SVGID_24_" cx="123.6279" cy="284.5297" r="5.5345" gradientUnits="userSpaceOnUse">
                        <stop  offset="0" style="stop-color:#B3C691"/>
                        <stop  offset="1" style="stop-color:#8DC39C"/>
                    </radialGradient>
                    <path fill="url(#SVGID_24_)" d="M129.1,289.1l0.8-9l-12.4-0.3c0.5,3.6,0.7,6.8,0.7,9.5L129.1,289.1z"/>
                </g>
                <radialGradient id="SVGID_25_" cx="172.6015" cy="300.2624" r="4.5011" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_25_)" points="175.8,294.8 169.8,295 169.4,305.5 175.4,305.7 		"/>
                <radialGradient id="SVGID_26_" cx="173.0728" cy="288.4841" r="4.1163" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_26_)" points="169.9,293.4 175.9,293.3 176.2,283.6 170.3,283.6 		"/>
                <radialGradient id="SVGID_27_" cx="181.1006" cy="288.4442" r="4.2042" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_27_)" points="177.7,293.3 183.9,293.2 184.5,283.6 178.2,283.6 		"/>
                <radialGradient id="SVGID_28_" cx="180.3941" cy="300.2492" r="4.7711" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <polygon fill="url(#SVGID_28_)" points="177.6,294.7 177,305.8 183,306.1 183.8,294.4 		"/>
                <radialGradient id="SVGID_29_" cx="207.1711" cy="313.096" r="2.5335" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <path fill="url(#SVGID_29_)" d="M204.8,315.5c1.8,0.1,3.6,0.1,4.9,0.1c-0.5-1.9-1.7-3.8-3.3-4.5c-0.6-0.3-1.2-0.4-1.8-0.5
            C204.7,311.8,204.7,313.6,204.8,315.5z"/>
                <radialGradient id="SVGID_30_" cx="200.052" cy="319.3596" r="3.0378" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <path fill="url(#SVGID_30_)" d="M203,322.5v-6.1l-5.8-0.2C196.6,319.5,199.7,321.9,203,322.5z"/>
                <radialGradient id="SVGID_31_" cx="207.4069" cy="319.5142" r="2.8412" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <path fill="url(#SVGID_31_)" d="M205.1,322.6c2.6-0.2,4.9-1.8,4.9-5.2c0,0,0,0,0-0.1c0-0.2,0-0.5-0.1-0.8l-5.1-0.1
            C204.9,318.7,205,321,205.1,322.6z"/>
                <radialGradient id="SVGID_32_" cx="200.2301" cy="313.021" r="2.6087" gradientUnits="userSpaceOnUse">
                    <stop  offset="0" style="stop-color:#B3C691"/>
                    <stop  offset="1" style="stop-color:#8DC39C"/>
                </radialGradient>
                <path fill="url(#SVGID_32_)" d="M203,315.5v-4.9c-1.8,0.2-3.4,1.3-4.5,2.8c-0.4,0.6-0.8,1.2-1,1.8
            C198.7,315.3,200.8,315.4,203,315.5z"/>
            </g>
            <g>
                <g>
<rect x="137.1" y="329" transform="matrix(0.9988 -4.811130e-02 4.811130e-02 0.9988 -16.9742 7.0908)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="132.2" y="357.9" transform="matrix(4.653655e-02 -0.9989 0.9989 4.653655e-02 -207.2361 502.021)" fill="#0B1E3A" width="54.4" height="3.4"/>
<rect x="178.3" y="333.8" transform="matrix(0.9976 -6.885616e-02 6.885616e-02 0.9976 -24.4295 13.255)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="171.6" y="362" transform="matrix(1.359625e-02 -0.9999 0.9999 1.359625e-02 -167.6719 557.5181)" fill="#0B1E3A" width="54.4" height="3.4"/>
<rect x="188.7" y="365.7" transform="matrix(0.1334 -0.9911 0.9911 0.1334 -177.0793 532.3605)" fill="#0B1E3A" width="54.4" height="3.4"/>
<rect x="202.7" y="362.5" transform="matrix(4.776060e-02 -0.9989 0.9989 4.776060e-02 -141.7709 579.6603)" fill="#0B1E3A" width="60.9" height="3.4"/>
<rect x="250.1" y="340.3" transform="matrix(0.9984 -5.715698e-02 5.715698e-02 0.9984 -20.5897 14.9935)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="239.5" y="361.8" transform="matrix(4.618584e-02 -0.9989 0.9989 4.618584e-02 -104.9478 617.0511)" fill="#0B1E3A" width="62.3" height="3.4"/>
<rect x="287.8" y="340.3" transform="matrix(0.9999 -1.146633e-02 1.146633e-02 0.9999 -4.1941 3.3434)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="306.6" y="334.3" transform="matrix(0.998 -6.319565e-02 6.319565e-02 0.998 -22.4152 20.2125)" fill="#0B1E3A" width="3.4" height="60.3"/>
                    <rect x="325.4" y="340.3" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="318.8" y="361.8" transform="matrix(5.132145e-02 -0.9987 0.9987 5.132145e-02 -34.7788 690.3513)" fill="#0B1E3A" width="54.4" height="3.4"/>
<rect x="364.8" y="337.3" transform="matrix(0.9991 -4.180894e-02 4.180894e-02 0.9991 -14.9167 15.6428)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="358.1" y="365.7" transform="matrix(5.070737e-02 -0.9987 0.9987 5.070737e-02 -1.1786 733.6251)" fill="#0B1E3A" width="54.4" height="3.4"/>
<rect x="400.8" y="334.6" transform="matrix(0.9992 -4.000066e-02 4.000066e-02 0.9992 -14.3013 16.3921)" fill="#0B1E3A" width="3.4" height="61.9"/>
<rect x="382.9" y="361.4" transform="matrix(6.891424e-02 -0.9976 0.9976 6.891424e-02 30.7668 759.1041)" fill="#0B1E3A" width="78.4" height="3.4"/>
<rect x="438.4" y="329" transform="matrix(0.9997 -2.392428e-02 2.392428e-02 0.9997 -8.5392 10.6339)" fill="#0B1E3A" width="3.4" height="66.4"/>
<rect x="455.9" y="335" transform="matrix(0.999 -4.577690e-02 4.577690e-02 0.999 -16.1003 21.3272)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="476.1" y="329" transform="matrix(0.9983 -5.887766e-02 5.887766e-02 0.9983 -20.1405 28.7505)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="466.4" y="351.4" transform="matrix(2.736701e-02 -0.9996 0.9996 2.736701e-02 130.1156 839.8727)" fill="#0B1E3A" width="60.5" height="3.4"/>
<rect x="511.4" y="329" transform="matrix(0.9989 -4.782021e-02 4.782021e-02 0.9989 -16.4443 24.9428)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="527.8" y="321.5" transform="matrix(0.9999 -1.683450e-02 1.683450e-02 0.9999 -5.8191 8.9635)" fill="#0B1E3A" width="3.4" height="57.2"/>
<rect x="521.1" y="352.1" transform="matrix(9.727337e-02 -0.9953 0.9953 9.727337e-02 144.8733 867.4089)" fill="#0B1E3A" width="59" height="3.4"/>
<rect x="570.3" y="329" transform="matrix(0.999 -4.490210e-02 4.490210e-02 0.999 -15.4151 26.0424)" fill="#0B1E3A" width="3.4" height="54.4"/>
<rect x="589.1" y="326" transform="matrix(0.9939 -0.1106 0.1106 0.9939 -35.6099 67.543)" fill="#0B1E3A" width="3.4" height="57.4"/>
<rect x="582.5" y="354.4" transform="matrix(5.981147e-02 -0.9982 0.9982 5.981147e-02 217.6703 943.4085)" fill="#0B1E3A" width="54.4" height="3.4"/>
                </g>
                <polygon fill="#0B1E3A" points="235.4,354.2 235.2,354.2 129.6,341.4 129.8,339.1 235.4,351.9 308.2,345.5 366.4,350.4
            402.4,342.3 457.5,345.5 513,335.1 513.2,335.1 572.1,339.1 620.3,333.1 620.6,335.4 572.1,341.4 513.1,337.4 457.7,347.8
            457.5,347.8 402.6,344.7 366.6,352.7 366.4,352.7 308.2,347.8 		"/>
                <polygon fill="#0B1E3A" points="215.9,377.2 129.5,360.7 129.9,358.4 216.1,375 271.5,375 308.3,371.8 343.7,375 393.1,372.3
            393.2,374.6 343.7,377.2 308.3,374.1 271.6,377.2 		"/>
                <polygon fill="#0B1E3A" points="432.9,372.3 432.7,370 480,364.4 514.9,358.4 515.1,358.4 560.9,362.3 560.7,364.6 515,360.7
            480.3,366.7 		"/>
                <polygon fill="#0B1E3A" points="567.8,364.6 567.5,362.3 591.7,358.4 619.3,358.4 619.3,360.7 591.9,360.7 		"/>
            </g>
            <path fill="#0B1E3A" d="M639.7,191.3l-0.2,1.8l4.1,0.5l3.7,1.8c0.1,0,0.2,0.1,0.3,0.1l8.5,1.1l12.1,4c0.1,0,0.3,0.1,0.4,0l12.6-2
        l3.7,0.9l0.3,0.3l0.6,3.5l-0.7,4.1c0,0.1,0,0.2,0,0.3l0.9,8.6l0.7,4.2l-1.3,12.6l-2,11c-0.1,0.3-0.1,0.6,0,0.9l0.9,5.5
        c0,0.2,0.1,0.5,0.2,0.7l4.6,10.2l9.2,20.1l2.9,15.6l0.2,7.9c0,0.4,0.1,0.7,0.1,1.1l3.5,15.8l0.2,7.8l-0.3,16.1l-4.8,35.9l12.1,1.6
        l4.9-36.2c0-0.2,0-0.5,0.1-0.7l0.3-16.7l-0.2-8.6c0-0.4-0.1-0.8-0.1-1.1l-3.5-15.8l-0.2-7.8c0-0.3,0-0.6-0.1-0.9l-3-16.2l-0.5-6.3
        l-0.2-6.5l6.7-7.4l0.3-0.3l0.3-0.5l5.3-6l5.3-4.6l0.7-0.4l12.3-3.4l1-0.3v-1.5l-1.4,0.5l-9.1,2.5l7.2-5.9l3.3-1.1V236l-3.9,1.3
        c-0.1,0-0.2,0.1-0.2,0.1l-3.9,3.2l0.6-1l6.9-4.8l0.5-0.5v-3.9l-5.6,5.1l-3,3.2l0,0.1c0,0,0,0-0.1,0.1l0,0l-2.1,3.6l-4.1,3.5
        l-6.6,3.9c-0.1,0.1-0.2,0.1-0.2,0.2l-2.3,3.7l-1.9,3.3l-0.2,0.2l0,0l-6,6.5l-0.7-24c0-0.3-0.1-0.7-0.2-1l-1.8-5.7l-0.1-5.5l4.2-6.8
        l13.3-10.9l7.3-4.3c0.2-0.1,0.4-0.3,0.6-0.6l2.1-3.5l7.3-3.8v-2.4l-7.8,4l1.3-2.8c0.1-0.1,0.1-0.2,0.1-0.4l0.2-2.3l0.2-0.2l6-0.7
        v-2.8l-5.5,0.7l2.2-4.4l2.8-1.8c0.1-0.1,0.2-0.2,0.3-0.3l0.3-0.4v-5.3l-1.4,1.3l-0.1,0.1l0,0l-2.6,3.4l-0.7,1.5l-0.5,0.3l-3.7,1.9
        l-7.9,3.1c-0.1,0-0.2,0.1-0.3,0.2l-9.1,9.1l-11.2,9c-0.2,0.2-0.4,0.3-0.5,0.6l-3.8,6.5l-0.3-1l-0.2-0.4l-3.2-12.4l1.1-3.3l1.9-6
        l0.8-2.4l2.6-2.8l0.1-0.1l0,0l6.7-11l6.9-10.7l7.2-4.3l6.3-6.1l2.5-3.7l3-3l2.7-3.4l3.7-5.8v-4.7l-0.4,2.6l-4.5,7.1l-2.6,3.2l0,0
        l-3,3.1l-2.5,3.7l-6.1,5.9l-7.2,4.3c-0.1,0.1-0.2,0.1-0.2,0.2l-5.4,8.4l0.1-1.4l0.3-5.2l5.2-4.9l0.5-0.5c0.1-0.1,0.1-0.1,0.2-0.2
        l1.7-4l2-3.8l2.6-3.2c0,0,0.1-0.1,0.1-0.2l1.7-3.9l-1.3-0.6l-1.7,3.8l-2.6,3.3l-2.1,3.9l-1.6,3.7l-4.5,4.3l0.1-1.1l1.6-3.9
        c0-0.1,0.1-0.2,0-0.3l-0.4-4.3l0,0l0,0l0.6-4l1.7-3.8l2.1-3.7l2.3-3.6L717,139l-2.3,3.6l-2.1,3.8l-1.8,4c0,0.1,0,0.1-0.1,0.2
        l-0.7,4.2l0,0.2l0,0l0.4,4.1l-1.5,3.8c0,0.1,0,0.1,0,0.2l-0.2,2.8l-0.1,0.1l-2.6,3.6l-2,3.9l-5.4,16l-0.1,0.1
        c-0.1,0.1-0.1,0.2-0.2,0.3l0,0l-3,9.1l-1.5-5.7c0-0.1-0.1-0.2-0.2-0.3l-2.8-4.2l-0.2-1.9l-2.6-8.3l0,0l1.4-12.5c0-0.1,0-0.2,0-0.3
        l-1.2-4.1l-1.6-12.7l-1.4,0.2l1.6,12.8l1.2,4.1l-1.5,12.7c0,0.1,0,0.2,0,0.3l0,0l2.1,6.5l-3.4-2.5l-0.4-0.4l0.6-5l-1.5-0.2
        l-0.4,3.6l-1-1.2c-0.1-0.1-0.2-0.2-0.3-0.2l-4-1.5c-0.1,0-0.2-0.1-0.4-0.1l-4.8,0.3l-0.4-0.1c-0.1,0-0.1,0-0.2,0l-3.5,0.1l-3.3-1.3
        l-3.4-2.4l-6.4-5.6l-3.4-2.7l-1,1.2l3.3,2.7l6.4,5.7l3.6,2.5l0.1,0.1l-1.2,0l0,1.6l4.8-0.1l0.3,0.1c0.1,0,0.2,0.1,0.3,0.1l0,0
        l0,0.1l3.8-0.2l3.2,0.8l6.8,3.7l-0.2,1.4c0,0.1,0,0.1,0,0.2l1.8,10.7l-3.1-0.7l-10.9-6.7l-9.9-8l-11.3-6.4l-0.9,1.6l11.2,6.4l9.9,8
        l3.7,2.3l5.7,3.4l-10.6,1.7l-12-3.9l-8.5-1.1l-3.7-1.8c-0.1,0-0.2-0.1-0.3-0.1L639.7,191.3z M682.4,182.5l-4.7-2.5l0,0l3.6,1.4
        L682.4,182.5z M701,187l4.3-12.8l1.9-3.7l1.3-1.8l-0.2,3.1l-0.4,4.1l-6.6,10.9L701,187z M739.5,234.2l1.7-1.5l-1.1,1.1L739.5,234.2
        z M694.8,206.4l-3.2-2.2l-2-3.4l0.5-0.8l1.6-4.1c0-0.1,0.1-0.2,0-0.4l-0.2-1.6l0.1,0.2l3,11.5L694.8,206.4z M733.5,191.8l-8.9,6.2
        l-3.9,1.4l-3,0.7l8-8l7.8-3.1l1.8-0.9l-1.6,3.3C733.5,191.5,733.5,191.7,733.5,191.8L733.5,191.8z M703.6,226.1l-1.4-3.3l-0.6-2
        l5.4-9.3l10.7-8.5l3.9-0.9l4.2-1.5c0.1,0,0.2-0.1,0.3-0.2l7.3-5.1l0,0.6l-1.8,3.7l-2,3.3l-7.2,4.3l-13.7,11.2
        c-0.1,0.1-0.3,0.3-0.4,0.4L703.6,226.1z M688.8,244.4l1.8-10l8.2-9.5l0.2,2.3l0.1,6.5c0,0.4,0.1,0.7,0.2,1.1l1.8,5.8l1,32.4
        l0.3,4.6l-12.9-28.4L688.8,244.4z M688.9,220.4c0-0.1,0-0.2,0-0.3l-0.7-4.2l-0.9-8.3l0.7-4l0.4-0.6l1.5,2.6
        c0.1,0.1,0.2,0.3,0.3,0.4l3.3,2.3l2.2,4.1l1.1,7.3c0,0.1,0,0.2,0.1,0.2l0.3,0.6l-0.6,1.1l-8.8,10.2L688.9,220.4z M686.9,201.3
        l0.4,0.4l-0.3,0.5L686.9,201.3z M684.5,186.2l0.1-0.6l2.6,1.7l2.5,3.8l0.6,4.5l-1.5,3.8l-0.2,0.3l-2.2-2L684.5,186.2z"/>
            <path fill="#0B1E3A" d="M65.7,255.9c-0.1,0-0.1,0-0.2,0.1l-2.5,1.2l-5.8,0.7l-8.1,2.6l-7.1-1.1l3.8-2.3l2.5-1.6l6.7-5.4l7.6-4.3
        l-0.6-1.1l-7.6,4.3l-6.7,5.4l-7.3,4.5l-2.1,0.5l1.2-7.2c0,0,0-0.1,0-0.1l-0.1-1l4.6-2.5l2.1-0.6l2.6,0.1l0-0.1l0,0
        c0.1,0,0.2,0,0.2,0l0.2-0.1l3.2,0.1l0-1.1l-0.8,0l0.1,0l2.4-1.7l4.3-3.8l2.3-1.8l-0.7-0.8l-2.3,1.8l-4.3,3.8l-2.3,1.6l-2.2,0.9
        l-2.4-0.1c-0.1,0-0.1,0-0.2,0l-0.3,0.1l-3.3-0.2c-0.1,0-0.2,0-0.2,0l-2.7,1c-0.1,0-0.2,0.1-0.2,0.2l-0.7,0.8l-0.3-2.4l-1,0.1
        l0.4,3.3l-0.2,0.3l-2.3,1.7l1.4-4.4l0,0c0-0.1,0-0.1,0-0.2l-1-8.5l0.8-2.8l1.1-8.6l-1-0.1l-1,8.5l-0.8,2.8c0,0.1,0,0.1,0,0.2l1,8.4
        l0,0l-1.8,5.6l-0.2,1.3l-1.9,2.8c0,0.1-0.1,0.1-0.1,0.2l-1,3.8l-2-6.1l0,0c0-0.1-0.1-0.1-0.1-0.2l-0.1-0.1l-3.6-10.8L24,241
        l-1.8-2.4l-0.1-0.1l-0.1-1.9c0-0.1,0-0.1,0-0.1l-1-2.6l0.3-2.8l0,0l0-0.1l-0.4-2.9c0,0,0-0.1,0-0.1l-1.2-2.7l-1.4-2.5l-1.6-2.4
        l-0.8,0.5l1.6,2.4l1.4,2.5l1.2,2.6l0.4,2.7l0,0l0,0l-0.3,2.9c0,0.1,0,0.2,0,0.2l1,2.6l0,0.8l-3-2.9l-1.1-2.5l-1.4-2.6l-1.8-2.2
        l-1.1-2.6l-0.9,0.4l1.2,2.7c0,0,0,0.1,0.1,0.1l1.8,2.2l1.3,2.5l1.1,2.7c0,0.1,0.1,0.1,0.1,0.2l0.4,0.3l3.5,3.3l0.2,3.5l0.1,0.9
        l-3.7-5.7c0-0.1-0.1-0.1-0.2-0.2l-4.9-2.9l-4.1-3.9L7,228.3l-2-2.1l0,0L3.3,224l-3-4.8L0,217.5v3.2l2.5,3.9l1.8,2.3l2,2l1.7,2.5
        l4.3,4.1l4.9,2.9l4.6,7.2l4.5,7.4l0,0l0.1,0.1l1.7,1.9l0.5,1.6l1.3,4l0.8,2.2l-2.2,8.3l-0.1,0.3l-0.2,0.7l-2.5-4.4
        c-0.1-0.1-0.2-0.3-0.3-0.4l-7.5-6l-6.1-6.1c-0.1-0.1-0.1-0.1-0.2-0.2L6,252.9l-2.5-1.3l-0.3-0.2l-0.5-1L1,248.1l0,0L0.9,248
        L0,247.1v3.6l0.2,0.3c0.1,0.1,0.1,0.1,0.2,0.2l1.9,1.2l1.5,3L0,254.9v1.9l4,0.5l0.2,0.1l0.1,1.6c0,0.1,0,0.2,0.1,0.2l0.9,1.9
        L0,258.3v1.6l4.9,2.6l1.4,2.3c0.1,0.2,0.2,0.3,0.4,0.4l4.9,2.9l9,7.4l2.8,4.6l-0.1,3.7l-1.2,3.9c-0.1,0.2-0.1,0.5-0.1,0.7
        l-0.5,16.2l-4-4.4l0,0l-0.1-0.2l-1.3-2.2l-1.5-2.5c0-0.1-0.1-0.1-0.2-0.2l-4.5-2.6l-2.7-2.4l-1.4-2.4l0,0c0,0,0,0,0,0l0,0l-2-2.2
        L0,282v2.6l0.4,0.4l4.7,3.2l0.4,0.7l-2.6-2.2c0,0-0.1-0.1-0.2-0.1L0,285.7v1.1l2.2,0.7l4.9,4L1,289.8l-1-0.3v1l0.7,0.2L9,293
        l0.5,0.3l3.6,3.1l3.6,4.1l0.2,0.3L17,301l4.5,5l-0.1,4.4l-0.3,4.3l-2.1,10.9c0,0.2-0.1,0.4-0.1,0.6l-0.2,5.3l-2.3,10.6
        c-0.1,0.3-0.1,0.5-0.1,0.8l-0.1,5.8l0.2,11.3c0,0.2,0,0.3,0,0.5l3.3,24.4l8.1-1.1l-3.2-24.2l-0.2-10.8l0.1-5.2l2.3-10.6
        c0.1-0.2,0.1-0.5,0.1-0.7l0.2-5.3l2-10.5l6.2-13.5l3.1-6.9c0.1-0.1,0.1-0.3,0.1-0.5l0.6-3.7c0-0.2,0-0.4,0-0.6l-1.4-7.4l-0.9-8.5
        l0.5-2.8l0.6-5.8c0-0.1,0-0.1,0-0.2l-0.5-2.8l0.4-2.4l0.2-0.2l2.5-0.6l8.5,1.4c0.1,0,0.2,0,0.3,0l8.1-2.7l5.7-0.7
        c0.1,0,0.1,0,0.2-0.1l2.5-1.2l2.8-0.3l-0.1-1.2L65.7,255.9z M40.5,248.9L43,248l0,0l-3.1,1.7L40.5,248.9z M27.1,252.5l-4.5-7.3
        l-0.3-2.8l-0.1-2.1l0.9,1.2l1.3,2.5l2.9,8.6L27.1,252.5z M1,284.2l-0.7-0.8l1.1,1L1,284.2z M31.5,265.3l2-7.7l0.1-0.1l-0.1,1.1
        c0,0.1,0,0.2,0,0.2l1.1,2.8l0.3,0.5l-1.4,2.3l-2.1,1.5L31.5,265.3z M5.4,255.9c0-0.1,0-0.2-0.1-0.2l-1.1-2.2l1.2,0.6l5.3,2.1
        l5.4,5.4l-2-0.5l-2.6-1L5.4,255.9L5.4,255.9z M22.5,274.1c-0.1-0.1-0.1-0.2-0.2-0.3l-9.3-7.6l-4.8-2.9l-1.4-2.3l-1.2-2.5l0-0.4
        l4.9,3.4c0.1,0,0.1,0.1,0.2,0.1l2.8,1l2.6,0.6l7.2,5.8l3.6,6.2l-0.4,1.3l-1,2.3L22.5,274.1z M35,294.6l-8.7,19.2l0.2-3.1l0.7-21.8
        l1.2-3.9c0.1-0.2,0.1-0.5,0.1-0.7l0.1-4.4l0.2-1.6l5.5,6.4l1.2,6.7L35,294.6z M36.3,282.8l-5.9-6.9l-0.4-0.7l0.2-0.4
        c0,0,0-0.1,0-0.2l0.7-4.9l1.5-2.7l2.2-1.5c0.1-0.1,0.2-0.1,0.2-0.2l1-1.7l0.2,0.4l0.5,2.7l-0.6,5.6l-0.5,2.9c0,0.1,0,0.1,0,0.2
        L36.3,282.8z M36.7,262.9l-0.2-0.3l0.3-0.3L36.7,262.9z M37.2,259.9l-1.5,1.4l-0.1-0.2l-1-2.6l0.4-3l1.7-2.6l1.7-1.1l0,0.4
        L37.2,259.9z"/>
            <linearGradient id="SVGID_33_" gradientUnits="userSpaceOnUse" x1="375" y1="451.8345" x2="375" y2="228.1793">
                <stop  offset="0" style="stop-color:#0C0A0C"/>
                <stop  offset="1" style="stop-color:#1857BD"/>
            </linearGradient>
            <path fill="url(#SVGID_33_)" d="M703.3,367.2c-37.5,5.6-56.4-0.1-97.8,1.7c-11.6,0.5-23.4-0.7-34.9,0.5
        c-27.8,2.9-57.2,3.8-83.3,10.8c-50.1,13.4-74.4,8.3-130.5,3.1c-23.4-2.1-61.2-1.3-84.7-2.4c-60.7-2.8-98.8,9.3-156.5,1.8
        c-35.9-4.7-65.7-3.8-97.6-15.7c-5.8-2.1-11.8-4.2-18-6v139.1h750V364.6C733.9,367.6,720,364.7,703.3,367.2z"/>
            <path fill="#0B1E3A" d="M508.7,376.8c0,0,2.7-37.3,13.3-38c10.7-0.7,24,3.3,12.7,37.7L508.7,376.8z"/>
            <path fill="#0B1E3A" d="M472.5,388.9c0,0-9.3-22.6-3.2-26.1c6.1-3.5,15-5,18.4,18.4L472.5,388.9z"/>
            <path fill="#0B1E3A" d="M248.9,386.7c0,0,0.1-24.5,7.1-25.4c6.9-0.9,15.8,1.1,9.9,24L248.9,386.7z"/>
            <path fill="#0B1E3A" d="M44.9,379.7c0,0,0.1-24.5,7.1-25.4c6.9-0.9,15.8,1.1,9.9,24L44.9,379.7z"/>
            <path fill="#0B1E3A" d="M414.1,367.5l-0.6-4.4l2.7-0.6l-0.4-2.8l-2.7,0.6l-0.5-3.5l-3.1,0.5l0.5,3.7l-3.1,0.8l0.8,2.4l2.7-0.6
        l0.6,4.4c-0.2,0.1-0.5,0.1-0.7,0.2c-6.6,2.1-2.3,26.2-2.3,26.2l16.4-4.4C425.8,370.9,420,367.1,414.1,367.5z"/>
            <path fill="#0B1E3A" d="M168,214.3c-0.1,0-4.2-1.1-5.1,2.9c0,0-3.4-1.7-5,1.8c0,0-2.9-2.6-5.2,1.2c0,0-3.6-2.8-5.8,1.6
        c0,0-4-0.5-3.1,4.6c-0.9-5.1-4.5-3.3-4.5-3.3c-3.5-3.4-6,0.5-6,0.5c-3.5-2.9-5.3,0.6-5.3,0.6c-2.7-2.7-5.3,0-5.3,0
        c-2.2-3.5-5.6-1-5.7-1c3.1-9.9,13.5-10.9,13.5-10.9c3.3,5.8,9.8,4.6,9.8,4.6l-0.5-2.6l2,0.9l1.6-1.5l0.5,2.6c0,0,6.6-1.2,7.7-7.7
        C151.6,208.7,161.6,206,168,214.3z"/>
            <path fill="#0B1E3A" d="M210.1,229.7c0.1,0,2.5-0.7,3,1.7c0,0,2-1,3,1.1c0,0,1.7-1.6,3.1,0.7c0,0,2.1-1.7,3.4,0.9
        c0,0,2.4-0.3,1.8,2.8c0.5-3,2.7-2,2.7-2c2.1-2,3.5,0.3,3.5,0.3c2.1-1.7,3.2,0.4,3.2,0.4c1.6-1.6,3.2,0,3.2,0
        c1.3-2.1,3.4-0.6,3.4-0.6c-1.9-5.9-8-6.5-8-6.5c-1.9,3.4-5.9,2.7-5.9,2.7l0.3-1.6l-1.2,0.6l-0.9-0.9l-0.3,1.6c0,0-3.9-0.7-4.6-4.6
        C219.9,226.4,213.9,224.8,210.1,229.7z"/>
            <path fill="#0B1E3A" d="M211.4,245.7c0,0-1.4-0.4-1.7,1c0,0-1.1-0.6-1.7,0.6c0,0-1-0.9-1.7,0.4c0,0-1.2-0.9-1.9,0.5
        c0,0-1.3-0.2-1,1.5c-0.3-1.7-1.5-1.1-1.5-1.1c-1.2-1.1-2,0.2-2,0.2c-1.2-1-1.8,0.2-1.8,0.2c-0.9-0.9-1.8,0-1.8,0
        c-0.7-1.2-1.9-0.3-1.9-0.3c1-3.3,4.5-3.6,4.5-3.6c1.1,1.9,3.3,1.5,3.3,1.5l-0.2-0.9l0.7,0.3l0.5-0.5l0.2,0.9c0,0,2.2-0.4,2.6-2.6
        C206,243.8,209.3,243,211.4,245.7z"/>
            <g>
                <path fill="#142228" d="M37.6,144.8c7.3,0,16.1,1.1,23.3-0.5c0.9-0.2,2.3-0.6,3.1-1c0.5-0.3,0.6-1.1,1-1.2c3-1.3,7.6,0.2,11.1,0.1
            c0.3-4,3.4-6.9,7.4-9c3.2-1.7,7.6-3.8,11.6-2.8c3.6,0.9,5.4,4.5,8.9,5.7c2.3,0.8,4.6,0.4,6.9-0.2c2.5-0.7,6.9-3.2,9.5-2.3
            c3.3,1.1,1.3,4.2,5.6,3.2c4.4-1.1,4.5-2.3,7.7,0.7c4.9,4.6,14.3,2.6,20.8,1.6c3.5-0.5,3.1-0.6,5.3,1c1.7,1.2,3.3,2.5,5.6,2.9
            c1.7,0.3,3.7-0.5,5.2-0.1c2.6,0.6,2.5,2.3,5.8,2c1.6-0.2,3.1-0.9,4.8-1c2.2-0.1,4.4,0.3,6.6,0.4c5.1,0.3,7.9,1.4,12,3.5
            c2.3,1.2,3,1,5.7,0.8c1.9-0.1,5.2-0.6,6.4,0.9c-3.1,2.1-8.2,0.9-11.8,0.6c-5.2-0.3-10.3-0.4-15.5-0.7c-12.6-0.5-25-0.2-37.6-0.2
            c-32.1,0-64.1,0.4-96.2,0c-4.8-0.1-13.8,1.1-18.2-1c-0.1-0.8,1.7-2.5,2.2-3c0.8-0.7,1.6-2.2,3.4-0.7"/>
                <path fill="#142228" d="M14.4,16.2c6,1.6,21.4,2.6,28.4,1c3-0.7,3.5-2.6,6.5-3.5c3.3-1,4.3,0.4,7.4,0.9c6.3,1.1,15-0.5,21.6-0.7
            c8.9-0.2,17.9-0.5,26.8-0.8c18.4-0.6,36.9-1.3,55.3-1.4c12.4-0.1,24.8,0.5,37.2,0.5c7.2,0,22.2-2.2,26.9,3c1.3,1.4,0.3,4,2.1,5.2
            c2.9,2,10.2,0.8,13.6,0.8c8.6,0,17.2,0,25.9,0c7.4,0,17.2,1.3,24.3-0.8c4.1-1.2,7.4-4.7,11.6-5.6c4.6-1,10.4,0.6,15,0.9
            c16.6,1.3,33.6-0.7,48.4,6.5c8.4,4.1,16.3,7.3,26.3,4.4c3.5-1,7.3-5.7,11.3-2.6c3.1,2.4,0.5,6.6,5.6,9.3c9.1,5,22.2,3.3,32.5,4.8
            c17.7,2.7,35.2,6.3,53.1,8c3.2,0.3,7.2,0.5,9.9,1.4c-9.5,2.3-21.5,0.3-31.2,0.6c-16.6,0.5-34.3,0.2-50.4,2.3
            c-25.9,3.3-52.7,0.4-78.7,0.8c-18,0.3-39.5,2.2-57-1.7c7.2-3.5,20.4-2.1,28.4-2.3c12.3-0.3,24.2-1.8,36.4-3.1
            c8.5-0.9,25.3,0.2,32.8-3.5c-5.3-2.8-11.6-2.9-17.7-3c-17.3-0.3-34.5-0.6-51.8-1.1c-32.4-0.9-64.7-1.4-97.1-1.4
            c-12.1,0-24.2-0.4-36.3-1.4c-3.8-0.3-11.2,0.3-14.5-1.4c-3.8-2-2-3.7-3.7-6.6c-3.4-5.9-10.1-4.4-17.1-4.7
            c-21.1-0.8-43.1-3.5-63.9,0.1c-0.8,5.4,8.2,7.6,12.4,10.4c-29.9-0.3-60,1.5-89.8,0.4c1.3-1.3,6.9-6.3,6.1-8.4
            C9.9,21.1,2.1,21.2,0,18.3c4.8-0.5,9.6-0.6,14.4-0.6"/>
                <path fill="#142228" d="M717.9,126.7c-42.3,2.5-85.1,1.5-127.5,1.5c-11.8,0-25.3,1.4-36.8-0.7c-9.1-1.7-11.5-9.9-20.4-10.3
            c-8.7-0.4-17.4,6.7-26.7,7.6c-27.8,2.7-57.1,2-85,1.9c-36.6,0-74.3-1.6-110.2,4.9c53.2,3.3,108.3,0.8,161.8,1.6
            c12.4,0.2,23.1,1.4,34.9,2.7c9,1,19.4-1.6,27.9,0.9c-0.4,2.5-2.5,4.8-3.5,7.1c56.4,2.4,113.1-0.6,169.6,1.9
            c6.2,0.3,38,5.8,40.6-0.3c3.3-7.9-21.9-10-24.7-14.6"/>
                <path fill="#142228" d="M640.7,290c-8,0-19.2,2.1-26-2.6c-3.3-2.3-4.2-9-9-10c-5.5-1.1-9.4,6.3-13.1,6.9
            c-8.7,1.5-18.1-9.1-28.6-8.9c-2.4,11.2-8.3,10.3-21.8,12.5c-22.1,3.6-45.7-0.6-67.7,4.8c31.6,1.7,62.5,3.3,94.3,2.2
            c14.1-0.5,28.1-0.7,42.2-0.7c8.6,0,23.9,2,31.2-0.7"/>
                <path fill="#142228" d="M184.5,195.8c16.9,0,38.9,3.8,54.5-2.6c3.6,7.6,21.5,1.9,29.2,1.9c15.4,0,36.5-1.4,51.6,2.1
            c-2.5,2.5-7.6,1.3-10.5,3.7c14,0.8,28.5,1.7,42.5,2.1c-9,2.2-69.6,3.8-71.6-1.9c-11.4-1.5-25.1,1.9-36.9,1.9
            c-10.3,0-19.8-1.3-29.7-2.7c-6.8-0.9-10.3,1.8-16.5,2c-4.1,0.1-8-2.3-12.3-2.7c-6-0.6-12.5,0.2-18.5-0.1
            c2.3-3.8,19.5-5.9,25.7-5.2"/>
                <path fill="#142228" d="M645.5,13.1c-22.6,0-45.2-0.8-67.9-0.7c-13,0-30.3-2.8-42.6-0.2c8,0.8,30.1-0.8,36,3.9
            c-6.1,4.8-20.6,3.7-28.6,4.7c-26.2,3.1-53.3,2.4-79.2,7.3c35.6-1,71.6,2.2,107.3,2.2c11.1,0,23.4,1.1,34.3-0.9
            c-2.3-6.3,1.5-6.7,8.3-7.3c14.4-1.4,27-0.1,41.3-3.9c-0.9-1.3-2.2-3.3-3.7-4.3"/>
            </g>
            <g id="owl">
                <path fill="#0B1E3A" d="M501.8,320.3c-1.7-4.6-4.3-8.3-6.8-9.7c-0.2-0.3-0.4-0.6-0.7-0.8l-0.3-10.3l-5.2,6.4
            c-1.7-0.7-3.6-1-5.5-0.8c-1.9,0.2-3.7,0.8-5.3,1.8l-6.2-5.3l1.5,10.1c-0.2,0.3-0.4,0.6-0.5,0.9c-2.2,1.8-4.2,5.9-5,10.7
            c-1.2,7.1,3.6,13.8,3.6,13.8s2-1.4,4-3.8c1.2,1.3,2.6,2.4,4.2,3.2l1,4.8l2-0.2l0.3-3.5c1.1,0.2,2.2,0.3,3.4,0.2
            c1.1-0.1,2.2-0.4,3.3-0.8l1,3.4l2-0.2l0.1-4.9c1.4-1,2.6-2.3,3.5-3.9c2.4,2,4.6,3,4.6,3S504.2,327,501.8,320.3z"/>
                <g>
                    <radialGradient id="SVGID_34_" cx="489.3958" cy="314.6052" r="2.9375" gradientUnits="userSpaceOnUse">
                        <stop  offset="0" style="stop-color:#FECA7A"/>
                        <stop  offset="0.1347" style="stop-color:#FACA7B"/>
                        <stop  offset="0.2792" style="stop-color:#EDC97F"/>
                        <stop  offset="0.4284" style="stop-color:#D7C886"/>
                        <stop  offset="0.5807" style="stop-color:#B9C68F"/>
                        <stop  offset="0.7354" style="stop-color:#93C49A"/>
                        <stop  offset="0.89" style="stop-color:#64C1A9"/>
                        <stop  offset="1" style="stop-color:#3EBFB4"/>
                    </radialGradient>
                    <circle fill="url(#SVGID_34_)" cx="489.4" cy="314.6" r="2.9"/>
                    <circle fill="#0B1E3A" cx="489.4" cy="314.6" r="1.2"/>
                    <g>
                        <path fill="#0C0A0C" d="M489.4,317.1c-1.4,0-2.5-1.1-2.5-2.5s1.1-2.5,2.5-2.5c1.4,0,2.5,1.1,2.5,2.5S490.8,317.1,489.4,317.1z
                     M489.4,312.3c-1.3,0-2.3,1-2.3,2.3c0,1.3,1,2.3,2.3,2.3c1.3,0,2.3-1,2.3-2.3C491.7,313.3,490.7,312.3,489.4,312.3z"/>
                    </g>
                </g>
                <g>
                    <radialGradient id="SVGID_35_" cx="480.1458" cy="315.2719" r="2.9375" gradientUnits="userSpaceOnUse">
                        <stop  offset="0" style="stop-color:#FECA7A"/>
                        <stop  offset="0.1347" style="stop-color:#FACA7B"/>
                        <stop  offset="0.2792" style="stop-color:#EDC97F"/>
                        <stop  offset="0.4284" style="stop-color:#D7C886"/>
                        <stop  offset="0.5807" style="stop-color:#B9C68F"/>
                        <stop  offset="0.7354" style="stop-color:#93C49A"/>
                        <stop  offset="0.89" style="stop-color:#64C1A9"/>
                        <stop  offset="1" style="stop-color:#3EBFB4"/>
                    </radialGradient>
                    <circle fill="url(#SVGID_35_)" cx="480.1" cy="315.3" r="2.9"/>
                    <circle fill="#0B1E3A" cx="480.1" cy="315.3" r="1.2"/>
                    <g>
                        <path fill="#0C0A0C" d="M480.1,317.8c-1.4,0-2.5-1.1-2.5-2.5c0-1.4,1.1-2.5,2.5-2.5c1.4,0,2.5,1.1,2.5,2.5
                    C482.7,316.7,481.5,317.8,480.1,317.8z M480.1,313c-1.3,0-2.3,1-2.3,2.3c0,1.3,1,2.3,2.3,2.3c1.3,0,2.3-1,2.3-2.3
                    C482.4,314,481.4,313,480.1,313z"/>
                    </g>
                </g>
            </g>
            <path fill="#0B1E3A" d="M559.8,373.2c0.1-4.5,4.6-8.3,7.8-10.8c-2.6,0.9-5.8,2.1-7.6,4.3c-1,1.2-1.4,2.8-2,4c0-2.1,1.7-4.5,2.3-6.5
        c0.7-2.3,0.9-4.8,0.8-7.3c-2.3,4.1-3.8,10-4.9,14.6c0.1-7.2,1-15-1.3-21.9c-0.3,5,0.4,10.2-0.1,15.3c-0.2,2-0.4,4-0.3,6
        c-1.6-3.7-3-7.5-4.7-11.2c-0.7-1.6-1.6-2.9-3.5-3.3c1.6,2.5,3.8,5.4,4.6,8.3c0.5,1.7,0.9,3.4,1.6,5.1c0.3,0.8,0.6,3,1.4,3.5
        c1.5,0.9,5.8-0.1,7.6,0.2"/>
            <path fill="#0B1E3A" d="M434.2,390.2c0-6.6-4.2-12.3-6.3-18.2c4.2,3.9,5.1,9.3,6.8,14.7c0.3-2.2-0.5-4.9-0.8-7.1
        c-0.4-2.6-0.5-5-0.5-7.6c0-2.6,0.7-5.4,0.5-8c-0.1,2.7,0.9,5.2,1.2,7.8c0.3,2.4,0.4,4.8,0.2,7.3c-0.2,3.3-0.1,6.6-0.1,9.9
        c0.1-2.4-0.3-4.7-0.1-7.1c0.4-3.7,2.1-7,3.7-10.4c1.4-3,2.5-6,5.1-8.2c-1.9,5.9-3.9,11.7-5.8,17.6c-0.8,2.6-2.1,5.4-1.9,8.2
        c-0.9-5.4,5.7-9.6,9-12.7c1.5-1.4,3.2-2.4,4.9-3.3c-2.8,3.1-5.9,6.3-9.1,9c-2.3,1.9-4.1,4.2-5.3,6.8"/>
            <path fill="#0B1E3A" d="M359.9,386.7c0-6.8,3.2-12.6,8.2-17.1c-1.3,1.1-2.9,1.8-4.2,3c-1.5,1.4-2,2.9-2.9,4.7
        c-0.9,1.8-2.9,4.8-2.6,6.7c-0.2-7.4-0.3-15,0.1-22.5c0.1-1.3-0.1-2.3-0.5-3.5c-0.6,5.5,0.2,11.4,0.1,17c0,2.5,0.3,5.2,0.1,7.7
        c0.1-1.1-0.2-2.2-0.5-3.2c-1.1-3.6-2.6-7.1-3.1-10.9c-0.3-2.1-0.2-3.9-0.9-5.9c0.7,2.9,0.3,6,0.9,8.9c0.3,1.6,1.1,3.2,1.6,4.8
        c0.5,2,1.4,4.1,1.8,6.2c0-2.9-4.7-4.3-6.3-6.2c-0.7-0.7-1.3-1.6-2-2.3c1.3,0.5,2.7,3.5,3.4,4.6c0.4,0.6,0.7,1.2,1,1.8
        c0.7,1.3,1.6,2.1,2.5,3.2c0.5,0.6,3.4,5.1,4,1.9"/>
            <path fill="#0B1E3A" d="M393.8,388.8c0.3-2.3,2.7-3.3,4.6-4c-1.5,0.3-5.3,1.4-5.5,3.3c0.1-1.4,0.8-3.2,0.4-4.6
        c-0.7,1.6-1,3.5-1.1,5.2c0.2-1.4-1-2.8-1.7-4c-0.3-0.4-0.5-1.1-0.9-1.4c0.3,1.9,2.1,3.5,2,5.6c0.6,0.2,1.3,0.1,2,0.3"/>
            <path fill="#0B1E3A" d="M74.2,379.1c0.4-3.7,3.1-8,6.9-9.1c-2.1,1-4.6,1.9-6.4,3.4c-0.9,0.8-0.8,1.2-0.9,2.3
        c0.6-3.6,1.9-7.4,0.6-10.9c-0.6,2.9-0.8,5.9-1.2,8.9c-0.1,1.1-0.7,2.5-0.4,3.5c-0.2-1.4-0.7-2.8-1-4.1c-1-4.4,0-9,0.2-13.5
        c0.1-2.5,0.2-5.9-1.1-8.2c-0.6,2,0,4,0,6c0,2.3-0.1,4.7-0.1,7c0,2.5-1.7,5.9-0.8,8.3c0.9-2.9-2.1-6.8-2.9-9.5
        c-0.5-1.5-0.9-3-0.8-4.5c0.8,5.4,3.2,10.5,3,16c0-1.8-2.9-4.8-5-5.4c0.8,1.5,1.8,3.2,2.9,4.6c0.4,0.5,1.3,1.1,1.4,1.7
        c-1.1-0.2-2.6-0.8-3.6-0.6c1.3,0.6,5,1.4,5.6,2.9c0.2,0.4-0.3,1.1,0,1.6c0.4,0.5,1.5,0.8,1.9,0.5"/>
            <path fill="#0B1E3A" d="M502,379.9c0,0,1.4-8.4,1.4-8.6c0.1-0.3,2-2.2,2-2.2s1.5,0,2.3,0.2c0.7,0.2,1.3-0.2,1.3-0.2
        s-1.9-1.2-2.3-1.3c-0.4-0.1-3,0.7-3,0.7l2.6-2.3c0,0,3.2,1,3.7,0.8c0.4-0.2-0.5-0.9-0.7-1.2c-0.2-0.2-2.2-1.1-2.2-1.1
        s-3,0.5-3.2,0.7s1.2-1.7,2.1-1.7c0.4,0,2.8,0.6,2.8,0.2c0.1-0.7-2.2-1.2-2.2-1.2s-2.8-0.4-3.6,0.7c-0.8,1.2-3,3.8-3,3.8l-0.2,5.8
        l-2.1,6L502,379.9z"/>
            <path fill="#0B1E3A" d="M375.6,387.4c0,0,0.6-12.7,0.6-13c0-0.3-1.5-2.5-1.5-2.5s-1.5-0.3-2.3-0.2c-0.8,0-1.2-0.4-1.2-0.4
        s2.1-0.8,2.5-0.8c0.4,0,2.9,1.2,2.9,1.2l-2.1-2.8c0,0-3.4,0.4-3.8,0.1c-0.4-0.3,0.7-0.8,0.9-1c0.3-0.2,2.4-0.7,2.4-0.7
        s2.8,1.1,3,1.3c0.2,0.3-0.8-1.9-1.8-2.1c-0.4-0.1-2.8,0-2.8-0.4c0.1-0.7,2.4-0.8,2.4-0.8s2.9,0.1,3.4,1.4c0.6,1.3,2.2,4.3,2.2,4.3
        l-0.9,5.7l0.5,10.6L375.6,387.4z"/>
        </g>
    </svg>
    <!--<style>
        @keyframes scroll {
            0% {
                transform: translateY(0px);
                opacity: 1;
            }
            50% {
                transform: translateY(7px);
                opacity: 1;
            }
        }
        .scroll-icon {
            transition: all 0.2s ease-in-out 0s;
            box-shadow: inset 0 0 0 2px #FFF;
            transform: translateY(0px);
            border-radius: 25px;
            position: absolute;
            margin-left: -9px;
            cursor: pointer;
            opacity: 0.75;
            height: 30px;
            width: 20px;
            z-index: 1;
            left: 50%;
        }
        .scroll-icon::before {
            animation-iteration-count: infinite;
            animation-duration: 1.5s;
            animation-name: scroll;
            border-radius: 4px;
            position: absolute;
            background: #FFF;
            margin-left: 8px;
            height: 5px;
            content: '';
            width: 4px;
            top: 8px;
        }
    </style>
    <a href="javascript:;" onclick="$(window).scrollTop ($('.CategorySelectBox').position ().top);" class="scroll-icon smooth-scroll"></a>-->
    <!-- Halloween: Masaüstü BG: Biter -->
    <!-- Halloween: Örümcek: Başlar -->
    <style>
        [class*="spider"] {
            position: absolute;
            height: 40px;
            width: 50px;
            -moz-border-radius: 50%;
            -webkit-border-radius: 50%;
            border-radius: 50%;
            margin: 40px 0 0 0;
            background: #110D04;
        }
        [class*="spider"] *, [class*="spider"]:before, [class*="spider"]:after, [class*="spider"] :after, [class*="spider"] :before {
            position: absolute;
            content: "";
        }
        [class*="spider"]:before {
            width: 1px;
            background: #AAAAAA;
            left: 50%;
            top: -320px;
            height: 320px;
        }
        [class*="spider"] .eye {
            top: 16px;
            height: 14px;
            width: 12px;
            background: #FFFFFF;
            -moz-border-radius: 50%;
            -webkit-border-radius: 50%;
            border-radius: 50%;
        }
        [class*="spider"] .eye:after {
            top: 6px;
            height: 5px;
            width: 5px;
            -moz-border-radius: 50%;
            -webkit-border-radius: 50%;
            border-radius: 50%;
            background: black;
        }
        [class*="spider"] .eye.left {
            left: 14px;
        }
        [class*="spider"] .eye.left:after {
            right: 3px;
        }
        [class*="spider"] .eye.right {
            right: 14px;
        }
        [class*="spider"] .eye.right:after {
            left: 3px;
        }
        [class*="spider"] .leg {
            top: 6px;
            height: 12px;
            width: 14px;
            border-top: 2px solid #110D04;
            border-left: 1px solid transparent;
            border-right: 1px solid transparent;
            border-bottom: 1px solid transparent;
            z-index: -1;
        }
        [class*="spider"] .leg.left {
            left: -8px;
            -moz-transform-origin: top right;
            -ms-transform-origin: top right;
            -webkit-transform-origin: top right;
            transform-origin: top right;
            -moz-transform: rotate(36deg) skewX(-20deg);
            -ms-transform: rotate(36deg) skewX(-20deg);
            -webkit-transform: rotate(36deg) skewX(-20deg);
            transform: rotate(36deg) skewX(-20deg);
            border-left: 2px solid #110D04;
            -moz-border-radius: 60% 0 0 0;
            -webkit-border-radius: 60%;
            border-radius: 60% 0 0 0;
            -moz-animation: legs-wriggle-left 1s 0s infinite;
            -webkit-animation: legs-wriggle-left 1s 0s infinite;
            animation: legs-wriggle-left 1s 0s infinite;
        }
        [class*="spider"] .leg.right {
            right: -8px;
            -moz-transform-origin: top left;
            -ms-transform-origin: top left;
            -webkit-transform-origin: top left;
            transform-origin: top left;
            -moz-transform: rotate(-36deg) skewX(20deg);
            -ms-transform: rotate(-36deg) skewX(20deg);
            -webkit-transform: rotate(-36deg) skewX(20deg);
            transform: rotate(-36deg) skewX(20deg);
            border-right: 2px solid #110D04;
            -moz-border-radius: 0 60% 0 0;
            -webkit-border-radius: 0;
            border-radius: 0 60% 0 0;
            -moz-animation: legs-wriggle-right 1s 0.2s infinite;
            -webkit-animation: legs-wriggle-right 1s 0.2s infinite;
            animation: legs-wriggle-right 1s 0.2s infinite;
        }
        [class*="spider"] .leg:nth-of-type(2) {
            top: 14px;
            left: -11px;
            -moz-animation: legs-wriggle-left 1s 0.8s infinite;
            -webkit-animation: legs-wriggle-left 1s 0.8s infinite;
            animation: legs-wriggle-left 1s 0.8s infinite;
        }
        [class*="spider"] .leg:nth-of-type(3) {
            top: 22px;
            left: -12px;
            -moz-animation: legs-wriggle-left 1s 0.2s infinite;
            -webkit-animation: legs-wriggle-left 1s 0.2s infinite;
            animation: legs-wriggle-left 1s 0.2s infinite;
        }
        [class*="spider"] .leg:nth-of-type(4) {
            top: 31px;
            left: -10px;
            -moz-animation: legs-wriggle-left 1s 0.4s infinite;
            -webkit-animation: legs-wriggle-left 1s 0.4s infinite;
            animation: legs-wriggle-left 1s 0.4s infinite;
        }
        [class*="spider"] .leg:nth-of-type(6) {
            top: 14px;
            right: -11px;
            -moz-animation: legs-wriggle-right 1s 0.4s infinite;
            -webkit-animation: legs-wriggle-right 1s 0.4s infinite;
            animation: legs-wriggle-right 1s 0.4s infinite;
        }
        [class*="spider"] .leg:nth-of-type(7) {
            top: 22px;
            right: -12px;
            -moz-animation: legs-wriggle-right 1s 0.7s infinite;
            -webkit-animation: legs-wriggle-right 1s 0.7s infinite;
            animation: legs-wriggle-right 1s 0.7s infinite;
        }
        [class*="spider"] .leg:nth-of-type(8) {
            top: 31px;
            right: -10px;
            -moz-animation: legs-wriggle-right 1s 0.3s infinite;
            -webkit-animation: legs-wriggle-right 1s 0.3s infinite;
            animation: legs-wriggle-right 1s 0.3s infinite;
        }
.spider_0 {
            left: 5%;
            -moz-animation: spider-move-0 5s infinite;
            -webkit-animation: spider-move-0 5s infinite;
            animation: spider-move-0 5s infinite;
        }
.spider_1 {
            left: 20%;
            -moz-animation: spider-move-1 5s infinite;
            -webkit-animation: spider-move-1 5s infinite;
            animation: spider-move-1 5s infinite;
        }
.spider_2 {
            left: 35%;
            -moz-animation: spider-move-2 5s infinite;
            -webkit-animation: spider-move-2 5s infinite;
            animation: spider-move-2 5s infinite;
        }
.spider_3 {
            right: 35%;
            margin-top: 160px;
            -moz-animation: spider-move-3 5s infinite;
            -webkit-animation: spider-move-3 5s infinite;
            animation: spider-move-3 5s infinite;
        }
.spider_4 {
            right: 20%;
            margin-top: 50px;
            -moz-animation: spider-move-4 5s infinite;
            -webkit-animation: spider-move-4 5s infinite;
            animation: spider-move-4 5s infinite;
        }
.spider_5 {
            right: 5%;
            margin-top: 210px;
            -moz-animation: spider-move-5 5s infinite;
            -webkit-animation: spider-move-5 5s infinite;
            animation: spider-move-5 5s infinite;
        }
@media (max-width: 768px)
        {
            .spider_0, .spider_2, .spider_4 {
                display: none;
            }
        }
h1 {
            position: absolute;
            right: 0;
            left: 0;
            top: 300px;
            width: 100%;
            text-align: center;
            font-family: 'Eater', cursive;
            font-size: 6.5vw;
            color: #111111;
            -moz-animation: flicker 4s 0s infinite;
            -webkit-animation: flicker 4s 0s infinite;
            animation: flicker 4s 0s infinite;
            padding: 0 10vw;
        }
.web-right {
            position: absolute;
            height: 200px;
            width: auto;
            right: -10px;
            top: -10px;
            z-index: -1;
            opacity: 0.2;
        }
.web-left {
            position: absolute;
            left: -10px;
            top: -10px;
            -moz-transform: rotate(-90deg);
            -ms-transform: rotate(-90deg);
            -webkit-transform: rotate(-90deg);
            transform: rotate(-90deg);
            z-index: -1;
            opacity: 0.2;
        }
@-moz-keyframes flicker {
            0%, 6%, 12% {
                text-shadow: none;
                color: #111111;
            }
            3%, 9% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6);
                color: #fa6701;
            }
            60% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6), 0 0 16px rgba(250, 103, 1, 0.4), 0 0 20px rgba(255, 0, 84, 0.2), 0 0 22px rgba(255, 0, 84, 0.1);
                color: #fa6701;
            }
            100% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6), 0 0 16px rgba(250, 103, 1, 0.4), 0 0 20px rgba(255, 0, 84, 0.2), 0 0 22px rgba(255, 0, 84, 0.1);
                color: #fa6701;
            }
        }
        @-webkit-keyframes flicker {
            0%, 6%, 12% {
                text-shadow: none;
                color: #111111;
            }
            3%, 9% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6);
                color: #fa6701;
            }
            60% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6), 0 0 16px rgba(250, 103, 1, 0.4), 0 0 20px rgba(255, 0, 84, 0.2), 0 0 22px rgba(255, 0, 84, 0.1);
                color: #fa6701;
            }
            100% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6), 0 0 16px rgba(250, 103, 1, 0.4), 0 0 20px rgba(255, 0, 84, 0.2), 0 0 22px rgba(255, 0, 84, 0.1);
                color: #fa6701;
            }
        }
        @keyframes flicker {
            0%, 6%, 12% {
                text-shadow: none;
                color: #111111;
            }
            3%, 9% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6);
                color: #fa6701;
            }
            60% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6), 0 0 16px rgba(250, 103, 1, 0.4), 0 0 20px rgba(255, 0, 84, 0.2), 0 0 22px rgba(255, 0, 84, 0.1);
                color: #fa6701;
            }
            100% {
                text-shadow: 0 0 8px rgba(250, 103, 1, 0.6), 0 0 16px rgba(250, 103, 1, 0.4), 0 0 20px rgba(255, 0, 84, 0.2), 0 0 22px rgba(255, 0, 84, 0.1);
                color: #fa6701;
            }
        }
        @-moz-keyframes legs-wriggle-left {
            0%, 100% {
                -moz-transform: rotate(36deg) skewX(-20deg);
                transform: rotate(36deg) skewX(-20deg);
            }
            25%, 75% {
                -moz-transform: rotate(15deg) skewX(-20deg);
                transform: rotate(15deg) skewX(-20deg);
            }
            50% {
                -moz-transform: rotate(45deg) skewX(-20deg);
                transform: rotate(45deg) skewX(-20deg);
            }
        }
        @-webkit-keyframes legs-wriggle-left {
            0%, 100% {
                -webkit-transform: rotate(36deg) skewX(-20deg);
                transform: rotate(36deg) skewX(-20deg);
            }
            25%, 75% {
                -webkit-transform: rotate(15deg) skewX(-20deg);
                transform: rotate(15deg) skewX(-20deg);
            }
            50% {
                -webkit-transform: rotate(45deg) skewX(-20deg);
                transform: rotate(45deg) skewX(-20deg);
            }
        }
        @keyframes legs-wriggle-left {
            0%, 100% {
                -moz-transform: rotate(36deg) skewX(-20deg);
                -ms-transform: rotate(36deg) skewX(-20deg);
                -webkit-transform: rotate(36deg) skewX(-20deg);
                transform: rotate(36deg) skewX(-20deg);
            }
            25%, 75% {
                -moz-transform: rotate(15deg) skewX(-20deg);
                -ms-transform: rotate(15deg) skewX(-20deg);
                -webkit-transform: rotate(15deg) skewX(-20deg);
                transform: rotate(15deg) skewX(-20deg);
            }
            50% {
                -moz-transform: rotate(45deg) skewX(-20deg);
                -ms-transform: rotate(45deg) skewX(-20deg);
                -webkit-transform: rotate(45deg) skewX(-20deg);
                transform: rotate(45deg) skewX(-20deg);
            }
        }
        @-moz-keyframes legs-wriggle-right {
            0%, 100% {
                -moz-transform: rotate(-36deg) skewX(20deg);
                transform: rotate(-36deg) skewX(20deg);
            }
            25%, 75% {
                -moz-transform: rotate(-15deg) skewX(20deg);
                transform: rotate(-15deg) skewX(20deg);
            }
            50% {
                -moz-transform: rotate(-45deg) skewX(20deg);
                transform: rotate(-45deg) skewX(20deg);
            }
        }
        @-webkit-keyframes legs-wriggle-right {
            0%, 100% {
                -webkit-transform: rotate(-36deg) skewX(20deg);
                transform: rotate(-36deg) skewX(20deg);
            }
            25%, 75% {
                -webkit-transform: rotate(-15deg) skewX(20deg);
                transform: rotate(-15deg) skewX(20deg);
            }
            50% {
                -webkit-transform: rotate(-45deg) skewX(20deg);
                transform: rotate(-45deg) skewX(20deg);
            }
        }
        @keyframes legs-wriggle-right {
            0%, 100% {
                -moz-transform: rotate(-36deg) skewX(20deg);
                -ms-transform: rotate(-36deg) skewX(20deg);
                -webkit-transform: rotate(-36deg) skewX(20deg);
                transform: rotate(-36deg) skewX(20deg);
            }
            25%, 75% {
                -moz-transform: rotate(-15deg) skewX(20deg);
                -ms-transform: rotate(-15deg) skewX(20deg);
                -webkit-transform: rotate(-15deg) skewX(20deg);
                transform: rotate(-15deg) skewX(20deg);
            }
            50% {
                -moz-transform: rotate(-45deg) skewX(20deg);
                -ms-transform: rotate(-45deg) skewX(20deg);
                -webkit-transform: rotate(-45deg) skewX(20deg);
                transform: rotate(-45deg) skewX(20deg);
            }
        }
/* - */
@media (min-width: 768px) {
            @-moz-keyframes spider-move-0 {
                0%, 100% {
                    margin-top: 131px;
                }
                44% {
                    margin-top: calc(131px + 113px);
                }
            }
            @-webkit-keyframes spider-move-0 {
                0%, 100% {
                    margin-top: 131px;
                }
                44% {
                    margin-top: calc(131px + 113px);
                }
            }
            @keyframes spider-move-0 {
                0%, 100% {
                    margin-top: 131px;
                }
                44% {
                    margin-top: calc(131px + 113px);
                }
            }
            @-moz-keyframes spider-move-1 {
                0%, 100% {
                    margin-top: 49px;
                }
                62% {
                    margin-top: calc(49px + 60px);
                }
            }
            @-webkit-keyframes spider-move-1 {
                0%, 100% {
                    margin-top: 49px;
                }
                62% {
                    margin-top: calc(49px + 60px);
                }
            }
            @keyframes spider-move-1 {
                0%, 100% {
                    margin-top: 49px;
                }
                62% {
                    margin-top: calc(49px + 60px);
                }
            }
            @-moz-keyframes spider-move-2 {
                0%, 100% {
                    margin-top: 83px;
                }
                68% {
                    margin-top: calc(83px + 85px);
                }
            }
            @-webkit-keyframes spider-move-2 {
                0%, 100% {
                    margin-top: 83px;
                }
                68% {
                    margin-top: calc(83px + 85px);
                }
            }
            @keyframes spider-move-2 {
                0%, 100% {
                    margin-top: 83px;
                }
                68% {
                    margin-top: calc(83px + 85px);
                }
            }
            @-moz-keyframes spider-move-3 {
                0%, 100% {
                    margin-top: 101px;
                }
                37% {
                    margin-top: calc(101px + 34px);
                }
            }
            @-webkit-keyframes spider-move-3 {
                0%, 100% {
                    margin-top: 101px;
                }
                37% {
                    margin-top: calc(101px + 34px);
                }
            }
            @keyframes spider-move-3 {
                0%, 100% {
                    margin-top: 101px;
                }
                37% {
                    margin-top: calc(101px + 34px);
                }
            }
            @-moz-keyframes spider-move-4 {
                0%, 100% {
                    margin-top: 208px;
                }
                44% {
                    margin-top: calc(208px + 62px);
                }
            }
            @-webkit-keyframes spider-move-4 {
                0%, 100% {
                    margin-top: 208px;
                }
                44% {
                    margin-top: calc(208px + 62px);
                }
            }
            @keyframes spider-move-4 {
                0%, 100% {
                    margin-top: 208px;
                }
                44% {
                    margin-top: calc(208px + 62px);
                }
            }
            @-moz-keyframes spider-move-5 {
                0%, 100% {
                    margin-top: 172px;
                }
                50% {
                    margin-top: calc(172px + 25px);
                }
            }
            @-webkit-keyframes spider-move-5 {
                0%, 100% {
                    margin-top: 172px;
                }
                50% {
                    margin-top: calc(172px + 25px);
                }
            }
            @keyframes spider-move-5 {
                0%, 100% {
                    margin-top: 172px;
                }
                50% {
                    margin-top: calc(172px + 25px);
                }
            }
        }
/* - */
@media (max-width: 768px)
        {
            [class*="spider"]:before {
                top: -160px;
                height: 160px;
            }
h1 {
                top: 222px;
            }
.web-left,
            .web-right {
                height: 100px;
                top: 75px;
            }
@-moz-keyframes spider-move-1 {
                0%, 100% {
                    margin-top: 20px;
                }
                44% {
                    margin-top: 60px;
                }
            }
            @-webkit-keyframes spider-move-1 {
                0%, 100% {
                    margin-top: 20px;
                }
                44% {
                    margin-top: 60px;
                }
            }
            @keyframes spider-move-1 {
                0%, 100% {
                    margin-top: 20px;
                }
                44% {
                    margin-top: 60px;
                }
            }
            @-moz-keyframes spider-move-3 {
                0%, 100% {
                    margin-top: 40px;
                }
                37% {
                    margin-top: 60px;
                }
            }
            @-webkit-keyframes spider-move-3 {
                0%, 100% {
                    margin-top: 40px;
                }
                37% {
                    margin-top: 60px;
                }
            }
            @keyframes spider-move-3 {
                0%, 100% {
                    margin-top: 40px;
                }
                37% {
                    margin-top: 60px;
                }
            }
            @-moz-keyframes spider-move-5 {
                0%, 100% {
                    margin-top: 10px;
                }
                50% {
                    margin-top: 40px;
                }
            }
            @-webkit-keyframes spider-move-5 {
                0%, 100% {
                    margin-top: 10px;
                }
                50% {
                    margin-top: 40px;
                }
            }
            @keyframes spider-move-5 {
                0%, 100% {
                    margin-top: 10px;
                }
                50% {
                    margin-top: 40px;
                }
            }
        }
    </style>
    <div class='spider_0'>
        <div class='eye left'></div>
        <div class='eye right'></div>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
    </div>
    <div class='spider_1'>
        <div class='eye left'></div>
        <div class='eye right'></div>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
    </div>
    <div class='spider_2'>
        <div class='eye left'></div>
        <div class='eye right'></div>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
    </div>
    <div class='spider_3'>
        <div class='eye left'></div>
        <div class='eye right'></div>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
    </div>
    <div class='spider_4'>
        <div class='eye left'></div>
        <div class='eye right'></div>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
    </div>
    <div class='spider_5'>
        <div class='eye left'></div>
        <div class='eye right'></div>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg left'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
        <span class='leg right'></span>
    </div>
    <h1>
        <?php echo $heading_title; ?>
    </h1>
    <img class='web-right' src='https://www.scandiafun.com/images/spiderweb-corner-right.png'>
    <img class='web-left' src='https://www.scandiafun.com/images/spiderweb-corner-right.png'>
    <!-- Halloween: Örümcek: Biter -->
<br />
<div class="container">
        <div class="row"><?php echo $column_left; ?>
            <?php if ($column_left && $column_right) { ?>
            <?php $class = 'col-sm-6'; ?>
            <?php } elseif ($column_left || $column_right) { ?>
            <?php $class = 'col-sm-9'; ?>
            <?php } else { ?>
            <?php $class = 'col-sm-12'; ?>
            <?php } ?>
            <div id="content" class="text-center <?php echo $class; ?> category-page"><?php echo $content_top; ?>
                <!--<h3><?php echo $text_refine; ?></h3> Alt Kategoriler -->
                <script type="text/javascript">
                    $(function () {
                        $.ajax({
                            url: 'index.php?route=product/category/switchCategory',
                            dataType: 'json',
                            type: 'POST',
                            data: {category_id : '<?=$category_id;?>'},
                            success: function(json){
                                if(json['all_categories']){
                                    json['all_categories'].forEach(function (item, index) {
                                        if(item.category_id == json['category_id']){
                                            $('#category_select_box').append('<option value="'+ item.href +'" selected="selected" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                        }else {
                                            $('#category_select_box').append('<option value="'+ item.href +'" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                        }
                                    });
                                    //Sub Category
                                    if(json['sub_categories']){
                                        json['sub_categories'][json['category_id']].forEach(function (item, index) {
                                            if(item.category_id == json['sub_category_id']){
                                                $('#category_select_box_2').append('<option value="'+ item.href +'" selected="selected" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                            }else {
                                                $('#category_select_box_2').append('<option value="'+ item.href +'" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                            }
                                        })
                                    }
                                    //Sub Category
                                    //Sub Category 2
                                    if(json['sub_categories2'][json['sub_category_id']]){
                                        json['sub_categories2'][json['sub_category_id']].forEach(function (item, index) {
                                            if(item.category_id == json['sub_category_id2']){
                                                $('#category_select_box_3').append('<option value="'+ item.href +'" selected="selected" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                            }else {
                                                $('#category_select_box_3').append('<option value="'+ item.href +'" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                            }
                                        })
                                    }
                                    else {
                                        $('#category_select_box_3').hide();
                                        $('#category_select_box_3').next ().hide();
                                    }
                                    //Sub Category 2
                                }
                                if(json['breadcrumbs']){
                                    json['breadcrumbs'].forEach(function (item, index) {
                                        $('.breadcrumb').append('<li><a href="'+ item.href +'">'+ item.text +'</a></li>');
                                    })
                                }
                            }
                        });
                        $('#category_select_box').on('change', function () {
                            //Collection Select Check control
                            var selected = $(this).children("option:selected").attr('data-id');
                            var asked = $('#category_select_box_3').children("option:selected").text(); //attr('data-id');
                            if(asked == 'Model'){
                                category_id = $(this).children("option:selected").attr('data-id');
                                $.ajax({
                                    url: 'index.php?route=product/category/getSubCategories',
                                    dataType: 'json',
                                    type: 'POST',
                                    data: {category_id : category_id },
                                    success: function(json){
                                        $('#category_select_box_2').html('');
                                        $('#category_select_box_2').append('<option value="0" data-id="0">Model Seçiniz</option>');
                                        json['categories'].forEach(function (item, index) {
                                            $('#category_select_box_2').append('<option value="'+ item.href +'" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                        });
                                    }
                                });
                            }else{
                                $.ajax({
                                    url: 'index.php?route=product/category/findsamecategories',
                                    dataType: 'json',
                                    type: 'POST',
                                    data: {category_id : selected, asked : asked },
                                    success: function(json){
                                        if(json['sub_categories']){
                                            $('#category_select_box_2').html('');
                                            json['sub_categories'][selected].forEach(function (item, index) {
                                                if(item.category_id == json['sub_category_id']){
                                                    $('#category_select_box_2').append('<option value="'+ item.href +'" selected="selected" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                                }else {
                                                    $('#category_select_box_2').append('<option value="'+ item.href +'" data-id="'+ item.category_id +'">'+ item.name +'</option>');
                                                }
                                            });
                                            $('#category_select_box_2').trigger('change')
                                        }
                                    }
                                });
                            }
                        });
                        //$('#category_select_box, #category_select_box_3').on('change', function () {
                        $('#category_select_box_3').on('change', function () {
                            const url = $(this).val();
                            location.href = url;
                        });
                        $('#category_select_box_2').on('change', function () {
                            var selected = $(this).children("option:selected").attr('data-id');
                            var asked = $('#category_select_box_3').children("option:selected").text(); //attr('data-id');
                            if(asked != 'Model'){
                                $.ajax({
                                    url: 'index.php?route=product/category/findsamecategory',
                                    dataType: 'json',
                                    type: 'POST',
                                    data: {category_id : selected, asked : asked },
                                    success: function(json){
                                        if(json['url']){
                                            location.href = json['url'];
                                        }
                                    }
                                });
                            }else {
                                location.href = $(this).val();
                            }
                        });
                    });
                </script>
                <!-- Main Category -->
                <select class="CategorySelectbox" id="category_select_box">
                    <option value="">Marka</option>
                </select>
                <div class="CategorySelectbox__Appearance">
                    <i class="CategorySelectbox__AppearanceIcon fa fa-chevron-down"></i>
                </div>
                <!-- Main Category -->
                <select class="CategorySelectbox" id="category_select_box_2">
                    <option value="" selected="selected">Model</option>
                </select>
                <div class="CategorySelectbox__Appearance">
                    <i class="CategorySelectbox__AppearanceIcon fa fa-chevron-down"></i>
                </div>
                <select class="CategorySelectbox" id="category_select_box_3">
                    <option value="" selected="selected">Model</option>
                </select>
                <div class="CategorySelectbox__Appearance">
                    <i class="CategorySelectbox__AppearanceIcon fa fa-chevron-down"></i>
                </div>
                <div class="row d-none">
                    <div class="col-md-2 col-sm-6 hidden-xs">
                        <div class="btn-group btn-group-sm">
                            <button type="button" id="list-view" class="btn btn-default" data-toggle="tooltip" title="<?php echo $button_list; ?>"><i class="fa fa-th-list"></i></button>
                            <button type="button" id="grid-view" class="btn btn-default" data-toggle="tooltip" title="<?php echo $button_grid; ?>"><i class="fa fa-th"></i></button>
                        </div>
                    </div>
                </div>
                <?php if ($show_products) { ?>
                <?php } else { ?>
                <?php if ($category_list) { ?>
                <?php foreach ($category_list as $c_key => $category_lists) { ?>
                <!-- . -->
                <div class="row">
                    <div class="col-xs-12 text-center"><hr>
                        <h2 class="h1_category"><a href="<?= $category_lists ['href']; ?>"><?php echo $category_lists['name']; ?></a></h2><hr>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <a href="<?= $category_lists ['href']; ?>">
                            <img data-original="<?php echo $category_lists['banner']; ?>" alt="<?php echo $category_lists['name']; ?>" class="w-100 lazy d-none" />
                        </a>
                    </div>
                    <div class="col-sm-6">
                        <div id="CProducts__<?=$c_key;?>" class="owl-carousel custom-0004 custom-0004--Full pt-20">
                            <?php foreach ($category_lists['products'] as $product_c) {
$product_ids[] = $product_c['product_id'];
                  ?>
                            <div class="product">
                                <!--<button type="button" data-toggle="tooltip" title="<?php echo $button_wishlist; ?>" onclick="wishlist.add('<?php echo $product_c['product_id']; ?>');" class="btnWish"><i class="fa fa-heart-o"></i></button>-->
                                <div class="product-thumb">
                                    <? if ($product_c ['product_type'] == '2'): ?>
                                    <a href="<?php echo $product_c['href']; ?>">
                                        <img class="GIFonPRODUCT_C" src="/catalog/view/theme/deercase/image/GIF_HarfYaz1.gif" alt="" />
                                    </a>
                                    <? elseif ($product_c ['product_type'] == '4' or $product_c ['product_type'] == '6'): ?>
                                    <a href="<?php echo $product_c['href']; ?>">
                                        <img class="GIFonPRODUCT_C" src="/catalog/view/theme/deercase/image/GIF_IsminiYaz.gif" alt="" />
                                    </a>
                                    <? elseif ($product_c ['product_type'] == '4' or $product_c ['product_type'] == '8'): ?>
                                    <a href="<?php echo $product_c['href']; ?>">
                                        <img class="GIFonPRODUCT_C" src="/catalog/view/theme/deercase/image/powerbank-ismini-yaz.gif" alt="" />
                                    </a>
                                    <? endif; ?>
                                    <style>
                                        .GIFonPRODUCT_C {
                                            position: absolute;
                                            width: 100%;
                                            z-index: 9;
                                            left: 0;
                                        }
                                    </style>
                                    <div class="image">
                                        <a href="<?php echo $product_c['href']; ?>">
                                            <img data-original="<?php echo $product_c['thumb']; ?>" alt="<?php echo $product_c['name']; ?>" title="<?php echo $product_c['name']; ?>" class="img-responsive lazy" />
                                        </a>
                                    </div>
                                    <div>
                                        <div class="caption">
                                            <h4><a href="<?php echo $product_c['href']; ?>"><?php echo $product_c['name']; ?></a></h4>
                                            <?php if (!$product_c['special']) { ?>
                                            <?php echo $product_c['price']; ?>
                                            <p style="font-weight: 700;color:red;"> - 3 al 2 Öde! Ücretsiz Kargo!</p>
                                            <?php } else { ?>
                                            <span class="price-new"><?php echo $product_c['special']; ?></span> <span class="price-old"><?php echo $product_c['price']; ?></span>
                                            <p style="font-weight: 700;color:red;"> - 3 al 2 Öde! Ücretsiz Kargo!</p>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <h4 class="h4_category"><a class="btn btn-primary" href="<?= $category_lists ['href']; ?>"><i class="fa fa-angle-right"></i> Tümünü Gör</a></h4>
                    </div>
                </div>
                <style>
                    .h4_category {
                        text-decoration: underline !important;
                        margin-left: 20px !important;
                    }
                    @media (min-width: 768px) { {.h4_category {margin-left: 0px !important;}}
                </style>
                <script>
                    jQuery (function ($) {
                        $('#CProducts__<?=$c_key;?>').owlCarousel ({
                            responsive: {
                                0: {
                                    items: 2
                                },
                                768: {
                                    items: 3
                                }
                            },
                            dots: true
                        });
                    });
                </script>
                <?php } ?>
                <!-- . -->
                <?php }
           $product_ids=json_encode($product_ids);
          ?>
                <?php } ?>
                <div class="row">
                    <?php
if ($show_products) {
            ?>
                    <?php foreach ($products as $index => $product) {
                    $product_ids[] = $product['product_id'];
                    ?>
                    <div class="product-layout product-list col-lg-3 col-md-3 col-sm-4 col-xs-6 d-none"><!--
              <button type="button" data-toggle="tooltip" title="<?php echo $button_wishlist; ?>" onclick="wishlist.add('<?php echo $product['product_id']; ?>');" class="btnWish"><i class="fa fa-heart-o"></i></button>-->
                        <!--<?= $product ['model']; ?>-->
                        <div class="product-thumb <? if ($sub_category_id2 >= 1806 and $sub_category_id2 <= 1926 or $sub_category_id2 >= 2038 and $sub_category_id2 <= 2155 ) { ?>pb-50<?php } else { ?>pb-105<?php } ?> pb-105_m mb-20">
                            <? if ($product ['product_type']): ?>
                            <? foreach ($product ['collection_color'] as $c_index => $color): ?>
                            <div class="PS-<?= $product ['product_id']; ?> PS-<?= $product ['product_id'] . $color ['attribute_id']; ?> <?= ($color ['show'])? '':'d-none'; ?> image">
                                <a href="<?php echo $color['href']; ?>" id="ProductImageCarousel__<?= $index; ?>--<?= $product ['product_id'] . $color ['attribute_id']; ?>" class="custom-0004 owl-carousel">
                                    <div>
                                        <? if ($product ['product_type'] == '2'): ?>
                                        <img class="GIFonPRODUCT" src="/catalog/view/theme/deercase/image/GIF_HarfYaz1.gif" alt="" />
                                        <? elseif ($product ['product_type'] == '4' or $product ['product_type'] == '6'): ?>
                                        <img class="GIFonPRODUCT" src="/catalog/view/theme/deercase/image/GIF_IsminiYaz.gif" alt="" />
                                        <? elseif ($product ['product_type'] == '8'): ?>
                                        <img class="GIFonPRODUCT" src="/catalog/view/theme/deercase/image/powerbank-ismini-yaz.gif" alt="" />
                                        <? endif; ?>
                                        <img data-src="<?php echo $color ['image']; ?>" alt="<?php echo $color ['name']; ?>" title="<?php echo $color ['name']; ?>" class="img-responsive owl-lazy" />
                                    </div>
                                    <? foreach ($color ['images'] as $image): ?>
                                    <div>
                                        <img data-src="<?php echo $image ['popup']; ?>" alt="<?php echo $color ['name']; ?>" title="<?php echo $color ['name']; ?>" class="img-responsive owl-lazy" />
                                    </div>
                                    <? endforeach; ?>
                                </a>
                                <script>
                                    jQuery (function ($) {
                                        $('#ProductImageCarousel__<?= $index; ?>--<?= $product ['product_id'] . $color ['attribute_id']; ?>').owlCarousel ({
                                            items: 1,
                                            lazyLoad: true,
                                            dots: true
                                        });
                                    });
                                </script>
                            </div>
                            <? endforeach; ?>
                            <? else: ?>
                            <div class="image">
                                <a href="<?php echo $product['href']; ?>" id="ProductImageCarousel__<?= $index; ?>" class="custom-0004 owl-carousel">
                                    <img data-original="<?php echo $product ['thumb']; ?>" src="/catalog/view/theme/deercase/image/placeholder250.png" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive lazy" />
                                    <? foreach ($product ['images'] as $image): ?>
                                    <img data-original="<?php echo $image ['popup']; ?>" src="/catalog/view/theme/deercase/image/placeholder250.png" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive lazy" />
                                    <? endforeach; ?>
                                </a>
                                <script>
                                    jQuery (function ($) {
                                        $('#ProductImageCarousel__<?= $index; ?>').owlCarousel ({
                                            items: 1,
                                            dots: true
                                        });
                                    });
                                </script>
                            </div>
                            <? endif; ?>
                            <div class="custom-0007 d-none">
                                <? if ($product ['product_type']): ?>
                                <? if ($sub_category_id2 >= 1806 and $sub_category_id2 <= 1926 or $sub_category_id2 >= 2038 and $sub_category_id2 <= 2155 ) { ?>
                                <style type="text/css">.pb-50{padding-bottom: 50px!important;}</style>
                                <?php } else {
                      if($show_color_attribute)
                      {
                      ?>
                                <div class="FlexScroller <?= (($category_id >= 2689 && $category_id <= 2692) || ($category_id >= 3023 && $category_id <= 3025) ?'d-none':'') ?>  <?= (4 < count($product ['collection_color']))? '': 'justify-content-center'; ?> <?= (count($product ['collection_color']) < 2)? 'd-none': ''; ?>">
                                    <? foreach ($product ['collection_color'] as $color): ?>
                                    <? if ($color ['show']): ?>
                                    <div class="PP__CaseCircle_Cat">
                                        <a href="javascript: PS (<?= $product ['product_id'] . $color ['attribute_id']; ?>, <?= $product ['product_id']; ?>);">
                                            <img src="<?= $color ['attribute_image']; ?>" alt="" />
                                        </a>
                                    </div>
                                    <? endif; ?>
                                    <? endforeach; ?>
                                    <? foreach ($product ['collection_color'] as $color): ?>
                                    <? if (! $color ['show']): ?>
                                    <div class="PP__CaseCircle_Cat">
                                        <a href="javascript: PS (<?= $product ['product_id'] . $color ['attribute_id']; ?>, <?= $product ['product_id']; ?>);">
                                            <img src="<?= $color ['attribute_image']; ?>" alt="" />
                                        </a>
                                    </div>
                                    <? endif; ?>
                                    <? endforeach; ?>
                                </div>
                                <?php } } ?>
                                <? endif; ?>
                                <div class="caption">
                                    <h4>
                                        <? if ($product ['product_type']): ?>
                                        <? foreach ($product ['collection_color'] as $c_index => $color): ?>
                                        <a class="PS-<?= $product ['product_id']; ?> PS-<?= $product ['product_id'] . $color ['attribute_id']; ?> <?= ($color ['show'])? '': 'd-none'; ?>" href="<?php echo $color ['href']; ?>"><?php echo $color ['name']; ?></a>
                                        <? endforeach; ?>
                                        <? else: ?>
                                        <a href="<?php echo $product['href']; ?>"><?php echo $product['name']; ?></a>
                                        <? endif; ?>
                                    </h4>
                                    <?php if ($product['price']) { ?>
                                    <? if ($product ['product_type']): ?>
                                    <? foreach ($product ['collection_color'] as $c_index => $color): ?>
                                    <p class="PS-<?= $product ['product_id']; ?> PS-<?= $product ['product_id'] . $color ['attribute_id']; ?> <?= ($color ['show'])? '': 'd-none'; ?> price">
                                        <?php if (!$color['special']) { ?>
                                        <?php echo $color['price']; ?><span style="color:red;"><b> - 3 Al 2 Öde! Ücretsiz Kargo!</b></span>
                                        <?php } else { ?>
                                        <span class="price-new"><?php echo $color['special']; ?></span> <span class="price-old"><?php echo $color['price']; ?>><b> - 3 Al 2 Öde! Ücretsiz Kargo!</b></span>
                                        <?php } ?>
                                    </p>
                                    <? endforeach; ?>
                                    <? else: ?>
                                    <p class="price">
                                        <?php if (!$product['special']) { ?>
                                        <?php echo $product['price']; ?>
                                        <?php } else { ?>
                                        <span class="price-new"><?php echo $product['special']; ?></span> <span class="price-old"><?php echo $product['price']; ?></span>
                                        <?php } ?>
                                    </p>
                                    <? endif; ?>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php }
            $product_ids=json_encode($product_ids);
            ?>
                    <?php } ?>
                    <script>
                        var PS = function (AttrPrd_ID, Product_ID) {
                            var targetIndex = $('.PS-' + Product_ID).find ('.owl-carousel:visible').find ('.owl-item.active').index ();
                            console.log (targetIndex);
                            $('.PS-' + Product_ID).addClass ('d-none');
                            $('.PS-' + AttrPrd_ID).removeClass ('d-none');
                            $(document).scrollTop ($(document).scrollTop () + 1);
                            $(document).scrollTop ($(document).scrollTop () - 1);
                            $('.PS-' + AttrPrd_ID).find ('.owl-carousel').trigger ('to.owl', [targetIndex, 0]);
                        };
                    </script>
                </div>
                <?php echo $content_bottom; ?></div>
            <?php echo $column_right; ?></div>
    </div>
    <script>
        jQuery (function ($) {
            $('.product-layout').removeClass ('d-none');
            $('.GIFonPRODUCT').click (function () {
                window.location.href = ('/' + $(this).next ('.product-thumb').find ('div:not(.d-none)').children ('a').attr ('href'));
            });
        });
    </script>
    <?php
    if($CretioOneTag_status && $product_ids)
    {
    ?>
    <!-- Criteo Category / Listing Tag -->
    <script type="text/javascript" src="//static.criteo.net/js/ld/ld.js" async="true"></script>
    <script type="text/javascript">
        window.criteo_q = window.criteo_q || [];
        var deviceType = /iPad/.test(navigator.userAgent) ? "t" : /Mobile|iP(hone|od)|Android|BlackBerry|IEMobile|Silk/.test(navigator.userAgent) ? "m" : "d";
        window.criteo_q.push(
            { event: "setAccount", account: '<?php echo $CretioOneTag_id ?>'}, // You should never update this line
            { event: "setEmail", email: "" }, // Can be an empty string
            { event: "setSiteType", type: deviceType},
            { event: "viewList", item: <?php echo $product_ids ?> });
    </script>
    <!-- END Criteo Category / Listing Tag -->
    <?php
    }
    ?>
    <?php
    if($useinsider_status)
    {
    ?>
    <script async src="//deercase.api.useinsider.com/ins.js?id=<?=$useinsider_partner_id?>"></script>
    <script type="text/javascript">
        window.insider_object = {
            "page": {
                "type": "Category"
            }
        }
        window.insider_object = {
            "listing": {
                "items": [
                <?php
                if ($category_list) {
                    foreach ($category_list as $c_key => $category_lists) {
                        foreach ($category_lists['products'] as $product_c) {
                                ?>
                            {
                                "id": "<?=$product_c['product_id']?>",
                                "name": "<?=$product_c['name']?>",
                                "taxonomy": [
                                "<?=$product_c['breadcrumb1']?>",
                                "<?=$product_c['breadcrumb2']?>",
                                "<?=$product_c['breadcrumb3']?>"
                            ],
                                "currency": "<?=$product_c['currency']?>",
                                "unit_price": <?=str_replace(',','.',str_replace('₺','',$product_c['price']))?>,
                                "unit_sale_price": <?=($product_c['special']?str_replace(',','.',str_replace('₺','',$product_c['special'])) :str_replace(',','.',str_replace('₺','',$product_c['price'])))?>,
                                "url": "<?=$product_c['href']?>",
                                "stock": <?=$product_c['quantity']?>,
                                "color": "<?=$product_c['color']?>",
                                "product_image_url": "<?=$product_c['thumb']?>",
                                "custom": {
                                "model": "<?=$product_c['model']?>"
                                "collection":"<?=$product_c['collection']?>"
                            }
                            },
                        <?php
                        }
                    }
                }else{
                    if($products){
                        foreach ($products as $index => $product) {
                                ?>
                            {
                                "id": "<?=$product['product_id']?>",
                                "name": "<?=$product['name']?>",
                                "taxonomy": [
                                "<?=$product['breadcrumb1']?>",
                                "<?=$product['breadcrumb2']?>",
                                "<?=$product['breadcrumb3']?>"
                            ],
                                "currency": "<?=$product['currency']?>",
                                "unit_price": <?=str_replace(',','.',str_replace('₺','',$product['price']))?>,
                                "unit_sale_price": <?=($product['special']?str_replace(',','.',str_replace('₺','',$product['special'])) :str_replace(',','.',str_replace('₺','',$product['price'])))?>,
                                "url": "<?=$product['href']?>",
                                "stock": <?=$product['quantity']?>,
                                "color": "<?=$product['color']?>",
                                "product_image_url": "<?=$product['thumb']?>",
                                "custom": {
                                "model": "<?=$product['model']?>"
                                "collection":"<?=$product['collection']?>"
                            }
                            },
                        <?php
                        }
                    }
                }
                    ?>
        ]
        }
        }
    </script>
    <?php
    }
    ?>
    <?php echo $footer; ?>
</div>