<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
        <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Oswald:wght@300;400;500&display=swap" />
        <style type="text/css">
@font-face {
  font-family: "lucida-sans-regular";
  src:url("catalog/view/theme/deercase/font/lucida-sans-regular.ttf");
}
@media only screen and (max-device-width: 640px) {
            .MainTable {
                width: 100%;
            }
            .TableInTable {}
            }
@media only screen and (max-device-width: 479px) {
                .MainTable {
                    margin-left: 10px;
                    width: 75%;
                }
                .TableInTable {}
            }
</style>
    </head>
<body>
<div style="background-color: #FDD0BF; width: 90%; padding: 5%; margin: auto;">
            <table class="MainTable" style="font-family: Arial !important; width: 100%; min-width: 400px; max-width: 800px; margin: auto;">
                <tr>
                    <td colspan="3">
                        <img height="50" src="data:image/png;base64,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" />
<h1 style="font-size: 30px; font-weight: 400; text-align: center;">Sipariş Bilgi Formu</h1>
                    </td>
                </tr>
                <tr>
                    <td style="text-align: center; font-size: 18px; font-weight: 300; padding-bottom: 30px;" colspan="3">
                        <p style="margin: 1px auto 0;">Merhaba <?= $firstname; ?> <?= $lastname; ?></p>
                        <p style="margin: 3px auto;">Özgür tasarımlarla dolu <a style="text-decoration: none; color: #000;" href="https://deercase.com" target="_blank"><b>Deercase</b></a>'i tercih ettiğiniz için teşekkür ederiz.</p>
                        <p style="margin: 3px auto;">Sipariş numaran <b><?= $order_id; ?></b></p>
                        <p style="margin: 3px auto;">Aşağıda siparişinle ilgili detayları bulabilirsin.</p>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <p style="margin: 3px auto 0; font-size: 20px; font-weight: 500;">Sipariş Özeti</p>
                        <p>
                            <? if ($order_status == "Teslimatta"): ?>
                                <?= $order_status; ?> <a href="#">Kargo Takip</a>
                            <? else: ?>
                                <?= $order_status; ?>
                            <? endif; ?>
                            <br />
                            <b>Telefon: </b> <?= $telephone; ?>
                            <b>E-Posta: </b> <?= $email; ?>
                        </p>
                        <p style="margin: 3px auto 0; font-size: 20px; font-weight: 500;">Ödeme Şekli</p>
                        <p><?= $payment_method; ?></p>
                        <p style="margin: 3px auto 0; font-size: 20px; font-weight: 500;">Kargo Bilgileri</p>
                        <p><?= $shipping_method; ?></p>
                        <p style="margin: 3px auto 0; font-size: 20px; font-weight: 500;">Fatura ve Teslimat Adresi</p>
                        <p><b>Fatura:</b> <?= $payment_address; ?></p>
                        <p><b>Teslimat:</b> <?= $shipping_address; ?></p>
                    </td>
                    <td style="text-align: right;">
                        <?
                            switch ($order_status)
                            {
                                case "Siparişiniz Onaylandı ve Üretime Hazırlanıyor": $Base64IMG = "data:image/png;base64,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"; break;
                                case "Hazırlanıyor": $Base64IMG = "data:image/png;base64,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"; break;
                                case "Kargoya Verilmek Üzere Hazırlandı": $Base64IMG = "data:image/png;base64,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"; break;
                                case "Kargo Verildi": $Base64IMG = "data:image/png;base64,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"; break;
                                case "Teslimatta": $Base64IMG = "data:image/png;base64,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"; break;
                                case "Tamamlandı": $Base64IMG = "data:image/png;base64,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"; break;
                                default: $Base64Img = "";
                            }
                        ?>
                        <img height="350" src="<?= $Base64IMG; ?>" />
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <p style="margin: 3px auto 0; font-size: 20px; font-weight: 500;">Ürün Bilgileri</p>
                        <table class="TableInTable" style="width: 100%; border-collapse: collapse; border-top: 1px solid #DDDDDD; border-left: 1px solid #DDDDDD; margin-bottom: 20px; background-color: #FFF;">
                            <thead>
                            <tr>
                                <td style="font-family: Arial; letter-spacing: 0.8px; text-transform: uppercase; font-size: 12px; border-right: 1px solid #DDDDDD; border-bottom: 1px solid #000; background-color: #000; font-weight: bold; text-align: left; padding: 7px; color: #FFF;">Fotoğraf</td>
                                <td style="font-family: Arial; letter-spacing: 0.8px; text-transform: uppercase; font-size: 12px; border-right: 1px solid #DDDDDD; border-bottom: 1px solid #000; background-color: #000; font-weight: bold; text-align: left; padding: 7px; color: #FFF;"><?php echo $text_product; ?></td>
                                <td style="font-family: Arial; letter-spacing: 0.8px; text-transform: uppercase; font-size: 12px; border-right: 1px solid #DDDDDD; border-bottom: 1px solid #000; background-color: #000; font-weight: bold; text-align: left; padding: 7px; color: #FFF;"><?php echo $text_model; ?></td>
                                <td style="font-family: Arial; letter-spacing: 0.8px; text-transform: uppercase; font-size: 12px; border-right: 1px solid #DDDDDD; border-bottom: 1px solid #000; background-color: #000; font-weight: bold; text-align: right; padding: 7px; color: #FFF;"><?php echo $text_quantity; ?></td>
                                <td style="font-family: Arial; letter-spacing: 0.8px; text-transform: uppercase; font-size: 12px; border-right: 1px solid #DDDDDD; border-bottom: 1px solid #000; background-color: #000; font-weight: bold; text-align: right; padding: 7px; color: #FFF;"><?php echo $text_price; ?></td>
                                <td style="font-family: Arial; letter-spacing: 0.8px; text-transform: uppercase; font-size: 12px; border-right: 1px solid #DDDDDD; border-bottom: 1px solid #000; background-color: #000; font-weight: bold; text-align: right; padding: 7px; color: #FFF;"><?php echo $text_total; ?></td>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($products as $product) { ?>
                            <tr>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: left; padding: 7px;">
                                    <img src="<?php echo $product['image']; ?>" height="100" width="100" />
                                </td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: left; padding: 7px;"><?php echo $product['name']; ?>
                                    <?php foreach ($product['option'] as $option) { ?>
                                    <br />
                                    &nbsp;<small> - <?php echo $option['name']; ?>: <?php echo $option['value']; ?></small>
                                    <?php } ?></td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: left; padding: 7px;"><?php echo $product['model']; ?></td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: right; padding: 7px;"><?php echo $product['quantity']; ?></td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: right; padding: 7px;"><?php echo $product['price']; ?></td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: right; padding: 7px;"><?php echo $product['total']; ?></td>
                            </tr>
                            <?php } ?>
                            <?php foreach ($vouchers as $voucher) { ?>
                            <tr>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: left; padding: 7px;"><?php echo $voucher['description']; ?></td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: left; padding: 7px;"></td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: right; padding: 7px;">1</td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: right; padding: 7px;"><?php echo $voucher['amount']; ?></td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: right; padding: 7px;"><?php echo $voucher['amount']; ?></td>
                            </tr>
                            <?php } ?>
                            </tbody>
                            <tfoot>
                            <?php foreach ($totals as $total) { ?>
                            <tr>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: right; padding: 7px;" colspan="4"><b><?php echo $total['title']; ?>:</b></td>
                                <td style="font-size: 12px;	border-right: 1px solid #DDDDDD; border-bottom: 1px solid #DDDDDD; text-align: right; padding: 7px;"><?php echo $total['text']; ?></td>
                            </tr>
                            <?php } ?>
                            </tfoot>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td style="text-align: center; font-size: 16px; font-weight: 300;" colspan="3">
                        <p style="margin: 20px auto 0;">
                            Siparişinin detaylarını görmek ve kargonu takip etmek için üye girişi sonrası Siparişlerim sayfasını kullanabilir ya da <a style="text-decoration: none; color: #000; font-weight: 400;" href="/" target="_blank">buraya</a> tıklayabilirsin.
                            <br />
                            Kafana takılan bir şey olursa yardım sayfamızı ziyaret edebilirsin. Yeni bir sipariş için tekrar görüşmek üzere...
                        </p>
                    </td>
                </tr>
            </table>
        </div>
</body>
</html>