<div class="row">
  <div class="col-sm-12">
    <h3><?php echo $heading_title; ?></h3>
    <div class="RecentlyViewed__Carousel owl-carousel product-layout">
      <?php foreach ($products as $product) { ?>
        <div class="item">
          <div class="product-thumb transition">
            <div class="image">
              <a href="<?php echo $product['href']; ?>"><img src="<?php echo $product['thumb']; ?>" alt="<?php echo $product['name']; ?>" title="<?php echo $product['name']; ?>" class="img-responsive" /></a>
            </div>
            <div class="caption text-center">
              <h4>
                <a href="<?php echo $product['href']; ?>"><?php echo $product['name']; ?></a>
              </h4>
              <?php if ($product['price']) { ?>
                <p class="price">
                  <?php if (!$product['special']) { ?>
                    <?php echo $product['price']; ?>
                  <?php } else { ?>
                    <span class="price-new"><?php echo $product['special']; ?></span> <span class="price-old"><?php echo $product['price']; ?></span>
                  <?php } ?>
                </p>
              <?php } ?>
            </div>
          </div>
        </div>
      <?php } ?>
    </div>
    <script>
      jQuery (function ($) {
        $('.RecentlyViewed__Carousel').owlCarousel ({
          autoplay: true,
          autoplayTimeout: 2000,
          responsive: {
            0: {
              items: 2
            },
            1000: {
              items: 4
            }
          }
        });
      });
    </script>
  </div>
</div>
