<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Ödeme Sayfası</title>

    <link rel="canonical" href="https://getbootstrap.com/docs/5.1/examples/checkout/">

    <!-- Bootstrap core CSS -->
    <link href="/catalog/view/theme/deercase/stylesheet/new_checkout/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://scripts.piyersoft.com/quickcheckout/quickcheckout.css" />

    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css">

    <link rel="stylesheet" type="text/css" href="/catalog/view/theme/deercase/stylesheet/hamburgers.min.css?ver=0.0.128" />


    <link rel="stylesheet" media="screen and (min-width: 701px) and (max-width: 99999px)" href="//scripts.piyersoft.com/quickcheckout/quickcheckout_two.css" />
    <link rel="stylesheet" media="screen and (min-width: 1px) and (max-width: 700px)" href="//scripts.piyersoft.com/quickcheckout/quickcheckout_mobile.css" />

    <script src="https://cdn.jsdelivr.net/npm/vue@2/dist/vue.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>



</head>
<body>

<div class="container" id="app">
    <div class="row">


        <div id="content" class="col-sm-12">
            <h1>Ödeme Sayfası</h1>

            <div id="quickcheckout-countdown"></div>
            <div id="quickcheckoutconfirm">
                <div id="quickcheckout-disable">

                    <!-- Login Component -->
                    <div v-if="isLoginControl" class="quickcheckoutmid" id="login-box">
                        <div id="checkout">
                            <div class="quickcheckout-heading"><i class="fa fa-sign-in"></i> Giriş Yapın</div>
                            <div class="quickcheckout-content">
                                <div id="login">
                                    <div class="col-sm-6 text-left">
                                        <label class="col-sm-3" for="input-login-email">E-Posta</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="email" value="" class="form-control" id="input-login-email" />
                                        </div>
                                    </div>
                                    <div class="col-sm-6 text-left">
                                        <label class="col-sm-3" for="input-login-password">Parola <a href="#" title="Parolamı Unuttum" data-toggle="tooltip"><i class="fa fa-question-circle"></i></a></label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <input type="password" name="password" value="" class="form-control" />
                                                <span class="input-group-btn">
                                                    <button type="button" id="button-login" data-loading-text="Yükleniyor" class="btn btn-primary">Oturum Aç</button>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="or">-- VEYA --</div>
                    </div>
                    <!-- Login Component -->

                    <!-- Payment Address AND Shipping Address -->
                    <div class="quickcheckoutleft">
                        <div id="payment-address">
                            <div class="quickcheckout-heading"><i class="fa fa-user"></i> Hesap & Fatura Bilgileri</div>
                            <div class="quickcheckout-content">Guest OR Payment Address FORM</div>
                        </div>
                        <div id="shipping-address">
                            <div class="quickcheckout-heading"><i class="fa fa-user"></i> Teslimat Bilgileri</div>
                            <div class="quickcheckout-content"><?php echo isset($shipping_address) ? $shipping_address : ''; ?></div>
                        </div>
                    </div>
                    <!-- Payment Address AND Shipping Address -->

                    <!-- Shipping Method AND Payment Method -->
                    <div class="quickcheckoutright">
                        <div id="shipping-method">
                        <div class="quickcheckout-heading"><i class="fa fa-truck"></i> Kargo Türü </div>
                        <div class="quickcheckout-content"></div>
                    </div>

                    <div id="payment-method">
                    <div class="quickcheckout-heading"><i class="fa fa-credit-card"></i> Ödeme Türü</div>
                    <div class="quickcheckout-content"></div>
                    </div>
                    </div>
                    <!-- Shipping Method AND Payment Method -->

                    <!-- Cart -->
                    <div class="quickcheckoutleft">
                        <div id="cart1">
                            <div class="quickcheckout-content" style="border:none; padding: 0px;">

                                <table class="quickcheckout-cart">
                                    <thead>
                                    <tr>
                                        <td class="image">{{ cart.column_image }}</td>
                                        <td class="name">{{ cart.column_name }}</td>
                                        <td class="quantity">{{ cart.column_quantity }}</td>
                                        <td class="price1">{{ cart.column_price }}</td>
                                        <td class="total">{{ cart.column_total }}</td>
                                    </tr>
                                    </thead>

                                    <tbody v-if="cart.products">

                                    <tr v-for="product in cart.products" :key="product.key">
                                        <td class="image">

                                            <img v-if="product.product_type != 11" width="50" height="80" :src="product.case_image" alt="Frame" style="position:absolute;">
                                            <img v-if="product.customcase_image" :width="product.product_type == 11 ? 52 : 49" :height="product.product_type == 11 ? 60:80" :src="product.customcase_image" alt="">

                                            <a v-else target="_blank" :href="product.customer_order_image">
                                                <img :src="product.customer_order_image" width="60">
                                            </a>

                                        </td>
                                        <td class="name"><a :href="product.href">{{ product.name }}</a>
                                            <div>
                                                <small v-for="option in product.option">{{ option.name }} {{ option.value }}</small><br />
                                                <br />
                                                <small v-if="product.reward">{{ product.reward }}</small>
                                                <br />
                                                <span v-if="product.recurring" class="label label-info">{{ cart.text_recurring_item }</span> <small>{{ product.recurring }}</small>
                                            </div>
                                        </td>
                                        <td class="quantity">
                                            <div class="input-group btn-block">
                                                <span class="input-group-btn">
                                                    <button data-toggle="tooltip" :title="cart.button_remove" class="btn btn-danger button-remove"><i class="fa fa-times-circle"></i></button>
                                                </span>
                                            </div>
                                        </td>
                                        <td class="price1">{{ product.price }}</td>
                                        <td class="total">{{ product.total }}</td>
                                    </tr>


                                    <tr v-for="voucher in cart.vouchers">
                                        <td class="image"></td>
                                        <td class="name">{{ voucher.description }}</td>
                                        <td class="quantity">x&nbsp;1</td>
                                        <td class="price1">{{ voucher.amount }}</td>
                                        <td class="total">{{ voucher.amount }}</td>
                                    </tr>


                                    <tr v-for="total in cart.totals">
                                        <td class="text-right" colspan="4"><b>{{ total.title }}:</b></td>
                                        <td class="text-right">{{ total.text }}</td>
                                    </tr>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                    <!-- Cart -->

                    <div style="clear:right;"></div>

                    <!-- Coupon -->
                    <div class="quickcheckoutright">
                        <div id="voucher">
                            <div class="quickcheckout-content" style="border:none; padding: 0px;overflow: hidden;">

                                <div v-if="coupon.coupon_module" id="coupon-heading"><i class="fa fa-ticket"></i> {{ coupon.entry_coupon }}</div>
                                <div v-if="coupon.coupon_module" id="coupon-content">
                                    <div class="input-group">
                                        <input type="text" name="coupon" value="" class="form-control" />
                                        <span class="input-group-btn">
	                                        <button type="button" id="button-coupon" class="btn btn-primary">{{ coupon.text_use_coupon }}</button>
	                                    </span>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- Coupon -->

                    <div style="clear: both;"></div>
                </div>

                <!-- Confirm -->
                <div class="quickcheckoutmid">
                    <div id="terms">
                        <div class="quickcheckout-content text-right">
                            <div id="payment" class="text-left" style="display:none;"></div>
                            <div class="terms">
                                <label>
                                    <span v-html="terms.text_agree"></span>
                                    <input type="checkbox" name="agree" value="1" />
                                    </label>
                                <button type="button" id="button-payment-method" class="btn btn-primary">{{ terms.button_continue }}</button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Confirm -->

            </div>
        </div>

           
        </div>
    </div>
</div>

<script>

    var app = new Vue({
        el: '#app',
        data: {
            message: 'Hello Vue!',
            cart: { products: {} },
            terms: {},
            coupon: {},
        },
        computed: {
            isLoginControl(){
                axios.get("index.php?route=checkout/odeme/isLogin").then(response => {
                    return response.data.logged ? true : false
                })
            }
        },
        mounted () {
            axios.get("index.php?route=checkout/odeme/getCartProducts").
            then(response => {
                //console.log(response.data)
                this.cart = response.data
            })

            axios.get("index.php?route=checkout/odeme/terms").
            then(response => {
                //console.log(response.data)
                this.terms = response.data
            })

            axios.get("index.php?route=checkout/odeme/voucer").
            then(response => {
                console.log(response.data)
                this.coupon = response.data
            })

        }
    })
</script>


</body>
</html>
