<?php
class ModelFeedGoogleMerchantCenter extends Model {
	public function getTaxonomy($category_id) {
		$query = $this->db->query("SELECT `".DB_PREFIX."feed_manager_taxonomy`.taxonomy_id, `".DB_PREFIX."feed_manager_taxonomy`.name FROM `".DB_PREFIX."feed_manager_category` RIGHT JOIN `".DB_PREFIX."feed_manager_taxonomy` ON `".DB_PREFIX."feed_manager_category`.taxonomy_id=`".DB_PREFIX."feed_manager_taxonomy`.taxonomy_id WHERE `".DB_PREFIX."feed_manager_category`.category_id LIKE '".$category_id."' OR `".DB_PREFIX."feed_manager_taxonomy`.status LIKE '1' ORDER BY `".DB_PREFIX."feed_manager_category`.category_id DESC LIMIT 1;");
		return $query->row;
	}

	public function getProductExtra($product_id,$attribute_id) {
		if ($attribute_id=='-1'){
			$query = $this->db->query("SELECT * FROM `".DB_PREFIX."feed_manager_product` gtp WHERE gtp.product_id LIKE '".$product_id."';");
		} else {
			$query = $this->db->query("SELECT pa.text as color, gtp.age_group,gtp.gender FROM `".DB_PREFIX."feed_manager_product` gtp LEFT JOIN `".DB_PREFIX."product_attribute` pa ON (pa.attribute_id LIKE '".$attribute_id."') WHERE gtp.product_id LIKE '".$product_id."' LIMIT 1;");
		}
		if ($query->rows)
			return $query->row;
	}

	public function getProductExtraType($product_id,$attribute_id) {
		$query = $this->db->query("SELECT pa.text FROM `".DB_PREFIX."product_attribute` pa WHERE pa.product_id LIKE '".$product_id."' AND pa.attribute_id LIKE '".$attribute_id."' LIMIT 1;");
		if ($query->rows)
			return $query->row['text'];
	}

	public function isApparel($taxonomy_id) {
		$query = $this->db->query("SELECT count(*) AS count FROM `".DB_PREFIX."feed_manager_taxonomy` WHERE ".DB_PREFIX."feed_manager_taxonomy.taxonomy_id LIKE '".$taxonomy_id."' AND ".DB_PREFIX."feed_manager_taxonomy.name LIKE 'Apparel & Accessories%';");
		return $query->row['count'];
	}

	public function getProductOptions($product_id,$option_id) {

		$product_option_query = $this->db->query("SELECT ".DB_PREFIX."option_value_description.name FROM ".DB_PREFIX."product_option_value LEFT JOIN ".DB_PREFIX."option_value_description ON ".DB_PREFIX."option_value_description.option_value_id=".DB_PREFIX."product_option_value.option_value_id WHERE ".DB_PREFIX."product_option_value.product_id LIKE '".$product_id."' AND ".DB_PREFIX."product_option_value.option_id LIKE '".$option_id."' AND ".DB_PREFIX."option_value_description.language_id LIKE '" . (int)$this->config->get('config_language_id') . "' AND (".DB_PREFIX."product_option_value.subtract LIKE '0' OR ".DB_PREFIX."product_option_value.quantity > 0) GROUP BY ".DB_PREFIX."option_value_description.name;");
		return $product_option_query->rows;
	}

	public function getTax() {
		$query = $this->db->query("SELECT iso_code_2,rate FROM ".DB_PREFIX."tax_rate tr LEFT JOIN ".DB_PREFIX."zone_to_geo_zone tgz ON tr.geo_zone_id=tgz.geo_zone_id  RIGHT JOIN ".DB_PREFIX."country c ON c.country_id=tgz.country_id WHERE type LIKE 'P' GROUP BY c.iso_code_2;");
		return $query->rows;
	}

	public function getShipping() {
		$query = $this->db->query("SELECT c.iso_code_2 FROM ".DB_PREFIX."zone_to_geo_zone ztgz LEFT JOIN ".DB_PREFIX."country c ON (c.country_id=ztgz.country_id) GROUP BY c.iso_code_2;");
		return $query->rows;
	}
}
?>
