<?php
class ModelExtensionTotalSubTotal extends Model {

    public function getTotal($total) {
        $this->load->language('extension/total/sub_total');

        $sub_total = $this->cart->getSubTotal();

        if (!empty($this->session->data['vouchers'])) {
            foreach ($this->session->data['vouchers'] as $voucher) {
                $sub_total += $voucher['amount'];
            }
        }

        $codtotal_fee = 0;
        if ($this->config->get('codtotal_status') && isset($this->session->data['payment_method']) && $this->session->data['payment_method']['code'] == 'cod'){
            $codtotal_fee = $this->config->get('codtotal_fee');
        }


        $discount_total = 0;
        if(isset($this->session->data['discount_total'])){
            $discount_total = $this->session->data['discount_total'];
            //$this->product->dump($this->session->data['discount_total']);
        }

        if(isset($this->session->data['user_id'])){
            //var_dump($this->session->data['discount_total']); die();
           // $discount_total = 0;
            //$this->product->dump();
            //$sub_total *= 1.18;
           // var_dump($sub_total ,$codtotal_fee,$discount_total); die();
        }

        $campaign_price_total = 0;
        if (isset($this->session->data['campaign_price_total'])){
            $campaign_price_total = $this->session->data['campaign_price_total'];
        }

        $extra_discount = 0;
        $promotion = $this->config->get('promotion');
                
        if(!empty($promotion['discount_percent'])) {
            $discount_percent = /*$promotion['discount_percent']/100*/0.1;
            $extra_discount = $sub_total*$discount_percent;            
        }

        $total['total'] += ($sub_total + $campaign_price_total);

        $sub_total = $sub_total + $codtotal_fee - ($discount_total) - $extra_discount;
        if($sub_total < 0){
            $sub_total = 0;
        }

        $total['totals'][] = array(
            'code'       => 'sub_total',
            'title'      => $this->language->get('text_sub_total'),
            'value'      => $sub_total,
            'sort_order' => $this->config->get('sub_total_sort_order')
        );

    }
}
