<?php
class ModelExtensionPaymentCOD extends Model {
	public function getMethod($address, $total) {
		$this->load->language('extension/payment/cod');

		$query = $this->db->query("SELECT * FROM ps_zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('cod_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

		if ($this->config->get('cod_total') > 0 && $this->config->get('cod_total') > $total) {
			$status = false;
		} elseif (!$this->cart->hasShipping()) {
			$status = false;
		}
	//	elseif($this->paymentCodeControl()){
      //      $status = false;
        //}
        elseif (!$this->config->get('cod_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$method_data = array();

		if ($status) {
			$method_data = array(
				'code'       => 'cod',
				'title'      => $this->language->get('text_title') . $this->config->get('cod_text'),
				'terms'      => '',
				'sort_order' => $this->config->get('cod_sort_order'),
				'is_PaymentCodeControl' => $this->paymentCodeControl()
			);
		}

		return $method_data;
	}

    private function paymentCodeControl(){

        //$this->product->dump($this->cart->getProducts());

        if(isset($this->session->data['user_id'])){
            if($this->session->data['user_id'] == 3){
               // return false;
            }
        }

        $additional_product_ids=array('140165','140168');

        foreach ($this->cart->getProducts() as $product){
            if($product['customer_pattern_data']){
                $customer_pattern_data = json_decode($product['customer_pattern_data'], true);
                if($customer_pattern_data['pattern_text'] OR $customer_pattern_data['gradienttext']){
                    return true;
                } //gradienttext
            }
            if ($product['customcase_image']){
                return true;
            }
            
            if(in_array($product['product_id'],$additional_product_ids)){
                return true;
            }

            $product_names = array('Neon', 'Simli Sulu','İsme Özel', 'Tutacaklı', 'Harfli');
            foreach ($product_names as $name){
                if(strpos($product['name'],$name) !== false){
                    //return true;
                    // Kapatılması istendi. 30/03/2020 #Bilal
                }
            }
        }





        return false;

    }

    public function doubleOrderControl($order_id)
    {
        $before_minute = date('Y-m-d H:i:s', strtotime('-1 minutes'));
        $later_minute = date('Y-m-d H:i:s', strtotime('1 minutes'));

        $order_info = $this->db->query("SELECT email, firstname , telephone FROM ps_order WHERE order_id = '". (int)$order_id ."' ")->row;


        if(!$order_info){
            return true;
        }

        $order_check = $this->db->query("SELECT * FROM ps_order WHERE 
            email = '". $this->db->escape($order_info['email']) ."' AND                 
            firstname = '". $this->db->escape($order_info['firstname']) ."' AND                 
            telephone = '". $this->db->escape($order_info['telephone']) ."' AND
            date_added BETWEEN '". $before_minute ."' AND '". $later_minute ."' AND payment_code = 'cod' ");
        if($order_check->num_rows > 1){
            return false;
        }

        return true;

    }
}
