<?php
class ModelExtensionModuleStokuyarisi extends Model {
    public function getLastOrder() {
        $last_order = $this->db->query("SELECT oh.*, o.customer_id 
            FROM " . DB_PREFIX . "order_history oh 
            LEFT JOIN " . DB_PREFIX . "order o 
            ON oh.order_id = o.order_id
            WHERE oh.order_status_id = 1
            OR oh.order_status_id = 2
            ORDER BY oh.order_history_id desc 
            LIMIT 1"
        );
        if(isset($last_order)) {
            return $last_order->row;            
        }
    }

    public function getLastOrderProducts($order_id) {
        $last_order_products = $this->db->query("SELECT op.*, p.quantity 
            FROM " . DB_PREFIX . "order_product op
            LEFT JOIN " . DB_PREFIX . "product p 
            ON op.product_id = p.product_id
            WHERE op.order_id = " . $order_id
        );

        return $last_order_products;
    }

    public function findProductInCart($product_id) {
        $product_in_cart = $this->db->query("SELECT * 
            FROM " . DB_PREFIX . "cart
            WHERE product_id = " . $product_id . "
        ");

        return $product_in_cart;
    }

    public function getCustomerEmail($customer_id) {
        $customer = $this->db->query("SELECT email 
            FROM " . DB_PREFIX . "customer 
            WHERE customer_id = " . $customer_id . "
            LIMIT 1
        ")->row;
        if(!empty($customer)) {
            return $customer['email'];
        }
        return false;
    }

    public function deleteOutdatedDatas() {
        $this->db->query("DELETE FROM " . DB_PREFIX . "stok_uyarilari 
            WHERE date_added < DATE_ADD(SYSDATE(), INTERVAL - 1 MONTH)  
        ");
    }

    public function getUyariHistory($customer_id) {
        return $this->db->query("SELECT * 
            FROM " . DB_PREFIX . "stok_uyarilari
            WHERE customer_id = " . $customer_id . "
        "); 
    }

    public function createUyariHistory($customer_id, $product_id) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "stok_uyarilari SET
            customer_id = " . $customer_id . ", 
            product_id = " . $product_id . ", 
            date_added = NOW() 
        ");
    }

    public function send($email) {
        $mail = new SendgridMail($this->config->get('sendgrid_api_key'));
		$mail->protocol = $this->config->get('config_mail_protocol');
		$mail->parameter = $this->config->get('config_mail_parameter');
		$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
		$mail->smtp_username = $this->config->get('config_mail_smtp_username');
		$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
		$mail->smtp_port = $this->config->get('config_mail_smtp_port');
		$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');

        $subject = 'Sepetinizdeki Ürün İçin Stok Uyarısı';
        $text = 'Sepetinizdeki ürünlerin stoku tükenmek üzere. Son stokları kaçırma!'.PHP_EOL.
        '<a href="'. $this->url->link('checkout/cart') . '">Sepete Git</a>';
		$mail->setTo($email);
		$mail->setFrom($this->config->get('config_email'));
		$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
		$mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
		$mail->setText(html_entity_decode($text, ENT_QUOTES, 'UTF-8'));
		$mail->send();
    }

}

?>