<?php
class ModelAffiliateDesigner extends Model {
	public function getProducts($data) {
		$affiliate_models = $this->db->query("SELECT model FROM ". DB_PREFIX."affiliate_model WHERE affiliate_id = '". $this->session->data['affiliate_id'] ."'")->rows; 

		$model_string = "";
		for ($i=0; $i < count($affiliate_models); $i++) { 
			$model = "'".$affiliate_models[$i]['model']."'";
			if($i<count($affiliate_models)-1) {
				$model.=",";
			}
			$model_string.=$model;
		}

		$this->load->model('catalog/product');
		$product_data = array();

			$sql = "SELECT p.product_id";

			if (!empty($data['filter_category_id'])) {
				if (!empty($data['filter_sub_category'])) {
					$sql .= " FROM ps_category_path cp LEFT JOIN ps_product_to_category p2c ON (cp.category_id = p2c.category_id)";
				} else {
					$sql .= " FROM ps_product_to_category p2c";
				}

				if (!empty($data['filter_filter'])) {
					$sql .= " LEFT JOIN ps_product_filter pf ON (p2c.product_id = pf.product_id) LEFT JOIN ps_product p ON (pf.product_id = p.product_id)";
				} else {
					$sql .= " LEFT JOIN ps_product p ON (p2c.product_id = p.product_id)";
				}

			} else {
				$sql .= " FROM ps_product p";
			}

			$sql .= " LEFT JOIN ps_product_description pd ON (p.product_id = pd.product_id) WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p.status = '1' AND p.date_available <= NOW() ";
			
			//$sql .= "  AND NOT p.model = 'ism01'"; // İsme Özel birden çok kılıf olduğu için bir kılıf sayfaya eklendiğinde birden çok kılıf geliyor. Bu sorundan ötürü 'ism01' hariç tutulur.
			
			if (!empty($data['filter_category_id'])) {
				if (!empty($data['filter_sub_category'])) {
					$sql .= " AND cp.path_id = '" . (int) $data['filter_category_id'] . "'";
				} else {
					$sql .= " AND p2c.category_id = '" . (int) $data['filter_category_id'] . "'";
				}

				if (!empty($data['filter_filter'])) {
					$implode = array();

					$filters = explode(',', $data['filter_filter']);

					foreach ($filters as $filter_id) {
						$implode[] = (int) $filter_id;
					}

					$sql .= " AND pf.filter_id IN (" . implode(',', $implode) . ")";
				}
			}

			if (!empty($data['brand'])) {
				$sql .= " AND p.manufacturer_id IN (" . ltrim($data['brand'], ",") . ") ";
			}

			if (!empty($data['filter_name']) || !empty($data['filter_tag'])) {
				$sql .= " AND (";

				if (!empty($data['filter_name'])) {
					$implode = array();

					$words = explode(' ', trim(preg_replace('/\s+/', ' ', $data['filter_name'])));

					foreach ($words as $word) {
						$implode[] = "pd.name LIKE '%" . $this->db->escape($word) . "%'";
					}

					if ($implode) {
						$sql .= " " . implode(" AND ", $implode) . "";
					}

					if (!empty($data['filter_description'])) {
						$sql .= " OR pd.description LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
					}
				}

				if (!empty($data['filter_name']) && !empty($data['filter_tag'])) {
					$sql .= " OR ";
				}

				if (!empty($data['filter_tag'])) {
					$implode = array();

					$words = explode(' ', trim(preg_replace('/\s+/', ' ', $data['filter_tag'])));

					foreach ($words as $word) {
						$implode[] = "pd.tag LIKE '%" . $this->db->escape($word) . "%'";
					}

					if ($implode) {
						$sql .= " " . implode(" AND ", $implode) . "";
					}
				}

				if (!empty($data['filter_name'])) {
					$sql .= " OR LCASE(p.model) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
					$sql .= " OR LCASE(p.sku) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
					$sql .= " OR LCASE(p.upc) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
					$sql .= " OR LCASE(p.ean) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
					$sql .= " OR LCASE(p.jan) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
					$sql .= " OR LCASE(p.isbn) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
					$sql .= " OR LCASE(p.mpn) = '" . $this->db->escape(utf8_strtolower($data['filter_name'])) . "'";
				}

				$sql .= ")";
			}

			if (!empty($data['filter_manufacturer_id'])) {
				$sql .= " AND p.manufacturer_id = '" . (int) $data['filter_manufacturer_id'] . "'";
			}

			if (isset($data['product_showcase'])) {
				$sql .= " AND p.product_showcase = '" . (int) $data['product_showcase'] . "'";
			}

			if ($this->config->get('config_instock')) {
				$sql .= " AND p.quantity > 0 ";
			}

			$sql .= " GROUP BY p.product_id";

			$sort_data = array(
				'pd.name',
				'p.model',
				'p.quantity',
				'p.price',
				'rating',
				'p.sort_order',
				'p.date_added'
			);

			if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
				if ($data['sort'] == 'pd.name' || $data['sort'] == 'p.model') {
					$sql .= " ORDER BY LCASE(" . $data['sort'] . ")";
				} elseif ($data['sort'] == 'p.price') {
					$sql .= " ORDER BY (CASE WHEN special IS NOT NULL THEN special WHEN discount IS NOT NULL THEN discount ELSE p.price END)";
				} else {
					$sql .= " ORDER BY " . $data['sort'];
				}
			} else {
				$sql .= " ORDER BY p.sort_order";
			}

			if (isset($data['order']) && ($data['order'] == 'DESC')) {
				$sql .= " DESC, LCASE(pd.name) DESC";
			} else {
				$sql .= " ASC, LCASE(pd.name) ASC";
			}

			if (isset($data['start']) || isset($data['limit'])) {
				if ($data['start'] < 0) {
					$data['start'] = 0;
				}

				if ($data['limit'] < 1) {
					$data['limit'] = 20;
				}

				$sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
			}

			$query = $this->db->query($sql);

			$affiliate_info = $this->db->query("SELECT * FROM ". DB_PREFIX."affiliate WHERE affiliate_id = '". $this->session->data['affiliate_id']."' LIMIT 1 ")->row; 

			foreach ($query->rows as $result) {
				$product = $this->model_catalog_product->getProduct($result['product_id']);
				$product['href'] = $product['href'] .'&tracking='.$affiliate_info['code']; 
				$product_data[$result['product_id']] = $product;
			}

        return $product_data;
	}
	public function deleteAffiliateModel($affiliate_id, $model) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "affiliate_model WHERE affiliate_id = " . (int)$affiliate_id . " AND model = '" . $model . "' LIMIT 1");
	}
	
	public function addAffiliateModel($affiliate_id, $model) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "affiliate_model` SET `affiliate_id` = '" . (int)$affiliate_id . "', `model` = '" . $model ."'");
	}

	public function deleteAffiliateProduct($affiliate_id, $product_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "affiliate_product WHERE affiliate_id = " . (int)$affiliate_id . " AND product_id = '" . $product_id . "' LIMIT 1");
	}
	
	public function addAffiliateProduct($affiliate_id, $product_id) {
		$this->db->query("INSERT INTO `" . DB_PREFIX . "affiliate_product` SET `affiliate_id` = '" . (int)$affiliate_id . "', `product_id` = '" . $product_id ."'");
	}
	
}